{ Bmp2RawBk256 (C) by Vladimir Kladov, 2004
    This small utility allows to convert easy bitmap to raw background 320x200
  256 colors .bNN file used in 256 Colors Spectrum modified games.
    Source bitmap should be 256x192, but if size is another it is stretched to
  256x192 format first.
    If an option /P used, resulting raw background image file will be created
  to use with special palette also saved as .pNN-file. When using several
  backgrounds switched via probe rules, selecting a background also selects a
  palette associated (note that this affects not only the background, but
  entire GFX screen image displayed).
    Note also, that resulting files should be so-named as loaded snapshot. E.g.,
  if a snapshot has name GAME1.SNA, its background files should be named as
  GAME1.B00, GAME1.B01, etc. and palette if any as GAME1.P00, GAME1.P01 etc.
    See also a documentation in 256_color_games.htm file provided in the
  EmuZWin_Addons.zip archive.
}


program Bmp2RawBk256;

{$APPTYPE CONSOLE}

uses
  windows, KOL;

type
  TPalette = array[ 0..255 ] of TColor;

var SystemPalette: TPalette = (
$000000, $00009B, $172FAB, $3763BB, $5B93CB, $83BFDB, $B3E3EB, $E7FFFF, 
$B70000, $BF1717, $CB3333, $D35353, $DF7777, $E79B9B, $F3C3C3, $FFEFEF, 
$003723, $07533B, $176F53, $2F8B73, $4FA78F, $73C3B3, $9FDFD3, $D3FFF7, 
$FF4B00, $FF771F, $FF9F3F, $FFBF63, $FFDB83, $FFEBA7, $FFF7C7, $FFFFEB, 
$672B00, $7B3B0B, $8F4F23, $A7673B, $BB835B, $D39F7F, $E7BFA7, $FFE7D7, 
$7F004B, $8F135B, $A32B73, $B34B8B, $C76FA3, $D79BBF, $EBCBDF, $FFFFFF, 
$0B2373, $1B3387, $2F479B, $4B63AF, $677FC3, $8B9FD7, $B3BFEB, $DFE7FF, 
$337F23, $438F1F, $53A31F, $6BB31B, $87C717, $ABD70F, $CFEB07, $FFFF00, 
$C30000, $AF1700, $BB3300, $C75300, $D77B00, $E3A300, $EFCF00, $FFFF00, 
$4B4B33, $636347, $7B7B5B, $979773, $AFAF8B, $CBCBA3, $E3E3BF, $FFFFDB, 
$000000, $434343, $636363, $7F7F7F, $9F9F9F, $BBBBBB, $DBDBDB, $FBFBFB, 
$A36F57, $AF7F63, $BB8F6F, $C7A37B, $D7B78B, $E3C79B, $EFDBAB, $FFEFBB, 
$00ABCB, $17B3CF, $33BBD7, $4FC7DF, $6BCFE3, $8BDBEB, $AFE7F3, $D3F3FB, 
$00D300, $17D717, $2FDF2F, $4BE34B, $67EB67, $83EF83, $A3F7A3, $C3FFC3, 
$4F4F67, $5F5F7B, $73738F, $8B8BA7, $9F9FBB, $B7B7D3, $CBCBE7, $E7E7FF, 
$8B8300, $9B930F, $ABA323, $BBB33B, $CBC353, $DBD773, $EBE793, $FFFBBB, 
$375757, $3B6F6F, $3B8787, $3B9F9F, $33B7B7, $27CFCF, $17E7E7, $07FFFF, 
$000000, $00001B, $000037, $00004F, $00006B, $000087, $0000A3, $0000BF, 
$000000, $1B0000, $370000, $4F0000, $6B0000, $870000, $A30000, $BF0000,
$000000, $1B001B, $370037, $4F004F, $6B006B, $870087, $A300A3, $BF00BF, 
$000000, $001B00, $003700, $004F00, $006B00, $008700, $00A300, $00BF00, 
$000000, $001B1B, $003737, $004F4F, $006B6B, $008787, $00A3A3, $00BFBF, 
$000000, $1B1B00, $373700, $4F4F00, $6B6B00, $878700, $A3A300, $BFBF00, 
$000000, $1B1B1B, $373737, $4F4F4F, $6B6B6B, $878787, $A3A3A3, $BFBFBF,
$000000, $000000, $000000, $000000, $000000, $000000, $000000, $000000,
$00003F, $000057, $000073, $00008F, $0000AB, $0000C7, $0000E3, $0000FF,
$3F0000, $570000, $730000, $8F0000, $AB0000, $C70000, $E30000, $FF0000,
$3F003F, $570057, $730073, $8F008F, $AB00AB, $C700C7, $E300E3, $FF00FF,
$003F00, $005700, $007300, $008F00, $00AB00, $00C700, $00E300, $00FF00,
$000000, $002323, $004747, $006B6B, $008F8F, $00B3B3, $00DBDB, $00FFFF,
$3F3F00, $575700, $737300, $8F8F00, $ABAB00, $C7C700, $E3E300, $FFFF00,
$3F3F3F, $575757, $737373, $8F8F8F, $ABABAB, $C7C7C7, $E3E3E3, $FFFFFF
);
var PalCreate: Boolean;
    PalList: PList;
    PalCounts: PList;
    Palette: TPalette;

function FindNearestColor( R, G, B: Byte ): Byte;
var I: Integer;
begin
  Result := 0;
  for I := 0 to 255 do
  begin
    if Abs( R - ((Palette[ I ] shr 16)and $FF) ) +
       Abs( G - ((Palette[ I ] shr 8) and $FF) ) +
       Abs( B - ((Palette[ I ]) and $FF) ) <
       Abs( R - ((Palette[ Result ] shr 16)and $FF) ) +
       Abs( G - ((Palette[ Result ] shr 8) and $FF) ) +
       Abs( B - ((Palette[ Result ]) and $FF) )
       then
    begin
      Result := I;
    end;
  end;
end;


procedure CountColor( C: TColor );
var I: Integer;
begin
  for I := 0 to PalList.Count-1 do
  begin
    if TColor( PalList.Items[ I ] ) and $FCFCFC = C and $FCFCFC then
    begin
      PalCounts.Items[ I ] := Pointer( DWORD( PalCounts.Items[ I ] ) + 1 );
      Exit;
    end;
  end;
  PalList.Add( Pointer( C ) );
  PalCounts.Add( Pointer( 1 ) );
end;

function ComparePalEntries(const Data: Pointer; const e1,e2 : Dword) : Integer;
var N1, N2: Integer;
begin
  N1 := Integer( PalCounts.Items[ e1 ] );
  N2 := Integer( PalCounts.Items[ e2 ] );
  Result := N2 - N1;
  if Result < 0 then Result := -1;
  if Result > 0 then Result := 1;
end;

procedure SwapItems(const Data : Pointer; const e1,e2 : Dword);
begin
  PalList.Swap( e1, e2 );
  PalCounts.Swap( e1, e2 );
end;

procedure ConvertFile( const Filename: String; N: Integer );
var B, B1: PBitmap;
    Pixels: array[ 0..199, 0..319 ] of Byte;
    I, X, Y: Integer;
    F: PStream;
    Src: PDWORD;
    S: String;
begin
  B := NewBitmap( 0, 0 );
  B.LoadFromFile( Filename );

  B1 := NewDIBBitmap( 256, 192, pf32bit );
  SetStretchBltMode( B1.Canvas.Handle, halftone );
  B.StretchDraw( B1.Canvas.Handle, B1.BoundsRect );
  {$IFDEF DEBUG}
  B1.SaveToFile( GetStartDir + 'aaa.bmp' );
  {$ENDIF}
  B1.PixelFormat := pf32bit;

  if PalCreate then
  begin
    PalList := NewList;
    PalCounts := NewList;
    for Y := 0 to B1.Height-1 do
    begin
      Src := B1.ScanLine[ Y ];
      for X := 0 to B1.Width-1 do
      begin
        CountColor( Src^ and $FFFFFF );
        Inc( Src^ );
      end;
    end;

    {$IFDEF DEBUG}
    S := '';
    for I := 0 to PalList.Count-1 do
    begin
      S := S + Int2Hex( DWORD( PalList.Items[ I ] ), 6 )
             + '(' + Int2Str( DWORD( PalCounts.Items[ I ] ) ) + ')'
           + ', ';
      if I and 7 = 7 then S := S + #13#10;
    end;
    F := NewWriteFileStream( GetStartDir + 'pal.txt' );
    F.WriteStr( S );
    F.Free;
    {$ENDIF}

    SortData( nil, PalList.Count, @ ComparePalEntries, @ SwapItems );
    for I := 0 to Min( 253, PalList.Count-1 ) do
      Palette[ I+1 ] := DWORD( PalList.Items[ I ] );
    Palette[ 0 ] := 0;
    Palette[ 255 ] := $FFFFFF;
    PalList.Free;
    PalCounts.Free;

    S := ExtractFilePath( Filename ) +
      ExtractFileNameWOExt( Filename ) + '.p' + Format( '%.02d', [ N ] );
    F := NewWriteFileStream( S );
    for I := 0 to 255 do
      F.Write( Palette[ I ], 3 );
    F.Free;
    Writeln( 'File ' + S + ' written' );
  end
    else
  begin
    Palette := SystemPalette;
  end;

  FillChar( Pixels, Sizeof( Pixels ), 0 );
  for Y := 0 to 191 do
  begin
    Src := B1.ScanLine[ Y ];
    for X := 0 to 255 do
    begin
      Pixels[ Y + 4, X + 32 ] := FindNearestColor( (Src^ shr 16) and $FF,
              (Src^ shr 8) and $FF, Src^ and $FF );
      Inc( Src );
    end;
  end;

  S := ExtractFilePath( Filename ) +
      ExtractFileNameWOExt( Filename ) + '.b' + Format( '%.02d', [ N ] );
  F := NewWriteFileStream( S );
  F.Write( Pixels, Sizeof( Pixels ) );
  F.Free;

  Writeln( 'File ' + S + ' written' );

  B1.Free;
  B.Free;
end;

procedure ConvertAllFiles;
var I, N: Integer;
    S: String;
begin
  PalCreate := FALSE;
  N := 0;
  for I := 1 to ParamCount do
  begin
    S := Trim( ParamStr( I ) );
    if (I = 1) and StrEq( S, '/P' ) then
    begin
      PalCreate := TRUE;
      continue;
    end;
    if S = '' then continue;
    if S[ 1 ] = '"' then
    begin
      S := CopyEnd( S, 2 );
      S := Trim( Parse( S, '"' ) );
    end;
    if not FileExists( S ) then
      Writeln( 'File ' + S + ' not found.' )
    else
    begin
      ConvertFile( S, N );
      Inc( N );
    end;
  end;
end;

begin
  UseDelphiMemoryManager;
  UseInputOutput;
  Writeln( 'Bmp2RawBk256 v1.0 (C) by Vladimir Kladov, 2004' );
  Writeln( 'This utility converts bitmap to raw image 320x200 in 256 colors.' );
  Writeln( 'Source bitmap should be 256x192 or it is stretched to 256x192. ' );
  Writeln( 'Usage: Bmp2RawBk256 [/P] filename1[.bmp] [filename2[.bmp]] ...' );
  Writeln( 'Key /P - create palette files also.' );
  ConvertAllFiles;
  Writeln;
  Writeln( 'Press any key...' );
  Readln;
end.
