library LoadSNA;

uses
  Windows, KOL, PluginUnit;

type
  TSNAHeader = packed record
    I: Byte;
    HLalt: Word;
    DEalt: Word;
    BCalt: Word;
    Falt: Byte;
    Aalt: Byte;
    HL: Word;
    DE: Word;
    BC: Word;
    IY: Word;
    IX: Word;
    IFF1IFF2: Byte;
    R: Byte;
    F: Byte;
    A: Byte;
    SP: Word;
    IM: Byte;
    BorderColor: Byte;
  end;

  TSNA128Hdr = packed record
    PC: Word;
    Port7FFD: Byte;
    TRDOS_rom: Byte;
  end;

procedure RegisterLoadSpectrum( LoadFileTypes, SaveFileTypes: PChar;
          Descriptions: PChar; CanSaveS128: PByte ); stdcall;
begin
  StrCopy( LoadFileTypes, '*.SNA' );
  StrCopy( SaveFileTypes, '*.SNA' );
  StrCopy( Descriptions, 'SNA raw snap format;SNA raw snap format' );
end;

function LoadSpectrum( FileData: Pointer; FileSize: Integer; FileExt: PChar;
         Data: PSpecData; ScreenOnly: Boolean ): Boolean; stdcall;
const
  VidBanks: array[ 0..1 ] of Integer = ( 5, 7 );
type
  TBlock16K = array[0..16383] of Byte;
  PBlock16K = ^TBlock16K;
var FS: PStream;
    Hdr: TSNAHeader;
    Hdr2: TSNA128Hdr;
    Mem16: PBlock16K;
    Mem48: PByte;
    Addr: Word;
    Is128: Boolean;
    I, L: Integer;
begin
  Result := FALSE;
  FS := NewMemoryStream;
  FS.Size := FileSize;
  Move( FileData^, FS.Memory^, FileSize );
  FS.Position := 0;
  TRY
    if FS.Read( Hdr, Sizeof( Hdr ) ) <> Sizeof( Hdr ) then Exit;
    Mem16 := Pointer( DWORD( FS.Memory ) + FS.Position );
    Is128 := FS.Size >= 49179 + 4 + 4 * 16384;
    if not Is128 and ScreenOnly then
    begin
      Move( Mem16^, Data.RAMs[ 5 ], Min( FS.Size - FS.Position, $1B00 ) );
    end
      else
    begin
      if not ScreenOnly then
      begin
        Data.State.AF := Hdr.A shl 8 or Hdr.F;
        Data.State.BC := Hdr.BC;
        Data.State.DE := Hdr.DE;
        Data.State.HL := Hdr.HL;
        Data.State.IX := Hdr.IX;
        Data.State.IY := Hdr.IY;
        Data.State.AFalt := Hdr.Aalt shl 8 or Hdr.Falt;
        Data.State.BCalt := Hdr.BCalt;
        Data.State.DEalt := Hdr.DEalt;
        Data.State.HLalt := Hdr.HLalt;
        Data.State.I := Hdr.I;
        Data.State.R := Hdr.R;
        Data.State.SP := Hdr.SP;
        Data.State.IFF1 := (Hdr.IFF1IFF2 and 4) <> 0;
        Data.State.IFF2 := Data.State.IFF1;
        Data.State.ImMode := Hdr.IM;
        Data.State.BorderColor := Hdr.BorderColor and 7;
        Data.State.TactsFromLastInt := 0;
      end;
      Mem48 := Pointer( Mem16 );
      Move( Mem16^, Data.RAMs[ 5 ], Min( FS.Size - FS.Position, 16384 ) );
      Inc( Mem16 );
      if FS.Size - FS.Position > 16384 then
        Move( Mem16^, Data.RAMs[ 2 ],
              Min( FS.Size - FS.Position - 16384, 16384 ) );
      Inc( Mem16 );
      if FS.Size - FS.Position > 32768 then
        Move( Mem16^, Data.RAMs[ 0 ],
              Min( FS.Size - FS.Position - 32768, 16384 ) );
      Data.Lock7FFD := not Is128;
      Data.State.BankRAM_C000 := 0;
      if not Is128 then
      begin
        // ,   RETN -   S48
        Addr := Data.State.SP;
        if Addr >= 16384 then
        begin
          Data.State.PC := PByte( Integer( Mem48 ) - 16384 + Addr )^;
          PByte( Integer( Mem48 ) - 16384 + Addr )^ := 0;
        end
        else
          Data.State.PC := Data.ROM1[ Addr ];
        Inc( Addr );
        if Addr >= 16384 then
        begin
          Data.State.PC := Data.State.PC or (PByte( Integer( Mem48 ) - 16384 + Addr )^ shl 8);
          PByte( Integer( Mem48 ) - 16384 + Addr )^ := 0;
        end
        else
          Data.State.PC := Data.State.PC or (Data.ROM1[ Addr ] shl 8);
        Inc( Addr );
        Data.State.SP := Addr;
        Data.State.BankROM_0000 := 1;
      end
        else
      begin
        Inc( Mem16 );
        Move( Mem16^, Hdr2, Sizeof( Hdr2 ) );
        Mem16 := Pointer( Integer( Mem16 ) + Sizeof( Hdr2 ) );
        Data.State.PC := Hdr2.PC;
        Data.State.BankROM_0000 := (Hdr2.Port7FFD and $10) shr 4;
        Data.State.BankVideo := (Hdr2.Port7FFD and 8) shr 3;
        Data.State.BankRAM_C000 := Hdr2.Port7FFD and 7;
        if Data.State.BankRAM_C000 <> 0 then
        begin
          if ScreenOnly then L := $1B00 else L := 16384;
          if not ScreenOnly or ScreenOnly and
             (Data.State.BankRAM_C000 = VidBanks[ Data.State.BankVideo ]) then
             Move( Data.RAMs[ 0 ], Data.RAMs[ Data.State.BankRAM_C000 ], L );
        end;
        FS.Position := 49183;
        for I := 0 to 7 do
        begin
          if (I = 2) or (I = 5) or (I = Data.State.BankRAM_C000) then
          else
          begin
            FS.Position := FS.Position + 16384;
            if FS.Position > FS.Size then break;
            if ScreenOnly then L := $1B00 else L := $4000;
            if not ScreenOnly or ScreenOnly and (I = VidBanks[ Data.State.BankVideo ]) then
              Move( Mem16^, Data.RAMs[ I ], L );
            Inc( Mem16 );
          end;
        end;
      end;
      Data.State.R := (Data.State.R and $80) or ((Data.State.R + 1) and $7F);
      {Addr := Data.State.PC;
      if PByte( Integer( Mem48 ) - 16384 + Addr )^ then}
    end;
    Result := TRUE;
  FINALLY
    FS.Free;
  END;
end;

function SaveSpectrum( FilePath: PChar; Data: PSpecData ): Boolean; stdcall;

  function Is48K: Boolean;
  begin
    Result := //(Data.State.BankROM_0000 = 1){ and
              //(Data.State.BankRAM_C000 = 7)};
              Data.Lock7FFD and ((Data.State.SP >= $4002) or (Data.State.SP = 0));
  end;

var FS: PStream;
    Hdr: TSNAHeader;
    Hdr2: TSNA128Hdr;
    Mem64: array[ 0..65535 ] of Byte;
    I: Integer;
begin
  Result := TRUE;
  Move( Data.RAMs[ 5 ], Mem64[ $4000 ], $4000 );
  Move( Data.RAMs[ 2 ], Mem64[ $8000 ], $4000 );
  Move( Data.RAMs[ Data.State.BankRAM_C000 ], Mem64[ $C000 ], $4000 );
  Hdr.SP := Data.State.SP;
  if Is48K then
  begin
    Dec( Hdr.SP );
    Mem64[ Hdr.SP ] := Data.State.PC shr 8;
    Dec( Hdr.SP );
    Mem64[ Hdr.SP ] := Data.State.PC and $FF;
  end;
  FS := NewWriteFileStream( FilePath );
  TRY
    Hdr.I := Data.State.I;
    Hdr.HLalt := Data.State.HLalt;
    Hdr.DEalt := Data.State.DEalt;
    Hdr.BCalt := Data.State.BCalt;
    Hdr.Falt := Data.State.AFalt and $FF;
    Hdr.Aalt := Data.State.AFalt shr 8;
    Hdr.HL := Data.State.HL;
    Hdr.DE := Data.State.DE;
    Hdr.BC := Data.State.BC;
    Hdr.IY := Data.State.IY;
    Hdr.IX := Data.State.IX;
    Hdr.R := (Data.State.R - 1) and $7F or (Data.State.R and $80);
    Hdr.F := Data.State.AF and $FF;
    Hdr.A := Data.State.AF shr 8;
    if Data.State.IFF1 then
      Hdr.IFF1IFF2 := 4
    else
      Hdr.IFF1IFF2 := 0;
    Hdr.IM := Data.State.ImMode;
    Hdr.BorderColor := Data.State.BorderColor;
    FS.Write( Hdr, Sizeof( Hdr ) );
    FS.Write( Mem64[ $4000 ], $C000 );
    if not Is48K then
    begin
      Hdr2.PC := Data.State.PC;
      Hdr2.Port7FFD := (Data.State.BankROM_0000 shl 4) or
                       (Data.State.BankVideo shl 3) or
                       (Data.State.BankRAM_C000);
      Hdr2.TRDOS_rom := 0;
      FS.Write( Hdr2, Sizeof( Hdr2 ) );
      for I := 0 to 7 do
      begin
        if (I = 5) or (I = 2) or (I = Data.State.BankRAM_C000) then
          continue;
        FS.Write( Data.RAMs[ I ], 16384 );
      end;
    end;
  FINALLY
    FS.Free;
  END;
end;

exports RegisterLoadSpectrum, LoadSpectrum, SaveSpectrum;

begin
  UseDelphiMemoryManager;
end.
