library LoadTAP;

uses
  Windows, KOL, PluginUnit;

type
  TWarajevoBlock = packed record
    PrevBlk: DWORD;
    NextBlk: DWORD;
    BlkSize: Word;
    FlgByte: Byte;
  end;

  TWarajevoBlk2 = packed record
    DecompLen: Word;
    ComprsLen: Word;
    SinatureLen: Word;
  end;

procedure RegisterLoadSpectrum( LoadFileTypes, SaveFileTypes: PChar;
          Descriptions: PChar; CanSaveS128: PByte ); stdcall;
begin
  StrCopy( LoadFileTypes, '*.TAP;*.BLK' );
  StrCopy( Descriptions, 'TAP/BLK tape image' );
end;

//{$R memory128.res}
{$R memory48.res}
function LoadSpectrum( FileData: Pointer; FileSize: Integer; FileExt: PChar;
         Data: PSpecData; ScreenOnly: Boolean ): Boolean; stdcall;
var Mem: Pointer;
    MS, RS: PStream;
    Pos: DWORD;
    WB: TWarajevoBlock;
    WB2: TWarajevoBlk2;
    L: Integer;
    B: Byte;
    W: Word;
    TapeChunk: array[ 0..3 ] of Char;
    MemSize: DWORD;
begin
  Result := FALSE;
  Data.Tape.Active := TRUE;
  if ScreenOnly then Exit;
  if (FileSize < 12) or (PDWORD( Integer( FileData ) + 8 )^ <> $FFFFFFFF) then
  begin
    RS := NewMemoryStream;
    MS := NewMemoryStream;
    TRY
      MS.Size := FileSize;
      Move( FileData^, MS.Memory^, FileSize );
      TapeChunk := 'TAPE';
      RS.Write( TapeChunk[ 0 ], 4 );
      L := 0;
      RS.Write( L, 4 ); //    
      while MS.Position < MS.Size do
      begin
        MS.Read( W, 2 );
        if W > 0 then
        begin
          B := 0;
          RS.Write( B, 1 );
          RS.Write( W, 2 );
          Stream2Stream( RS, MS, W );
          {//  3500 
          B := 1;
          RS.Write( B, 1 );
          W := 3500;
          RS.Write( W, 2 );
          L := 1;
          RS.Write( L, 4 );
          B := 0;
          RS.Write( B, 1 );}
          {// ,  /
          B := 11;
          RS.Write( B, 1 );}
        end;
      end;
      GetMem( Mem, RS.Size );
      Move( RS.Memory^, Mem^, RS.Size );
      Data.Tape.TapeImgLen := RS.Size;
      Data.Tape.Active := TRUE;
    FINALLY
      RS.Free;
      MS.Free;
    END;
  end
    else
  begin
    // Warajevo
    MS := NewMemoryStream;
    TRY
      MS.Size := FileSize;
      Move( FileData^, MS.Memory^, FileSize );
      RS := NewMemoryStream;
      TRY
        MS.Read( Pos, 4 );
        MS.Position := Pos;
        while MS.Position < MS.Size do
        begin
          L := MS.Read( WB, Sizeof( WB ) );
          if L <> Sizeof( WB ) then
          begin
            if (L <> 4) or (WB.PrevBlk <> 0) or (WB.NextBlk <> $FFFFFFFF) then
              Exit;
            break; // EOF - marker
          end;
          CASE WB.BlkSize OF
          65534: // tone record samples
            begin
              EXIT; //   
            end;
          65535: // compressed block
            begin
              if MS.Read( WB2, Sizeof( WB2 ) ) <> Sizeof( WB2 ) then Exit;
              if WB2.DecompLen <> WB2.ComprsLen then
                Exit; //   -   
              B := 0;
              RS.Write( B, 1 );
              Stream2Stream( RS, MS, WB2.DecompLen );
            end;
          else Exit;
          END;
        end;
        if RS.Size = 0 then Exit;
        GetMem( Mem, RS.Size );
        Move( RS.Memory^, Mem^, RS.Size );
        Data.Tape.TapeImgLen := RS.Size;
        Data.Tape.Active := TRUE;
      FINALLY
        RS.Free;
      END;
    FINALLY
      MS.Free;
    END;
  end;
  Data.ReleaseDescriptor := DWORD( Mem );
  Data.Tape.TapeImgData := Mem;

  {$IFDEF LOADER128}
  Data.State.AF := $7FA9;
  Data.State.BC := $9F22;
  Data.State.DE := $0011;
  Data.State.HL := $053F;
  Data.State.IX := $5CE2;
  Data.State.IY := $5C3A;
  Data.State.AFalt := $0001;
  Data.State.BCalt := $1821;
  Data.State.DEalt := $369B;
  Data.State.HLalt := $0038;
  Data.State.I := $00;
  Data.State.R := $3C;
  Data.State.IFF1 := FALSE;
  Data.State.IFF2 := FALSE;
  Data.State.ImMode := 1;
  Data.State.BorderColor := 7;

  Data.State.BankROM_0000 := 1;
  Data.State.BankVideo := 0;
  Data.State.BankRAM_C000 := 0;
  Data.State.PC := $05F5;
  Data.State.SP := $FF44;
  MemSize := 8 * 16384;
  {$ELSE}
  Data.State.AF := $FFA8;
  Data.State.BC := $EB22;
  Data.State.DE := $0011;
  Data.State.HL := $053F;
  Data.State.IX := $5CE2;
  Data.State.IY := $5C3A;
  Data.State.AFalt := $0001;
  Data.State.BCalt := $1721;
  Data.State.DEalt := $369B;
  Data.State.HLalt := $FFFF;
  Data.State.I := $3F;
  Data.State.R := $13;
  Data.State.IFF1 := FALSE;
  Data.State.IFF2 := FALSE;
  Data.State.ImMode := 1;
  Data.State.BorderColor := 7;

  Data.State.BankROM_0000 := 1;
  Data.State.BankVideo := 0;
  Data.State.BankRAM_C000 := 0;
  Data.State.PC := $05F3;
  Data.State.SP := $FF48;
  MemSize := 3 * 16384;
  {$ENDIF}

  MS := NewMemoryStream;
  TRY
    Resource2Stream( MS, hInstance, 'MEMORY', RT_RCDATA );
    if MS.Size = MemSize then
    if MemSize = 8 * 16384 then
    begin
      Move( MS.Memory^, Data.RAMs[ 0 ], 8 * 16384 );
      Result := TRUE;
    end
      else
    begin
      Move( MS.Memory^, Data.RAMs[ 1 ], MemSize );
      Move( Data.RAMs[ 1 ], Data.RAMs[ 5 ], 16384 );
      //Move( Data.RAMs[ 2 ], Data.RAMs[ 2 ], 16384 );
      Move( Data.RAMs[ 3 ], Data.RAMs[ 0 ], 16384 );
      Result := TRUE;
    end;
  FINALLY
    MS.Free;
  END;
end;

procedure ReleaseData( MemAddr: Pointer ); stdcall;
begin
  FreeMem( MemAddr );
end;

exports RegisterLoadSpectrum, LoadSpectrum, ReleaseData;

begin
  UseDelphiMemoryManager;
end.
