library SavePng;

uses
  Windows, KOL, PluginUnit, KOLPng;

procedure RegisterSpectrumScreenshots( FileTypes: PChar; Description: PChar ); stdcall;
begin
  StrCopy( FileTypes, '*.PNG' );
  StrCopy( Description, 'Portable Network Graphic image' );
end;

procedure SaveSpectrumScreen( Filename: PChar; SpecScreen: Pointer;
        Bmp: HBitmap; BmpScreenRect: PRect ); stdcall;
var P: PPngObject;
begin
  begin
    P := NewPngObject;
    P.AssignHandle( Bmp, FALSE, 0 );
    P.SaveToFile( Filename );
    DeleteObject( Bmp );
    P.Free;
  end;
end;

exports RegisterSpectrumScreenshots, SaveSpectrumScreen;

begin
  UseDelphiMemoryManager;
end.
