	.org 33h

	mov	m,e
	cmp	e
	lxi	sp,0746BH
	lxi	h,0746CH
	xra	a
	mov	c,a

clrscr:
	mov	m,c
	inx	h
	ora	h
	jp	clrscr

;--------------------------------------------------------------------------
;**************************************************************************

screen_addr	equ	0x746C  ; адрес экранной области (можно переназначить в другое место)

; параметры горизонтальной строки (в символах)
h_back		equ	8   ; отступ слева
h_act		equ	64  ; видимых символов в строке
h_front		equ	6   ; отступ справа
h_sync		equ	8   ; строчный синхроимпульс (2..32)
h_total		equ	h_back + h_act + h_front  ; общее количество символов в строке без учёта синхроимпульса (1..80)

; параметры кадра (в строках)
v_back		equ	4  ; отступ сверху
v_act		equ	30  ; видимых строк в кадре
v_front		equ	4  ; отступ снизу
v_sync		equ	1  ; кадровый синхроимпульс (1..4)
v_total		equ	v_back + v_act + v_front  ; общее количество строк в кадре без учёта синхроимпульса (1..64)

line_per_row	equ	8  ; линий в строке (1..16)
under_line	equ	8  ; позиция линии подчёркивания в строке (1..16) если этот параметр больше 8, то верхняя и нижняя линии в строке гасятся
spaced_row	equ	0  ; пропущенные строки (0..1) если 1, то каждая вторая строка гасится (соответственно и строк в кадре надо указывать в два раза меньше, и память под экран занимает в два раза меньше)
offset_line	equ	0  ; смещение для первой линии в строке символов (0..1) если 1, то первая линия строки будет отображаться второй (для псевдографики нужно ставить 0)
no_trans_attr	equ	0  ; отображаемые атрибуты (0..1) если 1, то атрибут отображается как пустой символ и занимает место в видеопамяти (на Радио-86РК стоит по умолчанию 0, поэтому если кинуть атрибутом в экран он начинает уплывать)
cursor_type	equ	1  ; тип курсора (1..4)

; команды и параметры для инициализации контроллера дисплея
disp_ctrl_addr	equ	0xC000  ; адрес контроллера дисплея
disp_reset_com	equ	0  ; команда Сброс
disp_param_1	equ	spaced_row*128 + h_total - 1
disp_param_2	equ	(v_sync - 1)*64 + v_total - 1
disp_param_3	equ	(under_line - 1)*16 + line_per_row - 1
disp_param_4	equ	offset_line*128 + no_trans_attr*64 + cursor_type*16 + h_sync/2 - 1
disp_cursor_com	equ	0x80  ; команда Установка курсора
disp_start_com	equ	0x27  ; команда Начать отображение
disp_ir_flag	equ	0x20  ; константа для проверки флага Запрос прерывания

; команды и параметры для инициализации контроллера ПДП
dma_ctrl_addr	equ	0xE000  ; адрес контроллера ПДП
dma_reset_com	equ	0x80  ; команда Сброс
dma_param_1	equ	screen_addr & 0x00FF
dma_param_2	equ	screen_addr >> 8
dma_param_3	equ	(0x4000 + h_total*v_total - 1) & 0x00FF
dma_param_4	equ	(0x4000 + h_total*v_total - 1) >> 8
dma_start_com	equ	0xA4  ; команда Запуск ПДП

InitDisplay:
	lxi	h, disp_ctrl_addr + 1
	mvi	m, disp_reset_com
	dcr	l
	mvi	m, disp_param_1
	mvi	m, disp_param_2
	mvi	m, disp_param_3
	mvi	m, disp_param_4
	inr	l
	mvi	m, disp_cursor_com
	dcr	l
	mvi	m, 0xFF
	mvi	m, 0xFF
	inr	l
	mvi	m, disp_start_com
	mov	a, m

WaitFlag:
	mov	a, m
	ani	disp_ir_flag
	jz	WaitFlag
	
InitDma:
	lxi	h, dma_ctrl_addr + 8
	mvi	m, dma_reset_com
	mvi	l, 4
	mvi	m, dma_param_1
	mvi	m, dma_param_2
	inr	l
	mvi	m, dma_param_3
	mvi	m, dma_param_4
	mvi	l, 8
	mvi	m, dma_start_com

;**************************************************************************
;--------------------------------------------------------------------------

	pic_start_addr	equ screen_addr + 140h


	h_offset equ 3Eh 	; межстрочный сдвиг
	scr_addr: dw 0000h

	lxi HL, pic_start_addr	; задаём верхний угол картинки в HL для последующей передачи в указатель
	mvi A, 0Fh		; счётчик количества изображений
	;__________________________________________________________________
	; старт отрисовки атрибутов

	mvi M, 85h
	inx H
	mvi M, 11h
	inx H

	mvi M, 8Dh
	inx H
	mvi M, 12h
	inx H

	mvi M, 81h
	mvi M, 13h		
inf_cyc:
	jmp inf_cyc


