;ͻ
;             Perlin Production Co. Ltd., May 1993 (c)                  
;Ķ
;  G r a p h i c a   M i n i m a l i s t a   L i b r a r y   ( G M L )  
;      i8080 assembler extension. Directives for register pairs.        
;Ķ
;           This code is distributed under modified BSD license         
;           For complete licensing information see LICENSE.TXT          
;ͼ
; History:
; March	2014: cosmethic changes
; May	2013: bugfixes (it took just 20 years)
; May	1993: original release

; ͸
;  S T A C K 
; ;

PushX	Macro
	push	h
	push	d
	push	b
EndM


PopX	Macro
	pop	b
	pop	d
	pop	h
EndM


PushA	Macro
	PushX
	push	psw
EndM


PopA	Macro
	pop	psw
	PopX
EndM

; ͸
;  C O M P A R I S O N 
; ;

; Compare <RPH1,RPL1> with <RPH2,RPL2>
; Bytes: 4, Speed: 24 Vector-06c cycles
; Side-effects: Changes flags, <A> is not saved

CmpRP	Macro	RPH1,RPL1,RPH2,RPL2
	mov	a,RPL1
	sub	RPL2
	mov	a,RPH1
	sbb	RPH2
EndM



; Compare <B,C> with <RPH,RPL>
; Bytes: 4, Speed: 24 Vector-06c cycles
; Side-effects: Changes flags, <A> is not saved

CmpBC	Macro	RPH,RPL
	CmpRP	B,C,RPH,RPL
EndM


; Compare <D,E> with <RPH,RPL>
; Bytes: 4, Speed: 24 Vector-06c cycles
; Side-effects: Changes flags, <A> is not saved

CmpDE	Macro	RPH,RPL
	CmpRP	D,E,RPH,RPL
EndM


; Compare <H,L> with <RPH,RPL>
; Bytes: 4, Speed: 24 Vector-06c cycles
; Side-effects: Changes flags, <A> is not saved

CmpHL	Macro	RPH,RPL
	CmpRP	H,L,RPH,RPL
EndM

; ͸
;  D A T A   A C C E S S 
; ;

; <DE> = (WORD)[<HL++>]
; Bytes: 4, Speed: 24 Vector-06c cycles
; Side-effects: none

LDXH	Macro
	mov	e,m
	inx	h
	mov	d,m
	inx	h	; hmmm...
EndM



; <DE> = (WORD)[<HL> = <DE++>]
; Bytes: 5, Speed: 28 Vector-06c cycles
; Side-effects: none
LDXD	Macro
	xchg
	LDXH
EndM
	


; <HL> = (WORD)[(<DE> = <HL++>)]
; Bytes: 5, Speed: 28 Vector-06c cycles

LHXH	Macro
	LDXH
	xchg
EndM


; <HL> = (WORD)[<DE++>]
; Bytes: 6, Speed: 36 Vector-06c cycles

LHXD	Macro
	xchg
	LHXH
EndM

; ͸
;  D A T A   E X C H A N G E 
; ;

; Exchange register pairs
;	xchg
;	XCRP	psw, b
;	XCRP	h,b
;	XCRP	d,b
; Bytes:4, Speed: 48 Vector-06c cycles
; Side-effects: none

XCRP	Macro	RP1,RP2
	push	RP1
	push	RP2
	pop	RP1
	pop	RP2
EndM


; Exchange <DE> and *<SP> (xthl for equivalent <DE>)
; Bytes: 3, Speed: 28 Vector-06c cycles
; Side-effects: none

XTDE	Macro
	xchg
	xthl
	xchg
EndM



; Exchange <BC> and *<SP> (xthl for equivalent <BC>)
; Bytes: 6, speed: 80 Vector-06c cycles
; Side-effects: none

XTBC	Macro
	xthl
	push	b
	mov	b,h
	mov	c,l
	pop	h
	xthl
EndM
	


; Exchange memory words VAR1,VAR2
; Bytes: 18, Speed: 136 Vector-06c cycles
; Side-effects: none

XCWM	MACRO	VAR1,VAR2
	push h
	push d
	lhld VAR1
	xchg
	lhld VAR2
	shld VAR1
	xchg
	shld VAR2
	pop d
	pop h
EndM

; ͸
;  A R I T H M E T I C 
; ;

; Inverts each bit of <RPH,RPL> to produce one's complement.
; Add one to RP (inx RPH) to produce two's complement
; Flags remain unchanged
; Bytes: 6, Speed; 40 Vector-06c cycles
; Side-effects: <A> is lost

CMRP	Macro	RPH,RPL
	mov	a,RPL
	cma
	mov	RPL,a
	mov	a,RPH
	cma
	mov 	RPH,a
EndM


; Inverts each bit of <H,L> to produce one's complement.
; Add one to <HL> (inx H) to produce two's complement
; Flags remain unchanged
; Bytes: 6, Speed; 40 Vector-06c cycles
; Side-effects: <A> is lost

CMHL	Macro
	CMRP	H,L
EndM


; Inverts each bit of <D,E> to produce one's complement.
; Add one to <DE> (inx D) to produce two's complement
; Flags remain unchanged
; Bytes: 6, Speed; 40 Vector-06c cycles
; Side-effects: <A> is lost

CMDE	Macro
	CMRP	D,E
EndM


; Inverts each bit of <B,C> to produce one's complement.
; Add one to <BC> (inx B) to produce two's complement
; Flags remain unchanged
; Bytes: 6, Speed; 40 Vector-06c cycles
; Side-effects: <A> is lost

CMBC	Macro
	CMRP	B,C
EndM


; Subtract <RPH2,RPL2> from <RPH1,RPL1>
; Bytes: 6, Speed; 40 Vector-06c cycles
; so use complemented DAD whenever possible
; Side-effects: Changes flags, <A> is not saved

SubRP	Macro	RPH1,RPL1,RPH2,RPL2
	mov	a,RPL1
	sub	RPL2
	mov	RPL1,a
	mov	a,RPH1
	sbb	RPH2
	mov	RPH1,a
EndM


; Subtract <RPH,RPL> from <H,L>
; Bytes: 6, Speed; 40 Vector-06c cycles
; Side-effects: Changes flags, <A> is not saved

SubHL	Macro	RPH,RPL
	SubRP	H,L,RPH,RPL
EndM


; Subtract <RPH,RPL> from <D,E>
; Bytes: 6, Speed; 40 Vector-06c cycles
; Side-effects: Changes flags, <A> is not saved

SubDE	Macro	RPH,RPL
	SubRP	D,E,RPH,RPL
EndM


; Subtract <RPH,RPL> from <B,C>
; Bytes: 6, Speed; 40 Vector-06c cycles
; Side-effects: Changes flags, <A> is not saved

SubBC	Macro	RPH,RPL
	SubRP	B,C,RPH,RPL
EndM


; Declares Word and adds it to <HL>
; 24 Vector-06c cycles
DadDW	Macro	_var,_rp
	DB	(lxi	_rp)
_var:	DW	0
	dad	_rp
EndM
