scr_addr: 
.WORD 0000h
	
DRAWPIC_APG:
	push PSW
	push B
	push D
	push H
	
	lxi H, $E330	; задаём верхний угол картинки в HL для последующей передачи в указатель
	
	;__________________________________________________________________
	; старт процедуры отрисовки картинки

	shld scr_addr		; задать начальную точку в указателе scr_addr

	lxi B, $0F04		; задать в BC размер картинки
	lxi H, pic		; загрузили в HL адрес старта картинки

	call draw_pic		; процедура отрисовки картинки

		
	;-----------------------------------------------------------------
	
	pop H
	pop D
	pop B
	pop PSW
	ret
	


;_________________________________________________________________________
; процедура отрисовки картинки расположенной по адресу pic, размером BC
draw_pic:
	push PSW
	push D

	mov A, C		; загрузили в A длину строки в байтах
	add A			; умножаем А на 2, чтобы счётчик ходил через строку
				; так как одна строка псевдографики задаётся двумя строками байт

next_pic_str:	
	push PSW		; старт обхода одной строки
	push H
	
	mov A, C

get_next_byte:
	mov D, M		; записываем в D байт с адреса HL
	call d_pair_wr		; записываем в E пару для D

	; рисуем DE		
	push H
	lhld scr_addr		; вытаскиваем указатель на адрес видеопамяти из scr_addr

	call draw_byte_pair

	inx H			; двигаем указатель на байт вправо
	shld scr_addr
	pop H

	inx H
	dcr A
	jnz get_next_byte
	
	call scr_addr_next_line ; теперь надо указатель видеопамяти сдвинуть на строку вниз

	pop H
	pop PSW			; финиш обхода одной строки

	

	call pic_point_ns	; сдвигаем указатель на следующую строку псевдографики
	dcr B			; вычитаем строку из B
	jnz next_pic_str	; если строка не последняя, то продолжить чтение строк

	pop D
	pop PSW
	ret
;-------------------------------------------------------------------


;___________________________________________________________________
; процедура сдвига адреса видеопамяти на строку вниз
scr_addr_next_line:
	push PSW
	push H

	mvi A, 3Eh
	lhld scr_addr
sa_next:
	inx H	
	dcr A
	jnz sa_next

	shld scr_addr

	pop H
	pop PSW
	ret
;-------------------------------------------------------------------

;___________________________________________________________________
; процедура вычисления пары для байта в регистре D, 
; для этого требуется сдвинуть указатель адреса HL на длину строки 

d_pair_wr:
	push PSW
	push H
	mov A, C

dpwr_next_byte:	
	inx H
	dcr A
	jnz dpwr_next_byte
	
	mov E, M

	pop H
	pop PSW
	ret
;------------------------------------------------------------------

;___________________________________________________________________
; процедура сдвига указателя НL на следующую строку псевдографики

pic_point_ns:			
	push B
	mov B, A

ppns_inc:
	inx H
	dcr A
	jnz ppns_inc

	mov A, B
	pop B
	ret
;------------------------------------------------------------------

draw_byte_pair: 		; загрузить в DE пару соседних байт изображения
				; загрузить в HL координаты
	push B
	push PSW

	push H

	mov A, D
	mvi B, 0F0h
	ana B
	mov B, A 		; посчитали верх первого байта

	mov A, E
	mvi C, 0F0h
	ana C
	rrc
	rrc
	rrc
	rrc
	mov C, A 		; посчитали низ первого байта
	ora B 			; сделали из них один байт, готовый для дешифровки
	mov H, A

	mov A, D
	mvi B, 00Fh
	ana B
	rrc
	rrc
	rrc
	rrc
	mov B, A 		; посчитали верх второго байта

	mov A, E
	mvi C, 00Fh
	ana C
	mov C, A 		; посчитали низ второго байта
	ora B 			; сделали из них второй байт, готовый для дешифровки
	mov L, A

	xchg
	pop H 			; не забыть вернуть из стека адрес видеопамяти 
				; HL после записи его в DE

	mov B, D 		; сохраняем оба байта DE в BC
	mov C, E


				; раскодируем и печатаем первый байт

	mov E, D 		; загружаем в E первый байт
	call byte_to_pix 	; на выходе должны получить в DE два байта для отрисовки

	mov A, D 		; грузим в A закодированный символ (пример)
	call pix_to_sym 	; загрузить в A закодированный символ знакоместа
	mov M, A 		; pix_to_sym вернёт в A раскодированный символ, его и печатаем

	inx H

	mov A, E 		; грузим в A закодированный символ (пример)
	call pix_to_sym 	; загрузить в A закодированный символ знакоместа
	mov M, A 		; pix_to_sym вернёт в A раскодированный символ, его и печатаем

				; раскодируем и печатаем второй байт

	inx H

	mov E, C 		; загружаем в E первый байт
	call byte_to_pix 	; на выходе должны получить в DE два байта для отрисовки

	mov A, D 		; грузим в A закодированный символ (пример)
	call pix_to_sym 	; загрузить в A закодированный символ знакоместа
	mov M, A 		; pix_to_sym вернёт в A раскодированный символ, его и печатаем

	inx H

	mov A, E 		; грузим в A закодированный символ (пример)
	call pix_to_sym 	; загрузить в A закодированный символ знакоместа
	mov M, A 		; pix_to_sym вернёт в A раскодированный символ, его и печатаем

	pop PSW
	pop B
	ret


byte_to_pix: 			; загрузить в E 8 бит точек в двух знакоместах
	push PSW 		; друг над другом и получить в DE два байта
				; закодированных символов 
	mov A, E
	mvi D, 0CCh
	ana D
	mov D, A

	mov A, E
	mvi E, 33h
	ana E
	rlc
	rlc
	mov E, A

	pop PSW
	ret

pix_to_sym: 			; загрузить в A закодированный символ знакоместа
	cpi 04h 		; pix_to_sym вернёт в A раскодированный символ
	rz
	cpi 80h
	jz sym01h
	cpi 40h
	jz sym02h
	cpi 0C0h
	jz sym03h
	cpi 08h
	jz sym10h
	cpi 88h
	jz sym11h 
	cpi 84h
	jz sym05h
	cpi 48h
	jz sym12h
	cpi 44h
	jz sym06h
	cpi 0Ch
	jz sym14h
	cpi 0C8h
	jz sym13h
	cpi 0C4h
	jz sym07h
	cpi 8Ch
	jz sym15h
	cpi 4Ch
	jz sym16h
	cpi 0CCh
	jz sym17h

	mvi A, 00h
	ret
 

sym01h: mvi A, 01h
	ret
sym02h: mvi A, 02h
	ret
sym03h: mvi A, 03h
	ret
sym10h: mvi A, 10h
	ret
sym11h: mvi A, 11h
	ret
sym05h: mvi A, 05h
	ret
sym12h: mvi A, 12h
	ret
sym06h: mvi A, 06h
	ret
sym14h: mvi A, 14h
	ret
sym13h: mvi A, 13h
	ret
sym07h: mvi A, 07h
	ret
sym15h: mvi A, 15h
	ret
sym16h: mvi A, 16h
	ret
sym17h: mvi A, 17h
	ret

pic: 
.byte 80h
.byte 0Ch
.byte 00h
.byte 03h
.byte 3Fh
.byte 0C0h
.byte 04h
.byte 10h
.byte 2Ah
.byte 40h
.byte 24h
.byte 10h
.byte 0Eh
.byte 00h
.byte 38h
.byte 30h
.byte 06h
.byte 00h
.byte 0Ch
.byte 30h
.byte 06h
.byte 00h
.byte 4Eh
.byte 00h
.byte 06h
.byte 41h
.byte 0DBh
.byte 00h
.byte 06h
.byte 0A1h
.byte 10h
.byte 00h
.byte 86h
.byte 0B3h
.byte 10h
.byte 3Ch
.byte 0Eh
.byte 0E3h
.byte 18h
.byte 34h
.byte 08h
.byte 0C1h
.byte 88h
.byte 3Ch
.byte 60h
.byte 70h
.byte 8Ch
.byte 3Ch
.byte 84h
.byte 18h
.byte 8Ch
.byte 00h
.byte 32h
.byte 08h
.byte 8Ch
.byte 00h
.byte 7Ah
.byte 01h
.byte 08h
.byte 18h
.byte 6Ah
.byte 07h
.byte 0Ch
.byte 3Ch
.byte 7Ah
.byte 1Ch
.byte 06h
.byte 78h
.byte 32h
.byte 30h
.byte 02h
.byte 00h
.byte 84h
.byte 60h
.byte 00h
.byte 00h
.byte 78h
.byte 0DFh
.byte 0A1h
.byte 77h
.byte 00h
.byte 93h
.byte 0A2h
.byte 15h
.byte 01h
.byte 90h
.byte 0A6h
.byte 25h
.byte 01h
.byte 13h
.byte 0BEh
.byte 77h
.byte 01h
.byte 1Eh
.byte 33h
.byte 00h
.byte 01h
.byte 98h
.byte 31h
.byte 27h
.byte 20h
.byte 98h
.byte 31h
.byte 61h
.byte 50h
.byte 98h
.byte 31h
.byte 22h
.byte 0A8h
.byte 10h
.byte 21h
.byte 72h
.byte 0A8h
.byte 02h
.byte 04h
.byte 00h
.byte 0Fh
.byte 88h
.byte 91h
.byte 7Fh