;_________________________________________________________________________
; процедура сдвига колонки влево на пиксель

#DEFINE pic_top_left=3000
row_pointer: .WORD pic_top_left
col_num: .BYTE 00h
row_num: .BYTE 00h

move_col:

	;прочитать задвигаемую колонку (слева)
	;прочитать придвигаемую колонку (справа)
	;сделать цикл на количество рядов

	mov A, H
	sta col_num
	mov A, L

next_row:
	sta row_num
	lhld row_pointer
	lxi BC,004Eh
	inr A
	dcr A
	jz skip_add

move_to_row:
	dad B
	dcr A
	jnz move_to_row

skip_add:
	mvi B,0
	lda col_num
	mov C,A

	dad B
	
	;в каждом ряду взять два соседних байта

	mov A, M
	call decode_sym
	mov D, A
	inx H
	mov A, M
	call decode_sym
	mov E, A

	;расшифровать их в пиксели

	mvi A, 05h
	ana D
	rlc
	mov D, A
	
	mvi A, 0Ah
	ana E
	rrc
	
	ora D
	
	;конвертнуть в байт левую часть и отрисовать

	call encode_sym
	dcx H
	mov M, A


	lda row_num
	dcr A
	jp next_row

	ret

;-------------------------------------------------------------------




;______________________________
; процедура выявления того, 
; что уже закрашено

decode_sym: 			; загрузить в A символ знакоместа
	cpi 01h			; вернуть в A биты пикселей
	jz sym08h
	cpi 02h
	jz sym04h
	cpi 03h
	jz sym0Ch
	cpi 04h 		
	jz sym01h
	cpi 05h
	jz sym09h
	cpi 06h
	jz sym05h
	cpi 07h
	jz sym0Dh

	cpi 10h
	jz sym02h
	cpi 11h
	jz sym0Ah
	cpi 12h
	jz sym06h
	cpi 13h
	jz sym0Eh
	cpi 14h
	jz sym03h 
	cpi 15h
	jz sym0Bh
	cpi 16h
	jz sym07h
	cpi 17h
	jz sym0Fh

	mvi A, 00h
	ret


sym01h: mvi A, 01h
	ret
sym02h: mvi A, 02h
	ret
sym03h: mvi A, 03h
	ret
sym04h: mvi A, 04h
	ret
sym05h: mvi A, 05h
	ret
sym06h: mvi A, 06h
	ret
sym07h: mvi A, 07h
	ret
sym08h: mvi A, 08h
	ret
sym09h: mvi A, 09h
	ret
sym0Ah: mvi A, 0Ah
	ret
sym0Bh: mvi A, 0Bh
	ret
sym0Ch: mvi A, 0Ch
	ret
sym0Dh: mvi A, 0Dh
	ret
sym0Eh: mvi A, 0Eh
	ret
sym0Fh: mvi A, 0Fh
	ret

; конец процедуры
;------------------------------




;______________________________
; процедура кодирования символа для печати

encode_sym:
	cpi 01h			; вернуть в A биты пикселей
	jz esym04h
	cpi 02h
	jz esym10h
	cpi 03h
	jz esym14h
	cpi 04h
	jz esym02h
	cpi 05h
	jz esym06h
	cpi 06h
	jz esym12h
	cpi 07h
	jz esym16h
	cpi 08h 		
	jz esym01h
	cpi 09h
	jz esym05h
	cpi 0Ah
	jz esym11h
	cpi 0Bh
	jz esym15h
	cpi 0Ch
	jz esym03h
	cpi 0Dh
	jz esym07h
	cpi 0Eh
	jz esym13h
	cpi 0Fh
	jz esym17h

	mvi A, 00h
	ret


esym01h: mvi A, 01h
	ret
esym02h: mvi A, 02h
	ret
esym03h: mvi A, 03h
	ret
esym04h: mvi A, 04h
	ret
esym05h: mvi A, 05h
	ret
esym06h: mvi A, 06h
	ret
esym07h: mvi A, 07h
	ret

esym10h: mvi A, 10h
	ret
esym11h: mvi A, 11h
	ret
esym12h: mvi A, 12h
	ret
esym13h: mvi A, 13h
	ret
esym14h: mvi A, 14h
	ret
esym15h: mvi A, 15h
	ret
esym16h: mvi A, 16h
	ret
esym17h: mvi A, 17h
	ret

; конец процедуры
;------------------------------


