// Заголовок
byte SB[27] = { 
  0x4E, 0x4F, 0x44, 0x49, 0x53, 0x43, 0x30, 0x30, // NODISK00
  0x31, 0x39, 0x30, 0x31, 0x31, 0x38,             // дата 190118
  0x74, 0x65, 0x73, 0x74, 0x74, 0x70, 0x20, 0x20, // testtp.....
  0x20, 0x20, 0x20, 0x00, 0x00 };
// собственно, сама программа -- тест техпрогона
byte St[1024] = {
  0xC3, 0x3D, 0x01, 0x77, 0x65, 0x6B, 0x74, 0x6F,  0x72, 0x2D, 0x30, 0x36, 0x63, 0x54, 0x45, 0x53,
  0x54, 0x20, 0x56, 0x28, 0x31, 0x2E, 0x31, 0x29,  0x20, 0x20, 0x72, 0x61, 0x7A, 0x72, 0x61, 0x62,
  0x2E, 0x74, 0x65, 0x6D, 0x69, 0x72, 0x61, 0x7A,  0x6F, 0x77, 0x20, 0x64, 0x2E, 0x61, 0x2E, 0x20,
  0x2C, 0x73, 0x6F, 0x6B, 0x6F, 0x6C, 0x6F, 0x77,  0x20, 0x61, 0x2E, 0x61, 0x2E, 0x3E, 0x80, 0xD3,
  0x04, 0x3E, 0xC3, 0x32, 0x00, 0x00, 0x3E, 0xC9,  0x32, 0x38, 0x00, 0x21, 0x01, 0x00, 0x22, 0xE6,
  0x04, 0x21, 0x3D, 0x01, 0x22, 0x01, 0x00, 0x21,  0x00, 0x05, 0x11, 0x01, 0x00, 0xAF, 0x77, 0x23,
  0x77, 0x23, 0x77, 0x23, 0x77, 0x19, 0xD2, 0x5E,  0x01, 0x31, 0x00, 0x01, 0x3E, 0x88, 0xD3, 0x00,
  0xCD, 0xD7, 0x02, 0x3E, 0x03, 0xD3, 0x02, 0x3E,  0x02, 0xD3, 0x01, 0x3E, 0xFF, 0xD3, 0x03, 0xCD,
  0xB4, 0x03, 0x21, 0x55, 0x9E, 0x06, 0x04, 0x0E,  0x08, 0x3E, 0xFF, 0xCD, 0x71, 0x03, 0x7C, 0xD6,
  0x04, 0x67, 0x0D, 0xC2, 0x89, 0x01, 0x7C, 0xC6,  0x20, 0x67, 0x7D, 0xC6, 0x20, 0x6F, 0x05, 0xC2,
  0x87, 0x01, 0x06, 0x80, 0x2A, 0xE6, 0x04, 0xE5,  0x7C, 0x21, 0x34, 0x8A, 0xF5, 0xCD, 0x38, 0x03,
  0xF1, 0x21, 0x34, 0xCA, 0xCD, 0x38, 0x03, 0xE1,  0x7D, 0x21, 0x34, 0x94, 0xF5, 0xCD, 0x38, 0x03,
  0xF1, 0x21, 0x34, 0xD4, 0xCD, 0x38, 0x03, 0x21,  0x00, 0x05, 0x78, 0x07, 0x47, 0x4E, 0x70, 0x7E,
  0x71, 0xB8, 0xCA, 0xFF, 0x01, 0xCD, 0x04, 0x03,  0xE5, 0x21, 0x1A, 0x9E, 0xCD, 0x38, 0x03, 0xE1,
  0xE5, 0x7C, 0x21, 0x1A, 0xAA, 0xCD, 0x38, 0x03,  0xE1, 0xE5, 0x7D, 0x21, 0x1A, 0xB4, 0xCD, 0x38,
  0x03, 0x3A, 0x9E, 0x04, 0x3C, 0x32, 0x9E, 0x04,  0x21, 0x0C, 0xB4, 0xCD, 0x38, 0x03, 0xE1, 0x7D,
  0xB7, 0xC2, 0x23, 0x02, 0xE5, 0x7C, 0xD3, 0x07,  0x21, 0x27, 0xCA, 0xCD, 0x38, 0x03, 0xE1, 0xE5,
  0x7D, 0xD3, 0x06, 0x21, 0x27, 0xD4, 0xCD, 0x38,  0x03, 0x78, 0xD3, 0x05, 0x21, 0x27, 0xFE, 0xCD,
  0x38, 0x03, 0xE1, 0x23, 0x7C, 0xFE, 0x00, 0xC2,  0xCD, 0x01, 0x3E, 0x80, 0xB8, 0xC2, 0xA4, 0x01,
  0xE5, 0x2E, 0x00, 0xCD, 0x99, 0x02, 0xCD, 0x99,  0x02, 0x21, 0xDC, 0x05, 0x3E, 0x36, 0xD3, 0x08,
  0x7D, 0xD3, 0x0B, 0x7C, 0xD3, 0x0B, 0x2E, 0xFF,  0xCD, 0x99, 0x02, 0x21, 0xEE, 0x02, 0x3E, 0x76,
  0xD3, 0x08, 0x7D, 0xD3, 0x0A, 0x7C, 0xD3, 0x0A,  0x2E, 0x01, 0xCD, 0x99, 0x02, 0x21, 0xF4, 0x01,
  0x3E, 0xB6, 0xD3, 0x08, 0x7D, 0xD3, 0x09, 0x7C,  0xD3, 0x09, 0x2E, 0x00, 0xCD, 0x99, 0x02, 0x21,
  0xFF, 0xFF, 0x3E, 0x00, 0xD3, 0x02, 0x2B, 0xD3,  0x01, 0x7C, 0xB5, 0xC2, 0x76, 0x02, 0x3E, 0x03,
  0xD3, 0x02, 0x2A, 0xE6, 0x04, 0x23, 0x22, 0xE6,  0x04, 0xE1, 0x3E, 0x30, 0xD3, 0x08, 0x3E, 0x70,
  0xD3, 0x08, 0x3E, 0xB0, 0xD3, 0x08, 0xC3, 0xA4,  0x01, 0x26, 0x00, 0x3E, 0xFF, 0xFB, 0x76, 0xD3,
  0x03, 0xF5, 0xE5, 0x21, 0x78, 0x02, 0x2B, 0x7C,  0xB5, 0xC2, 0xA6, 0x02, 0x2E, 0x0F, 0x26, 0x52,
  0x7D, 0xD3, 0x02, 0x25, 0xC2, 0xB3, 0x02, 0x2D,  0xC2, 0xAE, 0x02, 0x3E, 0x03, 0xD3, 0x02, 0xE1,
  0xF1, 0x85, 0x24, 0xC2, 0x9D, 0x02, 0xC9, 0xF6,  0xA4, 0x52, 0x00, 0xC0, 0x80, 0x40, 0x00, 0x20,
  0x10, 0x08, 0x00, 0x04, 0x02, 0x01, 0x24, 0xFB,  0x76, 0xF5, 0xE5, 0xD5, 0x11, 0x0F, 0x10, 0x21,
  0xC7, 0x02, 0x7B, 0xD3, 0x02, 0x7E, 0xD3, 0x0C,  0x23, 0xD3, 0x0C, 0x1D, 0xD3, 0x0C, 0x15, 0xD3,
  0x0C, 0x14, 0xD3, 0x0C, 0x15, 0xD3, 0x0C, 0x14,  0xD3, 0x0C, 0x15, 0xD3, 0x0C, 0xC2, 0xE2, 0x02,
  0xD1, 0xE1, 0xF1, 0xC9, 0xE5, 0xC5, 0x4F, 0x2E,  0x35, 0x7C, 0xE6, 0x60, 0x67, 0x7D, 0xC6, 0x20,
  0x6F, 0x7C, 0xD6, 0x20, 0x67, 0xF2, 0x0D, 0x03,  0x79, 0xA8, 0x26, 0xBE, 0x47, 0x7C, 0xC6, 0x04,
  0x67, 0xFE, 0xE2, 0xCA, 0x34, 0x03, 0x78, 0x1F,  0x47, 0xD2, 0x1D, 0x03, 0x3E, 0x55, 0xCD, 0x71,
  0x03, 0xC3, 0x1D, 0x03, 0x79, 0xC1, 0xE1, 0xC9,  0xC5, 0xD5, 0xE5, 0x06, 0x08, 0x4F, 0x78, 0xFE,
  0x04, 0xC2, 0x45, 0x03, 0x25, 0x79, 0x1F, 0x4F,  0xD2, 0x51, 0x03, 0x11, 0x94, 0x04, 0xC3, 0x54,
  0x03, 0x11, 0x8A, 0x04, 0xCD, 0x60, 0x03, 0x25,  0x05, 0xC2, 0x3E, 0x03, 0xE1, 0xD1, 0xC1, 0xC9,
  0xC5, 0xD5, 0xE5, 0x06, 0x0A, 0x1A, 0x77, 0x2D,  0x13, 0x05, 0xC2, 0x65, 0x03, 0xE1, 0xD1, 0xC1,
  0xC9, 0xC5, 0xD5, 0xE5, 0xFE, 0xFF, 0xCA, 0x93,  0x03, 0x11, 0xA4, 0x03, 0x4C, 0x21, 0xAC, 0x03,
  0xF5, 0x1A, 0xB9, 0x46, 0x13, 0x23, 0xC2, 0x81,  0x03, 0xF1, 0xE1, 0xE5, 0x60, 0x11, 0x72, 0x04,
  0xC3, 0x96, 0x03, 0x11, 0x5A, 0x04, 0x06, 0x18,  0x1A, 0x77, 0x13, 0x2D, 0x05, 0xC2, 0x98, 0x03,
  0xE1, 0xD1, 0xC1, 0xC9, 0xC2, 0xC6, 0xCA, 0xCE,  0xD2, 0xD6, 0xDA, 0xDE, 0xC6, 0xC2, 0xCE, 0xCA,
  0xD6, 0xD2, 0xDE, 0xDA, 0x06, 0x18, 0x3E, 0xFF,  0x26, 0x88, 0x0E, 0x38, 0x2E, 0xF8, 0x77, 0x2D,
  0x0D, 0xC2, 0xBE, 0x03, 0x24, 0x05, 0xC2, 0xBA,  0x03, 0x21, 0xE0, 0xEA, 0x3E, 0x01, 0xCD, 0x32,
  0x04, 0x24, 0x3C, 0xFE, 0x10, 0xC2, 0xCE, 0x03,  0x21, 0xF0, 0x81, 0xCD, 0xE1, 0x03, 0x21, 0xF0,
  0x99, 0x06, 0x03, 0x11, 0x9F, 0x04, 0xE5, 0x3E,  0x04, 0xF5, 0xE5, 0x0E, 0x09, 0x1A, 0x77, 0x2B,
  0x13, 0x0D, 0xC2, 0xED, 0x03, 0xE1, 0xF1, 0x24,  0x3D, 0xC2, 0xE9, 0x03, 0xE1, 0x11, 0xF0, 0x20,
  0x19, 0x05, 0xC2, 0xE3, 0x03, 0xD5, 0xE5, 0xC5,  0x21, 0xEB, 0x8B, 0x11, 0xC3, 0x04, 0xCD, 0x27,
  0x04, 0x21, 0xEB, 0x8F, 0xCD, 0x27, 0x04, 0x21,  0xEB, 0x93, 0xCD, 0x27, 0x04, 0x21, 0xEB, 0x97,
  0xCD, 0x27, 0x04, 0xC1, 0xE1, 0xD1, 0xC9, 0x06,  0x09, 0x1A, 0x77, 0x13, 0x2B, 0x05, 0xC2, 0x29,
  0x04, 0xC9, 0xF5, 0xE5, 0x57, 0x0E, 0x04, 0x06,  0x18, 0xE5, 0x7A, 0x0F, 0x57, 0xD2, 0x45, 0x04,
  0x3E, 0xFF, 0xC3, 0x46, 0x04, 0xAF, 0x77, 0x2D,  0x05, 0xC2, 0x46, 0x04, 0xE1, 0xD5, 0x11, 0x00,
  0xE0, 0x19, 0xD1, 0x0D, 0xC2, 0x37, 0x04, 0xE1,  0xF1, 0xC9, 0xFF, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x85,
  0x81, 0xFF, 0xFF, 0x81, 0x85, 0xA9, 0x91, 0xBD,  0x81, 0x81, 0xBD, 0xA9, 0xA9, 0x9D, 0x81, 0x91,
  0xA9, 0xA9, 0xBD, 0x81, 0x81, 0xAD, 0xAD, 0xBD,  0x81, 0xFF, 0x7C, 0xC6, 0xCE, 0xCE, 0xD6, 0xD6,
  0xE6, 0xE6, 0xC6, 0x7C, 0x04, 0x0C, 0x1C, 0x3C,  0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x3E, 0x00, 0x00,
  0x7F, 0x5D, 0x1C, 0x1C, 0x1C, 0x1C, 0x3E, 0x00,  0x00, 0x00, 0x00, 0x3E, 0x63, 0x7F, 0x60, 0x3E,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0x60, 0x3E, 0x03,  0x7E, 0x00, 0x00, 0x08, 0x18, 0x7F, 0x18, 0x18,
  0x19, 0x0E, 0x00, 0x00, 0x7C, 0x66, 0x66, 0x7C,  0x78, 0x6C, 0x66, 0x00, 0x00, 0x3C, 0x66, 0x6E,
  0x60, 0x66, 0x66, 0x3C, 0x00, 0x00, 0x7C, 0x66,  0x66, 0x7C, 0x66, 0x66, 0x7C, 0x00, 0x00, 0x66,
  0x66, 0x24, 0x18, 0x18, 0x3C, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

int p = 3; // номер пина, на который будет вывод сигнала

void setup() //процедура setup
{
  pinMode(p, OUTPUT); //объявляем пин как выход
}

void loop() //процедура loop
{
  tone(p, 500, 100); //включаем на 500 Гц на 100 мс
  delay(1000);       //ждем 1 с

  byte BLs = 0x01; // начальный блок
  byte BLe = 0x04; // всего блоков
  byte BLt;        // осталось блоков
  byte Nst;        // номер строки
  int  Nbt = 0;    // номер байта из массива 

  byte CSz = 0x00; // контрольная сумма заголовка
  byte CSs = 0x00; // контрольная сумма строки
  byte i;
  byte j;

  for (i=0; i<=3; i++){           // преамбула (4*(00H*25+55H*25))
    for (j=0; j<=24; j++){
      SendByte(0x00);
    }
    for (j=0; j<=24; j++){
      SendByte(0x55);
    }
  }  

  for (BLt=BLe; BLt>=1; BLt--){   // Вывод блоков данных
    CSz = BLs;
    CSz += BLe;
    CSz += BLt;
    for (j=0; j<=15; j++){        // 00h*16
      SendByte(0x00);
    }
    for (j=0; j<=3; j++){         // 55h*4
      SendByte(0x55);
    }
    SendByte(0xE6);               // E6h*1
    for (j=0; j<=3; j++){         // 00h*4
      SendByte(0x00);
    }

    for (j=0; j<=26; j++){        // заголовок блока
      CSz += SB[j];
      SendByte(SB[j]);
    }
    SendByte(BLs);                // начальный блок
    SendByte(BLe);                // конечный блок
    SendByte(BLt);                // осталось блоков
    SendByte(CSz);                // контр.сумма заголовка

    for (Nst=0x80; Nst<=0x87; Nst++){   // вывод строк (8 шт.)
      for (j=0; j<=3; j++){       // 00h*4
        SendByte(0x00);
      }
      SendByte(0xE6);             // E6h*1
      CSs = Nst;
      SendByte(Nst);              // номер строки
      CSs += CSz;
      SendByte(CSz);              // контр.сумма заголовка

      for (j=0; j<=31; j++){      // собственно, строка данных
        CSs += St[Nbt];
        SendByte(St[Nbt]);
        Nbt++;
      }
      SendByte(CSs);              // контр.сумма строки
    }  
  }

  for (j=0; j<=15; j++){          // 00h*16 -- завершение вывода программы (?)
    SendByte(0x00);
  }

  delay(15000);   // ждем 15 с
}

void SendByte(byte SBt){          // Подпрограмма вывода байта
  byte Pd=PORTD;
  byte i=8;
  do{                 // Выводим биты начиная со старшего
    i--;
    if ((bitRead(Pd, p))^(bitRead(SBt, i))){ // Если состояние порта и выводимый бит разные
      Pd ^= (1 << p); // инвертируем бит в позиции p=3
      PORTD = Pd;     // вывод в порт p
    }
    else{
      delayMicroseconds(128); // Задержка для выравнивания длительности сигнала
    }
    delayMicroseconds(256);   // Задержка первого полупериода сигнала
    Pd ^= (1 << p);   // инвертируем бит в позиции p
    PORTD = Pd;       // вывод в порт p
    delayMicroseconds(256);   // Задержка второго полупериода сигнала
  } 
  while (i>0);
}

