--------------------------------------------------------------------------------
--  PROShIVKA PLIS DLJa USTROJSTVA: "ZXKit1 - PLATA VGA & PAL"                  --                        
--  VERSIJa:  V2.0.9.02                                          DATA: 100304  --
--  AVTOR:   SABIRZhANOV VADIM                                                 --
--                                                                            --
--  PLIS: EPM3128ATC100-10N (128 MACROCELLS, KORPUS TQFP100)                  --
--  OZU:  K6R4016V1D-UI10 (256K * 16 bit)                                     --
--  TAKTOVAJa ChASTOTA: 14/12/10/8 MGc,                                         --
--                    PODAETSJa SO SPEKTRUMA, PROFI, ORIONA ILI SPECIALISTA    --
--  SREDA RAZRABOTKI: Quartus II Version 9.0 Web Edition                      --
--------------------------------------------------------------------------------

-- Compilation Report:
-- Warnings        = 50
-- Total macrocels = 126/128
-- Total pins      = 69/80

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;


entity VGA_PAL is
	port
	(

--------------------------------------------------------------------------------
--                 VHODNYE SIGNALY PLIS SO SPEKTRUMA                  091103  --
--------------------------------------------------------------------------------

RX0_IN        : in std_logic := '1'; -- cifrovoj RED
GX0_IN        : in std_logic := '1'; -- cifrovoj GREEN
RX1_IN        : in std_logic := '1'; -- cifrovoj RED
GX1_IN        : in std_logic := '1'; -- cifrovoj GREEN
BX1_IN        : in std_logic := '1'; -- cifrovoj BLUE
RX2_IN        : in std_logic := '1'; -- cifrovoj RED
GX2_IN        : in std_logic := '1'; -- cifrovoj GREEN
BX2_IN        : in std_logic := '1'; -- cifrovoj BLUE
KSI_IN      : in std_logic := '1'; -- kadrovye sinhroimpul'sy
SSI_IN      : in std_logic := '1'; -- strochnye sinhroimpul'sy
F14         : in std_logic := '1'; -- taktovye impul'sy chastotoj 14 MGc
F14_2       : in std_logic := '1'; -- F14, zaderzhannyj s pomoshh'ju dvuh invertorov


--------------------------------------------------------------------------------
--             PEREMYChKI / TUMBLERY DLJa UPRAVLENIJa REZhIMAMI           090812  --
--------------------------------------------------------------------------------

--INVERSE_RGBI  : in std_logic := '0'; -- inversija koda cveta: 
--                                     -- 0 - invertirovat', 1 - net.
--                                      
--INVERSE_KSI   : in std_logic := '1'; -- inversija kadrovyh sinhroimpul'sov: 
--                                     -- 0 - invertirovat', 1 - net.
--                                      
--INVERSE_SSI   : in std_logic := '1'; -- inversija strochnyh sinhroimpul'sov: 
--                                     -- 0 - invertirovat', 1 - net.
--                                      
--INVERSE_F14MHZ: in std_logic := '1'; -- inversija taktovyh impul'sov: 
--                                     -- 0 - invertirovat', 1 - net.
--
--VGA_SCART     : in std_logic := '1'; -- vybor signala na raz#eme VGA: 
--                                     -- 0 - dlja SCART, 1 - dlja VGA.
--
--SET_FK_IN     : in std_logic := '1'; -- ustanovka vhodnoj chastoty kadrov: 
--                                     -- 0 - 50 Gc(312 strok), 1 - 48 Gc(320 st.)
--                                      
--SET_FK_OUT    : in std_logic := '1'; -- ustanovka vyhodnoj chastoty kadrov: 
--                                     -- 1 - 60 Gc, 0 - 50/48 Gc.

--------------------------------------------------------------------------------
--                     VYHODNYE PORTY PLIS DLJa VGA                    090728  --
--------------------------------------------------------------------------------

R_VGA      : out std_logic_vector (2 downto 0) := "000"; -- cifrovoj RED
G_VGA      : out std_logic_vector (2 downto 0) := "000"; -- cifrovoj GREEN
B_VGA      : out std_logic_vector (1 downto 0) := "00"; -- cifrovoj BLUE

VSYNC_VGA  : out std_logic := '1'; -- kadrovye sinhroimpul'sy/sinhroimp. SCART
HSYNC_VGA  : out std_logic := '1'; -- strochnye sinhroimpul'sy/enable RGB SCART

--------------------------------------------------------------------------------
--                     VYHODNYE PORTY PLIS DLJa OZU                    100304  --
--------------------------------------------------------------------------------
--UB			  : out std_logic := '0';
--LB			  : out std_logic := '0';
CS			  : out std_logic := '0';
--A17		  : out std_logic := '0';
A          : out std_logic_vector(16 downto 0); -- ShA
WE         : out std_logic := '1'; -- signal zapisi v  OZU  
OE         : buffer std_logic := '1'; -- signal chtenija iz OZU   

--------------------------------------------------------------------------------
--                  DVUNAPRAVLENNYE PORTY PLIS DLJa OZU                090821  --
--------------------------------------------------------------------------------

D          : inout std_logic_vector(31 downto 0) := "ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ" -- ShD

	);
    end VGA_PAL;
architecture RTL of VGA_PAL is

--------------------------------------------------------------------------------
--                       VNUTRENNIE SIGNALY PLIS                      090804  --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                   NORMALIZOVANNYE VHODNYE SIGNALY                  090805  --
--------------------------------------------------------------------------------

signal INVERSE_RGBI  :std_logic := '1'; -- inversija koda cveta: 
                                     -- 0 - invertirovat', 1 - net.
                                      
signal INVERSE_KSI   : std_logic := '1'; -- inversija kadrovyh sinhroimpul'sov: 
                                     -- 0 - invertirovat', 1 - net.
                                      
signal INVERSE_SSI   : std_logic := '1'; -- inversija strochnyh sinhroimpul'sov: 
                                     -- 0 - invertirovat', 1 - net.
                                      
signal INVERSE_F14MHZ: std_logic := '0'; -- inversija taktovyh impul'sov: 
                                     -- 0 - invertirovat', 1 - net.

signal VGA_SCART     : std_logic := '1'; -- vybor signala na raz#eme VGA: 
                                     -- 0 - dlja SCART, 1 - dlja VGA.

signal SET_FK_IN     : std_logic := '1'; -- ustanovka vhodnoj chastoty kadrov: 
                                     -- 0 - 50 Gc(312 strok), 1 - 48 Gc(320 st.)
                                      
signal SET_FK_OUT    : std_logic := '1'; -- ustanovka vyhodnoj chastoty kadrov: 
                                     -- 1 - 60 Gc, 0 - 50/48 Gc.
signal RX0    : std_logic; -- cifrovoj RED
signal GX0    : std_logic; -- cifrovoj GREEN
signal RX1      : std_logic; -- cifrovoj RED
signal GX1      : std_logic; -- cifrovoj GREEN
signal BX1      : std_logic; -- cifrovoj BLUE
signal RX2      : std_logic; -- cifrovoj RED
signal GX2      : std_logic; -- cifrovoj GREEN
signal BX2      : std_logic; -- cifrovoj BLUE
signal RGBI_CLK : std_logic; -- taktovyj signal vhodnogo koda cveta

signal KSI    : std_logic; -- kadrovye sinhroimpul'sy
signal SSI    : std_logic; -- strochnye sinhroimpul'sy

--------------------------------------------------------------------------------
--                     PROMEZhUTOChNYE DANNYE CVETA                     100304  --
--------------------------------------------------------------------------------

signal RX0_3      : std_logic; -- cifrovoj RED
signal GX0_3      : std_logic; -- cifrovoj GREEN
signal RX1_3      : std_logic; -- cifrovoj RED
signal GX1_3      : std_logic; -- cifrovoj GREEN
signal BX1_3      : std_logic; -- cifrovoj BLUE
signal RX2_3      : std_logic; -- cifrovoj RED
signal GX2_3      : std_logic; -- cifrovoj GREEN
signal BX2_3      : std_logic; -- cifrovoj BLUE

--------------------------------------------------------------------------------
--                     SIGNALY DLJa SBROSA SChETChIKOV                   091220  --
--------------------------------------------------------------------------------

signal KSI_2  : std_logic; -- zaderzhannye kadrovye sinhroimpul'sy
signal SSI_2  : std_logic; -- zaderzhannye strochnye sinhroimpul'sy

--------------------------------------------------------------------------------
--              SChETChIKI I PARAMETRY RAZVERTKI DLJa VGA I VIDEO        091223  --
--------------------------------------------------------------------------------
-- strochnaja razvertka VGA:

signal VGA_H_CLK     : std_logic; -- signal uvelichenija schetchika taktov v stroke
signal VGA_H         : std_logic_vector(8 downto 0); -- schetchik taktov v stroke
signal VGA_H_MIN     : std_logic_vector(8 downto 0); -- min. znach.schetch. taktov
signal VGA_H_MAX     : std_logic_vector(8 downto 0); -- maks.znach.schetch. taktov
signal VGA_SSI1_BGN   : std_logic_vector(9 downto 0); -- nachalo strochnogo SI
signal VGA_SSI1_END   : std_logic_vector(9 downto 0); -- konec  strochnogo SI
signal VGA_SSI2_BGN   : std_logic_vector(9 downto 0); -- nachalo strochnogo SI
signal VGA_SSI2_END   : std_logic_vector(9 downto 0); -- konec  strochnogo SI
signal VGA_SGI1_BGN   : std_logic_vector(9 downto 0); -- nachalo strochnogo GI
signal VGA_SGI1_END   : std_logic_vector(9 downto 0); -- konec  strochnogo GI
signal VGA_SGI2_BGN   : std_logic_vector(9 downto 0); -- nachalo strochnogo GI
signal VGA_SGI2_END   : std_logic_vector(9 downto 0); -- konec  strochnogo GI
--------------------------------------------------------------------------------
-- kadrovaja razvertka VGA:

signal VGA_V_CLK     : std_logic; -- signal uvelichenija schetchika strok v kadre
signal VGA_V         : std_logic_vector(9 downto 0); -- schetchik strok v kadre
signal VGA_V_MIN     : std_logic_vector(9 downto 0); -- min. znach.schetchika strok
signal VGA_V_MAX     : std_logic_vector(9 downto 0); -- maks.znach.schetchika strok
signal VGA_KSI_BGN   : std_logic_vector(9 downto 0); -- nachalo kadrovogo SI
signal VGA_KSI_END   : std_logic_vector(9 downto 0); -- konec  kadrovogo SI
signal VGA_KGI1_END  : std_logic_vector(9 downto 0); -- konec  kadrovogo GI
signal VGA_KGI2_BGN  : std_logic_vector(9 downto 0); -- nachalo kadrovogo GI
--------------------------------------------------------------------------------
-- strochnaja razvertka VIDEO:

signal VIDEO_H_CLK   : std_logic; -- signal uvelichenija schetchika taktov v stroke
signal VIDEO_H       : std_logic_vector(9 downto 0); -- schetchik taktov v stroke
signal VIDEO_H_MAX   : std_logic_vector(9 downto 0); -- maks.znach. schetch. taktov
signal VIDEO_SSI_BGN : std_logic_vector(9 downto 0); -- nachalo strochnogo SI
signal VIDEO_SSI_END : std_logic_vector(9 downto 0); -- konec  strochnogo SI
signal VIDEO_SGI_BGN : std_logic_vector(9 downto 0); -- nachalo strochnogo GI
signal VIDEO_SGI_END : std_logic_vector(9 downto 0); -- konec  strochnogo GI
--------------------------------------------------------------------------------
-- kadrovaja razvertka VIDEO:

signal VIDEO_V_CLK   : std_logic;  --signal uvelichenija schetchika strok v kadre
signal VIDEO_V       : std_logic_vector(8 downto 0); -- schetchik strok v kadre
signal VIDEO_V_MAX   : std_logic_vector(8 downto 0); -- maks.znach. schetch. taktov
signal VIDEO_KSI_BGN : std_logic_vector(8 downto 0); -- nachalo kadrovogo SI
signal VIDEO_KSI_END : std_logic_vector(8 downto 0); -- konec  kadrovogo SI
signal VIDEO_KGI_BGN : std_logic_vector(8 downto 0); -- nachalo kadrovogo GI
signal VIDEO_KGI_END : std_logic_vector(8 downto 0); -- konec  kadrovogo GI
signal SCREEN_V_END  : std_logic_vector(8 downto 0); -- konec akt. chasti jekrana
--------------------------------------------------------------------------------
-- tip komp'jutera/parametry razvertki v stroke: 

signal H_TYPE : std_logic_vector(1 downto 0); 
                
                --  10 - standartnaja ili udvoennaja chastota tochek
                --       grafiki klonov "Spektrum", kvarc na 14 MGc
                --       v stroke 896 taktov (895 = 1 10 1111111)
                
                --  01 - rezhim grafiki "Profi", kvarc na 12 MGc
                --       v stroke 768 taktov (767 = 1 01 1111111)

                --  00 - rezhim grafiki "Orion", kvarc na 10 MGc
                --       v stroke 640 taktov (639 = 1 00 1111111)

                --  11 - rezhim grafiki "Specialist", kvarc na 8 MGc
                --       v stroke 512 taktov (511 = 0 11 1111111)
--------------------------------------------------------------------------------
--signal V_TYPE : std_logic; -- tip jekrana po-vertikali / chislo strok v kadre: 
                --   0 - 312 strok (311 = 10011 0 111)
                --   1 - 320 strok (319 = 10011 1 111)

--------------------------------------------------------------------------------
--                     SINHROIMPUL''SY DLJa VGA I VIDEO                 091220  --
--------------------------------------------------------------------------------

signal VGA_KSI      : std_logic; -- kadrovye sinhroimpul'sy dlja VGA
signal VGA_SSI      : std_logic; -- strochnye sinhroimpul'sy dlja VGA

signal VIDEO_KSI    : std_logic; -- kadrovye sinhroimpul'sy dlja VIDEO
signal VIDEO_SSI1   : std_logic; -- osnovnye strochnye sinhroimpul'sy dlja VIDEO
signal VIDEO_SSI2   : std_logic; -- strochnye sinhroimpul'sy - vrezki dlja VIDEO
signal VIDEO_SYNC   : std_logic; -- sinhrosmes' dlja VIDEO

signal VGA_RBGI_CLK : std_logic; -- sinhroimpul'sy dlja vyvoda na VGA 

signal RESET_ZONE   : std_logic; -- signal dlja sinhronicacii schetchika taktov
signal RESET_H      : std_logic; -- esli 0, to mozhno sbrasyvat' schetchik taktov    
signal RESET_V      : std_logic; -- esli 0, to mozhno sbrasyvat' schetchik strok    
 
--------------------------------------------------------------------------------
--                    GASJaShhIE IMPUL''SY DLJa VGA I VIDEO                091102  --
--------------------------------------------------------------------------------

signal VGA_KGI      : std_logic; -- kadrovye gasjashhie impul'sy dlja VGA
signal VGA_SGI      : std_logic; -- strochnye gasjashhie impul'sy dlja VGA
signal VGA_BLANK    : std_logic; -- gasjashhie impul'sy dlja VGA

signal VIDEO_KGI    : std_logic; -- kadrovye gasjashhie impul'sy dlja VIDEO
signal VIDEO_SGI    : std_logic; -- strochnye gasjashhie impul'sy dlja VIDEO
signal VIDEO_BLANK  : std_logic; -- gasjashhie impul'sy dlja VIDEO

--------------------------------------------------------------------------------
--                REGISTR DLJa ZAPISI PO ChETYRE TOChKI V OZU            090821  --
--------------------------------------------------------------------------------

signal WR_REG       : std_logic_vector(31 downto 0); -- bity 3-R, 2-G, 1-B, 0-I

--------------------------------------------------------------------------------
--                REGISTR DLJa ChTENIJa PO ChETYRE TOChKI V OZU            100304  --
--------------------------------------------------------------------------------

signal RD_REG       : std_logic_vector(23 downto 0); -- bity 3-R, 2-G, 1-B, 0-I

begin

--------------------------------------------------------------------------------
--                            PROCESSY                                        --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                   NORMALIZACIJa VHODNYH SIGNALOV                    090826  --
--------------------------------------------------------------------------------

-- esli sootvetstvujushhaja peremychka/tumbler nahoditsja v polozhenii ON, 
-- chto sootvetstvuet logicheskomu nulju, sootvetstvujushhij signal invertiruetsja.
-- zatem kod cveta taktirujutsja
--------------------------------------------------------------------------------
--UB <= '0';
--LB <= '0';
CS <= '0';
--A17 <= '0';

RGBI_CLK <= F14 xnor INVERSE_F14MHZ; -- normalizacija taktovyh sinhroimpul'sov
--------------------------------------------------------------------------------
process (RGBI_CLK)   
begin
  if (falling_edge(RGBI_CLK)) then -- esli spad taktovogo impul'sa
--------------------------------------------------------------------------------
        RX0   <=   RX0_IN xnor INVERSE_RGBI; 
        GX0   <=   GX0_IN xnor INVERSE_RGBI;
		  BX1   <=   BX1_IN xnor INVERSE_RGBI;    -- ostal'nye stroki - so Spektruma
        RX1   <=   RX1_IN xnor INVERSE_RGBI; 
        GX1   <=   GX1_IN xnor INVERSE_RGBI;
		  BX2   <=   BX2_IN xnor INVERSE_RGBI;    -- ostal'nye stroki - so Spektruma
        RX2   <=   RX2_IN xnor INVERSE_RGBI; 
        GX2   <=   GX2_IN xnor INVERSE_RGBI;

  end if;
end process;

--------------------------------------------------------------------------------
--              FORMIROVANIE SIGNALOV DLJa SBROSA SChETChIKOV            100304  --
--------------------------------------------------------------------------------
process (F14, VIDEO_H)
begin

  if (rising_edge(F14)) then  -- esli front taktovogo impul'sa, perehod iz 0 v 1
      SSI   <= SSI_IN xnor INVERSE_SSI;
      SSI_2 <= not SSI;       -- zaderzhka na takt strochnogo sinhroimpul'sa
  end if;

  -- vyborka sostojanija kadrovogo sinhroimpul'sa vo vremja 1/4...1/2 stroki VIDEO
  if (rising_edge(VIDEO_H(8)) and VIDEO_H(9)='0') then
      KSI   <= KSI_IN xnor INVERSE_KSI;
      KSI_2 <= not KSI;       -- zaderzhka kadrovogo sinhroimpul'sa na stroku 
  end if;
end process;

RESET_H <= SSI or SSI_2;      -- esli 0, to mozhno sbrasyvat' schetchik taktov    
RESET_V <= KSI or KSI_2;      -- esli 0, to mozhno sbrasyvat' schetchik strok
-- zona dlja sbrosa schetchikov, 0 v srednej chasti jekrana po-vertikali
RESET_ZONE <= (not VIDEO_V(7) or VIDEO_V(8)); 

VGA_V_CLK   <= (VGA_H(7)   or VGA_H(8));
VIDEO_V_CLK <= (VIDEO_H(8) or VIDEO_H(9));


--------------------------------------------------------------------------------
--                 UPRAVLENIE SChETChIKAMI TAKTOV V STROKAH             100304  --
--------------------------------------------------------------------------------
process (F14, SSI, SSI_2)
begin  
  if (falling_edge(SSI)) then -- esli spad  strochnogo sinhroimpul'sa,
    if RESET_ZONE = '0'  then -- esli zona dlja sbrosa schetchikov
      -- zapominaem sostojanie vspomogatel'nogo schetchika taktov v stroke
      VGA_H_MAX   <= (VIDEO_H(9 downto 1) );
    end if;
  end if;
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
  if (falling_edge(F14)) then         -- po spadu taktovogo impul'sa:
--------------------------------------------------------------------------------
    if (RESET_H = '0')  then          -- esli spad vhodnogo sinhrosignala,
      VIDEO_H <= (others => '0');     -- obnuljaem vspomogatel'nyj schetchik taktov
    else 
      VIDEO_H <= VIDEO_H + 1;         -- inache - uvelichivaem ego
    end if;   
--------------------------------------------------------------------------------
    -- esli nachalo strochnogo SI i stroka v srednej chasti jekrana po-vertikali:
    -- sinhroniziruem schetchiki taktov s vhodnymi sinhroimpul'sami
    -- ili, esli poslednjaja tochka v stroke VGA,
    if ((RESET_H or RESET_ZONE) = '0') or (VGA_H = VGA_H_MAX)  then
      VGA_H   <= (others => '0');     -- obnuljaem schetchik taktov VGA
    else
      VGA_H   <= VGA_H   + 1;         -- inache - uvelichivaem schetchik tochek VGA
    end if;   
  end if;   
end process;

--------------------------------------------------------------------------------
--                 UPRAVLENIE SChETChIKAMI STROK V KADRE                091223  --
--------------------------------------------------------------------------------
-- chtoby ne bylo smeshhenija jekrana vniz pri chastote VGA 60 Gc 
-- propuskajutsja 29.5 strok jekrana Spektruma sverhu jekrana, 
-- chto sootvetstvuet 59 strokam VGA.


process (VGA_H(8), VIDEO_H(9), VGA_V_CLK, VIDEO_V_CLK)
begin
--------------------------------------------------------------------------------
-- schetchik strok VGA:
  if (falling_edge(VGA_V_CLK)) then  -- po spadu signala uvelichenija schetch. strok

    -- esli vyhodnaja chastota kadrov 48/50 Gc
    if (SET_FK_OUT = '0') then
      if (RESET_V) = '0' then        -- esli nachalo kadrovogo sinhroimpul'sa:
        VGA_V <= (others => '0');    -- obnuljaem schetchik strok VGA
      else                           -- inache 
        VGA_V <= VGA_V   + 1;        -- uvelichivaem schetchik strok VGA
      end if;    
    else  

    -- inache, esli vyhodnaja chastota kadrov 60 Gc
      if VGA_V = 582 then            -- i poslednjaja stroka v kadre (523+59=585):
        VGA_V <= ("0000111011");     -- pervaja otobrazhaemaja stroka VGA: nomer 59
      else                           -- inache 
        VGA_V <= VGA_V   + 1;        -- uvelichivaem schetchik strok VGA
      end if;    

    end if;    
  end if;    
--------------------------------------------------------------------------------
-- schetchik strok VIDEO:
  if (falling_edge(VIDEO_V_CLK)) then -- po spadu signala uvelichenija schetch.strok
    if (RESET_V) = '0' then           -- esli nachalo kadrovogo sinhroimpul'sa:
      VIDEO_V <= (others => '0');     -- obnuljaem schetchik strok VIDEO
    else    
      VIDEO_V <= VIDEO_V + 1;         -- uvelichivaem schetchik strok VIDEO
    end if;    
  end if;    
-------------------------------------------------------------------------------
end process;

--------------------------------------------------------------------------------
--                       OPREDELENIE TIPA KVARCA                      100304  --
--------------------------------------------------------------------------------
-- esli peremychki JP6 (SET_FK_IN) i JP5 (VGA_SCART) snjaty, 
-- chastota kvarca opredeljaetsja avtomaticheski.
-- esli odna iz nih ili obe peremychki ustanovleny, chastota vybiraetsja imi

-- sootvetsvie bitov (peremychka snjata, 0 - ustanovlena) :
--                --  10 - standartnaja ili udvoennaja chastota tochek
--                --       grafiki klonov "Spektrum", kvarc na 14 MGc
--                --       v stroke 896 taktov (895 = 1 10 1111111)
--                
--                --  01 - rezhim grafiki "Profi", kvarc na 12 MGc
--                --       v stroke 768 taktov (767 = 1 01 1111111)
--
--                --  00 - rezhim grafiki "Orion", kvarc na 10 MGc
--                --       v stroke 640 taktov (639 = 1 00 1111111)
--
--                --  11 - rezhim grafiki "Specialist", kvarc na 8 MGc
--                --       v stroke 512 taktov (511 = 0 11 1111111)
process (H_TYPE, SET_FK_IN, VGA_SCART, VGA_H_MAX)                   
begin
  if (SET_FK_IN = '1' and VGA_SCART = '1') then
    H_TYPE(1) <= VGA_H_MAX(7); -- avtomaticheskoe opredelenie chastoty
    H_TYPE(0) <= VGA_H_MAX(6);
  else
    H_TYPE(1) <= SET_FK_IN;    -- chastota zadaetsja peremychkami
    H_TYPE(0) <= VGA_SCART;
  end if;
end process;


--------------------------------------------------------------------------------
--                FORMIROVANIE PARAMETROV RAZVERTKI VGA               100304  --
--------------------------------------------------------------------------------

-- strochnye sinhroimpul'sy dlja VGA:

process (H_TYPE)                   
begin
  case H_TYPE is
 
    when "10" =>   -- "Spektrum"
      -- strochnaja razvertka VGA:
      VGA_SSI1_BGN <= "0000000000"; --   0 - nachalo 1 strochnogo SI
      VGA_SSI1_END <= "0000100110"; --  38 - konec  1 strochnogo SI
      VGA_SSI2_BGN <= "1101110010"; -- 882 - nachalo 2 strochnogo SI
      VGA_SSI2_END <= "1101111111"; -- 895 - konec  2 strochnogo SI
      VGA_SGI1_END <= "0001000001"; --  65 - konec  1 strochnogo GI
      VGA_SGI2_BGN <= "1101110010"; -- 882 - nachalo 2 strochnogo GI

    when "01" =>   -- "Profi"
      VGA_SSI1_BGN <= "0000000000"; --   0 - nachalo 1 strochnogo SI
      VGA_SSI1_END <= "0000100010"; --  34 - konec  1 strochnogo SI
      VGA_SSI2_BGN <= "1011110101"; -- 757 - nachalo 2 strochnogo SI
      VGA_SSI2_END <= "1011111111"; -- 767 - konec  2 strochnogo SI
      VGA_SGI1_END <= "0000111001"; --  57 - konec  1 strochnogo GI
      VGA_SGI2_BGN <= "1011101101"; -- 749 - nachalo 2 strochnogo GI

    when "00" =>   -- "Orion"
      VGA_SSI1_BGN <= "0000000000"; --   0 - nachalo 1 strochnogo SI
      VGA_SSI1_END <= "0000100101"; --  37 - konec  1 strochnogo SI
      VGA_SSI2_BGN <= "0000000000"; --   0 - nachalo 2 strochnogo SI
      VGA_SSI2_END <= "0000100101"; --  37 - konec  2 strochnogo SI
      VGA_SGI1_END <= "0000111000"; --  56 - konec  1 strochnogo GI
      VGA_SGI2_BGN <= "1001111010"; -- 634 - nachalo 2 strochnogo GI

    when "11" =>   -- "Specialist"
      VGA_SSI1_BGN <= "0000000000"; --   0 - nachalo 1 strochnogo SI
      VGA_SSI1_END <= "0000010001"; --  17 - konec  1 strochnogo SI
      VGA_SSI2_BGN <= "0111110011"; -- 499 - nachalo 2 strochnogo SI
      VGA_SSI2_END <= "0111111111"; -- 511 - konec  2 strochnogo SI
      VGA_SGI1_END <= "0000100000"; --  32 - konec  1 strochnogo GI
      VGA_SGI2_BGN <= "0111101110"; -- 494 - nachalo 2 strochnogo GI

  end case;
end process;
--------------------------------------------------------------------------------
-- kadrovaja razvertka VGA:

-- chtoby ne bylo smeshhenija jekrana vniz pri chastote VGA 60 Gc 
-- propuskajutsja 32 stroki jekrana Spektruma sverhu jekrana, 
-- chto sootvetstvuet 64 strokam VGA.

process (SET_FK_OUT)                   
begin
  case SET_FK_OUT is
 
    when '0' =>  -- dlja chastoty kadrov 48/50 Gc:

      VGA_KSI_BGN  <= "0000001011"; --  11 - nachalo kadrovogo SI
      VGA_KSI_END  <= "0000001100"; --  12 - konec  kadrovogo SI
      VGA_KGI1_END <= "0000101100"; --  44 - konec  kadrovogo GI
      VGA_KGI2_BGN <= "1001110001"; -- 625 - nachalo kadrovogo GI

    when '1' =>  -- dlja chastoty kadrov 60 Gc:

      VGA_KSI_BGN  <= "0000111011"; --  59 - nachalo kadrovogo SI
      VGA_KSI_END  <= "0000111100"; --  60 - konec  kadrovogo SI
      VGA_KGI1_END <= "0001011100"; --  92 - konec  kadrovogo GI
      VGA_KGI2_BGN <= "1000111110"; -- 574 - nachalo kadrovogo GI
      
  end case;
end process;

--------------------------------------------------------------------------------
--                   FORMIROVANIE STROChNYH IMPUL''SOV VGA              091223  --
--------------------------------------------------------------------------------
-- osnovnye strochnye sinhroimpul'sy dlja VIDEO
VGA_SSI  <= '0' when (VGA_H >= VGA_SSI1_BGN and VGA_H <= VGA_SSI1_END) 
                  or (VGA_H >= VGA_SSI2_BGN and VGA_H <= VGA_SSI2_END) 
                else '1';

-- strochnye gasjashhie impul'sy dlja VIDEO
VGA_SGI  <= '0' when (VGA_H <= VGA_SGI1_END)
                  or (VGA_H >= VGA_SGI2_BGN)
                else '1';

--------------------------------------------------------------------------------
--                   FORMIROVANIE KADROVYH IMPUL''SOV VGA              091223  --
--------------------------------------------------------------------------------
-- kadrovye sinhroimpul'sy dlja VIDEO
VGA_KSI  <= '0' when (VGA_V >= VGA_KSI_BGN) 
                 and (VGA_V <= VGA_KSI_END) 
                else '1';
-- kadrovye gasjashhie impul'sy dlja VIDEO
VGA_KGI  <= '0' when (VGA_V <= VGA_KGI1_END) 
                  or (VGA_V >= VGA_KGI2_BGN )  
                else '1';
                  
--------------------------------------------------------------------------------
--                    FORMIROVANIE STROChNYH IMPUL''SOV VIDEO           091223  --
--------------------------------------------------------------------------------

---- osnovnye strochnye sinhroimpul'sy dlja VIDEO:
--
--                       -- klon Spektruma (14 MGc)
--VIDEO_SSI1 <= '0' when (VIDEO_H > 20 and VIDEO_H < 87 and H_TYPE = "10")
--                       -- Profi (12 MGc)
--                    or (VIDEO_H > 17 and VIDEO_H < 75 and H_TYPE = "01")
--                       -- Orion (10 MGc)
--                    or (VIDEO_H > 14 and VIDEO_H < 62 and H_TYPE = "00")
--                
--                  else '1';
--
---- strochnye sinhroimpul'sy - vrezki dlja VIDEO:
--                       -- klon Spektruma (14 MGc)
--VIDEO_SSI2 <= '0' when (VIDEO_H > 20 and VIDEO_H < 851 and H_TYPE = "10")
--                       -- Profi (12 MGc)
--                    or (VIDEO_H > 17 and VIDEO_H < 729 and H_TYPE = "01")
--                       -- Orion (10 MGc)
--                    or (VIDEO_H > 14 and VIDEO_H < 608 and H_TYPE = "00")
--                
--                  else '1';
--
---- strochnye gasjashhie impul'sy dlja VIDEO:
--                       -- klon Spektruma (14 MGc)
--VIDEO_SGI  <= '0' when (VIDEO_H < 168 and H_TYPE = "10")
--                       -- Profi (12 MGc)
--                    or (VIDEO_H < 144 and H_TYPE = "01")
--                       -- Orion (10 MGc)
--                    or (VIDEO_H < 120 and H_TYPE = "00")
--                
--                  else '1';
--
----------------------------------------------------------------------------------
----                   FORMIROVANIE KADROVYH IMPUL''SOV VIDEO            091103  --
----------------------------------------------------------------------------------
---- kadrovye sinhroimpul'sy dlja VIDEO
--VIDEO_KSI  <= '0' when VIDEO_V < 4 else '1';

-- kadrovye gasjashhie impul'sy dlja VIDEO
--VIDEO_KGI  <= '0' when VIDEO_V < 16 else '1';


--------------------------------------------------------------------------------
--                    FORMIROVANIE SINHROSMESI DLJa VIDEO              090820  --
--------------------------------------------------------------------------------
--VIDEO_SYNC <= VIDEO_SSI2 when VIDEO_KSI = '0' else VIDEO_SSI1;

--------------------------------------------------------------------------------
--                     MUL''TIPLEKSIROVANIE ADRESOV OZU                090812  --
--------------------------------------------------------------------------------

-- esli cikl zapisi i vyhodnaja chastota kadrov 50/48 Gc:
A <= "00000000" & VIDEO_V(0) & VIDEO_H(9 downto 2)
                                        when (VIDEO_H(0)='1' and SET_FK_OUT='0')

-- esli cikl zapisi i vyhodnaja chastota kadrov 60 Gc:
else VIDEO_V(8 downto 0) & VIDEO_H(9 downto 2) 
                                        when (VIDEO_H(0)='1' and SET_FK_OUT='1')

-- esli cikl chtenija i vyhodnaja chastota kadrov 50/48 Gc:
else "00000000" & (not VIDEO_V(0)) & VGA_H(8 downto 1) 
                                        when (VIDEO_H(0)='0' and SET_FK_OUT='0')

-- esli cikl chtenija i vyhodnaja chastota kadrov 60 Gc:
else VGA_V(9 downto 1) & VGA_H(8 downto 1);


--------------------------------------------------------------------------------
--                       PEREDAChA DANNYH ChEREZ OZU                    100304  --
--------------------------------------------------------------------------------
-- upravlenie vyvodom na shinu dannyh (zapis' proizojdet po frontu WE) 
D(31 downto 0) <= WR_REG when VIDEO_H(0) = '1' else (others => 'Z');

process (F14, VGA_H)                   
begin
  if (falling_edge(F14)) then -- po frontu 
--------------------------------------------------------------------------------
    -- zapis' koda chetyreh tochek VIDEO v registr pered zapis'ju srazu 16 v OZU:
    case VIDEO_H(1 downto 0) is
      when "00" =>      
        WR_REG(23 downto  16) <= RX0 & GX0 & RX1 & GX1 & BX1 & RX2 & GX2 & BX2; -- zapis' tochki vo vtoruju tetradu
      when "01" =>      
        WR_REG( 15 downto  8) <= RX0 & GX0 & RX1 & GX1 & BX1 & RX2 & GX2 & BX2; -- zapis' tochki v  tret'ju tetradu
      when "10" =>      
        WR_REG( 7 downto  0) <= RX0 & GX0 & RX1 & GX1 & BX1 & RX2 & GX2 & BX2; -- zapis' tochki v  chetv.  tetradu
      when "11" =>      
        WR_REG(31 downto 24) <= RX0 & GX0 & RX1 & GX1 & BX1 & RX2 & GX2 & BX2; -- zapis' tochki v  pervuju tetradu
    end case;
--------------------------------------------------------------------------------
  end if;

  if (rising_edge(F14) and VGA_H(0)='0') then -- po frontu OE
      -- chtenie koda dvuh tochek iz OZU v registr dlja vyvoda na VGA
      RD_REG(23 downto 0) <= D(23 downto 0);

--------------------------------------------------------------------------------
  end if;

end process;

--------------------------------------------------------------------------------
--                  FORMIROVANIE SIGNALOV UPRAVLENIJa OZU              100304  --
--------------------------------------------------------------------------------
-- signal zapisi v  OZU  
WE <= F14 or (VIDEO_H(1) nand VIDEO_H(0));
-- signal chtenija iz OZU   
OE <= F14 or VIDEO_H(0);

--------------------------------------------------------------------------------
--                      VYVOD SIGNALOV NA GNEZDO VGA                  090826  --
--------------------------------------------------------------------------------
-- razdelenie tochek iz registra posle chtenija iz OZU:

process (F14, VGA_H(0), RD_REG, D)                   
variable sel:std_logic_vector(1 downto 0);
begin
 
sel:=VGA_H(0) & F14 ;
  case sel is
    when "00" =>       -- cvet chetvertoj tochki
      RX0_3 <= RD_REG(7); 
      GX0_3 <= RD_REG(6);
      RX1_3 <= RD_REG(5); 
      GX1_3 <= RD_REG(4);
      BX1_3 <= RD_REG(3);
      RX2_3 <= RD_REG(2); 
      GX2_3 <= RD_REG(1);
      BX2_3 <= RD_REG(0);	
    when "01" =>       -- cvet pervoj tochki
      RX0_3 <= D(31); 
      GX0_3 <= D(30);
      RX1_3 <= D(29); 
      GX1_3 <= D(28);
      BX1_3 <= D(27);
      RX2_3 <= D(26); 
      GX2_3 <= D(25);
      BX2_3 <= D(24);	
    when "10" =>       -- cvet vtoroj tochki
      RX0_3 <= RD_REG(23); 
      GX0_3 <= RD_REG(22);
      RX1_3 <= RD_REG(21); 
      GX1_3 <= RD_REG(20);
      BX1_3 <= RD_REG(19);
      RX2_3 <= RD_REG(18); 
      GX2_3 <= RD_REG(17);
      BX2_3 <= RD_REG(16);	
    when "11" =>       -- cvet tret'ej tochki
      RX0_3 <= RD_REG(15); 
      GX0_3 <= RD_REG(14);
      RX1_3 <= RD_REG(13); 
      GX1_3 <= RD_REG(12);
      BX1_3 <= RD_REG(11);
      RX2_3 <= RD_REG(10); 
      GX2_3 <= RD_REG(9);
      BX2_3 <= RD_REG(8);			

  end case;

end process;

--------------------------------------------------------------------------------
-- sinhronizacija gasjashhih impul'sov i vyvod sinhroimpul'sov

process (F14) 
begin
  if (rising_edge(F14)) then  -- esli front taktovogo impul'sa, perehod iz 0 v 1

    -- gasjashhie impul'sy dlja VGA
    VGA_BLANK   <= VGA_KGI and VGA_SGI;

--    ---- gasjashhie impul'sy dlja VIDEO
--    VIDEO_BLANK <= VIDEO_KGI and VIDEO_SGI;
      

    VSYNC_VGA <= VGA_KSI;      -- kadrovye sinhroimpul'sy dlja VGA
    HSYNC_VGA <= VGA_SSI;      -- strochnye sinhroimpul'sy dlja VGA
      
  end if;
end process;

--------------------------------------------------------------------------------

-- udvoenie chastoty s pomoshh'ju zaderzhannogo signala
VGA_RBGI_CLK <= (not F14) xor F14_2; 
      
--------------------------------------------------------------------------------
--                      vyvod RGBI na raz#em VGA                      100304  --
--------------------------------------------------------------------------------
process (VGA_RBGI_CLK) 
begin
  if (rising_edge(VGA_RBGI_CLK)) then  -- esli front taktovogo impul'sa,
	if VGA_BLANK = '1' then
    R_VGA     <= (RX2_3 & RX1_3 & RX0_3);
    G_VGA     <= (GX2_3 & GX1_3 & GX0_3);
    B_VGA     <= (BX2_3 & BX1_3);
	else
	 R_VGA     <= "000";
    G_VGA     <= "000";
    B_VGA     <= "00";
	end if;
  end if;
end process;

end RTL;

