MODULE Robots; (*$MAIN*)
IMPORT c := Console, Math, Key := Input, Timer, Basic;

TYPE
  Object = CHAR;

CONST
  (*  : *)
  FieldWidth  = 22;
  FieldHeight = 15;
  NumHoles    = 30;
  NumRobots   = 20;

  (*   : *)
  Hole   = "O";
  Robot  = "P";
  Player = "X";
  Exit   = "+";
  Space  = ".";

  SkipLine = FALSE;
  Debug = TRUE;

  (*    (   MoveRobot* *)
  RobotUnmoved = "#"; TwoRobots = "@";

VAR
  field: ARRAY FieldWidth, FieldHeight OF Object;
  playerX, playerY: SHORTINT;
  gameOver: BOOLEAN;

PROCEDURE WriteCenter (IN text: ARRAY OF CHAR);
VAR
  n: SHORTINT;
BEGIN
  n := SHORT((32 - LEN(text)) DIV 2);
  WHILE n > 0 DO c.WriteCh(" "); DEC(n) END;
  c.WriteStrLn(text);
END WriteCenter;

PROCEDURE Title;
VAR i:SHORTINT;
BEGIN
  c.Clear(c.Black);
  c.SetColors(c.WhiteOnBlack);
  WriteCenter("Game creators:");
  WriteCenter("Oleg N. Cher");
  WriteCenter("DeMi (Denis Mitlenko)");
  IF ~ Debug THEN
    c.WriteLn; c.WriteStr("Loading:");
    i :=  0;
    REPEAT
      c.WriteCh("I");
      Timer.Delay(200);
      i := i + 1;
    UNTIL i=20;
  END;
  c.WriteLn; c.At(0, 11); WriteCenter("Press any key");
  REPEAT
    Math.Randomize;
  UNTIL Key.Available() # 0;
END Title;

PROCEDURE LvlComplete;
BEGIN
  c.Clear(c.Blue);
  c.SetColors(c.WhiteOnBlue);
  c.At(11,11);
  c.WriteStr("Level complete!");
END LvlComplete;

PROCEDURE GameOver;
BEGIN
  c.Clear(c.Red);
  c.SetColors(c.WhiteOnRed);
  c.At(0, 11);
  WriteCenter("Game Over");
END GameOver;

PROCEDURE AddObjects (n: SHORTINT; obj: Object);
VAR
  i, x, y: SHORTINT;
BEGIN
  FOR i := 1 TO n DO
    (*    : *)
    REPEAT
      x := SHORT( Math.RndRange(0, FieldWidth-1) );
      y := SHORT( Math.RndRange(0, FieldHeight-1) );
    UNTIL field[x, y] = Space;
    field[x, y] := obj;
  END;
END AddObjects;

PROCEDURE PrepareField; (*    *)
VAR
  x, y: SHORTINT;
BEGIN
  (*   : *)
  FOR y := 0 TO FieldHeight-1 DO
    FOR x := 0 TO FieldWidth-1 DO
      field[x, y] := Space;
    END;
  END;
  (*  : *)
  playerX := 17; playerY := 5; field[playerX, playerY] := Player;
  (*  : *)
  field[0, 5] := Exit;
  (*  : *)
  AddObjects(NumHoles, Hole);
  (*  : *)
  AddObjects(NumRobots, Robot);
END PrepareField;

PROCEDURE DrawField; (*    *)
VAR
  x, y: SHORTINT;
BEGIN
  c.At(0, 0);
  FOR y := 0 TO FieldHeight-1 DO
    FOR x := 0 TO FieldWidth-1 DO
      CASE field[x, y] OF
      | Space  : c.SetColors(c.BlackOnWhite); c.WriteCh(Space);
      | Robot  : c.SetColors(c.RedOnWhite  ); c.WriteCh(Robot);
      | Hole   : c.SetColors(c.BlueOnWhite ); c.WriteCh(Hole);
      | Player : c.SetColors(c.GreenOnWhite); c.WriteCh(Player);
      | Exit   : c.SetColors(c.MagentaOnWhite); c.WriteCh(Exit);
      ELSE END;
    END;
    c.WriteLn; IF SkipLine THEN c.WriteLn END;
  END;
END DrawField;

PROCEDURE MoveRobot (x, y: SHORTINT; VAR incomplete: BOOLEAN);
TYPE
  Dir = ARRAY 8 OF SHORTINT;
CONST
  DirX = Dir ( +1, +1, +1,  0, -1, -1, -1,  0);
  DirY = Dir ( -1,  0, +1, +1, +1,  0, -1, -1);
VAR
  i, dx, dy, tx, ty: SHORTINT; min, distance: INTEGER;
BEGIN
  incomplete := FALSE;
  min := MAX(INTEGER); dx := 0; dy := 0;
  i := 7; REPEAT (* i := 7 TO 0 *)
    tx := playerX - (x + DirX[i]); ty := playerY - (y + DirY[i]);
    distance := tx*tx + ty*ty;
    IF distance < min THEN
      min := distance;
      dx := DirX[i]; dy := DirY[i];
    END;
  DEC(i) UNTIL i < 0;
  (*     *)
  field[x, y] := Space;
  INC(x, dx); INC(y, dy);
  CASE field[x, y] OF
  | RobotUnmoved: field[x, y] := TwoRobots; (* 2 :   . *)
    incomplete := TRUE; (*  ""     *)
  | Hole, Robot, Exit: (*   *)
  | Player : field[x, y] := Robot; gameOver := TRUE;
  | Space  : field[x, y] := Robot;
  ELSE END;
END MoveRobot;

PROCEDURE MoveRobots; (*   *)
(*
    ,        , 
  -      ,   .
         ,    
        .    
   ,       :   .

   ,    ,     
  ( ,     ).    
     ,   .    
   ,     .  ,  
        .    
  (          .
*)
VAR
  x, y: SHORTINT; incomplete, twoRobots: BOOLEAN;
BEGIN
  (*     RobotUnmoved: *)
  FOR y := 0 TO FieldHeight-1 DO
    FOR x := 0 TO FieldWidth-1 DO
      IF field[x, y] = Robot THEN field[x, y] := RobotUnmoved END;
    END;
  END;
  (*     RobotUnmoved  : *)
  incomplete := FALSE;
  FOR y := 0 TO FieldHeight-1 DO
    FOR x := 0 TO FieldWidth-1 DO
      IF field[x, y] = RobotUnmoved THEN (*   : *)
        MoveRobot(x, y, twoRobots);
        incomplete := incomplete OR twoRobots;
      END;
    END;
  END;
  (* ""  -    : *)
  WHILE incomplete DO
    incomplete := FALSE;
    FOR y := 0 TO FieldHeight-1 DO
      FOR x := 0 TO FieldWidth-1 DO
        IF field[x, y] = TwoRobots THEN (* "" : *)
          MoveRobot(x, y, twoRobots); (*    . *)
          incomplete := incomplete OR twoRobots;
          field[x, y] := Robot; (*    . *)
        END;
      END;
    END;
  END;
END MoveRobots;

PROCEDURE ProduceRobots;
VAR
  robots, x, y: SHORTINT;
BEGIN
  (*     : *)
  robots := 0;
  FOR y := 0 TO FieldHeight-1 DO
    FOR x := 0 TO FieldWidth-1 DO
      IF field[x, y] = Robot THEN INC(robots) END;
    END;
  END;
  (*    ( ): *)
  IF robots < NumRobots THEN
    field[0,                        0] := Robot;
    field[FieldWidth-1,             0] := Robot;
    field[FieldWidth-1, FieldHeight-1] := Robot;
    field[0,                       10] := Robot;
  END;
END ProduceRobots;

PROCEDURE MovePlayer;
BEGIN
  field[playerX, playerY] := Space;
  Basic.BEEP(50, -20);
  CASE Key.Read() OF
  | "e": INC(playerX); DEC(playerY);
  | "d": INC(playerX);
  | "c": INC(playerX); INC(playerY);
  | "x":               INC(playerY);
  | "z": DEC(playerX); INC(playerY);
  | "a": DEC(playerX);
  | "q": DEC(playerX); DEC(playerY);
  | "w":               DEC(playerY);
  (* | "s": *)
  ELSE END;
  field[playerX, playerY] := Player;
  CASE field[playerX, playerY] OF
  | Exit: LvlComplete;
  | Hole: gameOver := TRUE;
  ELSE END;
END MovePlayer;

BEGIN
  Title;
  gameOver := FALSE;
  c.Clear(c.White);
  PrepareField;
  DrawField;
  (*  : *)
  REPEAT
    Timer.Delay(100);
    MovePlayer; MoveRobots; ProduceRobots; DrawField;
  UNTIL gameOver;
  GameOver;
END Robots.
