MODULE Engine; (*$MAIN*)
IMPORT SYSTEM, Laser2, Wham;

CONST
  FrameSizeBytes = 5(*hdr*) + 8*20(*data*) ;

TYPE
  Sprites = ARRAY FrameSizeBytes * 4 (*frames*) + 1 OF CHAR;
  Channel = ARRAY 706 OF CHAR;

CONST
  Chudik = Sprites (

    (* Phase 1: *)

    1X, CHR( FrameSizeBytes-2 ), 0X, 5X, 4X, (* SPN, offset, LEN, HGT *)
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    030X,048X,048X,030X,010X,010X,010X,009X,
    030X,048X,048X,030X,020X,040X,080X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    007X,00CX,019X,01CX,01FX,01FX,00FX,002X,
    080X,07CX,07EX,0FEX,0F0X,080X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    01FX,03FX,07FX,07FX,07EX,060X,0F0X,07FX,
    080X,0C0X,0C0X,000X,000X,000X,0E0X,080X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,

    (* Phase 2: *)

    2X, CHR( FrameSizeBytes-2 ), 0X, 5X, 4X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,018X,024X,024X,018X,004X,
    000X,000X,000X,000X,006X,009X,009X,006X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    002X,003X,007X,00EX,00FX,00FX,00FX,007X,
    008X,0E0X,018X,05EX,03FX,0FFX,0E7X,0C3X,
    000X,000X,000X,000X,000X,080X,080X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    001X,00FX,01FX,01FX,007X,007X,01EX,018X,
    080X,0F0X,0FCX,0FEX,0FCX,038X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    03FX,000X,000X,000X,000X,000X,000X,000X,
    080X,060X,030X,018X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,

    (* Phase 3: *)

    3X, CHR( FrameSizeBytes-2 ), 0X, 5X, 4X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    003X,004X,004X,003X,000X,000X,000X,000X,
    000X,0E1X,092X,00AX,03EX,071X,0E5X,0F3X,
    030X,0C8X,048X,030X,000X,0F0X,0F8X,0F8X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,001X,001X,000X,
    0FFX,0FEX,07CX,018X,0FFX,0FFX,0FFX,07FX,
    0E0X,000X,000X,000X,000X,0C0X,0E0X,0C0X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,001X,001X,003X,000X,000X,000X,000X,
    061X,0C0X,080X,0FFX,000X,000X,000X,000X,
    080X,000X,000X,080X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,

    (* Phase 4: *)

    4X, CHR( FrameSizeBytes-2 ), 0X, 5X, 4X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,006X,009X,009X,006X,
    000X,000X,000X,000X,080X,040X,040X,080X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    002X,002X,002X,001X,007X,00EX,01CX,01EX,
    000X,000X,006X,01FX,0FFX,03EX,0BCX,070X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    01FX,01FX,00FX,003X,00FX,01FX,01FX,007X,
    0C0X,0C0X,080X,000X,0C0X,0E0X,0E0X,0E0X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,
    00EX,01CX,01CX,00FX,000X,000X,000X,000X,
    0C4X,018X,060X,080X,000X,000X,000X,000X,
    000X,000X,000X,000X,000X,000X,000X,000X,

    0X
  );

  Channel1 = Channel (
    016X,002X,029X,029X,029X,029X,029X,002X,029X,002X,029X,029X,
    029X,029X,029X,002X,029X,0FBX,029X,029X,029X,029X,029X,0FBX,
    029X,0FBX,029X,029X,029X,029X,029X,0FBX,029X,0FEX,029X,029X,
    029X,029X,029X,0FEX,029X,0FEX,029X,029X,029X,029X,029X,0FEX,
    029X,0FDX,029X,029X,029X,029X,029X,0FDX,029X,0FDX,029X,029X,
    029X,029X,029X,0FDX,029X,002X,029X,029X,029X,029X,029X,002X,
    029X,002X,029X,029X,029X,029X,029X,002X,029X,0FBX,029X,029X,
    029X,029X,029X,0FBX,029X,0FBX,029X,029X,029X,029X,029X,0FBX,
    029X,0FEX,029X,029X,029X,029X,029X,0FEX,029X,0FEX,029X,029X,
    029X,029X,029X,0FEX,029X,0FDX,029X,029X,029X,029X,029X,0FDX,
    029X,0FDX,029X,029X,029X,029X,029X,0FDX,029X,002X,029X,029X,
    029X,0ECX,029X,002X,029X,002X,029X,029X,029X,029X,029X,002X,
    029X,0FBX,029X,029X,029X,0ECX,029X,0FBX,029X,0FBX,029X,029X,
    029X,0FDX,029X,029X,029X,0FEX,029X,029X,029X,029X,029X,0FEX,
    029X,0FEX,029X,029X,029X,029X,029X,0FEX,029X,0FDX,029X,029X,
    029X,029X,029X,0FDX,029X,0FDX,029X,029X,029X,029X,029X,0FDX,
    029X,002X,029X,029X,029X,029X,029X,002X,029X,002X,029X,029X,
    029X,0ECX,029X,002X,029X,0FBX,029X,029X,029X,029X,029X,0FBX,
    029X,0FBX,029X,029X,029X,0FDX,029X,029X,029X,0FEX,029X,029X,
    029X,029X,029X,0FEX,029X,0FEX,029X,029X,029X,029X,029X,0FEX,
    029X,0FDX,029X,029X,029X,029X,029X,0FDX,029X,0FDX,029X,029X,
    029X,029X,029X,0FDX,029X,002X,029X,029X,029X,029X,029X,002X,
    029X,002X,029X,029X,029X,0ECX,002X,0F9X,0FAX,0FBX,029X,029X,
    029X,029X,029X,0FBX,029X,0FBX,029X,029X,029X,0FDX,029X,029X,
    029X,0FEX,029X,029X,029X,029X,029X,0FEX,029X,0FEX,029X,029X,
    029X,0ECX,029X,0FEX,029X,0FDX,029X,029X,029X,029X,029X,0FDX,
    029X,0FDX,029X,029X,029X,029X,029X,0FDX,029X,002X,029X,029X,
    029X,029X,029X,002X,029X,002X,029X,029X,029X,0ECX,002X,0F9X,
    0FAX,0FBX,029X,029X,029X,029X,029X,0FBX,029X,0FBX,029X,029X,
    029X,0FDX,029X,029X,029X,0FEX,029X,029X,029X,029X,029X,0FEX,
    029X,0FEX,029X,029X,029X,0ECX,029X,0FEX,029X,0FDX,029X,029X,
    029X,029X,029X,0FDX,029X,0FDX,029X,029X,029X,029X,029X,0FDX,
    029X,002X,029X,029X,029X,0ECX,029X,002X,029X,002X,029X,029X,
    029X,0ECX,029X,002X,029X,0FBX,029X,029X,029X,029X,029X,0FBX,
    029X,0FBX,029X,029X,029X,0ECX,029X,0FBX,029X,0FEX,029X,029X,
    029X,029X,029X,0FEX,029X,0FEX,029X,029X,029X,029X,029X,0FEX,
    029X,0FDX,029X,029X,029X,029X,029X,0FDX,029X,0FDX,029X,029X,
    029X,0ECX,029X,0FDX,029X,002X,029X,029X,029X,029X,029X,002X,
    029X,002X,029X,029X,029X,029X,029X,002X,029X,0FBX,029X,029X,
    007X,002X,029X,029X,002X,0FEX,029X,0FEX,029X,0FBX,0FBX,0FBX,
    029X,0FEX,029X,029X,029X,029X,029X,0FEX,029X,0FEX,029X,029X,
    029X,0ECX,029X,0FEX,029X,0FDX,029X,029X,029X,029X,029X,0FDX,
    029X,0FDX,029X,029X,029X,029X,029X,0FDX,029X,002X,029X,029X,
    029X,029X,029X,002X,029X,002X,029X,029X,029X,029X,029X,002X,
    029X,0FBX,029X,029X,029X,029X,029X,0FBX,029X,0FBX,029X,029X,
    029X,0FDX,029X,029X,029X,0FEX,029X,029X,029X,029X,029X,0FEX,
    029X,0FEX,029X,029X,029X,029X,029X,0FEX,029X,0FDX,029X,029X,
    029X,029X,029X,0FDX,029X,0FDX,029X,029X,029X,000X,029X,0FDX,
    029X,002X,029X,029X,029X,029X,029X,002X,029X,002X,029X,029X,
    029X,0ECX,002X,0F9X,0FAX,0FBX,029X,029X,029X,029X,029X,0FBX,
    029X,0FBX,029X,029X,029X,0FDX,029X,029X,029X,0FEX,029X,029X,
    029X,029X,029X,0FEX,029X,0FEX,029X,029X,029X,029X,029X,0FEX,
    029X,0FDX,029X,029X,029X,029X,029X,0FDX,029X,0FDX,029X,029X,
    029X,029X,029X,0FDX,029X,002X,029X,029X,029X,029X,029X,002X,
    029X,002X,029X,029X,029X,0ECX,002X,0F9X,0FAX,0FBX,029X,029X,
    029X,029X,029X,0FBX,029X,0FBX,029X,029X,029X,0FDX,029X,029X,
    029X,0FEX,029X,029X,029X,029X,029X,0FEX,029X,0FEX,029X,029X,
    029X,0ECX,029X,0FEX,029X,0FDX,029X,029X,029X,029X,029X,0FDX,
    029X,0FDX,029X,029X,029X,029X,029X,0FDX,029X,040X);

  Channel2 = Channel (
    000X,01CX,01CX,01AX,01AX,015X,015X,011X,011X,01CX,01CX,01AX,
    015X,015X,015X,011X,011X,018X,018X,016X,016X,011X,011X,00EX,
    00EX,018X,018X,016X,011X,011X,011X,011X,011X,016X,016X,015X,
    015X,011X,011X,00EX,00AX,00AX,00AX,00AX,00AX,00AX,00AX,00AX,
    00AX,009X,009X,00AX,00AX,00CX,00CX,00EX,00EX,010X,010X,011X,
    013X,013X,013X,015X,015X,01CX,01CX,01AX,01AX,015X,015X,011X,
    011X,01CX,01CX,01AX,015X,015X,015X,011X,011X,018X,018X,016X,
    016X,011X,011X,00EX,00EX,018X,018X,016X,011X,011X,011X,011X,
    011X,016X,016X,015X,015X,011X,011X,00EX,00AX,00AX,00AX,00AX,
    00AX,00AX,00AX,00AX,00AX,009X,009X,00AX,00AX,00CX,00CX,00EX,
    00EX,010X,010X,011X,013X,013X,013X,015X,015X,009X,029X,009X,
    029X,001X,029X,007X,007X,007X,007X,005X,005X,005X,005X,004X,
    002X,002X,002X,002X,029X,001X,029X,029X,029X,029X,029X,029X,
    029X,029X,029X,002X,029X,009X,009X,00AX,00AX,00AX,00AX,007X,
    007X,007X,007X,002X,029X,005X,029X,002X,029X,009X,029X,029X,
    029X,007X,029X,029X,029X,005X,029X,029X,029X,004X,029X,029X,
    029X,029X,029X,002X,004X,005X,029X,007X,009X,009X,009X,029X,
    029X,001X,029X,029X,029X,029X,029X,002X,004X,005X,029X,002X,
    00CX,00CX,00EX,00CX,00AX,00AX,00AX,00AX,009X,009X,009X,00AX,
    00AX,009X,009X,00AX,00AX,009X,009X,00AX,009X,009X,009X,009X,
    009X,009X,029X,029X,029X,007X,029X,029X,029X,005X,029X,029X,
    029X,004X,029X,002X,029X,00EX,029X,029X,011X,011X,010X,010X,
    010X,010X,029X,00EX,00EX,001X,029X,029X,029X,011X,029X,00EX,
    029X,011X,029X,00EX,013X,029X,013X,011X,029X,010X,029X,00EX,
    029X,029X,029X,011X,011X,011X,029X,010X,029X,010X,029X,00EX,
    00EX,001X,029X,029X,00EX,010X,010X,029X,00EX,029X,010X,029X,
    029X,011X,011X,011X,011X,010X,010X,010X,010X,011X,011X,011X,
    029X,011X,010X,010X,010X,010X,029X,00EX,00EX,001X,029X,029X,
    00EX,011X,029X,00EX,029X,011X,029X,00EX,013X,013X,029X,011X,
    011X,010X,010X,00EX,00EX,029X,029X,011X,011X,011X,010X,010X,
    010X,010X,029X,00EX,00EX,001X,029X,029X,00EX,010X,010X,029X,
    00EX,00EX,00EX,010X,010X,011X,011X,011X,011X,010X,010X,010X,
    010X,002X,029X,029X,029X,001X,029X,002X,029X,002X,029X,029X,
    029X,001X,00EX,00CX,00AX,00CX,00CX,00CX,00CX,00AX,00AX,00AX,
    00AX,00AX,00AX,00AX,029X,001X,029X,011X,011X,010X,010X,010X,
    010X,011X,011X,013X,013X,013X,013X,015X,015X,015X,015X,01AX,
    01AX,01CX,01CX,01CX,01CX,01DX,01DX,01AX,01AX,01AX,01AX,01AX,
    01AX,0F5X,029X,029X,029X,029X,029X,00EX,00EX,00EX,00EX,009X,
    009X,00CX,00CX,00CX,00CX,00EX,00EX,009X,009X,007X,007X,007X,
    007X,029X,029X,029X,029X,029X,029X,029X,029X,029X,029X,007X,
    007X,011X,011X,011X,011X,010X,029X,010X,010X,00EX,00EX,00EX,
    029X,001X,029X,029X,029X,009X,009X,029X,029X,007X,007X,029X,
    029X,005X,005X,029X,029X,004X,004X,029X,029X,029X,029X,002X,
    004X,005X,029X,007X,009X,009X,009X,00EX,010X,011X,029X,013X,
    015X,029X,029X,002X,004X,005X,029X,002X,00CX,00CX,00EX,00CX,
    00AX,00AX,00AX,00AX,009X,009X,009X,00AX,00AX,009X,009X,00AX,
    00AX,009X,009X,00AX,009X,009X,009X,009X,009X,010X,010X,010X,
    010X,00EX,00EX,010X,010X,011X,011X,011X,011X,010X,010X,010X,
    010X,00EX,00EX,029X,011X,011X,010X,010X,010X,010X,029X,00EX,
    00EX,001X,029X,029X,029X,011X,029X,00EX,029X,011X,029X,00EX,
    013X,029X,013X,011X,029X,010X,029X,00EX,029X,029X,029X,011X,
    011X,011X,029X,010X,029X,010X,029X,00EX,00EX,029X,029X,029X,
    00EX,010X,010X,029X,00EX,029X,010X,029X,029X,011X,011X,011X,
    011X,010X,010X,010X,010X,011X,011X,011X,029X,011X,010X,010X,
    010X,010X,029X,00EX,00EX,001X,029X,029X,00EX,011X,029X,00EX,
    029X,011X,029X,00EX,013X,013X,029X,011X,011X,010X,010X,00EX,
    00EX,029X,029X,011X,011X,011X,010X,010X,010X,010X,029X,00EX,
    00EX,001X,029X,029X,00EX,010X,010X,029X,00EX,00EX,00EX,010X,
    010X,011X,011X,011X,011X,010X,010X,010X,010X,040X);

PROCEDURE INIT;
BEGIN
  Laser2.InitSpritesA(Chudik); Laser2.ATOF;
  Wham.InitPlayNote(SYSTEM.ADR(Channel1), SYSTEM.ADR(Channel2));
END INIT;

PROCEDURE NOTE;
BEGIN
  Wham.PlayNote;
END NOTE;

PROCEDURE SPRT;
BEGIN
  Laser2.PTBL(5, 5, 3);
END SPRT;

END Engine.
