

var
	mem:packed array [0..65535] of byte absolute 0;

var
	// текущая позиция вывода текста
	txt_x:byte; // столбец
	txt_y:byte; // строка
	txt_attr:byte;

procedure asmlib;
begin
	asm
	end;
end;


procedure pause_ms(n:longword);
begin
	n:=n*3;
	while n>0 do n:=n-1;
end;


// очистка экрана и установка позиции вывода текста в левый верхний угол
procedure clrscr;
var
	aa:word;
begin
	mem[$5800]:=txt_attr;
	asm
		ld hl,04000h
		ld de,04001h
		ld bc,017ffh
		ld (hl),0
		ldir

		ld hl,05800h
		ld de,05801h
		ld bc,002ffh
		ldir
	end;
	txt_x:=0;
	txt_y:=0;
end;

procedure GotoXY(x,y:byte);
begin
	txt_x:=x-1;
	txt_y:=y-1;
end;

procedure textcolor(n:byte);
begin
	txt_attr:={(txt_attr and $f8) +} (n and 7);
end;


procedure textbackground(n:byte);
begin
end;



// компилятор вызывает эту процедуру для вывода любого текста (write/writeln)
procedure writechar(c:byte);
var
	a,a2:word;
	i:byte;
	y:byte;
begin
	if c>=32 then
	begin
		a:=$5800+txt_y*32+txt_x; // адрес атрибута в видеопамяти
		mem[a]:=txt_attr; // цвет
		// адрес символа в видеопамяти
		y:=txt_y*8;
		a:=$4000 + ((y and 7) shl 8) + ((y and $38) shl 2) + ((y and $c0) shl 5) + txt_x;
		// адрес символа в ROM
		a2:=$3c00+c*8;
		for i:=0 to 7 do
		begin
			mem[a]:=mem[a2];
			a:=a+256;
			a2:=a2+1;
		end;
		txt_x:=txt_x+1;
	end;

	if txt_x>=32 then
	begin
		txt_x:=0;
		txt_y:=txt_y+1;
	end;

	if c=13 then
	begin
		txt_x:=0;
	end;
	
	if c=10 then
	begin
		txt_y:=txt_y+1;
	end;

	if txt_y>=24 then txt_y:=0; // TODO scroll
	
end;


procedure putpixel(x,y:byte);
var
	a:word;
begin
	a:=((y and 7) shl 8) + ((y and $38) shl 2) + ((y and $c0) shl 5);
	a:=a+$4000+(x shr 3);
	mem[a]:=mem[a] or (128 shr (x and 7));
end;

procedure putpixel0(x,y:byte);
var
	a:word;
begin
	a:=((y and 7) shl 8) + ((y and $38) shl 2) + ((y and $c0) shl 5);
	a:=a+$4000+(x shr 3);
	mem[a]:=mem[a] and ((128 shr (x and 7)) xor 255);
end;





