    .org 0
_p00_config	=	0x0000
_p03_set	=	0x0003
_p04_RAM0	=	0x0004
_p05_RAM1	=	0x0005
_p06_RAM2	=	0x0006
_p07_set	=	0x0007
_p0a_mem_man	=	0x000a
_p0b_set	=	0x000b
_p1d_set	=	0x001d
_p3b_set	=	0x003b
_pfa_vbank	=	0x00fa
_pfc_color_reg	=	0x00fc
_pf8_vmode	=	0x00f8

CONFIG_TURBO_BIT = 3
CONFIG_WIDE_BIT = 4

MEMM_RAM0EN_BIT = 0
MEMM_RAM1EN_BIT = 1
MEMM_RAM2EN_BIT = 2
MEMM_TURBO_BIT = 5
VB_WIDE_BIT = 7

VBANK_START = 0xc000
RAM1_WINDOW = 0x4000

TEST_16C_PALLETE = 0x5f

; registers global:
;   B - configuration switches
;   C - phase (0x00/0xFF)

init:
    ld sp, 0x3fff
    ld	a, 0x98
    out	(_p03_set), a
    ld	a, 0x80
    out	(_p07_set), a
    ld	a, 0x80
    out	(_p0b_set), a
    ld	a, 0x92
    out	(_p1d_set), a
    ld	a, 0x16
    out	(_p3b_set), a
    ld	a, 0x56
    out	(_p3b_set), a
    ld	a, 0x96
    out	(_p3b_set), a
    ld	a, 0x10
    out	(_p0a_mem_man), a
    ld	a, 0x00
    out	(_pf8_vmode), a

main:
    in      a, (_p00_config)
    ld      b, a        ; save configuration to B
    jr      set_turbo
main_turbo:
    ld      a, 0x00
    jr      set_vbank   ; set video bank to 0 (0xC000-0xFFFF)
main_vbank:
    ld      a, b        ; load configuretion to A
    and     0x07        ; extract video test number
    ld      h, 0
    ld      l, a
    add     hl, hl
    ld      de, video_tests
    add     hl, de
    ld      a, (hl)
    inc     hl
    ld      h, (hl)
    ld      l, a
    jp      (hl)
main_video_end:
	ld		de, TEST_TITLE
	ld		iyh, 0
	ld		iyl, 28
	ld		hl, main_title_end
	jp		print_str
main_title_end:
    ; wait loop
    ld      d, 0
wait_loop0:
	inc		d
    ld      hl, 0x0000
wait_loop1:
	inc		hl
	ld		a, h
	sub		a, 0x80
    jr      C, wait_loop1
	ld		a, d
	sub		a, 4
    jr      C, wait_loop0
    jr      main

TEST_TITLE:
	.db "ORION-128 NG tests (andreil, 2018)", 0x00

video_tests:
    .DW test_2colors_pallet1
    .DW test_2colors_pallet2
    .DW test_4colors_pallet1
    .DW test_4colors_pallet2
    .DW test_16colors_group
    .DW test_16colors_pallet
    .DW test_3bit
    .DW test_4bit

set_turbo:
    in      a, (_p0a_mem_man)
    res     MEMM_TURBO_BIT, a
    bit     CONFIG_TURBO_BIT, b
    jr      Z, turbo_not_set
    set     MEMM_TURBO_BIT, a
turbo_not_set:
    out     (_p0a_mem_man), a
    jr      main_turbo

set_vbank:
    bit     CONFIG_WIDE_BIT, b
    jr      Z, wide_not_set
    set     VB_WIDE_BIT, a
wide_not_set:
    out     (_pfa_vbank), a
    jr      main_vbank

VMODE_2COLOR_1PALLETE = 0x00
VMODE_2COLOR_2PALLETE = 0x01
VMODE_4COLOR_1PALLETE = 0x04
VMODE_4COLOR_2PALLETE = 0x05
VMODE_16COLOR_GROUP   = 0x06
VMODE_16COLOR_PALLET  = 0x0e

VIDEO_TEST_0_TITLE:
	.db "TEST: 2 colors, pallete 1           ", 0x00
VIDEO_TEST_1_TITLE:
	.db "TEST: 2 colors, pallete 2           ", 0x00
VIDEO_TEST_2_TITLE:
	.db "TEST: 4 colors, pallete 1           ", 0x00
VIDEO_TEST_3_TITLE:
	.db "TEST: 4 colors, pallete 2           ", 0x00
VIDEO_TEST_4_TITLE:
	.db "TEST: 16 colors, group              ", 0x00
VIDEO_TEST_5_TITLE:
	.db "TEST: 16 colors, pallete (port 0xFC)", 0x00
VIDEO_TEST_6_TITLE:
	.db "TEST: 3bit colors                   ", 0x00
VIDEO_TEST_7_TITLE:
	.db "TEST: 4bit colors                   ", 0x00

test_2colors_pallet1:
    ld      a, VMODE_2COLOR_1PALLETE
    out     (_pf8_vmode), a
    jp      fill_scr_1
test_2colors_pallet1_end:
	ld		de, VIDEO_TEST_0_TITLE
	ld		iyh, 0
	ld		iyl, 29
	ld		hl, main_video_end
	jp		print_str

test_2colors_pallet2:
    ld      a, VMODE_2COLOR_2PALLETE
    out     (_pf8_vmode), a
    jp      fill_scr_1
test_2colors_pallet2_end:
	ld		de, VIDEO_TEST_1_TITLE
	ld		iyh, 0
	ld		iyl, 29
	ld		hl, main_video_end
	jp		print_str

test_4colors_pallet1:
    ld      a, VMODE_4COLOR_1PALLETE
    out     (_pf8_vmode), a
    jp      fill_scr_1
test_4colors_pallet1_end:
	jp		fill_scr_2_4c
test_4colors_pallet1_end2:
	ld		de, VIDEO_TEST_2_TITLE
	ld		iyh, 0
	ld		iyl, 29
	ld		hl, main_video_end
	jp		print_str

test_4colors_pallet2:
    ld      a, VMODE_4COLOR_2PALLETE
    out     (_pf8_vmode), a
    jp      fill_scr_1
test_4colors_pallet2_end:
	jp		fill_scr_2_4c
test_4colors_pallet2_end2:
	ld		de, VIDEO_TEST_3_TITLE
	ld		iyh, 0
	ld		iyl, 29
	ld		hl, main_video_end
	jp		print_str

test_16colors_group:
    ld      a, VMODE_16COLOR_GROUP
    out     (_pf8_vmode), a
    jp      fill_scr_1
test_16colors_group_end:
	jp		fill_scr_2_16c
test_16colors_group_end2:
	ld		de, VIDEO_TEST_4_TITLE
	ld		iyh, 0
	ld		iyl, 29
	ld		hl, main_video_end
	jp		print_str

test_16colors_pallet:
    ld      a, VMODE_16COLOR_PALLET
    out     (_pf8_vmode), a
    jp      fill_scr_1
test_16colors_pallet_end:
	ld		a, TEST_16C_PALLETE
	out		(_pfc_color_reg), a
test_16colors_pallet_end2:
	ld		de, VIDEO_TEST_5_TITLE
	ld		iyh, 0
	ld		iyl, 29
	ld		hl, main_video_end
	jp		print_str

test_3bit:
test_3bit_end:
	ld		de, VIDEO_TEST_6_TITLE
	ld		iyh, 0
	ld		iyl, 29
	ld		hl, main_video_end
	jp		print_str

test_4bit:
test_4bit_end:
	ld		de, VIDEO_TEST_7_TITLE
	ld		iyh, 0
	ld		iyl, 29
	ld		hl, main_video_end
	jp		print_str

test_ret_table:
    .DW test_2colors_pallet1_end
    .DW test_2colors_pallet2_end
    .DW test_4colors_pallet1_end
    .DW test_4colors_pallet2_end
    .DW test_16colors_group_end
    .DW test_16colors_pallet_end
    .DW test_3bit_end
    .DW test_4bit_end

fill_scr_1:
; usage:
;  hl - screen pointer
;  de - temp
    ld      hl, VBANK_START
loop_f1_col:
    ld      l, 0
loop_f1_row:
    ld      (hl), 0xff
    inc     hl
    ld      (hl), 0x81
    inc     hl
    ld      (hl), 0x81
    inc     hl
    ld      (hl), 0x81
    inc     hl
    ld      (hl), 0x81
    inc     hl
    ld      (hl), 0x81
    inc     hl
    ld      (hl), 0x81
    inc     hl
    ld      (hl), 0xff
    inc     hl
	; check column end
	ld		a, l
	cp		0xe0
    jr      C, loop_f1_row
    ld      de, 0x0020
	ld		a, h
    add     hl, de
	; check row end
	cp		0xff
    jr      NZ, loop_f1_col
	; print column numbers
	ld		d, 0
	ld		hl, 0	; h=*10 , l=*1
fill1_nbrs:
	ld		a, l
	add		a, '0'
	ld		iyh, d
	ld		iyl, 31
	ld		ix, fill1_enbrs1
	jp		print_chr
fill1_enbrs1:
	ld		a, h
	add		a, '0'
	ld		iyh, d
	ld		iyl, 30
	ld		ix, fill1_enbrs2
	jp		print_chr
fill1_enbrs2:
	inc		l
	ld		a, l
	cp		10
	jr		C, fill1_nnbrs
	inc		h
	ld		l, 0
fill1_nnbrs:
	inc		d
	ld		a, d
	cp		64
	jr		C, fill1_nbrs
fill1_end:
    ; return to test
    ld      a, b        ; load configuration to A
    and     0x07        ; extract video test number
    ld      h, 0
    ld      l, a
    add     hl, hl
    ld      de, test_ret_table
    add     hl, de
    ld      a, (hl)
    inc     hl
    ld      h, (hl)
    ld      l, a
    jp      (hl)

test_ret_table_2:
    .DW 0
    .DW 0
    .DW test_4colors_pallet1_end2
    .DW test_4colors_pallet2_end2
    .DW test_16colors_group_end2
    .DW 0
    .DW 0
    .DW 0

fill_scr_2_4c:
	; enable window on RAM1
	in		a, (_p0a_mem_man)
	set		MEMM_RAM1EN_BIT, a
	out		(_p0a_mem_man), a
	; set RAM 1 to segment #7
	ld		a, 7
	out		(_p05_RAM1), a
	; screen pointer
	ld		hl, RAM1_WINDOW
	ld		d, 0 ; columns
fill2_row:
	; col N
	ld		a, 0
fill2_sr1:
	ld		(hl), 0xff
	inc		hl
	inc		a
	cp		0xe0
	jr		C, fill2_sr1
	; skip 4 rows
	ld		a, d
	ld		de, 0x0020
	add		hl, de
	ld		d, a
	; col N+1
	ld		a, 0
fill2_sr2:
	ld		(hl), 0x00
	inc		hl
	inc		a
	cp		0xe0
	jr		C, fill2_sr2
	; skip 4 rows
	ld		a, d
	ld		de, 0x0020
	add		hl, de
	ld		d, a
	; decrease columns counter
	inc		d
	ld		a, d
	cp		32
	jr		C, fill2_row
fill2_end:
	; disable window on RAM1
	in		a, (_p0a_mem_man)
	res		MEMM_RAM1EN_BIT, a
	out		(_p0a_mem_man), a
    ; return to test
    ld      a, b        ; load configuration to A
    and     0x07        ; extract video test number
    ld      h, 0
    ld      l, a
    add     hl, hl
    ld      de, test_ret_table_2
    add     hl, de
    ld      a, (hl)
    inc     hl
    ld      h, (hl)
    ld      l, a
    jp      (hl)

fill_scr_2_16c:
	; enable window on RAM1
	in		a, (_p0a_mem_man)
	set		MEMM_RAM1EN_BIT, a
	out		(_p0a_mem_man), a
	; set RAM 1 to segment #7
	ld		a, 7
	out		(_p05_RAM1), a
	; screen pointer
	ld		hl, RAM1_WINDOW
	ld		d, 0 ; columns
fill3_row:
	; calculate fill value
	ld		a, d
	and		0x0f
	sla		a
	sla		a
	sla		a
	sla		a
	ld		e, a
	ld		c, 0
	; rows main
fill3_sr1:
	ld		a, c
	and		0x0f
	add		a, e
	ld		(hl), a
	inc		hl
	ld		(hl), a
	inc		hl
	ld		(hl), a
	inc		hl
	ld		(hl), a
	inc		hl
	ld		(hl), a
	inc		hl
	ld		(hl), a
	inc		hl
	ld		(hl), a
	inc		hl
	ld		(hl), a
	inc		hl
	inc		c
	ld		a, c
	cp		0x1c
	jr		C, fill3_sr1
	; rows titles
	;ld		a, d
	;and		0x0f
	;jr		NZ, fill3_nz
	ld		a, 1
fill3_nz:
	ld		e, a
	ld		a, 0
fill3_sr2:
	ld		(hl), e
	inc		hl
	ld		(hl), e
	inc		hl
	ld		(hl), e
	inc		hl
	ld		(hl), e
	inc		hl
	ld		(hl), e
	inc		hl
	ld		(hl), e
	inc		hl
	ld		(hl), e
	inc		hl
	ld		(hl), e
	inc		hl
	inc		a
	cp		0x4
	jr		C, fill3_sr2
	; decrease columns counter
	inc		d
	ld		a, d
	cp		64
	jr		C, fill3_row
fill3_end:
	; disable window on RAM1
	in		a, (_p0a_mem_man)
	res		MEMM_RAM1EN_BIT, a
	out		(_p0a_mem_man), a
    ; return to test
    ld      a, b        ; load configuration to A
    and     0x07        ; extract video test number
    ld      h, 0
    ld      l, a
    add     hl, hl
    ld      de, test_ret_table_2
    add     hl, de
    ld      a, (hl)
    inc     hl
    ld      h, (hl)
    ld      l, a
    jp      (hl)

print_chr:
; parameters:
;  A - char
;  iyh - column
;  iyl - row
;  ix - return address
; usage:
;  shadow registers
	exx
	; get character start
    ld      de, font
	ld		h, 0
	ld		l, a
	add		hl, hl	; *2
	add		hl, hl	; *2
	add		hl, hl	; *2
	add		hl, de
	; calculate screen start
	ld		a, iyl ;28
	add		a, a	; *2
	add		a, a	; *2
	add		a, a	; *2
	ld		e, a
	ld		a, iyh ;0
	add		a, 0xc0
	ld		d, a
	; set count
	ld		bc, 0x0008
	ldir
	exx
	jp		ix

print_str:
; parameters:
;  de - string start (ZERO-ended)
;  iyh - column
;  iyl - row
;  hl - return address
	ld		ix, print_str_add
print_str_loop:
	ld		a, (de)
	cp		0
	jr		Z, print_str_exit
	inc		de
	jp		print_chr
print_str_add:
	inc		iyh
	jr		print_str_loop
print_str_exit:
	jp		hl

font:
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 // 0
    .db 0x00, 0x3E, 0x41, 0x55, 0x41, 0x55, 0x49, 0x3E // 1
    .db 0x00, 0x3E, 0x7F, 0x6B, 0x7F, 0x6B, 0x77, 0x3E // 2
    .db 0x00, 0x22, 0x77, 0x7F, 0x7F, 0x3E, 0x1C, 0x08 // 3
    .db 0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x3E, 0x1C, 0x08 // 4
    .db 0x00, 0x08, 0x1C, 0x2A, 0x7F, 0x2A, 0x08, 0x1C // 5
    .db 0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x3E, 0x08, 0x1C // 6
    .db 0x00, 0x00, 0x1C, 0x3E, 0x3E, 0x3E, 0x1C, 0x00 // 7
    .db 0xFF, 0xFF, 0xE3, 0xC1, 0xC1, 0xC1, 0xE3, 0xFF // 8
    .db 0x00, 0x00, 0x1C, 0x22, 0x22, 0x22, 0x1C, 0x00 // 9
    .db 0xFF, 0xFF, 0xE3, 0xDD, 0xDD, 0xDD, 0xE3, 0xFF // a
    .db 0x00, 0x0F, 0x03, 0x05, 0x39, 0x48, 0x48, 0x30 // b
    .db 0x00, 0x08, 0x3E, 0x08, 0x1C, 0x22, 0x22, 0x1C // c
    .db 0x00, 0x18, 0x14, 0x10, 0x10, 0x30, 0x70, 0x60 // d
    .db 0x00, 0x0F, 0x19, 0x11, 0x13, 0x37, 0x76, 0x60 // e
    .db 0x00, 0x08, 0x2A, 0x1C, 0x77, 0x1C, 0x2A, 0x08 // f
    .db 0x00, 0x60, 0x78, 0x7E, 0x7F, 0x7E, 0x78, 0x60 // 10
    .db 0x00, 0x03, 0x0F, 0x3F, 0x7F, 0x3F, 0x0F, 0x03 // 11
    .db 0x00, 0x08, 0x1C, 0x2A, 0x08, 0x2A, 0x1C, 0x08 // 12
    .db 0x00, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x66 // 13
    .db 0x00, 0x3F, 0x65, 0x65, 0x3D, 0x05, 0x05, 0x05 // 14
    .db 0x00, 0x0C, 0x32, 0x48, 0x24, 0x12, 0x4C, 0x30 // 15
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x7F, 0x7F // 16
    .db 0x00, 0x08, 0x1C, 0x2A, 0x08, 0x2A, 0x1C, 0x3E // 17
    .db 0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x1C, 0x1C, 0x1C // 18
    .db 0x00, 0x1C, 0x1C, 0x1C, 0x7F, 0x3E, 0x1C, 0x08 // 19
    .db 0x00, 0x08, 0x0C, 0x7E, 0x7F, 0x7E, 0x0C, 0x08 // 1a
    .db 0x00, 0x08, 0x18, 0x3F, 0x7F, 0x3F, 0x18, 0x08 // 1b
    .db 0x00, 0x00, 0x00, 0x70, 0x70, 0x70, 0x7F, 0x7F // 1c
    .db 0x00, 0x00, 0x14, 0x22, 0x7F, 0x22, 0x14, 0x00 // 1d
    .db 0x00, 0x08, 0x1C, 0x1C, 0x3E, 0x3E, 0x7F, 0x7F // 1e
    .db 0x00, 0x7F, 0x7F, 0x3E, 0x3E, 0x1C, 0x1C, 0x08 // 1f
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 // 20
    .db 0x00, 0x18, 0x3C, 0x3C, 0x18, 0x18, 0x00, 0x18 // 21
    .db 0x00, 0x36, 0x36, 0x14, 0x00, 0x00, 0x00, 0x00 // 22
    .db 0x00, 0x36, 0x36, 0x7F, 0x36, 0x7F, 0x36, 0x36 // 23
    .db 0x00, 0x08, 0x1E, 0x20, 0x1C, 0x02, 0x3C, 0x08 // 24
    .db 0x00, 0x60, 0x66, 0x0C, 0x18, 0x30, 0x66, 0x06 // 25
    .db 0x00, 0x3C, 0x66, 0x3C, 0x28, 0x65, 0x66, 0x3F // 26
    .db 0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00 // 27
    .db 0x00, 0x06, 0x0C, 0x18, 0x18, 0x18, 0x0C, 0x06 // 
    .db 0x00, 0x60, 0x30, 0x18, 0x18, 0x18, 0x30, 0x60 // 
    .db 0x00, 0x00, 0x36, 0x1C, 0x7F, 0x1C, 0x36, 0x00 
    .db 0x00, 0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, 0x00 
    .db 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x30, 0x60 
    .db 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00 
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60 
    .db 0x00, 0x00, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x00 
    .db 0x00, 0x3C, 0x66, 0x6E, 0x76, 0x66, 0x66, 0x3C 
    .db 0x00, 0x18, 0x18, 0x38, 0x18, 0x18, 0x18, 0x7E 
    .db 0x00, 0x3C, 0x66, 0x06, 0x0C, 0x30, 0x60, 0x7E 
    .db 0x00, 0x3C, 0x66, 0x06, 0x1C, 0x06, 0x66, 0x3C 
    .db 0x00, 0x0C, 0x1C, 0x2C, 0x4C, 0x7E, 0x0C, 0x0C 
    .db 0x00, 0x7E, 0x60, 0x7C, 0x06, 0x06, 0x66, 0x3C 
    .db 0x00, 0x3C, 0x66, 0x60, 0x7C, 0x66, 0x66, 0x3C 
    .db 0x00, 0x7E, 0x66, 0x0C, 0x0C, 0x18, 0x18, 0x18 
    .db 0x00, 0x3C, 0x66, 0x66, 0x3C, 0x66, 0x66, 0x3C 
    .db 0x00, 0x3C, 0x66, 0x66, 0x3E, 0x06, 0x66, 0x3C 
    .db 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00 
    .db 0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x30 
    .db 0x00, 0x06, 0x0C, 0x18, 0x30, 0x18, 0x0C, 0x06 
    .db 0x00, 0x00, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x00 
    .db 0x00, 0x60, 0x30, 0x18, 0x0C, 0x18, 0x30, 0x60 
    .db 0x00, 0x3C, 0x66, 0x06, 0x1C, 0x18, 0x00, 0x18 
    .db 0x00, 0x38, 0x44, 0x5C, 0x58, 0x42, 0x3C, 0x00 
    .db 0x00, 0x3C, 0x66, 0x66, 0x7E, 0x66, 0x66, 0x66 
    .db 0x00, 0x7C, 0x66, 0x66, 0x7C, 0x66, 0x66, 0x7C 
    .db 0x00, 0x3C, 0x66, 0x60, 0x60, 0x60, 0x66, 0x3C 
    .db 0x00, 0x7C, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7C 
    .db 0x00, 0x7E, 0x60, 0x60, 0x7C, 0x60, 0x60, 0x7E 
    .db 0x00, 0x7E, 0x60, 0x60, 0x7C, 0x60, 0x60, 0x60 
    .db 0x00, 0x3C, 0x66, 0x60, 0x60, 0x6E, 0x66, 0x3C 
    .db 0x00, 0x66, 0x66, 0x66, 0x7E, 0x66, 0x66, 0x66 
    .db 0x00, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C 
    .db 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x6C, 0x6C, 0x38 
    .db 0x00, 0x66, 0x6C, 0x78, 0x70, 0x78, 0x6C, 0x66 
    .db 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7E 
    .db 0x00, 0x63, 0x77, 0x7F, 0x6B, 0x63, 0x63, 0x63 
    .db 0x00, 0x63, 0x73, 0x7B, 0x6F, 0x67, 0x63, 0x63 
    .db 0x00, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C 
    .db 0x00, 0x7C, 0x66, 0x66, 0x66, 0x7C, 0x60, 0x60 
    .db 0x00, 0x3C, 0x66, 0x66, 0x66, 0x6E, 0x3C, 0x06 
    .db 0x00, 0x7C, 0x66, 0x66, 0x7C, 0x78, 0x6C, 0x66 
    .db 0x00, 0x3C, 0x66, 0x60, 0x3C, 0x06, 0x66, 0x3C 
    .db 0x00, 0x7E, 0x5A, 0x18, 0x18, 0x18, 0x18, 0x18 
    .db 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3E 
    .db 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x18 
    .db 0x00, 0x63, 0x63, 0x63, 0x6B, 0x7F, 0x77, 0x63 
    .db 0x00, 0x63, 0x63, 0x36, 0x1C, 0x36, 0x63, 0x63 
    .db 0x00, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x18 
    .db 0x00, 0x7E, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x7E 
    .db 0x00, 0x1E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1E 
    .db 0x00, 0x00, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x00 
    .db 0x00, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78 
    .db 0x00, 0x08, 0x14, 0x22, 0x41, 0x00, 0x00, 0x00 
    .db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F 
    .db 0x00, 0x0C, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00 
    .db 0x00, 0x00, 0x00, 0x3C, 0x06, 0x3E, 0x66, 0x3E 
    .db 0x00, 0x60, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x7C 
    .db 0x00, 0x00, 0x00, 0x3C, 0x66, 0x60, 0x66, 0x3C 
    .db 0x00, 0x06, 0x06, 0x06, 0x3E, 0x66, 0x66, 0x3E 
    .db 0x00, 0x00, 0x00, 0x3C, 0x66, 0x7E, 0x60, 0x3C 
    .db 0x00, 0x1C, 0x36, 0x30, 0x30, 0x7C, 0x30, 0x30 
    .db 0x00, 0x00, 0x3E, 0x66, 0x66, 0x3E, 0x06, 0x3C 
    .db 0x00, 0x60, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x66 
    .db 0x00, 0x00, 0x18, 0x00, 0x18, 0x18, 0x18, 0x3C 
    .db 0x00, 0x0C, 0x00, 0x0C, 0x0C, 0x6C, 0x6C, 0x38 
    .db 0x00, 0x60, 0x60, 0x66, 0x6C, 0x78, 0x6C, 0x66 
    .db 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 
    .db 0x00, 0x00, 0x00, 0x63, 0x77, 0x7F, 0x6B, 0x6B 
    .db 0x00, 0x00, 0x00, 0x7C, 0x7E, 0x66, 0x66, 0x66 
    .db 0x00, 0x00, 0x00, 0x3C, 0x66, 0x66, 0x66, 0x3C 
    .db 0x00, 0x00, 0x7C, 0x66, 0x66, 0x7C, 0x60, 0x60 
    .db 0x00, 0x00, 0x3C, 0x6C, 0x6C, 0x3C, 0x0D, 0x0F 
    .db 0x00, 0x00, 0x00, 0x7C, 0x66, 0x66, 0x60, 0x60 
    .db 0x00, 0x00, 0x00, 0x3E, 0x40, 0x3C, 0x02, 0x7C 
    .db 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x18 
    .db 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3E 
    .db 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x3C, 0x18 
    .db 0x00, 0x00, 0x00, 0x63, 0x6B, 0x6B, 0x6B, 0x3E 
    .db 0x00, 0x00, 0x00, 0x66, 0x3C, 0x18, 0x3C, 0x66 
    .db 0x00, 0x00, 0x00, 0x66, 0x66, 0x3E, 0x06, 0x3C 
    .db 0x00, 0x00, 0x00, 0x3C, 0x0C, 0x18, 0x30, 0x3C 
    .db 0x00, 0x0E, 0x18, 0x18, 0x30, 0x18, 0x18, 0x0E 
    .db 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18 
    .db 0x00, 0x70, 0x18, 0x18, 0x0C, 0x18, 0x18, 0x70 
    .db 0x00, 0x00, 0x00, 0x3A, 0x6C, 0x00, 0x00, 0x00 
    .db 0x00, 0x08, 0x1C, 0x36, 0x63, 0x41, 0x41, 0x7F
