#include <stdio.h>

static int v2_rf15 = 1, v2_rf14 = 1;
static int v1_rf17 = 1, v1_rf16 = 0, v1_rf15 = 0, v1_rf14 = 0;
static int v2_rf17 = 0, v2_rf16 = 0;
static int v9_rf17 = 0, v9_rf16 = 0, v9_rf15 = 0, v9_rf14 = 0;

/* Устанавливаем в значения, чтоб сразу убрать переходной процесс - на реальном железе регистры ПЛМ-ок
   не предустанавливаются по сбросу, а просто через некоторое время счетчики на их основе "входят врежим" */
static int v3_rf18=0, v3_rf15=1, v3_rf14=0, v3_rf16=0,  v3_rf13=1; 
static int v4_rf16=0, v4_rf15=1, v4_rf14=1, v4_rf17=0;
static int v3_rf17=1;

/* ПЛМки работают на разных частотах: V1/V2 - 16МГц, V9 - 250кГц, V3 - 15625 Гц (строчная), V4 - (501Гц  15625/312*10)  */
/* Или в длительностях печатей                62.5 нс       4 мкс         64 мкс                 1.997 мкс              */
static int v1_tick, v9_tick, v3_tick, v4_tick;

unsigned long long F[10]; // Таблица частот переключения сигналов (для поиска порядка бит на счетчиках)

// Проверка что фронт сигнала (переход 0->1)
#define EDGE(w) (w == 0 && (new_ ## w != w))
//#define FREQ_X
//#define FREQ_Y
#if defined(FREQ_X) && defined(FREQ_Y)
#  error Use one macros only
#endif

void Tick() {
  int new_v1_rf17, new_v1_rf16, new_v1_rf15, new_v1_rf14;
  int new_v2_rf17, new_v2_rf16, new_v2_rf15, new_v2_rf14;
  int v2_i3, v2_i4, v2_i5, v2_i6, v2_i7;

  int new_v9_rf17, new_v9_rf16, new_v9_rf15, new_v9_rf14;

  int new_v3_rf18, new_v3_rf17, new_v3_rf16, new_v3_rf15, new_v3_rf14,
      new_v3_rf13;
  int v3_i2, v3_i3, v3_i4, v3_i5, v3_i6, v3_i7, v3_i8, v3_i9;
  int v3_o12, v3_o19;

  int new_v4_rf17, new_v4_rf16, new_v4_rf15, new_v4_rf14;

  // Inputs of V3
  v3_i2 = v9_rf14; /* V9-14, этот же сигнал подаётся на v3_clk */
  v3_i3 = v4_rf17; /* V4-17 */
  v3_i4 = v4_rf16; /* V4-16 */
  v3_i5 = v9_rf15; /* V9-15 */
  v3_i6 = v9_rf16; /* V9-16 */
  v3_i7 = v2_rf16; /* V2-16: X4-500kHz */
  v3_i8 = v2_rf17; /* V2-17: X5-250kHz */
  v3_i9 = v9_rf17; /* V9-17 */

  // Комбинаторику V3 вычисляем заново, каждый раз, т.к. для неё изменяются
  // входные
  // сигналы от V2/V4/V9 (т.е. из-за V2 в каждом такте)
  v3_o12 =
      !(v3_i2 && v3_i3 && v3_i5 && v3_i6 && v3_i9 ||
        v3_i2 && v3_i4 && v3_i5 && v3_i6 && v3_i9 ||
        v3_i2 && v3_i5 && v3_i6 && v3_i9 && v3_rf15 && v3_rf18 ||
        v3_i2 && v3_i5 && v3_i6 && v3_i9 && v3_rf14 && !v3_rf15 && v3_rf18 ||
        v3_i2 && !v3_o12 || v3_i6 && !v3_o12 || v3_i9 && !v3_o12);

  v3_o19 = !(!v3_i2 && v3_i5 && !v3_i6 && !v3_i7 && v3_i8 && !v3_i9 ||
             !v3_i2 && v3_i5 && !v3_i6 && !v3_i9 && !v3_o19 ||
             !v3_i2 && !v3_i5 && !v3_i6 && v3_i8 && v3_i9 && !v3_o19 ||
             v3_i2 && !v3_o19 || v3_i6 && !v3_o19 ||
             !v3_i2 && !v3_i3 && !v3_i4 && !v3_i5 && !v3_i6 && v3_rf13 &&
                 !v3_rf14 && !v3_rf15 && v3_rf16 && v3_rf18 && !v3_o19 ||
             !v3_i2 && !v3_i3 && !v3_i4 && !v3_i5 && !v3_i6 && !v3_rf14 &&
                 !v3_rf15 && !v3_rf16 && v3_rf18 && !v3_o19);

  // V1
  new_v1_rf17 = !v1_rf17;

  new_v1_rf16 = !(v1_rf17 && v1_rf16 || !v1_rf17 && !v1_rf16);

  new_v1_rf15 = !(v1_rf17 && !v1_rf16 && v1_rf15 || v1_rf16 && !v1_rf15 ||
                  !v1_rf17 && !v1_rf15);

  new_v1_rf14 =
      !(v1_rf17 && !v1_rf16 && !v1_rf15 && v1_rf14 || v1_rf15 && !v1_rf14 ||
        v1_rf16 && !v1_rf14 || !v1_rf17 && !v1_rf14);
  // Inputs of V2
  v2_i3 = v3_rf17 ||
          v3_o19; /* Элемент ИЛИ выполненный на диодно-резисторной логике */
  v2_i4 = v1_rf17;
  v2_i5 = v1_rf16;
  v2_i6 = v1_rf15;
  v2_i7 = v1_rf14;

  // V2
  new_v2_rf17 = !(v2_i4 && v2_rf17 && !v2_i5 && !v2_rf16 && !v2_i6 && !v2_i7 ||
                  !v2_rf17 && v2_rf16 || !v2_rf17 && v2_i7 ||
                  !v2_rf17 && v2_i6 || !v2_rf17 && v2_i5 || !v2_i4 && !v2_rf17);

  new_v2_rf16 =
      !(v2_i4 && !v2_i5 && v2_rf16 && !v2_i6 && !v2_i7 || !v2_rf16 && v2_i7 ||
        !v2_rf16 && v2_i6 || v2_i5 && !v2_rf16 || !v2_i4 && !v2_rf16);

  new_v2_rf15 =
      !(v2_i4 && !v2_i5 && v2_i6 && v2_i7 || v2_i5 && !v2_i6 && v2_i7 ||
        v2_i3 && !v2_i5 && v2_i6 && !v2_i7 ||
        v2_i3 && v2_i4 && v2_i5 && !v2_i6 && !v2_i7 ||
        !v2_i3 && v2_i5 && v2_i6 && !v2_i7);

  new_v2_rf14 =
      !(v2_i4 && !v2_i5 && !v2_i6 && !v2_i7 || v2_i5 && v2_i6 && v2_i7 ||
        v2_i3 && !v2_i5 && !v2_i6 && v2_i7 ||
        v2_i3 && v2_i5 && v2_i6 && !v2_i7 || !v2_i5 && v2_i6 && v2_i7);

  if (EDGE(v2_rf17)) /* V9 защилкивает по фронту
                                                 сигнала v2_17, его частота
                                                 250кГц */
  {

    new_v9_rf17 = !(v9_rf17);
    new_v9_rf15 = !(v9_rf15 && !v9_rf17 || !v9_rf15 && v9_rf17);
    new_v9_rf16 = !(!v9_rf15 && v9_rf16 && !v9_rf17 || v9_rf15 && !v9_rf16 ||
                    !v9_rf16 && v9_rf17);
    new_v9_rf14 =
        !(v9_rf14 && !v9_rf15 && !v9_rf16 && !v9_rf17 || !v9_rf14 && v9_rf16 ||
          !v9_rf14 && v9_rf15 || !v9_rf14 && v9_rf17);

    /********** V3 **********/

    if (v9_rf14 == 0 &&
        new_v9_rf14 != v9_rf14) /* V3 защилкивает по фронту сигнала v9_14 */
    {
      new_v3_rf13 = !(v3_rf13);
      new_v3_rf16 = !(v3_rf13 && v3_rf16 || !v3_rf13 && !v3_rf16);
      new_v3_rf14 = !(v3_rf13 && v3_rf14 && !v3_rf16 || !v3_rf14 && v3_rf16 ||
                      !v3_rf13 && !v3_rf14);

      new_v3_rf17 = !(!v3_i3 && !v3_i4 && v3_rf13 && !v3_rf14 && v3_rf15 &&
                          !v3_rf16 && !v3_rf18 ||
                      v3_i4 && !v3_rf17 || v3_i3 && !v3_rf17 ||
                      v3_rf15 && !v3_rf17 || v3_rf14 && !v3_rf17);

      new_v3_rf15 =
          !(v3_i3 && v3_rf13 && !v3_rf14 && v3_rf15 && !v3_rf16 ||
            v3_i4 && v3_rf13 && !v3_rf14 && v3_rf15 && !v3_rf16 ||
            v3_rf13 && !v3_rf14 && v3_rf15 && !v3_rf16 && v3_rf18 ||
            v3_rf14 && !v3_rf15 || !v3_rf15 && v3_rf16 || !v3_rf13 && !v3_rf15);

      new_v3_rf18 =
          !(v3_rf13 && !v3_rf14 && !v3_rf15 && !v3_rf16 && v3_rf18 ||
            v3_i3 && v3_rf15 && !v3_rf18 || v3_i4 && v3_rf15 && !v3_rf18 ||
            v3_rf14 && !v3_rf18 || v3_rf16 && !v3_rf18 || !v3_rf13 && !v3_rf18);

      if (v3_rf18 == 0 &&
          new_v3_rf18 != v3_rf18) /* V4 защилкивает по фронту сигнала v3_18 */
      {

        new_v4_rf17 = !(v4_rf17);
        new_v4_rf14 = !(v4_rf14 && v4_rf16 && !v4_rf17 || !v4_rf14 && v4_rf17);
        new_v4_rf15 = !(!v4_rf14 && v4_rf15 && !v4_rf17 ||
                        !v4_rf15 && v4_rf17 || v4_rf14 && !v4_rf15 && v4_rf16);
        new_v4_rf16 = !(!v4_rf14 && !v4_rf15 && v4_rf16 && !v4_rf17 ||
                        !v4_rf16 && v4_rf17);

        // Registers emulation
#ifdef FREQ_Y
    if(EDGE(v4_rf14)) ++F[6];
    if(EDGE(v4_rf15)) ++F[7];
    if(EDGE(v4_rf16)) ++F[8];
    if(EDGE(v4_rf17)) ++F[9];
#endif
        v4_rf17 = new_v4_rf17;
        v4_rf16 = new_v4_rf16;
        v4_rf15 = new_v4_rf15;
        v4_rf14 = new_v4_rf14;
        printf("v4: %06d => %d%d%d%d (%d)\n", v4_tick++, v4_rf16, v4_rf15,
               v4_rf14, v4_rf17,
               (v4_rf16 * 8 + v4_rf15 * 4 + v4_rf14 * 2 + !v4_rf17));
      }
      // V3 Registers emulation
#ifdef FREQ_Y
    if(EDGE(v3_rf13)) ++F[0];
    if(EDGE(v3_rf14)) ++F[1];
    if(EDGE(v3_rf15)) ++F[2];
    if(EDGE(v3_rf16)) ++F[3];
    if(EDGE(v3_rf17)) ++F[4];
    if(EDGE(v3_rf18)) ++F[5];
#endif
      v3_rf18 = new_v3_rf18;
      v3_rf17 = new_v3_rf17;
      v3_rf16 = new_v3_rf16;
      v3_rf15 = new_v3_rf15;
      v3_rf14 = new_v3_rf14;
      v3_rf13 = new_v3_rf13;
      // После перещелкивания регистров комбинаторику вычисляем заново
      v3_o12 = !(v3_i2 && v3_i3 && v3_i5 && v3_i6 && v3_i9 ||
                 v3_i2 && v3_i4 && v3_i5 && v3_i6 && v3_i9 ||
                 v3_i2 && v3_i5 && v3_i6 && v3_i9 && v3_rf15 && v3_rf18 ||
                 v3_i2 && v3_i5 && v3_i6 && v3_i9 && v3_rf14 && !v3_rf15 &&
                     v3_rf18 ||
                 v3_i2 && !v3_o12 || v3_i6 && !v3_o12 || v3_i9 && !v3_o12);

      v3_o19 = !(!v3_i2 && v3_i5 && !v3_i6 && !v3_i7 && v3_i8 && !v3_i9 ||
                 !v3_i2 && v3_i5 && !v3_i6 && !v3_i9 && !v3_o19 ||
                 !v3_i2 && !v3_i5 && !v3_i6 && v3_i8 && v3_i9 && !v3_o19 ||
                 v3_i2 && !v3_o19 || v3_i6 && !v3_o19 ||
                 !v3_i2 && !v3_i3 && !v3_i4 && !v3_i5 && !v3_i6 && v3_rf13 &&
                     !v3_rf14 && !v3_rf15 && v3_rf16 && v3_rf18 && !v3_o19 ||
                 !v3_i2 && !v3_i3 && !v3_i4 && !v3_i5 && !v3_i6 && !v3_rf14 &&
                     !v3_rf15 && !v3_rf16 && v3_rf18 && !v3_o19);
      printf("V3/V4: %06d/%06d =>  %d%d%d%d_%d%d%d%d%d (Y= %-4d) Hsync=%d\n", v3_tick++, v1_tick,
             /*           8            7            6            5     |      4           3           2           1          0        HSYNC */
                        v4_rf16,     v4_rf15,     v4_rf14,     v4_rf17,     v3_rf18,    v3_rf15,    v3_rf14,    v3_rf16,  !v3_rf13,
             511 - (256*v4_rf16 + 128*v4_rf15 + 64*v4_rf14 + 32*v4_rf17 + 16*v3_rf18 + 8*v3_rf15 + 4*v3_rf14 + 2*v3_rf16 + !v3_rf13),  v3_rf17);
    }
    // Registers emulation
#ifdef FREQ_X
    if(EDGE(v9_rf14)) ++F[6];
    if(EDGE(v9_rf15)) ++F[7];
    if(EDGE(v9_rf16)) ++F[8];
    if(EDGE(v9_rf17)) ++F[9];
#endif
    v9_rf17 = new_v9_rf17;
    v9_rf16 = new_v9_rf16;
    v9_rf15 = new_v9_rf15;
    v9_rf14 = new_v9_rf14;
    printf("v9: %06d => %d%d%d%d (%d)\n", v9_tick++, v9_rf14, v9_rf16, v9_rf15,
           v9_rf17, (v9_rf14 * 8 + v9_rf16 * 4 + v9_rf15 * 2 + v9_rf17));
  }
  // Registers emulation
#ifdef FREQ_X
    if(EDGE(v1_rf14)) ++F[0];
    if(EDGE(v1_rf15)) ++F[1];
    if(EDGE(v1_rf16)) ++F[2];
    if(EDGE(v1_rf17)) ++F[3];
#endif
  v1_rf17 = new_v1_rf17;
  v1_rf16 = new_v1_rf16;
  v1_rf15 = new_v1_rf15;
  v1_rf14 = new_v1_rf14;

#ifdef FREQ_X
    if(EDGE(v2_rf16)) ++F[4];
    if(EDGE(v2_rf17)) ++F[5];
#endif
  v2_rf17 = new_v2_rf17;
  v2_rf16 = new_v2_rf16;
  v2_rf15 = new_v2_rf15;
  v2_rf14 = new_v2_rf14;
  printf("V1/V2/V9: %06d => %d->[%d%d] %d%d%d%d_%d%d_%d%d%d%d  (X=%-4d)  v3-12:%d  "
         "v3-19[tv_sync]=%d  both=%d\n", v1_tick++,
         v2_i3, v2_rf15, v2_rf14, /* Пока непонятно */
         v9_rf14, v9_rf16, v9_rf15, v9_rf17,
         v2_rf17, v2_rf16,
         v1_rf14, v1_rf15, v1_rf16, !v1_rf17,
         1023-(512 * v9_rf14 + 256 * v9_rf16 + 128 * v9_rf15 + 64 * v9_rf17 +
                32 * v2_rf17 +  16 * v2_rf16 +
                 8 * v1_rf14 +   4 * v1_rf15 +   2 * v1_rf16 + (!v1_rf17)),
         v3_o12, v3_o19, v3_o12 || v3_o19);
}

int main(void) {
  int i;

  for (i = 0; i < 1280000; i++) {
    Tick();
  }
#if defined(FREQ_X) || defined(FREQ_Y)
  for(i=0; i<sizeof(F)/sizeof(F[0]); i++)
  {
       printf("F[%d]=%llu\n", i, F[i]);
  }
#endif
  return 0;
}
