
ps = 0.01:0.01:0.99;
h0s = -ps.*log2(ps) - (1-ps).*log2(1-ps); %Entropy per payload bit at various values of p
h1s = h0s ./ (2+2*ps); % Entropy per encoded bit
dh1s = -(log2(ps)-2.*log2(1-ps))./2./(1+ps).^2; %Derivative of h1s
p = (3-sqrt(5))/2; %Value of p that maximizes h1
% You can override p to try out different values
%p = 0.5;
figure(1);
plot(ps,h1s);
%hold on
%plot(ps,dh1s,'r');
%hold off
grid on
xlabel('Percentage of 1''s in data');
title('Entropy per encoded bit');
n = 10000;
x = zeros(1,4*n);
I = 0;
j = 1;
ip = -p*log2(p) - (1-p)*log2(1-p);
% Encoding in Sinclair format
for i=1:n
  a = rand<p;
  if a==0
    x(j) = 1;
    x(j+1) = -1;
    j = j+2;
  else
    x(j:j+1) = 1;
    x(j+2:j+3) = -1;
    j = j+4;
  end
  I = I + ip; %Count information
end
x = x(1:j-1); %Trim unused values of x
figure(2);
% Spectrum analysis
pwelch(x,hanning(1024),0.7,1024,2000,'db','none'); % For Octave, comment out for Matlab
%pwelch(x,hanning(1024),768,1024,2000); % For Matlab, comment out for Octave
title(sprintf('Spectrum of encoded signal, p=%.1f%%',p*100));
grid on
fprintf('Information efficiency: %.1f%%\n',100*I/length(x));
% Max entropy per payload bit for optimal p
Hopt = -1/2*((3-sqrt(5))*log2(3-sqrt(5))+(sqrt(5)-1)*log2(sqrt(5)-1)-2);
% Mean length per bit for optimal p
Lopt = 2*(1+(3-sqrt(5))/2);
fprintf('Max inf. efficiency: %.1f%%\n',100*Hopt/Lopt);
% Make a better sound
xx = repmat(x,4,1);
xx = reshape(xx,1,numel(xx));
sound(xx/4,16000);
