ifname = 'C:\SPECCY\us0373\8b10b_exampl\wav\complete_tapef.wav';
ofname = 'C:\SPECCY\us0373\8b10b_exampl\wav\complete_tapef.tzx';
inversion = false;
%------- END OF USER-EDITABLE BLOCK -----------

[x,fs] = wavread(ifname);
% If the file is stereo, use left channel only
if size(x,2)>1
    x = x(:,1);
end
% Apply thresholding
if inversion
    x = x<0;
else
    x = x>0;
end
% Find the first and the last edges and truncate the array by them
ife = find(x~=x(1),1,'first');
if isempty(ife)
    disp('The recording contains no edges!');
    return;
end
x = x(ife:end);
ile = find(x~=x(end),1,'last');
x = x(1:ile+1);
% extend size if it is not a multiple of 8
lbytes = ceil(length(x)/8);
x(end:lbytes*8) = x(end);
% Reshape it to resemble bytes
xp = reshape(x,8,lbytes);
y = zeros(1,lbytes);
% Convert to bytes
for i=1:8
    y = y + bitshift(double(xp(i,:)),8-i);
end

% Open the TZX file
ft = fopen(ofname,'wb');
fwrite(ft,['ZXTape!' 26 1 20]);
% Write a "Direct recording" data block
fwrite(ft,21);
lbytes_cast = typecast(uint32(lbytes),'uint8');
fwrite(ft,[79 0 1 0 8 lbytes_cast(1:3)]);
fwrite(ft,y);
fclose(ft);
