; -----------------------------------------------------------------------------
; ZX7 mini by Einar Saukas, Antonio Villena
; -----------------------------------------------------------------------------
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
; -----------------------------------------------------------------------------
; 8080 compact version by Ivan Gorodetsky, 2018
; BACK - 53 bytes
; FORWARD - 56 bytes

;#define BACK
		
dzx7mini:
		mvi b,80h
copyby:	mov a,m
		stax d
#ifdef BACK
		dcx d
mainlo:
		dcx h
#else
		inx d
mainlo:
		inx h
#endif
		call getbit
		jnc copyby
		mvi c,1
lenval:
		call getbit
		mov a,c
		ral
		mov c,a
		rc
		call getbit
		jnc lenval
		push h
#ifdef BACK
		mov l,m
		mvi h,0
		dad d
lddr:
		mov a,m
		stax d
		dcx h
		dcx d
		dcr c
		jnz lddr
#else
		mov a,e
		sbb m
		mov l,a
		mov a,d
		sbi 0
		mov h,a
ldir:
		mov a,m
		stax d
		inx h
		inx d
		dcr c
		jnz ldir
#endif
		pop h
		jmp mainlo
getbit:
		mov a,b
		add a
		mov b,a
		rnz
		mov a,m
#ifdef BACK
		dcx h
#else
		inx h
#endif
		adc a
		mov b,a
		ret

		.end