; -----------------------------------------------------------------------------
; ZX7 mini by Einar Saukas, Antonio Villena
; -----------------------------------------------------------------------------
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
; -----------------------------------------------------------------------------
; 8080 normal version by Ivan Gorodetsky, 2018
; BACK - 57 bytes
; FORWARD - 60 bytes

;#define BACK

dzx7mini:
		mvi a,80h
copyby:
		mov c,m
		xchg
		mov m,c
		xchg
#ifdef BACK
		dcx d
mainlo:
		dcx h
#else
		inx d
mainlo:
		inx h
#endif		
		add a
		cz getbitn
		jnc copyby
		mvi c,1
lenval:
		add a
		cz getbitn
		mov b,a
		mov a,c
		ral
		mov c,a
		rc
		mov a,b
		add a
		cz getbitn
		jnc lenval
		mov b,a
		push h
#ifdef BACK
		mov l,m
		mvi h,0
		dad d
lddr:
		mov a,m
		stax d
		dcx h
		dcx d
		dcr c
		jnz lddr
#else
		mov a,e
		sbb m
		mov l,a
		mov a,d
		sbi 0
		mov h,a
ldir:
		mov a,m
		stax d
		inx h
		inx d
		dcr c
		jnz ldir
#endif
		pop h
		mov a,b
		jmp mainlo
getbitn:
		mov a,m
#ifdef BACK
		dcx h
#else
		inx h
#endif
		adc a
		ret

		.end