; -----------------------------------------------------------------------------
; ZX7 decoder by Einar Saukas, Antonio Villena & Metalbrain
; -----------------------------------------------------------------------------
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
; -----------------------------------------------------------------------------
; 8080 version - Ivan Gorodetsky, 2018
; 104 bytes - single-use
; 109 bytes - reusable

		
dzx7_standard:
;        
;		mvi a,80h
;		sta dzx7s_next_bit+1
dzx7s_copy_byte_loop:
		mov a,m
		stax d
		inx h
		inx d
dzx7s_main_loop:
        call    dzx7s_next_bit
        jnc dzx7s_copy_byte_loop ; next bit indicates either literal or sequence

; determine number of bits used for length (Elias gamma coding)
        push d
        lxi b,0
		mov d,b
dzx7s_len_size_loop:
		inr d
        call dzx7s_next_bit
        jnc dzx7s_len_size_loop

; determine length
dzx7s_len_value_loop:
		cnc dzx7s_next_bit
		mov a,c\ ral\ mov c,a
		mov a,b\ ral\ mov b,a
		jc dzx7s_exit
		dcr d
		jnz dzx7s_len_value_loop
		inx b
; determine offset
		mov a,m\ stc\ ral\ mov e,a
		inx h
		jnc dzx7s_offset_end
		mvi d,10h
dzx7s_rld_next_bit:
        call    dzx7s_next_bit
		mov a,d\ ral\ mov d,a
		jnc dzx7s_rld_next_bit
		mvi a,1\ add d\ rar\ mov d,a
dzx7s_offset_end:
		mov a,e\ rar\ mov e,a
; copy previous sequence
		xthl
		xchg
		mov a,e\ sbb l\ mov l,a
		mov a,d\ sbb h\ mov h,a
		push psw
ldir:
		mov a,m
		stax d
		inx h
		inx d
		dcx b
		mov a,b
		ora c
		jnz ldir
		pop psw
dzx7s_exit:
		pop h
		jnc dzx7s_main_loop
dzx7s_next_bit:
		mvi a,80h
		add a
		sta dzx7s_next_bit+1
		rnz
		mov a,m
		inx h
		ral
		sta dzx7s_next_bit+1
        ret

		.end
