; -----------------------------------------------------------------------------
; ZX7 decoder by Einar Saukas, Antonio Villena & Metalbrain
; -----------------------------------------------------------------------------
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
; -----------------------------------------------------------------------------
; 8080 fastr version - Ivan Gorodetsky, 2018
; 172 bytes

dzx7:
		mvi a,80h
		mvi c,0
		jmp dzx7s_copy_byte_loop
load_bits1:
		mov a,m\ inx h\ ral
		jc det_len
dzx7s_copy_byte_loop:
		mov b,m\ xchg\ mov m,b\ xchg\ inx h\ inx d
dzx7s_main_loop:
		add a
		jz load_bits1
        jnc dzx7s_copy_byte_loop ; next bit indicates either literal or sequence

det_len:
; determine number of bits used for length (Elias gamma coding)
        push d
		lxi d,1
dzx7s_len_size_loop:
		inr c
		add a
		jz load_bits2
        jnc dzx7s_len_size_loop
len_size_loop_end:	
; determine length
		xchg
		dcr c
		jz dzx7s_len_value_loop_end
dzx7s_len_value_loop:
		add a\ jnz $+6\ ldax d\ inx d\ adc a
		jnc $+6
		dad h\ inr l
		.db 006h	;mvi b,
		dad h
		jc dzx7s_exit
		dcr c
		jnz dzx7s_len_value_loop
dzx7s_len_value_loop_end:
		mov b,a
		inx h
		shld SetBC+1
		xchg
; determine offset
		mov a,m\ ral
		inx h
		mov d,c
		jnc dzx7s_offset_end
		mov e,a
		mov a,b\ add a\ jnz $+6
		mov a,m\ inx h\ ral
		jnc $+4 \ inr d
		add a\ mov b,a\ jnz $+7
		mov a,m\ inx h\ ral\ mov b,a
		mov a,d\ ral\ mov d,a
		mov a,b\ add a\ mov b,a\ jnz $+7
		mov a,m\ inx h\ ral\ mov b,a
		mov a,d\ ral\ mov d,a
		mov a,b\ add a\ mov b,a\ jnz $+7
		mov a,m\ inx h\ ral\ mov b,a
		mov a,e
		cmc
		jc dzx7s_offset_end
;"CY=1"
		inr d
dzx7s_offset_end:		
;"CY=0"
		rar
		mov e,a
; copy previous sequence
		xthl
		xchg
		stc
		mov a,e\ sbb l\ mov l,a
		mov a,d\ sbb h\ mov h,a
		push b
SetBC:
		lxi b,0
ldir:
		mov a,m
		stax d
		inx h
		inx d
		dcx b
		mov a,b
		ora c
		jnz ldir
		pop psw
		pop h
		jmp dzx7s_main_loop

load_bits2:
		mov a,m\ inx h\ ral
		jc len_size_loop_end
		jmp dzx7s_len_size_loop

dzx7s_exit:
		pop h
		ret
		
		.end
