;Exomizer3 8080 decoder version by Ivan Gorodetsky (based on Exomizer2 Z80 decoder by Metalbrain)
;compression algorithm by Magnus Lind
;input: 	hl=compressed data start
;		de=uncompressed destination start
;
;		you may change exo_mapbasebits to point to any free buffer
;v1.0 - 29.10.2018
;compress with <raw -P1 -M255 -c> options
;242 bytes - single-use
;250 bytes - reusable

exo_mapbasebits		.equ	0	;     exo_mapbasebits    256

deexo:
; IY
;			push	h
;			lxi	h, exo_mapbasebits;
;			shld	IY+1
;			pop	h
;     ,   IY  
			mov	a, m
			inx	h
			sta	exo_getbit+1
			mvi	b, 034h
			push	d
exo_initbits:
			mvi a,-4
			add b
			ani	00Fh
			jnz	exo_node1
			lxi	d, 1
exo_node1:
			mvi	c, 010h
exo_get4bits:
			call	exo_getbit
			mov	a,c\ ral\ mov c,a
			jnc	exo_get4bits
			ora a
			push	h
			lhld	IY+1
			mov	m, c
			lxi h,1
			jz skip_exo_setbit
exo_setbit:
			dad	h
			dcr	c
			jnz	exo_setbit
skip_exo_setbit:
			dad	d
			push	h			
IY:			lxi	h,exo_mapbasebits
			inr	l
			shld	IY+1
			mvi a,33h
			add l
			mov l,a
			mov	m, e
			mvi a,34h
			add l
			mov l,a
			mov	m, d
			pop	d
			pop	h
			dcr	b
			jnz	exo_initbits
			pop	d
			lda exo_getbit+1
			jmp exo_mainloop

exo_literalcopy:
			mov c,m\ xchg\ mov m,c\ xchg
			inx h
			inx d
exo_mainloop:
			call	exo_getbit
			jc	exo_literalcopy
			mvi	c, 0FFh
exo_getindex:
			inr	c
			add a
			cz exo_getbit2
			jnc	exo_getindex
			sta	exo_getbit+1
			mvi a,10h
			cmp c
			rz
			push	d
			mvi	b,exo_mapbasebits>>8
			ldax	b
			mov	b,a
			call	exo_getbits
			mvi a,34h
			mvi b,exo_mapbasebits>>8
			add c
			mov c,a
			ldax b
			add	e
			sta exo_lenght+1
			mov e,a
			lxi	b, 00230h
			dcr e
			jz	exo_goforit
			lxi	b, 00420h
			dcr e
			jz	exo_goforit
			mvi	c, 010h
exo_goforit:
			call exo_getbits
			mov a,c
			add e
			mov e,a
			mvi d,exo_mapbasebits>>8
			ldax d
			mov b,a
			push d
			call exo_getbits
			xthl
			lxi b,34h
			dad b
			mov	a,m
			dad b
			add e
			mov e,a
			mov a,m
			adc d
			pop h
			mov d,a

			xthl
			xchg
			mov	a, e
			sub l
			mov	l, a
			mov	a, d
			sbb h
			mov	h, a
exo_lenght:
			mvi c,0
			mov	a,m
			stax d
			inx	h
			inx	d
			dcr c
			jnz	$-5
			pop	h
			jmp	exo_mainloop

exo_getbits:
			xchg
			lxi h,0
			lda	exo_getbit+1
exo_gettingbits:
			dcr	b
			jm exo_gettingbitsexit
			add a
			jnz $+6 \ ldax d\ inx d\ adc a
			jc $+7
			dad h
			jmp	exo_gettingbits
			dad h
			inr l
			jmp	exo_gettingbits
exo_gettingbitsexit:
			xchg
			sta exo_getbit+1
			ret
exo_getbit:
			mvi a,0
			add a
			sta	exo_getbit+1
			rnz
exo_getbit2:
			mov	a, m
			inx	h
			adc a
			sta	exo_getbit+1
			ret


			.end