;     
; <= 76
;  28.11.2018

		.org 100h

start:
		xra	a
		out	10h
		lxi	sp,100h
		mvi	a,0C3h
		sta	0
		lxi	h,Restart
		shld	1

		call	Cls
		mvi	a,0C9h
		sta	38h
		ei
		hlt
		lxi	h, colors+15
colorset:
		mvi	a, 88h
		out	0
		mvi	c, 15
colorset1:	mov	a, c
		out	2
		mov	a, m
		out	0Ch
		dcx	h
		out	0Ch
		out	0Ch
		dcr	c
		out	0Ch
		out	0Ch
		out	0Ch
		jp	colorset1
		mvi	a,255
		out	3


		jmp Restart
		
		.org 200h
PixelMask:
		.db 10000000b
		.db 01000000b
		.db 00100000b
		.db 00010000b
		.db 00001000b
		.db 00000100b
		.db 00000010b
		.db 00000001b


Restart:
		call	Cls

		lxi h,8080h	;H=xc, L=yc
		mvi a,76	;
loop:		
		push psw
		push h
		call circle
		pop h
		pop psw
		sui 3
		jp loop

		jmp $

circle:
		shld ycxc+1
		mov b,a
		mvi a,1
		sub b
		mov l,a		;L=1-R
		mvi c,0
circle_loop:
		mov a,c
		cmp b
		jnc circ_pixels		;,  X>=Y
		call circ_pixels
		xra a
		ora e
		jp DmoreZ
;D<0
		inr c
		mov a,c
		add a
		add e
		inr a
		mov l,a
		jmp circle_loop

DmoreZ:
		inr c
		dcr b
		mov a,c
		sub b
		add a
		add e
		inr a
		mov l,a
		jmp circle_loop

circ_pixels:
		push h
ycxc:		
		lxi d,0
;xc+x, yc+y
		mov l,b
		mov h,c
		dad d
		call setpixel_xy
;xc+x, yc-y
		mov a,e
		sub b
		mov l,a
		call SetPixelMaskAdr_xy

;xc+y, yc+x
		mov l,c
		mov h,b
		dad d
		call setpixel_xy
;xc+y, yc-x
		mov a,e
		sub c
		mov l,a
		call SetPixelMaskAdr_xy

;xc-y, yc+x
		mov a,d
		sub b
		mov h,a
		mov a,e
		add c
		mov l,a
		call setpixel_xy
;xc-y, yc-x
		mov a,e
		sub c
		mov l,a
		call SetPixelMaskAdr_xy

;xc-x, yc+y
		mov a,d
		sub c
		mov h,a
		mov a,e
		add b
		mov l,a
		call setpixel_xy
;xc-x, yc-y
		mov a,e
		sub b
		mov l,a
		pop d
		jmp SetPixelMaskAdr_xy
; ---
; :
; H - X
; L - Y
;   =  base + (x / 8) << 8 + y
;   = x % 8
setpixel_xy:
		mvi a, 111b 		;    
		ana h 			;   PixelMask
		sta SetPixelMaskAdr_xy+1
		xra h
		rrc 			; 
		rrc 			; 
		stc 			; 
		rar 			; 
		mov h,a 		; h = 0x8000 | (a >> 3)
SetPixelMaskAdr_xy:
		lda PixelMask
		ora m 			; a =   
		mov m,a 		;   
		ret


Cls:
		lxi	h,08000h
		mvi	e,0
		xra	a
ClrScr:
		mov	m,e
		inx	h
		cmp	h
		jnz	ClrScr
		ret

		.end

colors:
		.db 00000000b,00001001b,00010010b,00011011b,00100100b,00101101b,00110110b,00111111b
		.db 11111111b,00001001b,00010010b,00011011b,00100100b,00101101b,00110110b,00111111b

