;   
;  08.12.2018

		.org 100h

start:
		xra	a
		out	10h
		lxi	sp,8000h
		mvi	a,0C3h
		sta	0
		lxi	h,Restart
		shld	1

		call	Cls
		mvi	a,0C9h
		sta	38h
		ei
		hlt
		lxi	h, colors+15
colorset:
		mvi	a, 88h
		out	0
		mvi	c, 15
colorset1:	mov	a, c
		out	2
		mov	a, m
		out	0Ch
		dcx	h
		out	0Ch
		out	0Ch
		dcr	c
		out	0Ch
		out	0Ch
		out	0Ch
		jp	colorset1
		mvi	a,255
		out	3


		jmp Restart
		
		.org 200h
PixelMask:
		.db 10000000b
		.db 01000000b
		.db 00100000b
		.db 00010000b
		.db 00001000b
		.db 00000100b
		.db 00000010b
		.db 00000001b
PaintMask:
		.db 11111111b
		.db 11111111b
		.db 11111111b
		.db 11111111b
		.db 11111111b
		.db 11111111b
		.db 11111111b
		.db 11111111b

ScrAdr	.equ 80h

Restart:
		call	Cls
		lxi h,8080h	;H=xc, L=yc
		mvi a,127	;
		call circle
		lxi h,0A090h	;H=xc, L=yc
		mvi a,45	;
		call circle
		lxi h,6090h	;H=xc, L=yc
		mvi a,40	;
		call circle

		lxi h,6060h
		lxi d,Mask2
		call paint
		lxi h,0A090h
		lxi d,Mask3
		call paint
		lxi h,6090h
		lxi d,Mask4
		call paint
		lxi h,8090h
		lxi d,Mask1
		call paint
		jmp $

Mask1:
		.db 10101010b
		.db 01010101b
		.db 10101010b
		.db 01010101b
		.db 10101010b
		.db 01010101b
		.db 10101010b
		.db 01010101b
Mask2:
		.db 11111011b
		.db 11111011b
		.db 00000000b
		.db 11011111b
		.db 11011111b
		.db 11011111b
		.db 00000000b
		.db 11111011b
Mask3:
		.db 10000000b
		.db 01000000b
		.db 00100000b
		.db 00010000b
		.db 00001000b
		.db 00000100b
		.db 00000010b
		.db 00000001b
Mask4:
		.db 00000001b
		.db 00000010b
		.db 00000100b
		.db 00001000b
		.db 00010000b
		.db 00100000b
		.db 01000000b
		.db 10000000b

GetMaskLine:
		push h
		mvi a,111b
		ana l
		adi 8
		mov l,a
		mvi h,PixelMask>>8
		mov e,m
		pop h
		ret

; ---------------------------------------------------------------------------
PaintExit:
		pop h
		pop	h
		ret
; ---------------------------------------------------------------------------

paint:
		push h
		lxi h,PaintMask
		mvi c,8
MovMask:
		ldax d
		inx d
		mov m,a
		inx h
		dcr c
		jnz MovMask
		pop h
		lxi	b, PaintExit	; 	  PAINT
		push h
		push h
		push b
		mov c,h
		mvi a, 111b
		ana h
		sta SetPixelMaskPaint+1
		xra h
		rrc
		rrc
		rrc
		ori ScrAdr
		mov h,a
SetPixelMaskPaint:
		lda PixelMask
		mov b,a
		push h
		push b
FillLine:
		pop b
		pop	h
		call GetMaskLine
		mov a,m
		ana b
		rnz				;   ,  
		mov a,b
		ana e
		ora m
		mov m,a
		push h

		xra a
		cmp c
		jz FillLineLeftExit2
		push b
		dcr	c
		mov a,b
		rlc
		mov b,a
		jnc FillLineLeft
		dcr h
FillLineLeft:
		ana m
		jnz FillLineLeftExit
		mov a,b
		ana e
		ora m
		mov m,a
		dcr c
		mov a,b
		rlc
		mov b,a
		jnc FillLineLeft
FillLineLeftFast:
		dcr h
		mvi a,ScrAdr-1
		cmp h
		jz FillLineLeftExit
		xra a
		ora m
		mov a,b
		jnz FillLineLeft
		mov m,e
		mvi a,-8
		add c
		mov c,a
		jmp	FillLineLeftFast
FillLineLeftExit:
		inr c
		mov a,c
		pop b
FillLineLeftExit2:
		mov d,a				; X  

		pop h
		mov a,b
		rrc
		mov b,a
		jnc $+4
		inr h
		inr c
		jz FillLineRightExit
FillLineRight:
		ana m
		jnz FillLineRightExit
		mov a,b
		ana e
		ora m
		mov m,a
		inr c
		mov a,b
		rrc
		mov b,a
		jnc FillLineRight
FillLineRightFast:
		inr h
		mvi a,ScrAdr+32
		cmp h
		jz FillLineRightExit
		xra a
		ora m
		mov a,b
		jnz FillLineRight
		mov m,e
		mvi a,8
		add c
		mov c,a
		jmp	FillLineRightFast
FillLineRightExit:
		dcr c

;  
		mov a,b
		rlc
		mov b,a
		jnc $+4
		dcr h
		shld RightBorderAdr+1	;  
		push h
		mov l,c
		mov h,b
		shld RightBorderXandMask+1
		pop h
		inr	l		; Y=Y+1
		call GetMaskLine
		xra a
		ora e
		jnz ChkUpperLineLoop
		mvi e,255
;"" 
ChkUpperLineLoop:
		mov a,m
		cmp e
		jz	ChkLeftBord1	;  ,  
		ana b
		jnz	ChkLeftBord1	;   ,  
		mov a,e
		ana b
		jz	ChkLeftBord1
		push h
		push b
		shld $+8
		lxi h,FillLine
		push h
		lxi h,0
		jmp ChkLeftBord1_1
ChkLeftBord1:
		mov a,c
		cmp d		;     (	 ) ?
		jz	ChkBottomLine
		dcr	c		;  ,  X=X-1
		mov a,b
		rlc
		mov b,a
		jnc ChkUpperLineLoop
ChkLeftBord1fast:
		dcr h
		mvi a,ScrAdr-1
		cmp h
		jz ChkBottomLine
		mov a,m
		cmp e
		jz ChkLeftBordSolid1
		inr a
		jz ChkLeftBordSolid1
		jmp ChkUpperLineLoop
ChkLeftBordSolid1:
		mvi a,-8
		add c
		cmp d
		jc ChkUpperLineLoop
		jz ChkBottomLine
		mov c,a
		jmp ChkLeftBord1fast


;" "
ChkUpperLineLoop2:
		mov a,m
		ana b
		jnz	ChkLeftBord1	;   ,     
ChkLeftBord1_1:
		mov a,c
		cmp d		;     (	 ) ?
		jz	ChkBottomLine
		dcr	c		;  ,  X=X-1
		mov a,b
		rlc
		mov b,a
		jnc ChkUpperLineLoop2
ChkLeftBord1_1fast:		
		dcr h
		mvi a,ScrAdr-1
		cmp h
		jz ChkBottomLine
		xra a
		cmp m
		jnz ChkUpperLineLoop2
ChkLeftBordFree1:
		mvi a,-8
		add c
		cmp d
		jc ChkUpperLineLoop2
		jz ChkBottomLine
		mov c,a
		jmp ChkLeftBord1_1fast
		
; ---------------------------------------------------------------------------

;  
ChkBottomLine:
RightBorderAdr:
		lxi h,0
RightBorderXandMask:
		lxi b,0
		dcr	l		; Y=Y-1
		call GetMaskLine
		xra a
		ora e
		jnz ChkBottomLineLoop
		mvi e,255
;"" 
ChkBottomLineLoop:
		mov a,m
		cmp e
		jz	ChkLeftBord2	;   ,  
		ana b
		jnz	ChkLeftBord2	;   ,  
		mov a,e
		ana b
		jz	ChkLeftBord2	;   ,  
		push h
		push b
		shld $+8
		lxi h,FillLine
		push h
		lxi h,0
		jmp ChkLeftBord2_2
ChkLeftBord2:
		mov a,c
		cmp d		;     (	 ) ?
		rz
		dcr	c
		mov a,b
		rlc
		mov b,a
		jnc ChkBottomLineLoop
ChkLeftBord2fast:
		dcr h
		mvi a,ScrAdr-1
		cmp h
		rz
		mov a,m
		cmp e
		jz ChkLeftBordSolid2
		inr a
		jz ChkLeftBordSolid2
		jmp ChkBottomLineLoop
ChkLeftBordSolid2:
		mvi a,-8
		add c
		cmp d
		jc ChkBottomLineLoop
		rz
		mov c,a
		jmp ChkLeftBord2fast

;"" 
ChkBottomLineLoop2:
		mov a,m
		ana b
		jnz	ChkLeftBord2	;   ,     
ChkLeftBord2_2:
		mov a,c
		cmp d		;     (	 ) ?
		rz
		dcr	c
		mov a,b
		rlc
		mov b,a
		jnc ChkBottomLineLoop2
ChkLeftBord2_2fast:
		dcr h
		mvi a,ScrAdr-1
		cmp h
		rz
		xra a
		cmp m
		jnz ChkBottomLineLoop2
ChkLeftBordFree2:
		mvi a,-8
		add c
		cmp d
		jc ChkBottomLineLoop2
		rz
		mov c,a
		jmp ChkLeftBord2_2fast
; ---------------------------------------------------------------------------


circle:
		shld ycxc+1
		mov b,a
		mov l,a
		mvi h,0
		dad h	;2*R
		mov a,l
		cma
		mov l,a
		mov a,h
		cma
		mov h,a
		inx h	;HL=-2*R
		lxi d,3
		dad d	;HL=3-2*R
		mvi c,0FFh
circle_loop:
		inr c
		mov a,b
		cmp c
		rc
		push h
ycxc:		
		lxi d,0
;xc+x, yc+y
		mov l,b
		mov h,c
		dad d
		call setpixel_xy
;xc+x, yc-y
		mov a,e
		sub b
		mov l,a
		call SetPixelMaskAdr_xy

;xc-x, yc-y
		mov a,d
		sub c
		mov h,a
		call setpixel_xy
;xc-x, yc+y
		mov a,e
		add b
		mov l,a
		call SetPixelMaskAdr_xy

;xc+y, yc+x
		mov l,c
		mov h,b
		dad d
		call setpixel_xy
;xc+y, yc-x
		mov a,e
		sub c
		mov l,a
		call SetPixelMaskAdr_xy

;xc-y, yc-x
		mov a,d
		sub b
		mov h,a
		call setpixel_xy
;xc-y, yc+x
		mov a,e
		add c
		mov l,a
		call SetPixelMaskAdr_xy
		pop d

		xra a
		ora d
		jp DmoreZ
;D<0
		mov l,c
		mvi h,0
		dad h
		dad h
		dad d
		lxi d,6
		dad d
		jmp circle_loop

DmoreZ:
		mov a,c
		sub b
		mov l,a
		mvi h,0FFh
		dad h
		dad h
		dad d
		lxi d,10
		dad d
		dcr b
		jmp circle_loop

; ---
; :
; H - X
; L - Y
;   =  base + (x / 8) << 8 + y
;   = x % 8
setpixel_xy:
		mvi a, 111b 		;    
		ana h 			;   PixelMask
		sta SetPixelMaskAdr_xy+1
		xra h
		rrc
		rrc
		rrc
		ori ScrAdr
		mov h,a
SetPixelMaskAdr_xy:
		lda PixelMask
		ora m 			; a =   
		mov m,a 		;   
		ret


Cls:
		lxi	h,08000h
		mvi	e,0
		xra	a
ClrScr:
		mov	m,e
		inx	h
		cmp	h
		jnz	ClrScr
		ret

		.end

colors:
		.db 00000000b,00001001b,00010010b,00011011b,00100100b,00101101b,00110110b,00111111b
		.db 11111111b,00001001b,00010010b,00011011b,00100100b,00101101b,00110110b,00111111b

