#pragma option -a-

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dos.h>


#define CPM_TYPE            0x02        // ⨯ ࠧ CP/M

#define MAX_WAIT_TIME   18*1        // . ६  ⢥  HDD

#define DI              asm cli;
#define EI              asm sti;

// 䮫 祭 ࠬ஢ ᪮
#define DEFAULT_ALV         256         // 256  = 1024 
#define DEFAULT_DIRBLOCKS   2
#define DEFAULT_RESTRACKS   2


typedef unsigned char   BOOL;
typedef unsigned char   UINT8;
typedef unsigned int    UINT16;
typedef unsigned long   UINT32;

typedef signed char     INT8;
typedef signed int      INT16;
typedef signed long     INT32;



typedef struct {
    UINT8   Active;     // 0x80 - active partion
    UINT8   Side;       // head
    UINT16  Addr;       // cylinder/sector
    UINT8   Type;       // type partion
    UINT8   SideEnd;
    UINT16  AddrEnd;
    UINT32  RelAddr;    // ⭮⥫  
    UINT32  Size;       // ࠧ ࠧ  ᥪ
} PARTION;

typedef struct {
    char    Active;     // ਧ ⢨⥫쭮 
    char    LBA;            // ਧ প LBA 樨
    char    Name[18];
    char    NumChan;
    char    NumDev;
    UINT16  Head;
    UINT16  Cyl;
    UINT16  Sec;
    UINT32  Size;       // in sectors
} DEVICE;

typedef struct {
    UINT16  SPT;        // sectors per track
    UINT8   BSH;        // block shift
    UINT8   BLM;        // block mask
    UINT8   EXM;        // extent mask
    UINT16  DSM;        // disk maximum
    UINT16  DRM;        // directory maximum
    UINT8   AL0;        // allocation vector
    UINT8   AL1;
    UINT16  CKS;        // checksum vector size
    UINT16  OFF;        // track offset
    UINT8   res;
} DPB;

typedef struct {
    char    Sign[8];    // ᨣ "CP/M"
    DPB     dpb;
    UINT8   res[486];   // १
    UINT16  parSign;    // 0xAA55;
} SYSSEC;

typedef struct {
    char    user;
    char    name[8];
    char    ext[3];
    char    ex;
    UINT16  res;
    char    rc;
    UINT16  map[8];
} DIRREC;


typedef struct {
    UINT32  ALV;        // ࠧ ⠡ ஢  
    UINT32  DirBlocks;  // ⢮ ஢  ४
    UINT32  ResTracks;  // १ࢨ㥬 ஦ ( ⥬   㤠)
    BOOL    isFilled;   // 㫥 ᥪ஢
} FILESYS;



#define DIRINSEC        (512 / sizeof(DIRREC))




/*
==============================================================================

                                 DISK IO

==============================================================================
*/

static UINT16 BaseAddr[2] = {0x1F0, 0x170};


char wait_nBSY(UINT16 base)
{
    UINT32      time;
    UINT32 far *timeptr;
    UINT8       b;

    timeptr = (UINT32 far*) MK_FP(0, 0x46C);
    time =  *timeptr + MAX_WAIT_TIME;
    while (time >= *timeptr) {
                b = inportb(base+7);
        if ((b & 0x80) == 0)
            return -1;
        }
    return 0;
}

char wait_DRDY(UINT16 base)
{
        UINT32      time;
    UINT32 far *timeptr;
    UINT8       b;

    timeptr = (UINT32 far *) MK_FP(0, 0x46C);
        time =  *timeptr + MAX_WAIT_TIME;
        while (time >= *timeptr) {
                b = inportb(base+7);
                if ((b & 0xC0) == 0x40)
                        return -1;
        }
        return 0;
}

char wait_DRQ(UINT16 base)
{
        UINT32      time;
        UINT32 far *timeptr;
        UINT8       b;

        timeptr = (UINT32 far *) MK_FP(0, 0x46C);
        time =  *timeptr + MAX_WAIT_TIME;
        while (time >= *timeptr) {
                b = inportb(base+7);
                if ((b & 0x88) == 0x08)
                        return -1;
        }
        return 0;
}


//  LBA-  ଠ CHS, 㯠  32- ⭮ ᫮
UINT32 ide_LBA2CHS(DEVICE* p, UINT32 AbsSec)
{
        UINT32  SecPerTrk, NumOfHeads, Temp;
        UINT32  Sec, Head, Cyl;

        SecPerTrk  = p->Sec;
        NumOfHeads = p->Head;

        Temp = AbsSec / SecPerTrk;
        Sec  = (AbsSec % SecPerTrk) + 1;
        Head = Temp % NumOfHeads;
        Cyl  = Temp / NumOfHeads;

        // 㥬
        Sec = Sec & 0xFF;
        Cyl = (Cyl & 0xFFFF) << 8;
        Head = (Head & 0x0F) << 24;
        return (Sec | Cyl | Head);
}

//  CHS-  LBA
UINT32 ide_CHS2LBA(DEVICE* p, UINT32 Cyl, UINT32 Head, UINT32 Sec)
{
        UINT32 maxhead, maxsec;

        maxhead = p->Head;
        maxsec = p-> Sec;

        return (Cyl * maxhead + Head) * maxsec + Sec - 1;
}


char ide_SendCmd(UINT8 Chan, UINT8 Device, UINT32 Sector, UINT8 Cmd, UINT8 LBA)
{
        UINT16 base;

        base = BaseAddr[Chan];
        //  ⮢ ன⢠
        if (!wait_nBSY(base))
                return 0;
        // 롨ࠥ ன⢮
        outportb(base+6, (Device << 4) | 0xA0);
        if (!wait_DRDY(base))
                return 0;
        // 㦠 ࠬ   ॣ
        DI;
        outportb(base+1, 0);            // feature register must be 0
        outportb(base+2, 1);            // sector count
        outportb(base+3, Sector & 0xFF);
        outportb(base+4, (Sector >> 8) & 0xFF);
        outportb(base+5, (Sector >> 16) & 0xFF);
        if (LBA)
        {
                outportb(base+6, ((Sector >> 24) & 0x0F) | (Device << 4) | 0xE0);
        } else {
                outportb(base+6, ((Sector >> 24) & 0x0F) | (Device << 4) | 0xA0);
        }
        outportb(base+7, Cmd);
        EI;
        return -1;
}

char ide_ReadSector(DEVICE *p, UINT32 Sector, void far *buff)
{
        int         i;
        UINT16      base = BaseAddr[p->NumChan];
        UINT16 far *b;
        UINT32      sec;

        if (p->LBA)
        {
                sec = Sector;
        } else {
                sec = ide_LBA2CHS(p, Sector);
        }

        if (!ide_SendCmd(p->NumChan, p->NumDev, sec, 0x20, p->LBA))
                return 0;
        if (!wait_DRQ(base))
                return 0;
        b = (UINT16 far *) buff;
        DI;
        for (i=0; i<256; i++)
        {
                *b = inpw(base);
                b++;
        }
        EI;
        wait_nBSY(base);
        return -1;
}

char ide_WriteSector(DEVICE *p, UINT32 Sector, void far *buff)
{
        int         i;
        UINT16      base = BaseAddr[p->NumChan];
        UINT16 far *b;
        UINT32      sec;

        if (p->LBA)
        {
                sec = Sector;
        } else {
                sec = ide_LBA2CHS(p, Sector);
        }

        if (!ide_SendCmd(p->NumChan, p->NumDev, sec, 0x30, p->LBA))
                return 0;
        if (!wait_DRQ(base))
                return 0;
        b = (UINT16 far *) buff;
        DI;
        for (i=0; i<256; i++)
        {
                outpw(base, *b);
                b++;
        }
        EI;
        wait_nBSY(base);
        return -1;
}



char ide_Identify(UINT8 Chan, UINT8 Device, void far *buff)
{
        int         i;
        UINT16      base =  BaseAddr[Chan];
        UINT16 far *b;

        if (!ide_SendCmd(Chan, Device, 0, 0xEC, 0))
                return 0;
        if (!wait_DRQ(base))
                return 0;
        if (inp(base+7) & 0x01 != 0)
                return 0;
        b = (UINT16 far *) buff;
        DI;
        for (i=0; i<256; i++)
        {
                *b = inpw(base);
                b++;
        }
        EI;
        wait_nBSY(base);
        return -1;
}


/*
==============================================================================

                                                                  FORMAT

==============================================================================
*/

char hdd_CheckSign(char buff[])
{
        if ((buff[0x1FE] != 0x55) || ((unsigned char)buff[0x1FF] != 0xAA))
        return 0;
    else
        return -1;
}

//
//   室騩 ࠧ BLS  ⥪饩 
//  size - ।⥫ ࠧ 
//
UINT16 calck_BlockSize(UINT32 DiskSize, UINT32 alv)
{
    UINT32 BLS, tmp;

    tmp = DiskSize / ((alv - 1) * 8);       // ਬ ࠧ 
    BLS = 2048;                             //   
    while (BLS < tmp)
        BLS <<= 1;
    return BLS;
}


//
// DiskSize     - ࠧ ᪠  
// BlockSize    - ࠧ 
// ResTracks    - १. ஦
// SecPerTrack  - ᪨ ᥪ஢  ஦ ( 128 )
// DirBlock     - ࠧ ४ਨ  
//
void make_DPB(DPB *dpb, UINT32 DiskSize, UINT32 BlockSize, UINT32 ResTracks, UINT32 SecPerTrack, int DirBlock)
{
    UINT32  Tracks;
    UINT32  SecInBlock;
    int     w;

    Tracks = DiskSize / (SecPerTrack * 128);
    SecInBlock = BlockSize / 128;
    dpb->SPT = SecPerTrack;
    dpb->OFF = ResTracks;
    dpb->CKS = 0;

    dpb->BLM = SecInBlock - 1;
    dpb->BSH = 3;
    dpb->EXM = 0;
    w = BlockSize/1024;
    while (w > 1)
    {
        dpb->BSH++;
        dpb->EXM = (dpb->EXM << 1) | 0x01;
        w >>= 1;
    }
    dpb->DSM = ((Tracks-ResTracks) * SecPerTrack) / SecInBlock;
    if (dpb->DSM > 256)
        dpb->EXM >>= 1;
    dpb->DSM--;
    w = 0x0000;
    dpb->DRM = DirBlock * (BlockSize / 32) - 1;
    do
    {
        w = (w >> 1) | 0x8000;
        DirBlock--;
    }
    while (DirBlock > 0);
    dpb->AL0 = (w >> 8) & 0xFF;
    dpb->AL1 = w & 0xFF;
}


char hdd_doFormatCPM(DEVICE *p, UINT32 AbsAddr, UINT32 TotalSec, FILESYS *fsys)
{
    UINT32  DiskSize;
    SYSSEC  sec;
    UINT32  i, n;
    UINT32  DSM, BLS;
    char    buf[512];

    memset(&sec, 0, sizeof(SYSSEC));

    // ।⥫ ᫥
    DiskSize = TotalSec * 512;
    BLS = calck_BlockSize(DiskSize, fsys->ALV);
    make_DPB(&sec.dpb, DiskSize, BLS, fsys->ResTracks, 128, fsys->DirBlocks);
    DSM =(sec.dpb.DSM+1);
    DiskSize = (DSM * BLS) / 1024;
    printf("        First sector   : 0x%08lX\n", AbsAddr);
    printf("        Reserv sectors : %luKb\n", (fsys->ResTracks * (128*128)) / 1024);
    printf("        Size           : %luKb\n", DiskSize);
    printf("        Cluster size   : %lu\n", BLS);
    printf("        Block shift    : 0x%02hX\n", sec.dpb.BSH);
    printf("        Block mask     : 0x%02hX\n", sec.dpb.BLM);
    printf("        Extent mask    : 0x%02hX\n", sec.dpb.EXM);
    printf("        Num clusters   : %u\n", sec.dpb.DSM+1);
    printf("        Num dir entries: %u\n", sec.dpb.DRM+1);
    printf("        AL0            : 0x%02hX\n", sec.dpb.AL0);
    printf("        AL1            : 0x%02hX\n", sec.dpb.AL1);

    // 塞 ᥪ
    memcpy(sec.Sign, "CP/M    ", 8);
    sec.parSign = 0xAA55;

    if (!ide_WriteSector(p, AbsAddr, &sec))
    {
        printf("      *error* - can't write DPB at 0x%08lX!\n", AbsAddr);
        return 0;
    }
    // 樨㥬 १ࢭ 
    if (fsys->ResTracks)
    {
        memset((char*) &buf, 0x00, sizeof(buf));
        n = fsys->ResTracks * (128*128) / 512;
        for (i = 0; i < n; i++)
        {
            AbsAddr++;
            ide_WriteSector(p, AbsAddr, &buf);
        }
    }
    // 頥    
    if (fsys->isFilled)
        n = (sec.dpb.DSM+1)*(BLS/512)-1;
    else
        n = (sec.dpb.DRM+1) / DIRINSEC;

    memset((char*) &sec, 0xE5, sizeof(SYSSEC));
    AbsAddr++;
    printf("        Format        .. ");
    for (i = 0; i < n; i++)
    {
        ide_WriteSector(p, AbsAddr, &sec);
        AbsAddr++;
    }
    printf("ok\n");
    return -1;
}



//
// ᪠஢ SMBR  । ᪨ ᪮ CP/M
//  relAdd - ⭮⥫   砫 ࠧ SMBR
//
void hdd_ParseSMBR(DEVICE *p, UINT32 relAddr, char *lastDev, FILESYS *fsys)
{
    PARTION    *par;
    PARTION    *nxt;
    UINT8       buff[512];
    UINT32      base = relAddr;     // ᮫  砫 SMBR
    char        c;

    do
    {
        // 㦠 SMBR
                if (!ide_ReadSector(p, relAddr, &buff))
        {
            printf("    *error* - can't read SMBR at 0x%08lX!\n", relAddr);
            return;
        }
                if (!hdd_CheckSign(buff))
        {
            printf("    *error* - SMBR at 0x%08lX is corrupt!\n", relAddr);
            return;
        }
        par = (PARTION *) &buff[0x1BE];
        nxt = (PARTION *) &buff[0x1CE];
        switch (par->Type)
        {
            case 0x01:
            case 0x04:
            case 0x06:
            case 0x0B:
            case 0x0E: {        // DOS logic disk
                (*lastDev)++;
                                printf("    -found DOS disk [%c]    size: %9luKb\tFormat drive (Yes/No)? ", (*lastDev)+'A', par->Size / 2);
                fflush(stdout);
                c = getch();
                if ((c == 'y') || (c == 'Y'))
                {
                    printf("\r                                                                               \r");
                    printf("    -created CP/M disk [%c]\n", (*lastDev)+'A');
                    if (hdd_doFormatCPM(p, par->RelAddr+relAddr, par->Size, fsys))
                    {
                        par->Type = CPM_TYPE;
                        ide_WriteSector(p, relAddr, &buff);
                    }
                                } else {
                    printf("\r                                                                               \r");
                    printf("    -skip DOS disk [%c]   size: %9luKb\n", (*lastDev)+'A', par->Size / 2);
                                }
                break;
            }
            case CPM_TYPE: {
                (*lastDev)++;
                printf("    -found CP/M disk [%c]   size: %9luKb\tUnformat drive (Yes/No)? ", (*lastDev)+'A', par->Size / 2);
                fflush(stdout);
                c = getch();
                if ((c == 'y') || (c == 'Y'))
                {
                    par->Type = 1;
                    if ((par->Size / 2) > 15*1024)
                        par->Type += 3;
                    if ((par->Size / 2) > 32*1024)
                        par->Type += 2;
                                        ide_WriteSector(p, relAddr, &buff);
                                        printf("\r                                                                               \r");
                                        printf("    -unformat disk [%c] to DOS disk\n", (*lastDev)+'A');
                                } else {
                                        printf("\r                                                                               \r");
                                        printf("    -skip CP/M disk [%c]   size: %9luKb\n", (*lastDev)+'A', par->Size / 2);
                                }
                                break;
                        }
                } // switch
                relAddr = nxt->RelAddr+base;
        } while (nxt->Type != 0);
}



//
//  ᪨ CP/M   ७ ࠧ dos
//
void hdd_ParseMBR(DEVICE *p, FILESYS *fsys)
{
        PARTION    *par;
        UINT8       buff[512];
        int         i;
        char        lastDev;

        // 㦠 MBR
        if (!ide_ReadSector(p, 0, &buff))
        {
                printf("  *error* - can't read MBR!\n");
                return;
        }
        if (!hdd_CheckSign(buff))
        {
                printf("  *error* - MBR is corrupt!\n");
                return;
    }

        // ᪠㥬 樨  MBR
    par = (PARTION*) &buff[0x1BE];
        lastDev = -1;
    for(i = 0; i < 4; i++)
        {
        if (par->Active)
        {
            printf("    -skip primary DOS partion.\n");
        } else {
            if ((par->Type == 0x05) || (par->Type == 0x0C) || (par->Type == 0xF))
                hdd_ParseSMBR(p, par->RelAddr, &lastDev, fsys);
        }
        par++;
    }
}



/*
==============================================================================

                                   MENU

==============================================================================
*/

char* szDrives[4] = {"Prim. master: ","Prim. slave : ","Sec.  master: ","Sec.  slave : "};



//   䨪  㯭 ⮢
int hdd_Find(DEVICE *dev)
{
    int     i, j, k;
    DEVICE* p;
    UINT16  buff[256];
    char*   b;
    int     numDev;
    UINT32  sec,cyl,head;
    numDev = 0;
        p = dev;
    for (i=0; i<2; i++)
        for (j=0; j<2; j++)
        {
            p->Active = 0;
            if (ide_Identify(i, j, &buff))
            {
                                p->Active = 0xFF;
                                p->NumChan = i;
                                p->NumDev = j;
                                p->Cyl = buff[1];
                                p->Head = buff[3];
                                p->Sec = buff[6];
                                cyl = buff[1];
                                head = buff[3];
                                sec = buff[6];
                                if ((buff[60] | buff[61]) != 0)
                                {
                                        // ன⢮ ন LBA-
                                        p->LBA = 0xFF;
                                        cyl = buff[60];
                                        sec = buff[61];
                                        p->Size = (sec << 16) | cyl;

                                } else {
                                        p->LBA = 0;
                                        p->Size = cyl*sec*head;
                                }
                                // ७ᨬ  ன⢠
                                b = (char*) &buff[27];
                                for (k=0; k<8; k++)
                                {
                                        p->Name[k*2+1]  = *b++;
                                        p->Name[k*2]    = *b++;
                                }
                                p->Name[k*2] = 0x00;            // !!!   ন !!!
                                numDev++;
                        }
                        p++;
                }
        return numDev;
}


char mnu_Select(DEVICE *dev)
{
        DEVICE* p;
        int i;

        printf(">Select drive:\n");
        p = dev;
        for (i=0; i<4; i++)
        {
                printf("[%i] %s", i, szDrives[i]);
                if (p->Active)
                {
                        if (p->LBA)
                        {
                                printf("%s  Size: %8luKb\tLBA sectors:%u\n",&p->Name, p->Size / 2, p->Size);
                        } else {
                                printf("%s  Size: %8luKb\tCHS: %u/%u/%u\n",&p->Name, p->Size / 2,p->Cyl,p->Head,p->Sec);
                        }
                } else {
            printf("none\n");
        }
        p++;
    }
    printf("[4] or [ESC] to exit\n");
    return getch();
}

void do_Usage(void)
{
    printf("Usage: F8000d.EXE [-options | /options]\n");
    printf("  options:\n");
    printf("    h|?    - this help\n");
    printf("    a<xxx> - size ALV with 'xxx', [128..512] (default 256)\n");
    printf("    d<x>   - size directory in clusters [2..16] (default 2)\n");
    printf("    t<x>   - reserved tracks [0..9] (default 2)\n");
    printf("    u      - clear all disk space (default clear only directory)\n");
}

char do_argv(int argc, char *argv[], FILESYS *fsys)
{
    int     i;
    long    n;

    fsys->ALV = DEFAULT_ALV;
    fsys->DirBlocks = DEFAULT_DIRBLOCKS;
    fsys->ResTracks = DEFAULT_RESTRACKS;
    fsys->isFilled = 0;
    i = 1;
    while (i < argc)
    {
        if ((argv[i][0] == '-') || (argv[i][0] == '/'))
        {
            switch (argv[i][1])
            {
                case 'H':
                case 'h':
                case '?': {
                    do_Usage();
                    return 0;
                }
                case 'A':
                case 'a': {     // ALV size
                    n = atol(&argv[i][2]);
                    if ((n >= 128) && (n <= 512))
                        fsys->ALV = n;
                    else
                        printf("  *error* - parameter '-a' is bad! Use default.\n");
                    break;
                }
                case 'D':
                case 'd': {
                                        n = atol(&argv[i][2]);
                    if ((n >= 2) && (n <= 16))
                        fsys->DirBlocks = n;
                    else
                        printf("  *error* - parametr '-d' is bad! Use default.\n");
                    break;
                }
                case 'T':
                case 't': {
                    n = atol(&argv[i][2]);
                    if ((n >= 0) && (n <= 9))
                        fsys->ResTracks = n;
                    else
                        printf("  *error* - parametr '-t' is bad! Use default.\n");
                    break;
                }
                case 'U':
                case 'u': {
                    fsys->isFilled = -1;
                    break;
                }
            } // switch

        }   // if
        i++;
    }
    return -1;
}


void do_Format(int argc, char *argv[])
{
    DEVICE  dev[4];          //   ன⢠   
    FILESYS fsys;
    unsigned char   b;
    DEVICE         *p;

    while (kbhit()) getch();
    if (!do_argv(argc, argv, &fsys))
        return;

    if (hdd_Find(dev) == 0)
    {
        printf("*error* - hard disk's not found!\n");
        return;
        }

    switch ((b = mnu_Select(dev)))
    {
        case '0':
        case '1':
        case '2':
        case '3':
        {
            p = &dev[b-'0'];
            if (!p->Active)
            {
                printf("*error* - select unused drive!\n");
                return;
            }
            break;
        }
        case '4':
        case  27:
        {
            printf("Good ");
            return;
        }
        default:
        {
            printf("*error* - select must be range in [0..3]!\n");
            return;
        }
    } // switch

    // 稭 ᪠஢  ଠ
    hdd_ParseMBR(p, &fsys);

    while (kbhit()) getch();
}


int main(int argc, char *argv[])
{
    printf("Format for PK8000.  ver 2.3\n");
    do_Format(argc, argv);
    printf("Bye!\n");
    return 0;
}

