#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>

#include <conio.h>

// ⨯ 
#define CAS_BINARY      0       // ୨
#define CAS_BINPROT     1       // ୨  ⮩  AMATASOFT
#define CAS_BASIC       2
#define CAS_TEXT        3

#define MAX_BSIZE  0x7F00   // . ࠧ  ᨪ ணࠬ 0xBF00-0x4000

// ᬥ饭 ⭮⥫쭮  娤஢
#define CSTART    -6        // 砫 
#define CSIZE     -2        // ࠧ 
#define CENTRY    -4        // 窠 室

//  訡
#define ERR_BAD_FORMAT      1
#define ERR_PROTECTED       2
#define ERR_UNEXPECTED_EOF  3
#define ERR_CORRUPT_DATA    4
#define ERR_UNKNOWN_FRM     5
#define ERR_CREATE_FILE     6
#define ERR_WRITE_FILE      7
#define ERR_NOT_MEM         8
#define ERR_TOO_LARGE       9
#define ERR_LAST            10


typedef struct
{
    unsigned char  type;                // ⨯ 䠩: CAS_BINARY|CAS_BASIC|CAS_TEXT
    unsigned char  name[16];            //  䠩  
    unsigned char  fname[16];           //     
    unsigned long  size;                // ࠧ 䠩
    unsigned int   start;               // 砫  㧪
    unsigned int   stop;                //   㧪
    unsigned int   entry;               //  窨 室
    char          *data;
} CAS;

char *ext[] = {".COM", ".COM", ".COM", ".BAS"};
char *err[] = {"bad file format",
               "file is protect",
               "unexpected end of file",
               "corrupt data",
               "unknown data format",
               "can`t create file",
               "can`t write data",
               "not enought memory",
               "file too large"};


char HEADER[8] = { 0x1F,0xA6,0xDE,0xBA,0xCC,0x13,0x7D,0x74 };
char BIN[10]   = { 0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0 };
char ASCII[10] = { 0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,0xEA };
char BASIC[10] = { 0xD3,0xD3,0xD3,0xD3,0xD3,0xD3,0xD3,0xD3,0xD3,0xD3 };

char CLOAD[256] = {0xF3, 0xAF, 0xD3, 0x84, 0xD3, 0x86, 0x3D, 0xD3, 0x80, 0x31,
                   0x00, 0xF2, 0x21, 0x50, 0x01, 0x11, 0x00, 0xF0, 0x01, 0xB0,
                   0x00, 0xCD, 0x29, 0x01, 0x11, 0x00, 0x40, 0x2A, 0xFE, 0x01,
                   0x44, 0x4D, 0x21, 0x00, 0x02, 0xCD, 0x29, 0x01, 0xC3, 0x00,
                   0xF0, 0x09, 0xEB, 0x09, 0xEB, 0x2B, 0x1B, 0x7E, 0x12, 0x2B,
                   0x1B, 0x0B, 0x78, 0xB1, 0xC2, 0x2F, 0x01, 0xC9, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x3E, 0x81, 0xD3, 0x87, 0xAF, 0xD3, 0x84, 0x3E, 0x82, 0x00,
                   0x00, 0x3E, 0xFC, 0xD3, 0x80, 0x3E, 0xDF, 0xD3, 0x86, 0x3E,
                   0x05, 0xD3, 0x87, 0x31, 0xFD, 0xF7, 0x01, 0x94, 0x00, 0x11,
                   0x00, 0xF8, 0x21, 0xB3, 0x00, 0xCD, 0x5C, 0x00, 0x01, 0x61,
                   0x00, 0x11, 0xF0, 0xF8, 0x21, 0x05, 0x02, 0xCD, 0x5C, 0x00,
                   0xAF, 0x67, 0x6F, 0x01, 0x00, 0x40, 0xCD, 0x56, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x3E, 0x0F, 0x32, 0x24, 0xFA, 0xAF, 0xCD,
                   0x6D, 0x28, 0xCD, 0xA4, 0x29, 0x3E, 0x2C, 0x32, 0x45, 0xFA,
                   0x21, 0x59, 0x17, 0x3E, 0x02, 0xCD, 0x50, 0x00, 0xCD, 0xA9,
                   0x03, 0xAF, 0xCD, 0x63, 0x1B, 0x21, 0x6D, 0x02, 0xCD, 0x93,
                   0x0D, 0x21, 0xFF, 0xFF, 0x22, 0x26, 0xF9, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x2A, 0xAC, 0xF0, 0x22, 0x30, 0xF9, 0x22, 0x32, 0xF9,
                   0x22, 0x34, 0xF9, 0x2A, 0x2C, 0xFA, 0x36, 0x52, 0x23, 0x36,
                   0x55, 0x23, 0x36, 0x4E, 0x23, 0x36, 0x0D, 0x23, 0x22, 0x2A,
                   0xFA, 0xC3, 0x0D, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x50, 0x4B, 0x38, 0x30, 0x30, 0x30,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };


char BLOAD[128] = {0xF3, 0x31, 0x00, 0xF0, 0x21, 0x37, 0x01, 0x11, 0xF0, 0xFF,
                   0x01, 0x0D, 0x00, 0xCD, 0x26, 0x01, 0x2A, 0x7A, 0x01, 0x54,
                   0x5D, 0x2A, 0x7E, 0x01, 0x44, 0x4D, 0x21, 0x80, 0x01, 0xCD,
                   0x26, 0x01, 0x2A, 0x7C, 0x01, 0xC3, 0xF0, 0xFF, 0x09, 0xEB,
                   0x09, 0xEB, 0x2B, 0x1B, 0x7E, 0x12, 0x2B, 0x1B, 0x0B, 0x78,
                   0xB1, 0xC2, 0x2C, 0x01, 0xC9, 0x3E, 0xFC, 0xD3, 0x80, 0xFB,
                   0xAF, 0xD3, 0x84, 0x3E, 0xDF, 0xD3, 0x86, 0xE9, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x4B, 0x38, 0x30,
                   0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

char BPROT[256] = {0xF3, 0x31, 0x00, 0xF0, 0x21, 0x50, 0x01, 0x11, 0xD0, 0xF6, 0x01, 0x51, 0x00, 0xCD, 0x32, 0x01,
                   0x21, 0x43, 0x01, 0x11, 0xF0, 0xFF, 0x01, 0x0D, 0x00, 0xCD, 0x32, 0x01, 0x2A, 0xFA, 0x01, 0x54,
                   0x5D, 0x2A, 0xFE, 0x01, 0x44, 0x4D, 0x21, 0x00, 0x02, 0xCD, 0x32, 0x01, 0x2A, 0xFC, 0x01, 0xC3,
                   0xF0, 0xFF, 0x09, 0xEB, 0x09, 0xEB, 0x2B, 0x1B, 0x7E, 0x12, 0x2B, 0x1B, 0x0B, 0x78, 0xB1, 0xC2,
                   0x38, 0x01, 0xC9, 0x3E, 0xFC, 0xD3, 0x80, 0xFB, 0xAF, 0xD3, 0x84, 0x3E, 0xDF, 0xD3, 0x86, 0xE9,
                   0x3E, 0xFF, 0x32, 0x42, 0xFA, 0x21, 0x23, 0xF3, 0x01, 0xE1, 0xF6, 0xE5, 0xC5, 0x2A, 0x1C, 0x35,
                   0xE9, 0xE1, 0xFE, 0x00, 0xC2, 0xD8, 0xF6, 0x01, 0x06, 0x00, 0xCD, 0xCC, 0x35, 0xE1, 0xC1, 0xCD,
                   0xFC, 0x34, 0xD0, 0x3E, 0x01, 0x32, 0xD2, 0x02, 0xC3, 0xF8, 0xF6, 0xF6, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x50, 0x4B, 0x38, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };


char KOI2DOS[64]= {'j','a','b','c','d','e','f','g','h','i','i','k','l','m','n','o',
                   'p','y','r','s','t','u','w','v','-','-','z','j','q','j','x','-',
                   'J','A','B','C','D','E','F','G','H','I','I','K','L','M','N','O',
                   'P','Y','R','S','T','U','W','V','-','-','Z','J','Q','J','X','-' };

char KOI2RUS[64]= {'','','','','','','','','','','','','','','','',
                   '','','','','','','','','','','','','','','','',
                   '','','','','','','','','','','','','','','','',
                   '','','','','','','','','','','','','','','',''};


char fpresent(char *name)
{
    FILE *f;
    if ((f = fopen(name, "rb")) == NULL)
    {
        return 0;
    }
    fclose(f);
    return 0xFF;
}

long fsize(FILE *f)
{
    long oldpos, size;

    oldpos = ftell(f);
    fseek(f, 0, SEEK_END);
    size = ftell(f);
    fseek(f, oldpos, SEEK_SET);
    return size;
}


void cas_Warning(char *msg)
{
    printf("WARNING: %s\n", msg);
}

void cas_Error(int n)
{
    if (n < ERR_LAST && n > 0)
        printf("ERROR:  %s!\n\n", err[n-1]);
}
//  訡


void cas_ToName(CAS *cas)
{
    int i;
    unsigned char c;

    for (i = 0; i < 6; i++)
    {
        c = cas->name[i];
        if (c <= ' ')
            break;
        if (c >= 0xC0)
        {
            cas->fname[i] = KOI2DOS[c-0xC0];
            cas->name[i] = KOI2RUS[c-0xC0];
        } else {
            cas->fname[i] = c;
        }
    }
    cas->name[i] = 0x00;
    cas->fname[i] = 0x00;
}

//  । ਯ
int cas_ReadDesc(FILE *f)
{
    char buff[8];
    long pos;

    pos = ftell(f);
    while (fread(buff, 1, 8, f) == 8)
    {
        if (!memcmp(buff, HEADER, 8))
        {
            return -1;                      // 諨 ਯ
        }
        fseek(f, ++pos, SEEK_SET);
    }
    return 0;
}

unsigned int fgetw(FILE *f)
{
    unsigned int h, l;
    l = fgetc(f);
    h = fgetc(f);
    return h*256+l;
}

void fseteof(FILE *f)
{
    while (!feof(f))
        fgetc(f);
}


// 뢠   ୮ ଠ
int cas_ReadBData(FILE *f, CAS *cas)
{
    unsigned int size;
    unsigned int size2;
    unsigned char ch;

    // 뢠 ਯ 
    if (!cas_ReadDesc(f))
        return ERR_BAD_FORMAT;
    // 뢠   ࠧ饭  
    cas->start = fgetw(f);
    cas->stop  = fgetw(f);
    cas->entry = fgetw(f);

    if (cas->start < 0x4000 || cas->start >= cas->stop)
        return ERR_BAD_FORMAT;

    if (cas->start >= 0xF635)
    {
        // 㧪  ࠡ稥    ᨪ, 宦    ஢
        if (cas->start == 0xFB85)
        {
            //  ஢ 堨
            size = cas->stop-cas->start;
            if (size < 200)
                return ERR_PROTECTED;   //  ଠ
            cas_Warning("programm is protect by Nazarov Mihail");
            // 뢠   ࠧ饭  
            cas->start = fgetw(f);
            cas->stop  = fgetw(f);
            cas->entry = fgetw(f);
            size -= 6;
            // ய᪠  
            while (size)
            {
                fgetc(f);
                size--;
            }
            if (!cas_ReadDesc(f))
                return ERR_CORRUPT_DATA;
        } else if (cas->start == 0xF6D0) {
            // 宦   AMATASOFT
            cas->type = CAS_BINPROT;
            // ய᪠  
            size = 80;
            while (size)
            {
                fgetc(f);
                size--;
            }
            // 饬 騥 
            size = 100;
            while (size)
            {
                ch = fgetc(f);
                if (ch == 0)
                    break;
            }
            if (!size)
                return ERR_PROTECTED;   //  ଠ
            cas_Warning("programm is protect by AMATASOFT");
            // 뢠   ࠧ饭  
            cas->start = fgetw(f);
            cas->stop  = cas->start + fgetw(f);
            cas->entry = fgetw(f);
            if (cas->start < 0x4000 || cas->start >= cas->stop)
                return ERR_BAD_FORMAT;
        } else if (cas->start == 0xF6D6) {
            // 宦   Protection v2.0 1.03.93 + Alior
            size = 14;
            while (size)
            {
                fgetc(f);
                size--;
            }
            if (fgetc(f) != 0x21)
                return ERR_PROTECTED;
            cas->stop = fgetw(f);
            fgetc(f);fgetc(f);fgetc(f);
            if (fgetc(f) != 0x21)
                return ERR_PROTECTED;
            cas->start = fgetw(f);
            fgetc(f);fgetc(f);fgetc(f);
            if (fgetc(f) != 0x01)
                return ERR_PROTECTED;
            size = fgetw(f);
            if ((cas->start + size) > cas->stop)
                return ERR_PROTECTED;
            cas_Warning("programm is protect by Alior");
            cas->stop = cas->start + size;
            // ய᪠  稪
            size = 48;
            while (size)
            {
                fgetc(f);
                size--;
            }
            // 樮㥬  砫 ॠ쭮 
            size = 100;
            while (size)
            {
                ch = fgetc(f);
                if (ch == 0)
                    break;
            }
            if (!size)
                return ERR_CORRUPT_DATA;
        } else {
            return ERR_PROTECTED;
        }
    }
    // 㧪  ᢮  
    if (cas->entry < cas->start || cas->entry >= cas->stop)
        return ERR_CORRUPT_DATA;
    // 뤥塞   뢠
    size = cas->stop-cas->start;
    cas->data = malloc(size);
    if (cas->data == NULL)
        return ERR_NOT_MEM;
    if ((size2 = fread(cas->data, 1, size, f)) != size)
    {
        printf("WARNING: expected: %u bytes, read: %u bytes\n", size, size2);
//        free(cas->data);
//        return ERR_UNEXPECTED_EOF;
    }
    return 0;
}



int cas_ReadCData(FILE *f, CAS *cas)
{
    unsigned int size;
    char        *b;

    if (!cas_ReadDesc(f))
        return ERR_BAD_FORMAT;

    // 㦠  
    cas->data = malloc(MAX_BSIZE+0x100);
    if (cas->data == NULL)
        return ERR_NOT_MEM;
    memset(cas->data, 0x00, MAX_BSIZE+0x100);
    size = 0;
    if (fread(cas->data+1, 1, MAX_BSIZE, f) > 0)
    {
        // 뢠 ࠧ
        b = cas->data;
        while (size < MAX_BSIZE)
        {
            if (*b == 0x00)
            {
                b++;
                size++;
                if (*b == 0x00)
                {
                    b++;
                    size++;
                    if (*b == 0x00)
                        break;              // 諨  
                }
            }
            b++;
            size++;
        } // while
    } else {
        cas_Warning("no data!");
    }
    if (*b != 0x00)
    {
        cas_Warning("file too long, cut data!");
        *b = 0x00;
    }
    // ࠢ ࠧ  ࠭ 256 
    size = ((size+10) & 0xFF00) + 0x100;
    cas->start = 0x0000;
    cas->entry = size+0x4000;
    cas->stop  = size;
    return 0;
}

int cas_ReadTData(FILE *f, CAS *cas)
{
    unsigned int rd, size;
    char *b;

    cas->data = malloc(MAX_BSIZE+0x100);    // ᨬ ࠧ 
    if (cas->data == NULL)
        return ERR_NOT_MEM;
    b = cas->data;
    size = 0;
    while (!feof(f))
    {
        // 室  । 
        if (!cas_ReadDesc(f))
            return ERR_CORRUPT_DATA;
        // 뢠   256 
        rd = fread(b, 1, 256, f);
        while (rd)
        {
            if (*b == 0x1A)
            {
                size++;
                fseteof(f);
                break;
            } else {
                b++;
                size++;
                rd--;
            }
            if (size > MAX_BSIZE)
            {
                cas_Warning("file too long, cut data!");
                fseteof(f);
                break;
            }
        }
    }
    cas->stop = size;
    return 0;
}


CAS *cas_Open(char *name)
{
    FILE *f;
    char buff[10];
    CAS *cas;
    int  code;

    if ((f = fopen(name, "rb")) == NULL)
    {
        printf("\nERROR: can`t open '%s'\n", name);
        return NULL;
    }
    cas = (CAS*) malloc(sizeof(CAS));
    if (cas)
    {
        cas->size = fsize(f);
        printf("  (%li bytes)\n", cas->size);
        if (cas->size >= 64000)
        {
            cas_Error(ERR_TOO_LARGE);
            free(cas);
            return NULL;
        }

        if (cas_ReadDesc(f))
        {
            if (fread(buff, 1, 10, f) == 10)    // 뢠 ⨯ 
            {
                if (!memcmp(buff, BIN, 10))
                {
                    //   , 뢠  䠩
                    cas->type = CAS_BINARY;
                    fread(cas->name, 1, 6, f);
                    cas_ToName(cas);
                    printf("FOUND:  %s (BINARY)\n",cas->name);
                    code = cas_ReadBData(f, cas);
                    printf("  -start: 0x%X\n  -stop : 0x%X\n  -entry: 0x%X\n", cas->start, cas->stop, cas->entry);

                } else if (!memcmp(buff, BASIC, 10))
                {
                    //  ᨪ-ணࠬ, 뢠  䠩
                    cas->type = CAS_BASIC;
                    fread(cas->name, 1, 6, f);
                    cas_ToName(cas);
                    printf("FOUND:  %s (BASIC)\n",cas->name);
                    code = cas_ReadCData(f, cas);
                    printf("  -start: 0x%X\n  -stop : 0x%X\n  -size : %u bytes\n", 0x4000, cas->entry, cas->stop);

                } else if (!memcmp(buff, ASCII, 10))
                {
                    cas->type = CAS_TEXT;
                    fread(cas->name, 1, 6, f);
                    cas_ToName(cas);
                    printf("FOUND:  %s (TEXT)\n",cas->name);
                    // 뢠 
                    code = cas_ReadTData(f, cas);
                    if (!code)
                        printf("  -size: %u\n", cas->stop);

                } else {
                    fread(cas->name, 1, 6, f);
                    cas_ToName(cas);
                    printf("FOUND:  %s (UNKNOWN)\n",cas->name);
                    code = ERR_UNKNOWN_FRM;
                }
            } else {
               code = ERR_UNEXPECTED_EOF;
            }
        } else {
            code = ERR_BAD_FORMAT;
        }
    } else {
        printf("\n");
        code = ERR_NOT_MEM;
    }
    fclose(f);
    if (!code)
        return cas;
    if (cas)
        free(cas);
    cas_Error(code);
    return NULL;
}


int com_Create(CAS *cas)
{
    FILE *f;
    char *head;
    char fill[256];
    char fname[16];
    unsigned int size, hsize;          // ࠧ 
    int          code;
    int          i;

    strcpy(fname, cas->fname);
    strcat(fname, ext[cas->type]);
    printf("CREATE: %s\n", fname);
    memset(fill, 0x00, sizeof(fill));
    code = 0;

    if (fpresent(fname))
    {
        printf("WARNING: file is already present!\n");
        // ࠥ 㣮   䠩
        for (i = 1; i <= 99; i++)
        {
            memset(fname, 0x00,sizeof(fname));
            sprintf(fname,"%s%i%s",cas->fname,i,ext[cas->type]);
            if (!fpresent(fname))
                break;
        }
        if (fpresent(fname))
        {
            cas_Error(ERR_CREATE_FILE);
            return 0;
        }
        printf("CREATE: %s\n", fname);
    }

    if ((f = fopen(fname, "wb")) != NULL)
    {
        // 롨ࠥ  ࠨ 
        switch (cas->type)
        {
            case CAS_BINARY:
                {
                    hsize = sizeof(BLOAD);
                    size = cas->stop-cas->start;
                    head = &BLOAD[0];
                    break;
                }
            case CAS_BINPROT:
                {
                    hsize = sizeof(BPROT);
                    size = cas->stop-cas->start;
                    head = &BPROT[0];
                    break;
                }
            case CAS_BASIC:
                {
                    hsize = sizeof(CLOAD);
                    size = cas->stop;
                    head = &CLOAD[0];
                    break;
                }
            case CAS_TEXT:
                {
                    size = cas->stop;
                    hsize = 128 - (size % 128); //   ࠢ
                    head = NULL;
               }
        } // switch

        if (head)
        {
            head[hsize+CSTART]   = cas->start & 0xFF;
            head[hsize+CSTART+1] = cas->start >> 8;
            head[hsize+CENTRY]   = cas->entry & 0xFF;
            head[hsize+CENTRY+1] = cas->entry >> 8;
            head[hsize+CSIZE]    = size & 0xFF;
            head[hsize+CSIZE+1]  = size >> 8;
            //  ࠭塞 
            if (fwrite(head, 1, hsize, f) != hsize)
                code = ERR_WRITE_FILE;
        }
        // ࠭塞 
        printf("WRITE:  %u Bytes data\n", size);
        if (!code)
            if (fwrite(cas->data, 1, size, f) != size)
                code = ERR_WRITE_FILE;
        if (!code)
        {
            size += hsize;
            if (size % 128)
                fwrite(fill, 1, 128 - (size % 128), f);
        }
        fclose(f);
    } else {
        code = ERR_CREATE_FILE;
    }

    if (!code)
        return -1;

    cas_Error(code);
    return 0;
}


int main(int argc, char* argv[])
{
    CAS *cas;

    printf("CAS to COM converter  v1.4\n");
    if (argc != 2)
    {
        printf("USAGE: %s <filename.cas>\n", argv[0]);
        return 0;
    }
    printf("SOURCE: %s", argv[1]);
    if ((cas = cas_Open(argv[1])) != NULL)
    {
        // ᮧ COM-䠩
        if (com_Create(cas))
            printf("Done!\n\n");
    }
    return -1;
}
