#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Keyboard emulation (part of sPycialist - Specialist PC Emulator)
# (C) Stanislav Yudin (CityAceE)
# http://zx-pk.ru


vv55a_mode = 0x82
kb_mem = bytearray([0x00, 0x00, 0x00])

matrix82=bytearray([0x00, 0x00, 0x00,0x00, 0x00, 0x00,0x00, 0x00, 0x00,0x00, 0x00, 0x00, 0x00])
matrix91hi=bytearray([0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0])
matrix91lo=bytearray([0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00])

trans8to3={
    0b00000000: [0],
    0b10000000: [5],
    0b01000000: [6],
    0b00100000: [7],
    0b00010000: [8],
    0b00001000: [9],
    0b00000100: [10],
    0b00000010: [11],
    0b00000001: [12]}

trans4to3={
    0b0000: [0],
    0b1000: [1],
    0b0100: [2],
    0b0010: [3],
    0b0001: [4]}

trans8to3_91={
    0b00000000: [0],
    0b10000000: [1],
    0b01000000: [2],
    0b00100000: [3],
    0b00010000: [4],
    0b00001000: [5],
    0b00000100: [6],
    0b00000010: [7],
    0b00000001: [8]}

keys = {
   # Key [   C O L U M N    ] [  R O W  ]
    282: [0b1000, 0b00000000, 0b10000000],  # F - F1
    283: [0b0100, 0b00000000, 0b10000000],  # HELP - F2
    284: [0b0010, 0b00000000, 0b10000000],  # NEW - F3
    285: [0b0001, 0b00000000, 0b10000000],  # LOAD - F4
    286: [0b0000, 0b10000000, 0b10000000],  # SAVE - F5
    287: [0b0000, 0b01000000, 0b10000000],  # RUN - F6
    288: [0b0000, 0b00100000, 0b10000000],  # STOP - F7
    289: [0b0000, 0b00010000, 0b10000000],  # CONT - F8
    290: [0b0000, 0b00001000, 0b10000000],  # EDIT - F9
    291: [0b0000, 0b00000100, 0b10000000],  # СФ - F10
    292: [0b0000, 0b00000010, 0b10000000],  # ТФ - F11
    293: [0b0000, 0b00000001, 0b10000000],  # НФ - F12

    61: [0b1000, 0b00000000, 0b01000000],  # ; + - +
    49: [0b0100, 0b00000000, 0b01000000],  # 1 ! - 1
    50: [0b0010, 0b00000000, 0b01000000],  # 2 " - 2
    51: [0b0001, 0b00000000, 0b01000000],  # 3 # - 3
    52: [0b0000, 0b10000000, 0b01000000],  # 4 $ - 4
    53: [0b0000, 0b01000000, 0b01000000],  # 5 % - 5
    54: [0b0000, 0b00100000, 0b01000000],  # 6 & - 6
    55: [0b0000, 0b00010000, 0b01000000],  # 7 ' - 7
    56: [0b0000, 0b00001000, 0b01000000],  # 8 ( - 8
    57: [0b0000, 0b00000100, 0b01000000],  # 9 ) - 9
    48: [0b0000, 0b00000010, 0b01000000],  # 0 - 0
    45: [0b0000, 0b00000001, 0b01000000],  # - = - -

    113: [0b1000, 0b00000000, 0b00100000],  # Й J - Й
    119: [0b0100, 0b00000000, 0b00100000],  # Ц C - Ц
    101: [0b0010, 0b00000000, 0b00100000],  # У U - У
    114: [0b0001, 0b00000000, 0b00100000],  # К K - К
    116: [0b0000, 0b10000000, 0b00100000],  # Е E - Е
    121: [0b0000, 0b01000000, 0b00100000],  # Н N - Н
    117: [0b0000, 0b00100000, 0b00100000],  # Г G - Г
    105: [0b0000, 0b00010000, 0b00100000],  # Ш [ - Ш
    111: [0b0000, 0b00001000, 0b00100000],  # Щ ] - Щ
    112: [0b0000, 0b00000100, 0b00100000],  # З Z - З
    91:  [0b0000, 0b00000010, 0b00100000],  # Х H - H
    93:  [0b0000, 0b00000001, 0b00100000],  # : * - Ъ

    97:  [0b1000, 0b00000000, 0b00010000],  # Ф F - Ф
    115: [0b0100, 0b00000000, 0b00010000],  # Ы Y - Ы
    100: [0b0010, 0b00000000, 0b00010000],  # В W - В
    102: [0b0001, 0b00000000, 0b00010000],  # А A - А
    103: [0b0000, 0b10000000, 0b00010000],  # П P - П
    104: [0b0000, 0b01000000, 0b00010000],  # Р R - Р
    106: [0b0000, 0b00100000, 0b00010000],  # О O - О
    107: [0b0000, 0b00010000, 0b00010000],  # Л L - Л
    108: [0b0000, 0b00001000, 0b00010000],  # Д D - Д
    59:  [0b0000, 0b00000100, 0b00010000],  # Ж V - Ж
    39:  [0b0000, 0b00000010, 0b00010000],  # Э \ - Э
    92:  [0b0000, 0b00000001, 0b00010000],  # . > - \

    122: [0b1000, 0b00000000, 0b00001000],  # Я Q - Я
    120: [0b0100, 0b00000000, 0b00001000],  # Ч ^ - Ч
    99:  [0b0010, 0b00000000, 0b00001000],  # С S - С
    118: [0b0001, 0b00000000, 0b00001000],  # М M - М
    98:  [0b0000, 0b10000000, 0b00001000],  # И I - И
    110: [0b0000, 0b01000000, 0b00001000],  # Т T - Т
    109: [0b0000, 0b00100000, 0b00001000],  # Ь X - Ь
    44:  [0b0000, 0b00010000, 0b00001000],  # Б B - Б
    46:  [0b0000, 0b00001000, 0b00001000],  # Ю @ - Ю
    47:  [0b0000, 0b00000100, 0b00001000],  # , < - ?
    303: [0b0000, 0b00000010, 0b00001000],  # / ? - Right Shift
    8:   [0b0000, 0b00000001, 0b00001000],  # ЗБ - Backspace

    301: [0b1000, 0b00000000, 0b00000100],  # НРФ - CapsLock
    277: [0b0100, 0b00000000, 0b00000100],  # HOME - Home
    273: [0b0010, 0b00000000, 0b00000100],  # ВВЕРХ - Up
    274: [0b0001, 0b00000000, 0b00000100],  # ВНИЗ - Down
    000: [0b0000, 0b10000000, 0b00000100],  #
    000: [0b0000, 0b01000000, 0b00000100],  #
    32:  [0b0000, 0b00100000, 0b00000100],  # ПРОБЕЛ - Space
    276: [0b0000, 0b00010000, 0b00000100],  # ВЛЕВО - Left
    307: [0b0000, 0b00001000, 0b00000100],  # ПВ - Rigth Alt
    275: [0b0000, 0b00000100, 0b00000100],  # ВПРАВО - Right
    281: [0b0000, 0b00000010, 0b00000100],  # ПС - PageDown
    13:  [0b0000, 0b00000001, 0b00000100],  # ВК - Enter

    304: [0b0000, 0b00000000, 0b00000010]}  # НР - Left Shift


def keydown(code):
    if code in keys:
        temp1=trans4to3[keys[code][0]]
        temp2=trans8to3[keys[code][1]]
        matrix82[temp1[0]+temp2[0]] |= keys[code][2]
        temp1=trans8to3_91[keys[code][2]]
        matrix91lo[temp1[0]] |= keys[code][1]
        matrix91hi[temp1[0]] |= keys[code][0]


def keyup(code):
    if code in keys:
        temp1=trans4to3[keys[code][0]]
        temp2=trans8to3[keys[code][1]]
        matrix82[temp1[0]+temp2[0]] &=0xff - keys[code][2]
        temp1=trans8to3_91[keys[code][2]]
        matrix91lo[temp1[0]] &= 0xff - keys[code][1]
        matrix91hi[temp1[0]] &= 0xff - keys[code][0]


def read_kb_ports(addr):
    if vv55a_mode == 0x91:
        if not (addr % 4):
            temp1=0
            mask=128
            for i in range(1,9):
               if kb_mem[1]&mask==mask:
                  temp1|=matrix91lo[i]
               mask>>=1
            return 0xff-temp1
        elif addr % 4 == 1:
            return 0xff - kb_mem[1]
        elif addr % 4 == 2:
            temp1=0
            mask=128
            for i in range(1,9):
               if kb_mem[1]&mask==mask:
                  temp1|=matrix91hi[i]
               mask>>=1
            return 0xff-temp1
    elif vv55a_mode == 0x82:
        if not (addr % 4):
            return 0xff - kb_mem[0]
        elif addr % 4 == 1:
             temp1=0
             mask=8
             for i in range(1,5):
                if kb_mem[2]&mask==mask:
                   temp1|=matrix82[i]
                mask>>=1
             mask=128
             for i in range(5,13):
                if kb_mem[0]&mask==mask:
                   temp1|=matrix82[i]
                mask>>=1
             return 0xff-(temp1|matrix82[0])

        elif addr % 4 == 2:
                return 0xff - kb_mem[2]

def write_kb_ports(addr, byte):
    global vv55a_mode
    if addr % 4 != 3:
        kb_mem[(addr % 4)] = 0xff - byte

    elif byte == 0x91:
        vv55a_mode = byte
        kb_mem[1] = 0xff

    elif byte == 0x82:
        vv55a_mode = byte
        kb_mem[0] = 0xff
        kb_mem[2] = 0xff
