;Z80 depacker for megalz V4 packed files   (C) fyrex^mhm

; DESCRIPTION:
;
; Depacker is fully relocatable, not self-modifying,
;it's length is 110 bytes starting from DEC40.
;Register usage: AF,AF',BC,DE,HL. Must be CALL'ed, return is done by RET.
;Provide extra stack location for store 2 bytes (1 word). Depacker does not
;disable or enable interrupts, as well as could be interrupted at any time
;(no f*cking wicked stack usage :).

; USAGE:
;
; - put depacker anywhere you want,
; - put starting address of packed block in HL,
; - put location where you want data to be depacked in DE,
;   (much like LDIR command, but without BC)
; - make CALL to depacker (DEC40).
; - enjoy! ;)

; PRECAUTIONS:
;
; Be very careful if packed and depacked blocks coincide somewhere in memory.
;Here are some advices:
;
; 1. put packed block to the highest addresses possible.
;     Best if last byte of packed block has address #FFFF.
;
; 2. Leave some gap between ends of packed and depacked block.
;     For example, last byte of depacked block at #FF00,
;     last byte of packed block at #FFFF.
;
; 3. Place nonpackable data to the end of block.
;
; 4. Always check whether depacking occurs OK and neither corrupts depacked data
;     nor hangs computer.
;

DEC40
        LD      A,#80
        EX      AF,AF'
MSl      LDI
M0l      LD      BC,#2FF
M1l      EX      AF,AF'
M1Xl     ADD     A,A
        JR      NZ,M2l
        LD      A,(HL)
        INC     HL
        RLA
M2l      RL      C
        JR      NC,M1Xl
        EX      AF,AF'
        DJNZ    X2l
        LD      A,2
        SRA     C
        JR      C,N1l
        INC     A
        INC     C
        JR      Z,N2l
        LD      BC,#33F
        JR      M1l

X2l      DJNZ    X3l
        SRL     C
        JR      C,MSl
        INC     B
        JR      M1l
X6l
        ADD     A,C
N2l
        LD      BC,#4FF
        JR      M1l
N1l
        INC     C
        JR      NZ,M4l
        EX      AF,AF'
        INC     B
N5l      RR      C
        RET     C
        RL      B
        ADD     A,A
        JR      NZ,N6l
        LD      A,(HL)
        INC     HL
        RLA
N6l      JR      NC,N5l
        EX      AF,AF'
        ADD     A,B
        LD      B,6
        JR      M1l
X3l
        DJNZ    X4l
        LD      A,1
        JR      M3l
X4l      DJNZ    X5l
        INC     C
        JR      NZ,M4l
        LD      BC,#51F
        JR      M1l
X5l
        DJNZ    X6l
        LD      B,C
M4l      LD      C,(HL)
        INC     HL
M3l      DEC     B
        PUSH    HL
        LD      L,C
        LD      H,B
        ADD     HL,DE
        LD      C,A
        LD      B,0
        LDIR
        POP     HL
        JR      M0l
