
	device zxspectrum128
	org 48500
start:
	;set machine value for game
	xor a: ld (49151),a
        ;detect +2|gray or +2b,+3 by port ff
	halt : call TestPortFF
	jr z,1f
	ld a,4+16
	ld (paga+1),a
	ld (49151),a
1:

;The routine starts at address 0556 and requires the following register settings: 
;IX	Start of the block,
;DE	Length of the block,
;A	Flag byte (normally +00 for the header and +FF for a data block),
;carry flag	set for LOAD, reset for VERIFY.

	;load screen$
	ld ix,32768 : ld de,2371 : ld a,#ff : SCF : call #0556
	ld hl,32768 : ld de,16384 : call DEC40

;11 LET p=17: IF PEEK 2899=126 THEN LET p=20
;30 POKE 23388,16+7:OUT 32765,16+7:LOAD "p7" CODE 49152
	;page7
	ld a,7+16 : call swapPage
	ld ix,32768 : ld de,p7e-p7s : ld a,#ff : SCF : call #0556
	ld hl,32768 : ld de,49152 : call DEC40

	;page1 or 4
;	ld a,(2899)
;	cp 126
;	jr z,1f
;	ld a,1+16 
;	jr 2f
;1:
;	ld a,4+16
;2:
;	call swapPage

paga:	ld a,1+16: call swapPage
	ld ix,32768 : ld de,p1e-p1s : ld a,#ff : SCF : call #0556
	ld hl,32768 : ld de,49152 : call DEC40
	;main game
	ld a,16 : call swapPage
	ld ix,49152 : ld de,ge-gs : ld a,#ff : SCF : call #0556
	ld hl,49152 : ld de,24500 : call DEC40
	;run game
	jp 24500
swapPage:
	ld bc,#7ffd : ld (23388),a : out (c),a
	ret

	include	"include\DEC40.asm"


;
;  test if this computer has the floating bus (assumes that screen is filled with 0s)
;  Z = port #FF present, NZ = port #FF not present
;
TestPortFF:		ld	hl, 3125
			ld	c, #FF
			ld	a, c
LoopTestFF:		in	b, (c)
			and	b
			dec	l
			jr	nz, LoopTestFF		; inner loop takes 12+4+4+12 = 32t
			dec	h
			jr	nz, LoopTestFF
			or	a
			ret

	display /d,"addr: ",$
end:
	org 49152
p7s:
	incbin "p7.bin.mlz"
p7e:
	org 49152
p1s:
	incbin "p1.bin.mlz"
p1e:
	org 49152
gs:
	incbin "test.bin.mlz"
ge:


	savebin "mcloader.bin",start,end-start
