;GLUF by Denis Grachev
;

;define if need pentagon timings
;			DEFINE	PENTAGON

START_LEVEL=1

DEADTIME=8

;game states
GS_GAMEPLAY = 0
GS_WIN = 1
GS_DEAD = 2
GS_RESTART=3
GS_SHOW = 4

;where draw power bar attrs
powerAdr = 22528+19+21*32
;delay for fire button
FIRE_DELAY=20

;hero states
HERO_STAND = 0
HERO_JUMP = 1
HERO_UP = 2
HERO_DOWN = 3
;tiles
TILE_NULL = 0
TILE_START = 4	;hero start tile
;TILE_POWER = 7	;power bank
TILE_POWER = 11	;power bank
TILE_BRIDGE = 12;broken bridge

TILE_SOLID = 11 ;first solid block 14
TILE_UNPAINT = 14 ;first solid block 14
TILE_PAINTED = 15 ;first solid block 15
TILE_LIFT = 10
TILE_LIFT1 = 5
TILE_END = 40
TILE_DOOR = 9
;
GHOST_POINT=31

;enemies
ENEMY1 = 32
ENEMY2 = 33
ENEMY22 = 34;move left on start??
ENEMY24 = 38;move left on start??
ENEMY23 = 39;move left on start??
ENEMY3 = 35
ENEMY4 = 36
ENEMY4d = 41
ENEMY4u = 42
ENEMY5 = 37

;enemies dirs
DIR_LEFT=0
DIR_RIGHT=1
DIR_DOWN=2
DIR_UP=3
DIR_IDLE=4

PackedPSG=49152
	define AYREGS AYbuffer ; TBKPSGPlayer.BufferPSG

	device zxspectrum128
;multicolor buffers
mcBuffer =  49152
mcBuffer1 = 49152+4096
mcBuffer2 = 49152+4096*2
mcBuffer3 = 49152+4096*3

;used to skip or draw third collumn for sprites
DRAW2=87+256*103
DRAW3=82+100*256


	page 0
	org 24500
start:
	di	
	ld sp,24499
	call kempstonTest
	ld a,e
	ld (haveKempston),a;1 - if have it
	
	di
	xor a: call swapPage : call generateCodeScreen
	call machineTest
	;fill mcBuffer with red ink and black papper for dead fx
	ld a,(pg0+1) : call swapPage
	ld hl,mcBuffer3
	ld de,mcBuffer3+1
	ld bc,4096-1
	ld (hl),6+2*8
	ldir
	;gen sins
	ld de,sin1
	ld bc,16+17*256  	;b=start, =delta  less b
	call SINMAKE

	;init game
	call initGame
	call setMusic1

	ld hl,interruptNull : call IMON
restartLevel:
	halt
	ld a,7 : call swapPage
;	ld hl,bgPacked
;	ld de,16384
;	call DEC40
	halt
	xor a: call fillBottom
	halt
	ld a,8
	ld (soundToPlay+1),a
        ;setup null interrupt
	ld hl,nullProc
	ld (topBorder+1),hl
	ld (downBorder+1),hl
;============================================
	ld a,(currentLevel)
	cp 25
	jp z,outro
	;INIT LEVEL
	call initLevel
	;build waypoints
	call buildWP
	;draw level
	call drawLevel
	;ok wait for music frame - we 25hz errrrgh
	halt
	ld a,(ntk+1)
	or a
	jr z,1f
	halt;one frame +; play
1:
	ld hl,interrupt : call IMON
        ;setup main gameplay interrupt
	ld hl,top2
	ld (topBorder+1),hl
	ld hl,down1
	ld (downBorder+1),hl
	;gameplay game state
	ld a,GS_SHOW
	ld (gameState),a
	ld a,7
	ld (soundToPlay+1),a

mainLoop:
	ei
	halt	;not play
	di
	ld hl,top1
	ld (topBorder+1),hl
	ld hl,down2
	ld (downBorder+1),hl
	ei
	halt      ;play
	di
	ld hl,top2
	ld (topBorder+1),hl
	ld hl,down1
	ld (downBorder+1),hl

	;draw main menu game logo
	ld a,(currentLevel)
	or a
	call z,doLogo

	ld a,(gameState)
	or a;gameplay
	call z,controls
	;do hero
	call doHero
	;gravity
	call tryHeroFall

	;enemies
	call doEnemies
	;do lifts
	call doLifts

	;do exit door
       	ld a,(totalBlocks)
	or a
	jr nz,1f
	ld a,(drClr+1)
	cp 5
	jr nz,1f
drClr:	ld a,5
	call paintDoor
1:
;	ld a,0
;	out (254),a
	;----
	call doCamera

	;patch video output adresses
        ld hl,(startPixel+1)
	inc l
	call patchVideoOut

	;loop based on game state
       ld a,(gameState)
       or a 
       jp z,mainLoop
       cp GS_SHOW
       jp z,mainLoop

	;dead
	cp GS_DEAD
	jr nz,1f
	ld hl,mcBuffer3
	ld (mcStart+1),hl
	call getRandom
	ld (sinAdd+1),a
	ld a,(deadCount)
	dec a
	ld (deadCount),a
	;hide hero
	cp DEADTIME-2
	jr nz,2f
	;restore pixels under dead hero
	call restoreLeft
	call restoreMiddle
	call restoreRight
	;put it off screen
	ld a,160
	ld (sprites+4*18+3),a
	jr 1f
2:
	or a
	jr nz,1f
	ld a,128
	ld (gameState),a

	
1:
       ;check fire button for restart on other game states
       call checkFireButton
       jp nz,mainLoop

;restartLevel2:
	ld a,(gameState)
	cp GS_WIN
	jr nz,3f
	ld a,(currentLevel)
	inc a
	ld (currentLevel),a

	;reinitMusic
	cp 8
	push af: call z,setMusic2 : pop af
	cp 14
	push af: call z,setMusic1 : pop af
	cp 20
	push af: call z,setMusic2 : pop af

3:

	ei
	halt;not play
	;
	ld a,1 : ld (ntk+1),a;play on next frame
	ld hl,interruptNull : call IMON
	jp restartLevel

deadCount:	db 0
haveKempston:	db 0
currentLevel:	db START_LEVEL-1

setMusic1:
	di
	push af
	;init music	
	ld hl,384 : ld (TBKPSGPlayer.loopTick),hl: xor a: ld (TBKPSGPlayer.PSGLOOP),a
	ld hl,0 : ld (TBKPSGPlayer.tickTick+1),hl
	ld hl,music : ld (InitPSG+1),hl : call InitPSG
	pop af
	ei
	ret

setMusic2:
	di
	push af
	;init music	
	ld hl,256 : ld (TBKPSGPlayer.loopTick),hl: xor a: ld (TBKPSGPlayer.PSGLOOP),a
	ld hl,0 : ld (TBKPSGPlayer.tickTick+1),hl
	ld hl,music2 : ld (InitPSG+1),hl : call InitPSG
	pop af
	ei
	ret
;============  DRAW LOGO  ===========
;use 4 enemies sprite for drawing logo
doLogo:
s1:	ld hl,sin1
	ld a,l: add 12: ld l,a
	ld (s1+1),hl
	push hl: call drawLetterG: pop hl
	ld a,l:	add 32 :	ld l,a
	push hl: call drawLetterL: pop hl
	ld a,l:	add 32 :	ld l,a
	push hl: call drawLetterU: pop hl
	ld a,l:	add 32 :	ld l,a
	push hl: call drawLetterF: pop hl
	ret
drawLetterG:	
	ld de,eSprites+24*60*2
	ld (sprites+0*18+0),de
	ld a,(hl)
	srl a
	add 98
	ld d,a
	ld e,8
	ld (sprites+0*18+2),de
	ld hl,DRAW2
	ld (sprites+0*18+4),hl
	ld de,(sprites+0*18+6)
	ld hl,(sprites+0*18+12);addr in shadow 1
	call restoreCollumnPixels2
	ld de,(sprites+0*18+8)
	ld hl,(sprites+0*18+12);addr in shadow 1
	ld bc,320
	add hl,bc
	call restoreCollumnPixels2
	ret
drawLetterL:	
	ld de,eSprites+24*61*2
	ld (sprites+1*18+0),de
	ld a,(hl)
	srl a
	add 97
	ld d,a
	ld e,10
	ld (sprites+1*18+2),de
	ld hl,DRAW2
	ld (sprites+1*18+4),hl

	ld de,(sprites+1*18+6)
	ld hl,(sprites+1*18+12);addr in shadow 1
	call restoreCollumnPixels2
	ld de,(sprites+1*18+8)
	ld hl,(sprites+1*18+12);addr in shadow 1
	ld bc,320
	add hl,bc
	call restoreCollumnPixels2
	ret
drawLetterU:	
	ld de,eSprites+24*62*2
	ld (sprites+2*18+0),de
	ld a,(hl)
	srl a
	add 97
	ld d,a
	ld e,12
	ld (sprites+2*18+2),de
	ld hl,DRAW2
	ld (sprites+2*18+4),hl

	ld de,(sprites+2*18+6)
	ld hl,(sprites+2*18+12);addr in shadow 1
	call restoreCollumnPixels2
	ld de,(sprites+2*18+8)
	ld hl,(sprites+2*18+12);addr in shadow 1
	ld bc,320
	add hl,bc
	call restoreCollumnPixels2
	ret
drawLetterF:	
	ld de,eSprites+24*63*2
	ld (sprites+3*18+0),de
	ld a,(hl)
	srl a
	add 98
	ld d,a
	ld e,14
	ld (sprites+3*18+2),de
	ld hl,DRAW2
	ld (sprites+3*18+4),hl
	ld de,(sprites+3*18+6)
	ld hl,(sprites+3*18+12);addr in shadow 1
	call restoreCollumnPixels2
	ld de,(sprites+3*18+8)
	ld hl,(sprites+3*18+12);addr in shadow 1
	ld bc,320
	add hl,bc
	call restoreCollumnPixels2
	ret
;============  END DRAW LOGO  ===========

;blink push fire button
drawPushFire:
pfFrame:	ld a,0
	inc a
	and 7
	ld (pfFrame+1),a
	cp 6
	ld a,7+64
	jr c,1f
	xor a
1:
	call fillBottom
	ret
fillBottom:
	ld hl,22528+32*21+4
	ld de,22528+32*21+1+4
	ld bc,12
	ld (hl),a
	ldir
	ld hl,22528+32*22+4
	ld de,22528+32*22+1+4
	ld bc,12
	ld (hl),a
	ldir
	ld hl,22528+32*23+4
	ld de,22528+32*23+1+4
	ld bc,12
	ld (hl),a
	ldir
	ret
;return 1 if pressed fire
checkFireButton:
      ;drawPushFire
      call drawPushFire
      ;space
      LD    BC,32766
      IN    A,(C)
      BIT 0,A
      ret z
      ;M
      LD    BC,32766
      IN    A,(C)
      BIT 2,A 
      ret z
      ;0
        LD    BC,61438
        IN    A,(C)
        BIT 0,A
      ret z
	;5
        LD    BC,63486
        IN    A,(C)
        BIT 4,A
	ret z

        ld a,(haveKempston)
	or a
	jr z,2f;check kempston
        ld bc,31
        in a,(c)
        bit 4,a
	jr z,2f
	xor a
	ret
2:
       or 1;reset zero flag
      ret

paintDoor:
        ex af,af'
	;swap a mc page
	ld a,(pg1+1)
	ld bc,#7ffd
	out (c),a

	ex af,af'
	ld hl,(doorAdr)
	ld bc,23
	dup 8
	ld (hl),a
	inc hl
	ld (hl),a
	add hl,bc
	edup
	org $-1

	ld a,16+0
	ld bc,#7ffd
	out (c),a

	ret


gameState: db GS_GAMEPLAY

;ok we need
;init lifts
;init ghost points
;init enemies
;init hero
;init maps - lift wp
;unpack level
;reset sprites???
initLevel:
	;restore door flash color
	ld a,5
	ld (drClr+1),a

	xor a
	ld (sinAdd+1),a
	ld (totalBlocks),a
	;reset power bar
	ld hl,powerAdr
	ld de,powerAdr+1
	ld bc,9
	ld (hl),1
	ldir
	;ok

	call initSprites
	call initHero
	call initMaps
	call initLifts
	call initGpList
	call initRestoreList
	call initEnemiesList
;unpack level
	ld a,7:call swapPage
	halt
        ld a,(pgOutro) : call swapPage
	call setWorld
	ld a,7:call swapPage
	halt
	ld a,(pgOutro) : call swapPage

	ld a,(currentLevel)
	add a,a
	ld hl,levels
	ld c,a : ld b,0
	add hl,bc
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
;	ld hl,level01
	ld de,map
	call DEC40
	xor a: call swapPage
	ret

addLiftEnd:
	ld (hl),TILE_NULL
	ld a,TILE_LIFT1
	ret

drawLevel:
	halt;we will ride an interrupts
	ld hl,00000
	ld (doorAdr),hl
	ld hl,mcTable
	ld (mcFix1+1),hl
	ld (mcFix2+1),hl
	;and now draw a level
	ld hl,map
;===tsst
	ld de,0
	ld b,20
2:
	push bc
	ld e,0
	ld b,12
1:	
	push bc
	push de
	ld a,(hl)
	push hl
;enemies >32
	cp ENEMY1
	call z,addEnemy
	cp ENEMY2
	call z,addEnemy2;random x dir
	cp ENEMY22
	call z,addEnemy2Left;random x dir
	cp ENEMY23
	call z,addEnemy2Down
	cp ENEMY24
	call z,addEnemy2Up
	cp ENEMY3
	call z,addEnemy3
	cp ENEMY4
	call z,addEnemy2;random x dir
	cp ENEMY4d
	call z,addEnemy4Down
	cp ENEMY4u
	call z,addEnemy4Up
	cp ENEMY5
	call z,addEnemy2;random x dir
	CP GHOST_POINT
	call z,addGhostPoint

	cp TILE_START
	call z,setHeroStart

	cp TILE_START
	call z,setHeroStart

;	cp TILE_DOOR
;	call z,addDoor	


	cp TILE_END
	call z,addLiftEnd

	cp TILE_LIFT
	call z,addLift

	cp TILE_UNPAINT
	jr nz,9f
	push af
;	call incBlocks
	ld a,(totalBlocks)
	inc a
	ld (totalBlocks),a
	pop af
9:
;	halt
;	di
	call drawTileLevel;may change it to stack free version
;	ld a,r
;	and 00000111b
;	out (254),a
;	ei
	pop hl
	inc hl
	pop de
	inc e
	pop bc
	djnz 1b

	halt

	inc d;
	pop bc
	djnz 2b
;==========	
;	ret
	;copy to second buffers
;	di
	ei
	halt
pg0:	ld a,4:	call swapPage
;	out (254),a
	ld hl,mcBuffer
	ld de,mcBuffer1
	ld bc,24*80
	ldir
	xor a :	call swapPage
	halt
	ld a,(pg0+1):	call swapPage
	ld bc,24*80
	ldir
	xor a :	call swapPage
	halt
	ld a,(pg0+1):	call swapPage
	ld hl,mcBuffer
	ld de,mcBuffer2
	ld bc,24*80
	ldir
	xor a :	call swapPage
	halt
	ld a,(pg0+1):	call swapPage
	ld bc,24*80
	ldir
	xor a :	call swapPage
	ei
	ret


;build waypoints
buildWP:
	;build a map
	;on a first attempt process waypoints only

	ld hl,map
;===tsst
	ld de,0
	ld b,20
2:
	push bc
	ld e,0
	ld b,12
1:	
	push bc
	push de
	ld a,(hl)
	push hl


;waypoints > 16
	cp 16
	jr c,4f
	cp 31
	jr nc,4f

	push af;asve wp
	;if on top of wp a lift then put a lift1 to map
	push hl
	push de

	ld de,-12
	add hl,de
	ld a,(hl)

	CP TILE_LIFT1
	ld a,0
	jr nz,7f
	ld a,TILE_LIFT1
7:

	pop de
	pop hl
	ld (hl),a
	;reset in level map
;	ld a,(rTile+1)
;	ld (hl),a;TILE_LIFT1
;	ld (hl),0

	pop af;restore wp

	;put to wpoints buffer
	ld bc,240;right after map
	add hl,bc	
	sub 16
	ld (hl),a;wpoint our started from 0,1,2,3,4
4:

	pop hl
	inc hl
	pop de
	inc e
	pop bc
	djnz 1b
	inc d;
	pop bc
	djnz 2b

	ret


;de - tile coords
setHeroStart:	
	ld (hl),TILE_DOOR
	call addDoor
;	push hl
;	push de

	ld a,e;x
	add a,a
	ld l,a
	ld a,d
	add a,a
	add a,a
	add a,a
	ld h,a
	ld (heroPos),hl
	ld (heroTilePos),de
	;set real x
	;x - in collums so reals is x*8 and +4 for center of sprite
	ld a,e
	add a,a;x2 from tiles
	add a,a
	add a,a
	add a,a
	add 4
	ld (heroRealX),a
;	pop de
;	pop hl
;	xor a;reset to null
	;draw door
	ld a,TILE_DOOR
	ret

animateWin:
	
	ret	

;scripts describes how to draw a sprite during move

scriptRight:
;sprite drawer
	;frames,howdraw,deltax,restore procedure and realX
	dw tiles+24*36: dw DRAW3 : db 0 : dw nullProc : db +2
	dw tiles+24*39: dw DRAW3 : db 0 : dw nullProc : db +2
	dw tiles+24*42: dw DRAW3 : db 0 : dw nullProc : db +2
	dw tiles+24*45: dw DRAW2 : db 1 : dw restoreLeft : db +2
	dw tiles+24*47: dw DRAW3 : db 0 : dw nullProc : db +2
	dw tiles+24*50: dw DRAW3 : db 0 : dw nullProc : db +2
	dw tiles+24*53: dw DRAW3 : db 0 : dw nullProc : db +2
	dw tiles+24*32: dw DRAW2 : db 1 : dw restoreLeft : db +2
	;stop flag
	db 255,255

scriptLeft:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw tiles+24*53: dw DRAW3 : db -1 : dw nullProc : db -2
	dw tiles+24*50: dw DRAW3 : db 0 : dw nullProc : db -2
	dw tiles+24*47: dw DRAW3 : db 0 : dw nullProc : db -2
	dw tiles+24*45: dw DRAW2 : db 0 : dw restoreRight : db -2
	dw tiles+24*42: dw DRAW3 : db -1 : dw nullProc : db -2
	dw tiles+24*39: dw DRAW3 : db 0 : dw nullProc : db -2
	dw tiles+24*36: dw DRAW3 : db 0 : dw nullProc : db -2
	dw tiles+24*32: dw DRAW2 : db 0 : dw restoreRight : db -2
	;stop flag
	db 255,255

scriptStand:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw tiles+24*32: dw DRAW2 : db 0 : dw nullProc : db 0
	dw tiles+24*32: dw DRAW2 : db 0 : dw nullProc : db 0
	dw tiles+24*32: dw DRAW2 : db 0 : dw nullProc : db 0
	dw tiles+24*32: dw DRAW2 : db 0 : dw nullProc : db 0
	dw tiles+24*34: dw DRAW2 : db 0 : dw nullProc : db 0
	dw tiles+24*34: dw DRAW2 : db 0 : dw nullProc : db 0
	dw tiles+24*34: dw DRAW2 : db 0 : dw nullProc : db 0
	dw tiles+24*34: dw DRAW2 : db 0 : dw nullProc : db 0
	;stop flag
	db 255,255

leftleft:
	call getRandom
	call getRandom
	call getRandom
	cp 3
	jp z,tryMoveLeft
	ret

rightright:
	call getRandom
	call getRandom
	call getRandom
	call getRandom
	call getRandom
	cp 2
	jp z,tryMoveRight
	ret

muteDelay: db 20

controls:

;if already jump - ret
     ld a,(heroState)
     or a
     ret nz

        xor a
      ld (sinAdd+1),a

	ld a,(muteDelay)
	or a
        jr z,2f
        dec a
	ld (muteDelay),a
	jr 1f		
2:
      ;mute music
	ld bc,#BFFE
	in a,(c)
	bit 0,a
	jr nz,1f
	ld a,20
	ld (muteDelay),a
	ld a,(mute)
	xor 1
	ld (mute),a	
1:

      ;keyboard moving controls
      LD    BC,57342
      ;P
      IN    A,(C)
      BIT 0,A
      jp z,tryMoveRight
      ;O
      BIT 1,A
      jp z,tryMoveLeft
      ;Q
      ld bc,64510
      in a,(c)
      BIT 0,A
      jp z,tryMoveUp0
      ;A
      ld bc,65022
      in a,(c)
      BIT 0,A
      jp z,tryMoveDown0

;sinclair 2
	;7
	LD    BC,61438
        IN    A,(C)
        BIT 3,A
        jp z,tryMoveRight
	;6
        BIT 4,A
        jp z,tryMoveLeft
	;8
        BIT 2,A
        jp z,tryMoveDown0
	;9
        BIT 1,A
        jp z,tryMoveUp0


	;2
        LD    BC,63486
        IN    A,(C)
        BIT 1,A
        jp z,tryMoveRight
	;1
        BIT 0,A
        jp z,tryMoveLeft
	;3
        BIT 2,A
        jp z,tryMoveDown0
	;4
        BIT 3,A
        jp z,tryMoveUp0


;kempston
      ld a,(haveKempston)
      or a
      jr z,1f

      ld bc,31
      in a,(c)
      bit 1,a
      jp nz,tryMoveLeft
      bit 0,a
      jp nz,tryMoveRight
      bit 2,a
      jp nz,tryMoveDown0
      bit 3,a
      jp nz,tryMoveUp0

1:

      ;R
      ld bc,64510
      in a,(c)
      BIT 3,A
      jp nz,1f
      BIT 4,A
      jp nz,1f
      ld a,GS_WIN
      ld (heroState),a	
      xor a
      ld (totalBlocks),a
1:

      ld a,HERO_STAND
      ld (heroState),a



      ret

dlt:	db 0,16,0,-16
;based on tiles around move up or down
firePressed:
	ld a,1
	or a
	jr z,1f
	dec a
	ld (firePressed+1),a
	ret
1:
;ok fire delay end switch again
	ld a,FIRE_DELAY
	ld (firePressed+1),a
	;change
bbb:	ld a,0
	inc a
	and 3
	ld (bbb+1),a
	ld hl,dlt
	ld c,a
	ld b,0
	add hl,bc
	ld a,(hl)
	ld (sinAdd+1),a

	ld a,3
	ld (soundToPlay+1),a

	ret
	
onLift:	db 0

tryMoveUp0:
	ld a,(heroState)
	cp HERO_STAND
	ret nz
	ld a,(heroPos+1)
	cp 16
	jr c,tryMoveUp
	ld a,-16
	ld (sinAdd+1),a

tryMoveUp:
;if lift under hero
;if we on lift allread then check only current place
	ld de,(heroTilePos)

	ld a,(onLift)
	or a
	jr nz,9f
;======================
	dec d
	call getTile
	inc d
	cp TILE_LIFT
	jr z,1f
	cp TILE_LIFT1
	jr z,1f
9:
	call getTile
	cp TILE_LIFT
	jr z,1f
	cp TILE_LIFT1
	jr z,1f

	;no lift - stop blink active lift
	ld a,1*8+6+64
	ld (activeLiftColor+1),a
	xor a
	ld (onLift),a
	ret
1:
	ld a,0
	ld (sinAdd+1),a

	ld a,1
	ld (onLift),a

	dec d
	;save new coords
	ld (heroTilePos),de
	;enable current lift if it's not enabled already(!!!! fix later !!!!)
	call getLiftMapAddr
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	ld (activeLift+2),hl
	ld a,2*8+6+64
	ld (activeLiftColor+1),a

	;set jump state
	ld a,HERO_UP
	ld (heroState),a
	;set move count
	ld a,4
	ld (yCount),a

	;jump sound
	ld a,3
	ld (soundToPlay+1),a
	ret

incBlocks:
	ld a,(totalBlocks)
	inc a
	ld (totalBlocks),a	
	;
	cp 1
	ret nz
	;ok paoint door with blue again
	ld a,1
	call paintDoor
	ret

decBlocks:
	ld a,(totalBlocks)
	dec a
	ld (totalBlocks),a	
;level complete
;	or a
;	ret nz
;	ld a,10
;	ld (soundToPlay+1),a
;	ld a,GS_WIN
;	ld (gameState),a
;	jp z,0
	ret

unPaintColors: db 0*8+7+64,1*8+7+64,5+1*8
paintColors: db 0+3+64,1*8+3+64,2+1*8


nullColors:	db 1,1,1

killBridge:
	xor a
	ld (hl),a
	ld hl,nullColors;attribs
	call paintTileLevel

	;jump sound
	ld a,3;3
	ld (soundToPlay+1),a

	ret

;paint block under hero and put a painter block here
paintUnder:
	;if we have power
	ld a,(heroPower)
	or a
	ret z
	;ok we have power - decrease it 
	dec a
	ld (heroPower),a
	
	call decBlocks

	ld a,TILE_PAINTED
	ld (hl),a
	ld hl,paintColors;attribs
	call paintTileLevel
ps:	ld a,0
	xor 1
	ld (ps+1),a
	add 4
	ld (soundToPlay+1),a

	;draw a power
	ld a,(heroPower)
;	inc a
	ld hl,powerAdr
	ld c,a
	ld b,0
	add hl,bc
	ld (hl),1;2*8+64

	ret

;increase hero power for paint
powerUp:
	;power delay
pd:	ld a,0
	inc a
	and 3
	ld (pd+1),a
	or a
	ret nz
	;ok add power
	ld a,(heroPower)
	cp 10
	ret z
	;not more than 10

	;draw a power
	ld hl,powerAdr
	ld c,a
	ld b,0
	add hl,bc
	ld (hl),6+64

	inc a
	ld (heroPower),a
	;
	ld a,0
	ld (soundToPlay+1),a
	ret

tryHeroFall:
	ld a,(heroState)
	or a
	ret nz
	ld a,(gameState)
	or a
	ret nz
;if null under hero
	ld de,(heroTilePos)
	inc d
	call getTile
	cp TILE_POWER
	jp z,powerUp
	;we not on tile power reset tile power counter
	push af
	xor a
	ld (powerUp+1),a
	pop af
	cp TILE_UNPAINT
	jr z,paintUnder
	cp TILE_SOLID
	ret nc
	cp TILE_LIFT
	ret z

	ld a,1
	ld (wasFall),a

	;save new coords
	ld (heroTilePos),de
	;set jump state
	ld a,HERO_DOWN
	ld (heroState),a
	;set move count
	ld a,4
	ld (yCount),a

	;jump sound
;	di
	ld a,2
	ld (soundToPlay+1),a
;	ei

	ret

wasFall:	db 0

tryMoveDown0:
	ld a,(heroState)
	cp HERO_STAND
	ret nz
	ld a,16
	ld (sinAdd+1),a

tryMoveDown:

;if lift under hero
	ld de,(heroTilePos)
	inc d
	call getTile
	cp TILE_LIFT
	jr z,5f
	cp TILE_LIFT1
	jr z,1f
2:
	;no lift - stop blink
	ld a,1*8+6+64
	ld (activeLiftColor+1),a
	xor a
	ld (wasFall),a
	ret
5:
	ld a,(wasFall)
	or a
	jr nz,2b

1:
        ld a,0
	ld (sinAdd+1),a

	;save new coords
	ld (heroTilePos),de
	;enable current lift if it's not enabled already(!!!! fix later !!!!)
	call getLiftMapAddr
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	ld (activeLift+2),hl
	ld a,2*8+6+64
	ld (activeLiftColor+1),a
	

	;set jump state
	ld a,HERO_DOWN
	ld (heroState),a
	;set move count
	ld a,4
	ld (yCount),a

	;jump sound
	ld a,3
	ld (soundToPlay+1),a

	ret

tryMoveRight:
;if wall left ret
	ld de,(heroTilePos)
	inc e
	call getTile
	cp TILE_SOLID
	ret nc
	;jump sound
	ld a,1
	ld (soundToPlay+1),a
	;save new coords
	ld (heroTilePos),de
	;check under hero broken bridge
	dec e
	inc d
	call getTile
	cp TILE_BRIDGE
	call z,killBridge

	;set jump state
	ld a,HERO_JUMP
	ld (heroState),a
	;set script
	ld hl,scriptRight
	ld (currentScript),hl

	ret

tryMoveLeft:
;if wall left ret
	ld de,(heroTilePos)
	dec e
	call getTile
	cp TILE_SOLID
	ret nc
	;save new coords
	ld (heroTilePos),de
	;jump sound
	ld a,1
	ld (soundToPlay+1),a
	;check under hero broken bridge
	inc e
	inc d
	call getTile
	cp TILE_BRIDGE
	call z,killBridge


	;set jump state
	ld a,HERO_JUMP
	ld (heroState),a
	;set script
	ld hl,scriptLeft
	ld (currentScript),hl


	ret

nullProc:
	ret


;=======================HERO PROPS =============
currentScript:	dw scriptStand
heroPos:	dw 00000
heroRealX:	db 0; real X coordinate +2 -2 till moves
heroTilePos:	dw 00000
heroState:	db HERO_STAND
heroPower:	db 0

yTick:	db 0
;yFrames:	dw tiles+24*56,tiles+24*56,tiles+24*58,tiles+24*58,tiles+24*56,tiles+24*56,tiles+24*58,tiles+24*58
yFrames:	dw tiles+24*56,tiles+24*56,tiles+24*56,tiles+24*56,tiles+24*58,tiles+24*58,tiles+24*58,tiles+24*58
;tick for y movement
yCount:	db 4

initHero:

	ld hl,showAnima
	ld (pots+1),hl
	ld hl,winAnima
	ld (potw+1),hl

	ld a,4
	ld (yCount),a
	ld a,HERO_STAND
	ld (heroState),a
	xor a
	ld (yTick),a
	ld (heroPower),a
	ld (onLift),a
	ld hl,scriptStand
	ld (currentScript),hl
	
	ret

doHeroUp:
	;animate
	ld a,(yTick)
	inc a
	and 7
	ld (yTick),a
	add a,a
	ld b,0
	ld c,a
	ld hl,yFrames
	add hl,bc
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	ld (sprites+4*18),hl

	ld hl,(heroPos)
	dec h
	dec h
;	dec h
;	dec h
	ld (heroPos),hl
	ld (sprites+4*18+2),hl
	call restoreLeft
	call restoreMiddle

	ld a,(yCount)
	dec a
	ld (yCount),a
	or a
	ret nz

	ld a,HERO_STAND
	ld (heroState),a

	jp tryMoveUp

	ret

doHeroDown:
	;animate
	ld a,(yTick)
	inc a
	and 7
	ld (yTick),a
	add a,a
	ld b,0
	ld c,a
	ld hl,yFrames
	add hl,bc
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	ld (sprites+4*18),hl

	ld hl,(heroPos)
	inc h
	inc h
;	inc h
;	inc h
	ld (heroPos),hl
	ld (sprites+4*18+2),hl


	call restoreLeft
	call restoreMiddle

	ld a,(yCount)
	dec a
	ld (yCount),a
	or a
	ret nz

	ld a,HERO_STAND
	ld (heroState),a


	jp tryMoveDown

	ret

showAnima:	dw eSprites+24*2*47,eSprites+24*2*46,eSprites+24*2*45,eSprites+24*2*44,eSprites+24*2*31
		dw eSprites+24*2*30,eSprites+24*2*29
		db 255,255 


winAnima:	dw eSprites+24*2*29,eSprites+24*2*30,eSprites+24*2*31,eSprites+24*2*44,eSprites+24*2*45
		dw eSprites+24*2*46,eSprites+24*2*47
		db 255,255 

playOneTimeShow:
	ld a,1
	xor 1
	ld (playOneTimeShow+1),a
	or a
	ret z

	ld hl,(heroPos)
	ld (sprites+4*18+2),hl
pots:	ld hl,showAnima
	;get frame we need
	ld e,(hl);low
	inc hl		
	ld a,(hl)
	cp 255
	jr z,3f
	ld d,a
	inc hl
	ld (sprites+4*18),de
	;get draw proc	
	ld de,DRAW2
	ld (sprites+4*18+4),de
	ld (pots+1),hl
	ret
3:
	ld a,GS_GAMEPLAY
	ld (gameState),a
	ret


playOneTimeWin:
	ld a,1
	xor 1
	ld (playOneTimeWin+1),a
	or a
	ret z

potw:	ld hl,winAnima
	;get frame we need
	ld e,(hl);low
	inc hl		
	ld a,(hl)
	cp 255
	jr z,3f
	ld d,a
	inc hl
	ld (sprites+4*18),de
	;get draw proc	
	ld de,DRAW2
	ld (sprites+4*18+4),de
	ld (potw+1),hl
	ret
3:
	;put hero off screen
	ld a,160
	ld (sprites+4*18+3),a
	;change door color
	ld a,1
	ld (drClr+1),a
	ret

doHero:
	ld a,(gameState)
	cp GS_WIN
	jr z,playOneTimeWin
	cp GS_SHOW
	jr z,playOneTimeShow
	;add dead
	or a
	ret nz

	;jump and idle
	ld a,(heroState)
	cp HERO_UP
	jp z,doHeroUp
	cp HERO_DOWN
	jp z,doHeroDown
;else do herox
	ld hl,(currentScript)
	;get frame we need
	ld e,(hl);low
	inc hl		
	ld d,(hl)
	ld (sprites+4*18),de
	inc hl
	;get draw proc	
	ld e,(hl)	
	inc hl
	ld d,(hl)
	inc hl
	ld (sprites+4*18+4),de
	;get hero pos delta
	ld e,(hl);get x
	inc hl

	;restore proc
	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl
	ld (rProc+1),bc
	;get REAL x delta
	ld c,(hl)
	ld a,(heroRealX)
	add c
	ld (heroRealX),a
	inc hl
;==============================
	inc hl
	;check end
	;if high =255 then end of script
	ld a,(hl)
	cp 255
	jr nz,1f
;OK STOPS
;check EXIT
	;=================
	ld a,(totalBlocks)
	or a
	jr nz,9f
	push hl
	push de
	ld de,(heroTilePos)
	call getTile
	cp TILE_DOOR
	jr nz,4f
	ld a,GS_WIN
	ld (gameState),a
	ld a,6
	ld (soundToPlay+1),a

4:
	pop de
	pop hl
9:

;STOPED STOPED

	ld hl,scriptStand+1
	xor a
	ld (heroState),a;reset hero state
1:
        dec hl
	ld (currentScript),hl

	ld a,(heroPos)
	add e
	ld l,a
	ld a,(heroPos+1)
	ld h,a
	
	ld (sprites+4*18+2),hl
	ld (heroPos),hl

rProc:	call nullProc


	ret

restoreLeftMiddleHL:
	push hl
	pop iy
	ld e,(iy+6)
	ld d,(iy+7)
	ld l,(iy+12)
	ld h,(iy+13)
	call restoreCollumnPixels2
	ld e,(iy+8)
	ld d,(iy+9)
	ld l,(iy+12)
	ld h,(iy+13)
	ld bc,320
	add hl,bc
	jp restoreCollumnPixels2	

restoreLeftHL:
	push hl
	pop iy
	ld e,(iy+6)
	ld d,(iy+7)
	ld l,(iy+12)
	ld h,(iy+13)
;	ld de,(sprites+0*18+6)
;	ld hl,(sprites+0*18+12);addr in shadow 1
	jp restoreCollumnPixels2

restoreMiddleHL:
	push hl
	pop iy
	ld e,(iy+8)
	ld d,(iy+9)
	ld l,(iy+12)
	ld h,(iy+13)
;	ld de,(sprites+0*18+8)
;	ld hl,(sprites+0*18+12);addr in shadow 1
	ld bc,320
	add hl,bc
	jp restoreCollumnPixels2

restoreRightHL:
	push hl
	pop iy
	ld e,(iy+10)
	ld d,(iy+11)
	ld l,(iy+12)
	ld h,(iy+13)
;	ld de,(sprites+0*18+10)
;	ld hl,(sprites+0*18+12);addr in shadow 1
	ld bc,640
	add hl,bc
	jp restoreCollumnPixels2

restoreLeft:
	ld de,(sprites+4*18+6)
	ld hl,(sprites+4*18+12);addr in shadow 1
	jp restoreCollumnPixels2

restoreMiddle:
	ld de,(sprites+4*18+8)
	ld hl,(sprites+4*18+12);addr in shadow 1
	ld bc,320
	add hl,bc
	jp restoreCollumnPixels2

restoreRight:
	ld de,(sprites+4*18+10)
	ld hl,(sprites+4*18+12);addr in shadow 1
	ld bc,640
	add hl,bc
	jp restoreCollumnPixels2


swapPage:
	add 16
	ld (restorePage+1),a
	ld bc,#7ffd
	out (c),a
	ret
                    
	include "include\DEC40.asm"
;bgPacked:	incbin "res\bg.scr.mlz"


initGame:
;clea screen
	xor a
	out (254),a
	ld a,7 : call swapPage
	ld hl,bgPacked
	ld de,16384
	call DEC40
	ld hl,soundBank	;樠  䥪⮢
	call AFXINIT

	xor a : call swapPage
	ret	

;================interrupt enable===================
IMON:
       ld a,195 ; jp
       ld (#bfbf),a
       ld (#bfbf+1),hl; 室

       ld hl,#be00
       ld a,h;訩   ⠡
       ld de,#be01
       ld bc,256
       ld (hl),#bf
       ldir

       ;⠡  be00-beff+1
       ;jp    뢠  bfbf             
       LD    I,A
       IM 2
       ei
       ret

exitSolid:
	ld a,TILE_SOLID
	ret

;d = x e = y in map TILE coords
;ret a - tile num
getTile:
	;check boundares
	ld a,e
	cp 255
	jp z,exitSolid
	cp 12
	jp z,exitSolid
	ld a,d
	cp 255
	jp z,exitSolid
	cp 21
	jp z,killHero;exitNull

	ld h,high mapTable
;	ld a,d
	add a,a
	ld l,a
	ld a,(hl)
	inc l
	ld h,(hl)
	ld l,a

	ld c,e
	ld b,0
	add hl,bc
	ld a,(hl)

	ret

initMaps:
	ld hl,liftMap
	ld de,liftMap+1
	ld bc,24*20-1
	ld (hl),0
	ldir
	ld hl,wpMap
	ld de,wpMap+1
	ld bc,12*20-1
	ld (hl),255
	ldir
	ret


map:	;incbin "levels\map.bin"
	block 240,0
;array of waypoints for enemies
wpMap: block 12*20,255   ;240 bytes only
;array of lifts links
liftMap: block 24*20,0



getWp:
	ld h, high wpMapTable
;	call
;	ret
;h - high of table
;de - coords
;d=y
;e=x in tile coords
getAtAddr:
	ld a,d
	add a,a
	ld l,a
	ld a,(hl)
	inc l
	ld h,(hl)
	ld l,a
	;add x
	ld d,0
	add hl,de
	ld a,(hl)
	ret


;de - coords
;d=y
;e=x in tile coords
getLiftMapAddr:
	ld a,d
	add a,a
	ld l,a
	ld h,0
	ld bc,liftMapTable
	add hl,bc

	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a

	;add x
	ld d,0
	ld a,e
	add a,a;one cel=2 bytes of address
	ld e,a
	add hl,de
	ret

;=random
getRandom:
	ld hl,rnd4
	ld a,(hl)
	inc l
	ld (getRandom+1),hl
	ret

	align 256
wpDirs:	db DIR_LEFT,DIR_LEFT,DIR_LEFT,DIR_LEFT ;0
	db DIR_RIGHT,DIR_RIGHT,DIR_RIGHT,DIR_RIGHT ;1
	db DIR_DOWN,DIR_DOWN,DIR_DOWN,DIR_DOWN     ;2
	db DIR_UP,DIR_UP,DIR_UP,DIR_UP            ;3

	db DIR_UP,DIR_UP,DIR_RIGHT,DIR_RIGHT       ;4
	db DIR_UP,DIR_UP,DIR_LEFT,DIR_LEFT         ;5
	db DIR_DOWN,DIR_DOWN,DIR_RIGHT,DIR_RIGHT   ;6
	db DIR_DOWN,DIR_DOWN,DIR_LEFT,DIR_LEFT   ;7

	db DIR_UP,DIR_UP,DIR_LEFT,DIR_RIGHT   ;8
	db DIR_DOWN,DIR_DOWN,DIR_LEFT,DIR_RIGHT   ;9
	db DIR_DOWN,DIR_UP,DIR_LEFT,DIR_LEFT   ;10
	db DIR_DOWN,DIR_UP,DIR_RIGHT,DIR_RIGHT   ;11

	db DIR_RIGHT,DIR_RIGHT,DIR_LEFT,DIR_LEFT   ;12
	db DIR_DOWN,DIR_UP,DIR_DOWN,DIR_DOWN   ;13

	db DIR_DOWN,DIR_UP,DIR_LEFT,DIR_RIGHT   ;14
	align 256
wpMapTable:
N=0
        dup 20
	dw wpMap+N*12
N=N+1
	edup	

;ugly rnd with a rand of 0..3
	align 256
rnd4:	incbin "include\rnd.rnd"
	align 256
liftMapTable:	
N=0
        dup 20
	dw liftMap+N*24
N=N+1
	edup

	align 256
;12x20
mapTable:
N=0
	dup 20
	dw map+N*12
N=N+1
	edup
	dw map
	dw map


liftList:
	;16 lifts max
	dup 24
	dw 00000 ;addr of lift in mcbuffer1
	dw 00000 ;lift tile coords
	db 1	;height
	edup
	;fake small lift
	dw 00000 ;addr of lift in mcbuffer1
	dw 00000 ;lift tile coords
	db 1	;height
initLifts:
	ld a,1*8+6+64
	ld (activeLiftColor+1),a
	ld (activeLiftColor2+1),a
	ld hl,liftList+24*5
	ld (activeLift+2),hl
	ld (activeLift2+2),hl

	;reset list pointer
	ld hl,liftList
	ld (liftPointer),hl
	;clear all lifts
	ld hl,liftList
	ld de,liftList+1
	ld bc,5*24-1
	ld (hl),0
	ldir
	ret

doorAdr: dw 00000
addDoor:
	push de
	push hl
	;calc in mctable1 adr and save
	ld bc,mcTable1
	ld l,d : ld h,0
	add hl,hl : add hl,hl : add hl,hl: add hl,hl
	add hl,bc

	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	
	;add x
	ld d,0
	ld a,e
	add a,a
	ld e,a
	add hl,de

	ld (doorAdr),hl

	pop hl
	pop de
	;put door to level
	ld a,TILE_DOOR
	ret
;de - in level tile coords
addLift:
	halt
	ld ix,(liftPointer)
	;save coords
;	ld (ix+2),e
;	ld (ix+3),d
	push de;save coords

;===================================
	push de
	call getLiftMapAddr
	push hl

	exx
	pop hl

	ld de,(liftPointer)
	ld bc,-24
	add hl,bc
	ld (hl),e
	inc hl
	ld (hl),d

	ld bc,23
	add hl,bc
	ld (hl),e
	inc hl
	ld (hl),d
;	ld bc,23
	add hl,bc
	exx

	pop de
;===================================

	push de
	ld a,d
	add a,a
	add a,a
	add a,a
	;
	ld h,0 : ld l,a
	add hl,hl
	ld bc,mcTable1
	add hl,bc

	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	;add x
	ld a,e
	add a,a
	ld e,a
	ld d,0	
	add hl,de

	pop de

;	ld hl,mcBuffer1;+4096
	ld (ix),l
	ld (ix+1),h


	ex af,af'
	ld a,1;default height
	ex af,af'
1:	
;================================
	inc d;y
	call getTile
	cp TILE_LIFT1
	jp z,8f
	cp TILE_END
	jp nz,2f
8:
	ex af,af'
	inc a
	ex af,af'

	exx
	ld (hl),e
	inc hl
	ld (hl),d
	add hl,bc
	exx


	jr 1b	
2:	

	;ok in a - height in tiles
	ex af,af'
	add a,a
	add a,a
	dec a
;	add a,a
;	sub 1;minus 2 up rows
	ld (ix+4),a
	ex af,af'

	;step to net lift
	inc ix: inc ix: inc ix: inc ix : inc ix
	ld (liftPointer),ix

	pop de;restore coords
	ld a,TILE_LIFT;restore lift

	ret

liftPointer:	dw liftList

doLift:

	ret
;ix - lift pointer
;a - attrib 2*8+6+64
fillLift:
        push af
	ld a,(pg1+1)
	ld bc,#7ffd
	out (c),a
;	ld ix,liftList+2*3
	ld l,(ix)   ;adr
	ld h,(ix+1);adr
	ld b,(ix+4);height

	ld de,24   ;stop
	;skip 2 top attribs
	add hl,de
	add hl,de
	dec de;23

	ld de,48-1


	pop af;restore lift color

1:
	ld (hl),a
	inc hl
	ld (hl),a
	add hl,de
	djnz 1b

	ld a,16+0
	ld bc,#7ffd
	out (c),a

	ret


doLifts:
	;draw active list
activeLift:		ld ix,liftList+24*5;16*5 - fake lift
activeLiftColor:
	ld a,1*8+6+64
	call fillLift
	;check if we need disable it
	;if last fill was 1*8+6=64 than switch to fake lift
	ld a,(activeLiftColor+1)
	cp 1*8+6+64
	jr nz,1f
	ld hl,liftList+24*5
	ld (activeLift+2),hl
1:

	;draw active list
activeLift2:		ld ix,liftList+24*5;16*5 - fake lift
activeLiftColor2:
	ld a,1*8+6+64
	call fillLift
	;check if we need disable it
	;if last fill was 1*8+6=64 than switch to fake lift
	ld a,(activeLiftColor2+1)
	cp 1*8+6+64
	jr nz,1f
	ld hl,liftList+24*5
	ld (activeLift2+2),hl
1:
	ret

deactivateLift2:
	ld hl,liftList+24*5
	ld a,1*8+6+64
	ld (activeLiftColor2+1),a
	;reset lift busy flag
	xor a
	ld (liftBusy),a
	ret
activateLift2:

	push de

	;set lift busy flag
	ld a,1
	ld (liftBusy),a

	call getLiftMapAddr
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	;ld hl,liftList+16*5
	ld (activeLift2+2),hl
	ld a,2*8+6+64
	ld (activeLiftColor2+1),a
	pop de
	ret


SINMAKE INC     C
        LD      HL,SIN_DAT
        PUSH    BC
        LD      B,E
LP_SMK1 PUSH    HL
        LD      H,(HL)
        LD      L,B
        LD      A,#08
LP_SMK2 ADD     HL,HL
        JR      NC,$+3
        ADD     HL,BC
        DEC     A
        JR      NZ,LP_SMK2
        LD      A,H
        LD      (DE),A
        POP     HL
        INC     HL
        INC     E
        BIT     6,E
        JR      Z,LP_SMK1
        LD      H,D
        LD      L,E
        DEC     L
        LD      A,(HL)
        LD      (DE),A
        INC     E
LP_SMK3 LD      A,(HL)
        LD      (DE),A
        INC     E
        DEC     L
        JR      NZ,LP_SMK3
LP_SMK4 LD      A,(HL)
        NEG
        LD      (DE),A
        INC     L
        INC     E
        JR      NZ,LP_SMK4
        POP     BC
LP_SMK5 LD      A,(DE)
        ADD     A,B
        LD      (DE),A
        INC     E
        JR      NZ,LP_SMK5
        RET

SIN_DAT
	DB  #00,#06,#0D,#13,#19,#1F,#25,#2C
	DB  #32,#38,#3E,#44,#4A,#50,#56,#5C
	DB  #62,#67,#6D,#73,#78,#7E,#83,#88
	DB  #8E,#93,#98,#9D,#A2,#A7,#AB,#B0
	DB  #B4,#B9,#BD,#C1,#C5,#C9,#CD,#D0
	DB  #D4,#D7,#DB,#DE,#E1,#E4,#E7,#E9
	DB  #EC,#EE,#F0,#F2,#F4,#F6,#F7,#F9
	DB  #FA,#FB,#FC,#FD,#FE,#FE,#FF,#FF

;camera deltas
	align 256
cameraDeltas:  block 256,0

	align 256
tilesTable:
N=0
	dup 128
	dw tiles + 48*N
N=N+1
	edup
	align 256
sin1:	
kempstonTest:
	EI
	HALT
	LD E,0
	LD BC,#001F
	IN B,(C)
	LD A,B
	RLCA
	RET C
	LD A,B
	AND 3
	CP 3
	RET Z
	LD A,B
	RRCA
	RRCA
	AND 3
	CP 3
	RET Z
	LD E,1
	RET

;
;  test if this computer has the floating bus (assumes that screen is filled with 0s)
;  Z = port #FF present, NZ = port #FF not present
;
;TestPortFF:		ld	hl, 3125
;			ld	c, #FF
;;			ld	a, c
;LoopTestFF:		in	b, (c)
;			and	b
;			dec	l
;			jr	nz, LoopTestFF		; inner loop takes 12+4+4+12 = 32t
;			dec	h
;			jr	nz, LoopTestFF
;			or	a
;			ret

machineTest:
;machines test
;On 128k models, PEEK 2899 is 159 on a 128 or +2, 126 on a +3 or +2a.
;	ld a,(2899)
;	cp 159
;	ret z;ok 128k and grey +2; 4,6 fast

;get machine type that we have from loader
	ld a,(49151)
	or a
	ret z

;	halt : call TestPortFF

	;patch for +2ab,+3	;1,3 fast
	ld a,4;
	ld (pgOutro),a

	ld a,1
	ld (pg0+1),a
	add 16
	ld (pg1+1),a
	ld (pg2+2),a
	ld (pg3+2),a
	ld a,3+16
	ld (pg4+1),a
	ld (pg5+2),a

	ld a,(pg0+1):call swapPage
	ld hl,49152
	ld de,49153
	ld bc,16383
	ld (hl),0
	ldir

	ld a,(pg4+1): sub 16 : call swapPage
	ld hl,49152
	ld de,49153
	ld bc,16383
	ld (hl),0
	ldir

	xor a: call swapPage

	ret
	align 256;to fix sin

;====scripts===
;========================ENEMY 5 scripts
enemy5Idle:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*0+3*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0+3*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+3*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+3*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0+3*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0+3*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+3*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+3*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	;stop flag
	db 255,255
enemy5Right:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*4+3*32*24: dw DRAW3 : db 0,0 : dw nullProc : db +2
	dw eSprites+24*7+3*32*24: dw DRAW3 : db 0,0 : dw nullProc : db +2
	dw eSprites+24*10+3*32*24: dw DRAW3 : db 0,0 : dw nullProc : db +2
	dw eSprites+24*13+3*32*24: dw DRAW2 : db +1,0 : dw restoreLeftHL : db +2
	dw eSprites+24*15+3*32*24: dw DRAW3 : db 0,0 : dw nullProc : db +2
	dw eSprites+24*18+3*32*24: dw DRAW3 : db 0,0 : dw nullProc : db +2
	dw eSprites+24*21+3*32*24: dw DRAW3 : db 0,0 : dw nullProc : db +2
	dw eSprites+24*0+3*32*24: dw DRAW2 : db +1,0 : dw restoreLeftHL : db +2
	;stop flag
	db 255,255

enemy5Left:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*21+3*32*24: dw DRAW3 : db -1,0 : dw nullProc : db -2
	dw eSprites+24*18+3*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*15+3*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*13+3*32*24: dw DRAW2 : db 0,0 : dw restoreRightHL : db -2
	dw eSprites+24*10+3*32*24: dw DRAW3 : db -1,0 : dw nullProc : db -2
	dw eSprites+24*7+3*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*4+3*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*0+3*32*24: dw DRAW2 : db 0,0: dw restoreRightHL : db -2
	;stop flag
	db 255,255
;========================ENEMY 4 scripts
enemy4Right:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*4+2*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*7+2*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*10+2*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*13+2*32*24: dw DRAW2 : db +1,0 : dw restoreLeftHL : db 2
	dw eSprites+24*15+2*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*18+2*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*21+2*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*0+2*32*24: dw DRAW2 : db +1,0 : dw restoreLeftHL : db 2
	;stop flag
	db 255,255

enemy4Left:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*21+2*32*24: dw DRAW3 : db -1,0 : dw nullProc : db -2
	dw eSprites+24*18+2*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*15+2*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*13+2*32*24: dw DRAW2 : db 0,0 : dw restoreRightHL : db -2
	dw eSprites+24*10+2*32*24: dw DRAW3 : db -1,0 : dw nullProc : db -2
	dw eSprites+24*7+2*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*4+2*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,0: dw restoreRightHL : db -2
	;stop flag
	db 255,255
enemy4Idle:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	;stop flag
	db 255,255

enemy4Down:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	;stop flag
	db 255,255

enemy4Up:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	;stop flag
	db 255,255

enemy4Flip:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dup 2
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+1*15*48: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+1*15*48: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+1*15*48: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+2*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+1*15*48: dw DRAW2 : db 0,0 : dw nullProc : db 0
	edup
	;stop flag
	db 255,255
;========================ENEMY 2
enemy2Idle:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*0+1*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0+1*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0+1*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0+1*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,0 : dw nullProc : db 0
	;stop flag
	db 255,255
enemy2Right:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*4+1*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*7+1*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*10+1*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*13+1*32*24: dw DRAW2 : db +1,0 : dw restoreLeftHL : db 2
	dw eSprites+24*15+1*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*18+1*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*21+1*32*24: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*0+1*32*24: dw DRAW2 : db +1,0 : dw restoreLeftHL : db 2
	;stop flag
	db 255,255

enemy2Left:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*21+1*32*24: dw DRAW3 : db -1,0 : dw nullProc : db -2
	dw eSprites+24*18+1*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*15+1*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*13+1*32*24: dw DRAW2 : db 0,0 : dw restoreRightHL : db -2
	dw eSprites+24*10+1*32*24: dw DRAW3 : db -1,0 : dw nullProc : db -2
	dw eSprites+24*7+1*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*4+1*32*24: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*0+1*32*24: dw DRAW2 : db 0,0: dw restoreRightHL : db -2
	;stop flag
	db 255,255

enemy2Up:
;sprite drawer
	;frames,howdraw,deltax,deltay,restore procedure
	dw eSprites+24*24+1*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*24+1*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*24+1*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*24+1*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,-1 : dw restoreLeftMiddleHL : db 0
	;stop flag
	db 255,255

enemy2Down:
;sprite drawer
	;frames,howdraw,deltax,deltay,restore procedure
	dw eSprites+24*24+1*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*24+1*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*24+1*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*24+1*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*2+1*32*24: dw DRAW2 : db 0,1 : dw restoreLeftMiddleHL : db 0
	;stop flag
	db 255,255
;=======================ENEMY1
enemy1Idle:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*0: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*0: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2: dw DRAW2 : db 0,0 : dw nullProc : db 0
	dw eSprites+24*2: dw DRAW2 : db 0,0 : dw nullProc : db 0
	;stop flag
	db 255,255
enemy1Right:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*4: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*7: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*10: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*13: dw DRAW2 : db +1,0 : dw restoreLeftHL : db 2
	dw eSprites+24*15: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*18: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*21: dw DRAW3 : db 0,0 : dw nullProc : db 2
	dw eSprites+24*0: dw DRAW2 : db +1,0 : dw restoreLeftHL : db 2
	;stop flag
	db 255,255

enemy1Left:
;sprite drawer
	;frames,howdraw,deltax,restore procedure
	dw eSprites+24*21: dw DRAW3 : db -1,0 : dw nullProc : db -2
	dw eSprites+24*18: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*15: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*13: dw DRAW2 : db 0,0 : dw restoreRightHL : db -2
	dw eSprites+24*10: dw DRAW3 : db -1,0 : dw nullProc : db -2
	dw eSprites+24*7: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*4: dw DRAW3 : db 0,0 : dw nullProc : db -2
	dw eSprites+24*0: dw DRAW2 : db 0,0: dw restoreRightHL : db -2
	;stop flag
	db 255,255

enemy1Down:
;sprite drawer
	;frames,howdraw,deltax,deltay,restore procedure
	dw eSprites+24*24: dw DRAW2 : db 0,2 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*24: dw DRAW2 : db 0,2 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*0: dw DRAW2 : db 0,2 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*0: dw DRAW2 : db 0,2 : dw restoreLeftMiddleHL : db 0
	;stop flag
	db 255,255

enemy1Up:
;sprite drawer
	;frames,howdraw,deltax,deltay,restore procedure
	dw eSprites+24*24: dw DRAW2 : db 0,-2 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*24: dw DRAW2 : db 0,-2 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*0: dw DRAW2 : db 0,-2 : dw restoreLeftMiddleHL : db 0
	dw eSprites+24*0: dw DRAW2 : db 0,-2 : dw restoreLeftMiddleHL : db 0
	;stop flag
	db 255,255



	display /d,"pre 32768: ",32768-$

	org 32768
;restore buffers for attribute
	align 256
N=0
	dup 128
;	dw  mcBuffer1+4096-N*24
	dw 0
N=N+1
	edup
	align 256
realRestore:
N=0
	dup 128
	dw 0
;	dw  mcBuffer1+4096-N*24
N=N+1
	edup

        include "sound/tbkplayer.aligned.asm"

;	align 256

;adresses for level in tiles coords
levelTable:
N=0
	dup 160
	dw 49152+51*N+51-3
N=N+2
	edup
	block 32,0;for draw off screen

	align 256
shadowTable:
N=0
	dup 24
	dw 49152+320*N
N=N+1
	edup
	block 32,0;for draw off screen

mcTable:
N=0
	dup 160
	dw mcBuffer+24*N
N=N+1
	edup
	block 32,0;for draw off screen
mcTable1:
N=0
	dup 160
	dw mcBuffer1+24*N
N=N+1
	edup

	block 32,0;for draw off screen

mcTable2:
N=0
	dup 160
	dw mcBuffer2+24*N
N=N+1
	edup

	block 32,0;for draw off screen

table51:
N=0
	dup 320
	dw 49152+N*51
N=N+1
	edup

AYbuffer:  ds 32, 0
	include "sound\afx.asm"
soundBank:	incbin "sound\game.afb"


totalBlocks:	db 0
mcPos:	dw mcBuffer

camY:	db 0
doCamera:
	ld a,(heroPos+1)
sinAdd:	add 0
	sub 26
	jr nc,1f;if>0 then ok
	xor a	
	jr 2f
1:
	cp 68+26
	jr c,2f
	ld a,68+26

2:

	ld e,a;save hero pos
	ld a,(camY);camera

	;if same everything ok
	cp e
	jr z,1f
	jr c,2f
;camera more
	ld d,a;save camera pos
	sub e
	srl a
	srl a
	srl a
	inc a
	ld e,a
	ld a,d
	sub e
;	dec a
	jr 1f
;camera less
2:
	ld d,a;save camera to d
	ld a,e;hero to a
	sub d;get dif
	srl a
	srl a
	srl a
	inc a
	ld e,a
	ld a,d
	add e

1:
	ld (camY),a
	ld (camPos+1),a

;ok scroll pixels
	ld de,table51
	;
camPos:	ld hl,00064
	add hl,hl;x2 since 8x2
	add hl,hl;2 bytes per addr
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a

;	ld hl,49152

	;now in hl addr of line
	ld (startPixel+1),hl

	IFDEF PENTAGON
	ld de,51*79
	ELSE
	ld de,51*69
	ENDIF

	add hl,de
	ld (fix+1),hl
	ld (startPixel2+1),hl

	IFDEF PENTAGON
	ld de,51*49
	ELSE
	ld de,51*59
	ENDIF



	add hl,de
	ld (fix2+1),hl

	;and now multicolor
	ld hl,(camPos+1)
	add hl,hl
	add hl,hl
	add hl,hl
	push hl
	add hl,hl
	pop de
	add hl,de
	ld de,mcBuffer
	add hl,de
	ld (mcPos),hl
	ret

;deltas to draw in our fucked ld push screen
;xx00xx00
;+1,+3   +3,+1 e.t.s
;deltas:	
;	db 1,3,3,1
;de-level coords
;hl - attribs 8 attribs only width=2
;d=y*8
;e=x*2
paintTileLevel:
	push hl
;draw only in 3 mcolor buffers and in main mc buffer
	ld a,e
	add a,a
	ex af,af'

	ld a,d
	add a,a;x2
	add a,a;x4
	add a,a;x8
	
	ld l,a
	ld h,0
	add hl,hl

	ld de,mcTable1
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	;hl point to line in mcbuffer
	;add x

	ex af,af'
	ld d,0
	ld e,a
	add hl,de
	;ok draw in 3 buffers errr
	pop de

	ld a,(pg1+1)
	ld bc,#7ffd
	out (c),a

	ld bc,23

	push hl
	push de
	call paint
	pop de
	pop hl
	res 4,h
	set 5,h
	push hl
	push de
	call paint
	pop de
	pop hl
	res 5,h
	call paint

	ld a,16+0
	ld bc,#7ffd
	out (c),a


	ret

paint:
	dup 3
	ld a,(de) ;7
	ld (hl),a ;7
	inc hl    ;6
	ld (hl),a ;7
	inc de    ;6
	add hl,bc ;11
	edup
	org $-1

	ret
;a-tile
;de-level coords
;d=y*8
;e=x*2
drawTileLevel:
	ex af,af'
	ld a,d
	add a,a
	add a,a
	add a,a
	ld b,a

	
	ld a,e
	add a,a
	ld c,a

	;if even add 2
;	ld a,e
;	rra
;	jr nc,1f
;	inc b;inc y	
;
;1:
	ex af,af'

;a - tile
;bc - coords
; c = 0,1...23
; b = 0,1,2,3,4...159
drawTile:
;=========calc a shodow screen line and put to dtShadow+1
	push af
	push bc
	ld a,c;column<256
	add a,a;addr 2 bytes
	ld h,high shadowTable
	ld l,a
	ld a,(hl)
	inc l
	ld h,(hl);
	ld l,a
	;hl is line add x
	;but x 320 so 16bit reg need
	ex de,hl;save addr to de
	ld l,b
	ld h,0
	add hl,hl;x2 b = 0-160 but in real is 320 pixels
	add hl,de
;	ld hl,00000
	ld (dtShadow+1),hl
	pop bc
	pop af
;======================================================

	exx
	ld bc,#7ffd
pg2:	ld de,16+(16+4)*256
pg5:	ld hl,16+(16+6)*256
	exx
;==== calc addr for tile====
	ld h,high tilesTable
	add a,a
	ld l,a
	ld a,(hl)
	inc l
	ld h,(hl)
	ld l,a
	ld (dcTile2+1),hl
	ld (dcpTile+1),hl
;==== calculate mcolor addr ====
	ld l,b;get y
	ld h,0
	add hl,hl;x2
	ex de,hl;4
mcFix1:	ld hl,mcTable
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	;add x
	ld b,0
	add hl,bc;add X
	;save mc address
	push hl
;========================================
;======= pixel addr and delta for next collumn calc
;	d=y e=x
	ld hl,levelTable
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	;now add x(!) a most fun part with our screen loyout
	ld a,c
	rra
	ld a,c
	jr nc,1f;0,2,4
;1,3,5
	inc hl  ;6
	dec a   ;4
	add a,a ;4
	ld c,a
	ld de,-5
	ld (delta1+1),de
	jr 2f   
1:
	nop	;4
	inc de;6t for fix
	ld b,0;+7t for fix time
	add a,a ;4
	ld c,a
	ld de,+1
	ld (delta1+1),de
2:
	sbc hl,bc
;	ld hl,49152+4
;========================================
	pop de;restore mcolor adress

	;save draw and mc addr
	push hl
	push de

;draw also to shadow buffer
;===========================================
	push hl
	push de
;hl gets from dtShadow+1
	call drawCollumnPixels
	pop de
	pop hl
;===========================================

	call drawCollumn2



	pop de
	pop hl
	inc de;mcolor is linear
	;add delta to mc
delta1:	ld bc,00000
	add hl,bc;pixels unlenear ^)

;draw also to shadow buffer
;===========================================
	push hl
	push de
;hl gets from dtShadow+1
	call drawCollumnPixels
	pop de
	pop hl
;===========================================

	jp drawCollumn2
;	ret

;3column tile
;bc - coords
;de - where to save restore bytes
;hl - draw or not 3 collumn hl = #57+#67 - not draw hl=#52+#64 draw
;ix - where save a restore addr for screen
;iy - tiles pointer
; c = 0,1...23
; b = 0,1,2,3,4...159
;lom: dw 00000
drawTileWide:
	ld (dcTile+1),iy
	ld (lom),hl
	push de;save restore bytes
	exx
	pop hl;save restore bytes to alt hl'
	exx
;==== calculate addr in shadow buffer for restore pixels
	push bc
	ld a,c;column<256
	add a,a;addr 2 bytes
	ld h,high shadowTable
	ld l,a
	ld a,(hl)
	inc l
	ld h,(hl);
	ld l,a
	;hl is line add x
	;but x 320 so 16bit reg need
	ex de,hl;save addr to de
	ld l,b
	ld h,0
	add hl,hl;x2 b = 0-160 but in real is 320 pixels
	add hl,de
;	ld hl,tmp
	ld (ix+12),l
	ld (ix+13),h
;and other collums too
;	ld de,320
;	add hl,de
;	ld (ix+14),l
;	ld (ix+15),h
;	add hl,de
;	ld (ix+16),l
;	ld (ix+17),h
	pop bc
;==== calculate mcolor addr ====
	ld l,b;get y
	ld h,0
	add hl,hl;x2
	ex de,hl;4

mcFix2:	ld hl,mcTable
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	;add x
	ld b,0
	add hl,bc;add X
	;save mc address
	push hl
;============================================
	;save 8 lines to restore
	push hl
	exx
	ld bc,24
	pop de;get mc address back
	dup 8
	ld (hl),e
	inc l
	ld (hl),d
	inc l
	ex de,hl
	add hl,bc
	ex de,hl
	edup
	org $-3
	exx
;========================================
;======= pixel addr and delta for next collumn calc
;	d=y e=x
	ld hl,levelTable
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	;now add x(!) a most fun part with our screen loyout
	ld a,c
	rra
	ld a,c
	jr nc,1f;0,2,4
;1,3,5
	inc hl  ;6
	dec a   ;4
	add a,a ;4
	ld c,a
	ld de,-5
	ld (delta2+1),de
	ld de,+1
	ld (delta3+1),de
	jr 2f   
1:
	nop	;4
	inc de;6t for fix
	ld b,0;+7t for fix time
	add a,a ;4
	ld c,a
	ld de,+1
	ld (delta2+1),de
	ld de,-5;-4
	ld (delta3+1),de
2:
	sbc hl,bc

	;(!)we need save it for next restore
	ld (ix+6),l
	ld (ix+7),h
;========================================
	pop de;restore mcolor adress

	;save draw and mc addr
	push hl
	push de
	;hl - where draw pixels
	;de - where draw mcolor

	;set pages
	exx
	ld bc,#7ffd
pg3:	ld de,16+(16+4)*256
	exx

	call drawCollumn
	pop de
	pop hl
	inc de;mcolor is linear
	;add delta to pix
delta2:	ld bc,00000
	add hl,bc;pixels unlenear ^)

	;(!)we need save it for next restore
	ld (ix+8),l
	ld (ix+9),h

	push hl
	push de
	call drawCollumn
	pop de
	pop hl
;check if we need skip last collumn with fixed time
;set h=0 d=0 it cause draw to ROM with same timings
	xor a
lom:	ld h,h
	ld d,d

	inc de;mcolor is linear
delta3: ld bc,00000
	add hl,bc
	;(!)we need save it for next restore
	ld (ix+10),l
	ld (ix+11),h
;	jp drawCollumn
;	ret

;drawCollumn
;in: 
; hl: where draw
; 650t
drawCollumn:
	ld (dcMC+1),de	;20
	ld (dcSP+1),sp  ;20

dcTile:	ld sp,00000     ;10

	ld bc,51 ;10
;=====================================
	dup 8
	pop de		;10
	ld (hl),e	;7
	add hl,bc	;11
	ld (hl),d	;7
	add hl,bc	;11            
	edup
	org $-1
;==================================357t

dcMC:   ld hl,00000     ;10

	exx
	out (c),d
	exx

	ld bc,24 ;10
;======================================
	dup 4
;	pop de		;10
;	ld (hl),e	;7
;	add hl,bc	;11
;	ld (hl),d	;7
;	add hl,bc	;11

;cut ink from bg and put sprite ink to it

	pop de		;10
	ld a,(hl)       ;7
	and 01111000b   ;7
	or e            ;4
	ld (hl),a       ;7
	add hl,bc       ;11
	ld a,(hl)       ;7
	and 01111000b   ;7
	or d            ;4
	ld (hl),a       ;7
	add hl,bc       ;11
	edup

	org $-1
;==================================173t
	;resave a tiles pointer
	ld (dcTile+1),sp   ;20

	exx
	out (c),e
	exx

dcSP:	ld sp,00000        ;10

	ret

drawCollumn2:
	ld (dcMC2+1),de	;20
	ld (dcSP2+1),sp  ;20

dcTile2:	ld sp,00000     ;10

	ld bc,51 ;10
;=====================================
	dup 8
	pop de		;10
	ld (hl),e	;7
	add hl,bc	;11
	ld (hl),d	;7
	add hl,bc	;11            
	edup
	org $-1
;==================================357t

dcMC2:   ld hl,00000     ;10

	exx
	out (c),d
	exx

	ld bc,24 ;10
;======================================
	dup 4
	pop de		;10
	ld (hl),e	;7
	add hl,bc	;11
	ld (hl),d	;7
	add hl,bc	;11

;cut ink from bg and put sprite ink to it

;	pop de		;10
;	ld a,(hl)       ;7
;	and 01111000b   ;7
;	or e            ;4
;	ld (hl),a       ;7
;	add hl,bc       ;11
;	ld a,(hl)       ;7
;	and 01111000b   ;7
;	or d            ;4
;	ld (hl),a       ;7
;	add hl,bc       ;11
	edup

	org $-1
;==================================173t
	;resave a tiles pointer
	ld (dcTile2+1),sp   ;20

	exx
	out (c),e
	exx

dcSP2:	ld sp,00000        ;10

	ret


; hl: where draw its a shadow address
; 650t
drawCollumnPixels:

dtShadow:	ld hl,0
	ld (dcpSP+1),sp  ;20
dcpTile:ld sp,00000     ;10

;swap to shadow page
	exx
	out (c),h
	exx
;=====================================
	dup 8
	pop de		
	ld (hl),e	
	inc hl
	ld (hl),d
	inc hl
	edup
	org $-1
;swap back
	exx
	out (c),l
	exx

	;resave hl for next collumn
	ld hl,(dtShadow+1)
	ld bc,320
	add hl,bc
	ld (dtShadow+1),hl

	;step for tile - skip attribs
	ld hl,(dcpTile+1)
	ld bc,16+8
	add hl,bc
	ld (dcpTile+1),hl

	;resave a tiles pointer
;	ld (dcpTile+1),sp   ;20
dcpSP:  ld sp,00000

	ret




restoreBuffer:	block 16,0
;draws in game buffer collumn
;in: bc = coords
; c = 0,1...23
; b = 0,1,2,3,4...159

;it's universal
tmp:	block 32,255
;restoreCollumnPixels:
;	call getPixelAddrs
;entry point when we know addreses

;hl - addr in shadow
;de - where to restore
restoreCollumnPixels2:
	ld (rcpSP+1),sp  ;20
;======= get restore bytes from buffer =====
	ld sp,hl ;what to restore
	;get 16 bytes of collumn from shadow level to restore buffer
;=========================================
;swap page to buffer one
pg4:	ld a,16+6;
	ld bc,#7ffd
	out (c),a
N=0
	dup 8
	pop hl				;10
	ld (restoreBuffer+N),hl         ;16
N=N+2
	edup

	ld a,16+0
	ld bc,#7ffd
	out (c),a


;========================================208t
;HL: where draw SP - what to draw
	ex de,hl ;main scr addr to hl
	ld sp,restoreBuffer     ;10
	ld bc,51 ;10
;=====================================
	dup 8
	pop de		;10
	ld (hl),e	;7
	add hl,bc	;11
	ld (hl),d	;7
	add hl,bc	;11            
	edup
	org $-1
;==================================173t
rcpSP:	ld sp,00000        ;10
	ret

;bc - coords c=0,1,2,3,45
;	     b=line
;out: hl - coords
getPixelAddrs:
	push bc
	ld l,b;get y
	ld h,0
	add hl,hl;x2
	ex de,hl;4
	ld hl,levelTable
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	ld b,0

	;now add x(!) a most fun part with our screen loyout
	ld a,c
	rra
	ld a,c
	jr nc,1f;0,2,4
;1,3,5
	inc hl  ;6
	dec a   ;4
	add a,a ;4
	ld c,a
	jr 2f   
1:
	ld b,0;+7t for fix time
	add a,a ;4
	ld c,a
2:
	sbc hl,bc

	ex de,hl;save to de addr in ugly screen

	;now calc addr in shadow screnn - what we need to restore
	;get coords
	pop bc


	push de

	ld a,c;column<256
	add a,a;addr 2 bytes
	ld h,high shadowTable
	ld l,a
	ld a,(hl)
	inc l
	ld h,(hl);
	ld l,a
	;hl is line add x
	;but x 320 so 16bit reg need
	ex de,hl;save addr to de
	ld l,b
	ld h,0
	add hl,hl;x2 b = 0-160 but in real is 320 pixels
	add hl,de

	pop de

	;shadow table mirrored
;	ld hl,shadowTable
;	ld a,c;column
;	add a,a
;	ld l,a
;	ld a,(hl)
;	inc hl
;	ld h,(hl)
;	ld l,a
;	;add y
;	ld a,b
;	ld b,0
;	ld c,a
;	add hl,bc

	;hl points to restore screen
	;de - points to main screen

	ret


;tiles:
;	incbin "res\tiles.tile"
;eSprites:	incbin "res\enemies.tile";,0,32*48

;no need %256
;we need an adresses of all pixel lines for our screen
;started
pixAddrs:	
globalLine = 24
	dup 16;16*8
XX = 4
line = globalLine % 8
YY = globalLine / 8
a1 = ( YY / 8 ) * 2048
a2 = ( YY % 8) * 32
addr  =  16384 + a1 + a2 +line*256+XX	
	dw addr+24
globalLine = globalLine+8
	edup
;patch proc - path from hl 128 lines with output addresses
patchVideoOut:
;======================
	ld (pvoSP+1),sp

	ld bc,51-1;length-1
	ld sp,pixAddrs

	dup 16
	pop de ;10
	dup 8
	ld (hl),e ;7
	inc hl    ;6
	ld (hl),d ;7
	add hl,bc ;11
	inc d     ;4
	edup
	org $-1
	edup
pvoSP:	ld sp,00000
	ret

top1:
	;160t
	dup 40
	nop
	edup

	IFDEF	PENTAGON
	ld bc,224*8+32
	call DELAY
	ELSE

	ENDIF

	;where to ret and save stack
	ld hl,retret;where to ret
	ld (top1SP+1),sp
	;patch a start and jp (hl) on exit      	
	; jp (hl)  	-       #e9
	; ld sp,nn	-	#31 nn nn
	;set limit; x51
	ld a,#e9

	IFDEF	PENTAGON
fix:	ld (49152+51*89),a;how much lines to draw+1 to set jp (hl)
	ELSE
fix:	ld (49152+51*69),a;how much lines to draw+1 to set jp (hl)
	ENDIF
	;start
startPixel:	jp 49152;*55 bytes per line, first byte is a stack pointer at end of line, then ld push
retret: 
	;ok restore ld sp
	ld a,#31
	ld hl,(fix+1)
	ld (hl),a

top1SP:	ld sp,00000
	ret

initRestoreList:
	ld hl,restoreList
	ld de,restoreList+1
	ld bc,80-1
	ld (hl),0
	ldir
	;and restore buffers
	ld hl,32768
	ld de,32768+1
	ld bc,512-1
	ld (hl),0
	ldir
	ret

restoreList:
	;5 columns by 8
	dup 5*8
	dw 00000;where
	dw 00000;what
	edup
	;5 rows by 8
	dup 5*8
	dw 00000;where
	dw 00000;what
	edup

down1:	          
	ld a,0
	out (254),a             
           
	ld (down1SP+1),sp

;restore
	ld a,(pg1+1)
	ld bc,#7ffd
	out (c),a
;ok restore attribs for every sprite
;	ld (restSP+1),sp
	ld sp,32768+256
	dup 5;5 sprites
	dup 8
	pop de;where restore
	;reset 2 bits to hit a base buffer
	ld a,d;4
	and 11001111b;7
	ld h,a;4
	ld l,e;4
;	ld hl,0	;testing
	ldi : ldi : ldi
	edup
	edup

;copy restore
	ld hl,32768	;10
	ld de,32768+256 ;10
	dup 5*16	;
	ldi
	edup


                                                        
	ld a,16+0
	ld bc,#7ffd
	out (c),a

;swap multicolor buffers for drawing
	ld hl,mcTable1
	ld de,4096*2

swp:	ld a,1
	xor 1
	ld (swp+1),a
	or a
	jr z,1f
	ld hl,mcTable2
	ld de,4096
1:
	ld (mcFix1+1),hl
	ld (mcFix2+1),hl
	ld (bufDelta+1),de


;restSP:	ld sp,00000
;==========================================
	;where to ret and save stack
	ld hl,retret2;where to ret
	;patch a start and jp (hl) on exit      	
	; jp (hl)  	-       #e9
	; ld sp,nn	-	#31 nn nn
	;set limit; x51
	ld a,#e9

	IFDEF PENTAGON
fix2:	ld (49152+51*(89+39)),a;how much lines to draw+1 to set jp (hl)
	ELSE
fix2:	ld (49152+51*(69+59)),a;how much lines to draw+1 to set jp (hl)
	ENDIF

	;start
	IFDEF PENTAGON
startPixel2:	jp 49152+51*89;+55*16*8 ;*55 bytes per line, first byte is a stack pointer at end of line, then ld push
	ELSE
startPixel2:	jp 49152+51*69;+55*16*8 ;*55 bytes per line, first byte is a stack pointer at end of line, then ld push
	ENDIF
retret2: 
	;ok restore ld sp
	ld a,#31
	ld hl,(fix2+1)
	ld (hl),a

down1SP: ld sp,00000

;set mc pos
	ld hl,(mcPos)
bufDelta:	ld bc,00000
	add hl,bc
	ld (mcStart+1),hl


        xor a
	out (254),a
	

	ret

;table fo 5 sprites
sprites:
N=0
	dup 5
	;frame addr
	dw tiles+32*24	;0,1
	;position
	dw 0+160*256; 160 = off screen ;2 3
	;how to draw DRAW3 or DRAW2
	dw DRAW2                       ;4 5
;ix	;address to restore for every collumn
	dw 00000	;6,7
	dw 00000        ;8,9
	dw 00000        ;10,11
	;adress in shadow buffer to restore collumn
	dw 00000	;12,13
	dw 00000	;14,15
	dw 00000	;16,17
N=N+1
	edup

baseSprites:
N=0
	dup 5
	;frame addr
	dw tiles+32*24	;0,1
	;position
	dw 0+160*256; 160 = off screen ;2 3
	;how to draw DRAW3 or DRAW2
	dw DRAW2                       ;4 5
;ix	;address to restore for every collumn
	dw 00000	;6,7
	dw 00000        ;8,9
	dw 00000        ;10,11
	;adress in shadow buffer to restore collumn
	dw 00000	;12,13
	dw 00000	;14,15
	dw 00000	;16,17
N=N+1
	edup

initSprites:
	ld hl,baseSprites
	ld de,sprites
	ld bc,5*18
	ldir
	ret

top2:
	ld a,0
	out (254),a


N=0
	dup 5
	ld iy,(sprites+N*18) ;sprites pointer
	ld bc,(sprites+2+N*18);coords
	;where save restore dataa
	ld de,32768+N*16;restore
	ld hl,(sprites+4+N*18);draw 2 or 3
	ld ix,sprites+N*18;pointer to sprite
	call drawTileWide
N=N+1
	edup

	IFDEF PENTAGON
	ld bc,224*18-32
	call DELAY
	ELSE
	ld bc,228+72+24+24;-32-24
	call DELAY
	ENDIF


	ret

down2:
	jp doMusic
	ret
mute:	db 0
doMusic:
	call AFXFRAME
	;swap music page
mPage:	ld a,7 : call swapPage
	call UnpackPSG ;unpack to buffer
	call TBKPSGPlayer.PSGLOOP

	
  	ld hl, TBKPSGPlayer.BufferPSG
        ld de, AYbuffer
        ld bc, 15
        ldir
        ld a,(mute)
	or a
	jr z,1f

  	ld hl, AYbuffer
        ld de, AYbuffer+1
        ld bc, 14
	ld (hl),0
        ldir
1:

	;reset
soundToPlay:	ld a,254
	cp 254
	jr z,1f
	call SFX
	ld a,254
	ld (soundToPlay+1),a
1:
 ;================================
	ld a,(restorePage+1)
	ld bc,#7ffd
	out (c),a
	ret

getRandomColor:
	call getRandom
;	cp 2
;	jr nc,2f
;	ld a,6*8+6
;	ret
;2:
;	ld a,1*8+1+64
;	add 3
	ld c,a
	add a,a
	add a,a
	add a,a
	add c
	ret
interruptNull:
;; preserve all registers
        push    af
        push    bc
        push    de
        push    hl
        ex      af, af'
        exx
        push    af
        push    bc
        push    de
        push    hl
        push    ix
        push    iy

;ok if flag set then fill screen with black
;!!!!!!!!!!!!rewrite - too much memmory :)
N=3
	dup 16
	call getRandomColor
	ld hl,22528+N*32+4
	ld de,22528+N*32+4+1
	ld bc,23
	ld (hl),a
	ldir
N=N+1
	edup

ntk:	ld a,0
	xor 1
	ld (ntk+1),a
mmm:	call z,doMusic

;any
;	ld a,(restorePage+1)
;;	add 16
;	ld bc,#7ffd
;	out (c),a

        pop     iy
        pop     ix
        pop     hl
        pop     de
        pop     bc
        pop     af
        exx
        ex      af, af'
        pop     hl
        pop     de
        pop     bc
        pop     af

	ei
	ret

interrupt:
; preserve all registers
        push    af
        push    bc
        push    de
        push    hl
        ex      af, af'
        exx
        push    af
        push    bc
        push    de
        push    hl
        push    ix
        push    iy

	ld a,0
	out (254),a

topBorder:	call top2

	xor a
	out (254),a
;mcolor in 4 page
pg1:	ld a,16+4
	ld bc,#7ffd
	out (c),a

        ld (spsp+1),sp

	IFDEF	PENTAGON
	include "include\multicolorPG.a80"
	ELSE
	include "include\multicolor.a80"
	ENDIF

spsp:	ld sp,00000


restorePage:
	ld a,16+0
	ld bc,#7ffd
	out (c),a

	;restore page after interrupt
downBorder:	call down1

	

	xor a
	out (254),a
	

        pop     iy
        pop     ix
        pop     hl
        pop     de
        pop     bc
        pop     af
        exx
        ex      af, af'
        pop     hl
        pop     de
        pop     bc
        pop     af
	ei
	ret

; Z80 delay routine
; by Jan Bobrowski, license GPL, LGPL
DELAY:  ; wait bc T (including call; bc>=141)
	; destroys: af, bc, hl
	ld hl, -141
	add hl, bc
	ld bc, -23
_loop	add hl, bc
	jr c, _loop
	ld a, l
	add a, 15
	jr nc, _g0
	cp 8
	jr c, _g1
	or 0
_g0	inc hl
_g1	rra
	jr c, _b0
	nop
_b0	rra
	jr nc, _b1
	or 0
_b1	rra
	ret nc
        ret


enemiesPointer:	dw enemiesList

initEnemiesList:
	xor a
	ld (liftBusy),a

	ld hl,enemiesList
	ld (enemiesPointer),hl
	ld hl,baseEnemiesList
	ld de,enemiesList
	ld bc,4*eSize
	ldir
	ret

enemiesList:
eSize = 20
N=0
        dup 4
	;tile coords
	dw 0+19*256	;0 1
	;real coords
	dw 0+19*8*256        ;2 3
	;sprite
	dw eSprites+14*24   ;4 5
	;enemy type
	db ENEMY1     ;6
	;enemy move dir
	db DIR_IDLE        ;7
	;enemy moving flag
	db 0			;8
	;current script		;9 10
	dw enemy1Idle
	;how to draw
	dw DRAW2		;11 12
	;enabled disabled
	db 0			;13
	;delay
	db N*1			;14
	;on lift flag, flip flag for ghost etc
	db 0			;+15
	;another flag for delay move ;+16
	db 0
	;REAL X coordinate for center of enemy
	;x*8+4 where x-collumn x from pos
	db 0			;+17
	;if set we can't beat hero
	db 0                      ;+18
	;save cur dir here
	db 0			 ;+19
N=N+1
	edup

baseEnemiesList:
;eSize = 19
N=0
        dup 4
	;tile coords
	dw 0+20*256	;0 1
	;real coords
	dw 0+20*8*256        ;2 3
	;sprite
	dw eSprites+14*24   ;4 5
	;enemy type
	db ENEMY1     ;6
	;enemy move dir
	db DIR_IDLE        ;7
	;enemy moving flag
	db 0			;8
	;current script		;9 10
	dw enemy1Idle
	;how to draw
	dw DRAW2		;11 12
	;enabled disabled
	db 0			;13
	;delay
	db N*1			;14
	;on lift flag, flip flag for ghost etc
	db 0			;+15
	;another flag for delay move ;+16
	db 0
	;REAL X coordinate for center of enemy
	;x*8+4 where x-collumn x from pos
	db 0			;+17
	;if set we can't beat hero
	db 0                      ;+18
	;save cur dir here
	db 0			 ;+19
N=N+1
	edup

	
gpPointer: dw gpList
	;4 ghost points and we sel it by random
initGpList:
	ld hl,gpList
	ld (gpPointer),hl
	ld de,gpList+1
	ld bc,8+16-1
	ld (hl),0
	ldir
	ret
gpList:
	dup 4
	dw 00000;tile coords
	dw 00000;real coords
	edup
	;for safe
	block 16,0
	
addGhostPoint:
	push hl
	push de
	;save coords
	ld hl,(gpPointer)
	;tile coords
	ld (hl),e
	inc hl
	ld (hl),d
	inc hl

	ld a,d
	add a,a
	add a,a
	add a,a
	ld d,a
	ld a,e
	add a,a
	ld e,a
	ld (hl),e
	inc hl
	ld (hl),d
	inc hl
	ld (gpPointer),hl

	pop de
	pop hl
	;reset tile
	xor a	
	ld (hl),0
	ret
;====================== ENEMIES PROPS ==========
addEnemy3:
	ld (ix+7),-12; position in sin table!
;	ld a,(sin1)
;	ld e,(ix+1);base Y
;	add e
;	sub 8+2
;	ld (ix+3),a;save to draw
	jr addEnemy
addEnemy2Left:
	ld a,ENEMY2
	ld ix,(enemiesPointer)		
	ld (ix+7),DIR_LEFT
	jr addEnemy
addEnemy2Up:
	ld a,ENEMY2
	ld ix,(enemiesPointer)		
	ld (ix+7),DIR_UP
	jr addEnemy
addEnemy4Up:
	ld a,ENEMY4
	ld ix,(enemiesPointer)		
	ld (ix+7),DIR_UP
	jr addEnemy
addEnemy2Down:
	ld a,ENEMY2
	ld ix,(enemiesPointer)		
	ld (ix+7),DIR_DOWN
	jr addEnemy
addEnemy4Down:
	ld a,ENEMY4
	ld ix,(enemiesPointer)		
	ld (ix+7),DIR_DOWN
	jr addEnemy
addEnemy2:
	ld ix,(enemiesPointer)		
	ld (ix+7),DIR_RIGHT
addEnemy:
	ld ix,(enemiesPointer)	
	;save type - same as tile
	ld (ix+6),a
	;reset in level
	ld (hl),0
	;set sprites based on enemy type
	sub 32
	ld hl,eSprites
	ld bc,16*24*2
1:
	or a
	jr z,2f	
	add hl,bc
	dec a
	jr nz,1b

2:
	ld (ix+4),l
	ld (ix+5),h

	push de
	;enable it
	ld (ix+13),1
	;set idle dir
;	ld (ix+7),DIR_IDLE
	;save tile coords
	ld (ix),e
	ld (ix+1),d
	ld a,d
	add a,a
	add a,a
	add a,a
	ld d,a
	ld a,e
	add a,a
	ld e,a
	;save real coords
	ld (ix+2),e
	ld (ix+3),d
	;save REAL x coord
	;x*8+4
	add a,a
	add a,a
	add a,a
	add 4
	ld (ix+17),a

	;ok if we enemy 3 then save base Y
	ld a,(ix+6)
	cp ENEMY3
	jr nz,1f
	ld a,d
	ld (ix+1),a
;	xor a
;	ld (ix+3),0
1:
	
	;step enemies pointer
	ld de,eSize
	add ix,de
	ld (enemiesPointer),ix

	pop de
	xor a;reset tile
	ret

;move by script at end set moving flag to 0
doEnemyScript:
	;frames,howdraw,deltax,restore procedure
	;get script to do
	ld l,(ix+9)
	ld h,(ix+10);
	;========process script in hl
	;sprite
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	;=====save sprite
	ld (ix+4),e
	ld (ix+5),d
	;=========how to draw
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld (ix+11),e
	ld (ix+12),d
	;===============
	;get delta x
	ld e,(hl)
	;get coords x
	ld a,(ix+2)
	add e
	ld (ix+2),a
	;add x
	inc hl
	;get delta y
	ld e,(hl)
	ld a,(ix+3)
	add e
	ld (ix+3),a
	inc hl
	;=======================
	;get rest proc
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld (rEnemyProc+1),de
	;===============================
	;get delta for real coord
	ld e,(hl)
	ld a,(ix+17)
	add e
	ld (ix+17),a	
	inc hl
	;===============================
	;save new script value
	ld (ix+9),l
	ld (ix+10),h
	inc hl;check end of script
	ld a,(hl)
	cp 255
	jr nz,1f
;ok script ended set move by logic not scipt
	ld (ix+8),0
	jr 1f
	ret
1:
rEnemyLink:	ld hl,00000;sprites+1*18
rEnemyProc:	call nullProc
;	exx

;	jp 0
	ret

killHero:
	ld a,GS_DEAD
	ld (gameState),a
	ld a,DEADTIME
	ld (deadCount),a
	ld a,9
	ld (soundToPlay+1),a
	ret

;absolute A
absA:
     or a
     ret p
     neg         ;or you can use      cpl \ inc a
     ret

doOneEnemy:
	;check hero collisions
	;if gameplay - not dead and not win
	ld a,(gameState)
	or a;gameplay
	jr nz,1f
	;check if we can't beat it now
	ld a,(ix+18)
	or a
	jr nz,1f
	;real y coords
	ld e,(ix+3)
	ld a,(heroPos+1)
	sub e
	call absA
	cp 6
	jr nc,1f
	;real X coords
	ld e,(ix+17)
	ld a,(heroRealX)
	sub e
	call absA
	cp 12
	jr nc,1f
;	ld a,5
;	out (254),a
	;ugly one
	call killHero
;	jp c,0	
1:

	;delay for some enemies
	ld a,(ix+6)
	cp ENEMY4
	jr c,6f
	ld a,(ix+16)
	xor 1
	ld (ix+16),a
	or a
enemyDelay:	ret nz
6:

	;check if enemy is already moving inside cell tile - keep moving else do logic
	ld a,(ix+8)
	or a
	jp nz,doEnemyScript
	;get type and move by type
	ld a,(ix+6)
	cp ENEMY1
	jp z,doEnemy1
	cp ENEMY2
	jp z,doEnemy2
	cp ENEMY3
	jp z,doEnemy3
	cp ENEMY4
	jp z,doEnemy4
	cp ENEMY5
	jp z,doEnemy5
	ret

;slow left right waypoints driven dude
;sometimes unpaint blocks, asshole
doEnemy5:
	;set scripts
	ld hl,enemy5Idle
	ld (enemyIdleScript+1),hl
	ld hl,enemy5Right
	ld (enemyRightScript+1),hl
	ld hl,enemy5Left
	ld (enemyLeftScript+1),hl

	;not unpaint if we not in gameplay mode
	ld a,(gameState)
	or a;gameplay
	jr nz,3f
	;random unpaint block
	call getRandom
	cp 1
	jr nz,3f
	call getRandom
	cp 1
	jr nz,3f
	call getRandom
	cp 1
	jr nz,3f
	;ok unpaint
	ld e,(ix)
	ld d,(ix+1)
	inc d
	call getTile
	cp TILE_PAINTED
	jr nz,3f
	;unpaint
	ld a,TILE_UNPAINT
	ld (hl),a
	call incBlocks
	;ok unpaint
	ld hl,unPaintColors;attribs
	call paintTileLevel		
	jp setEnemyIdle
3:

	;left right random switch
	call getRandom
	cp 2
	jr c,1f
	call getRandom
	cp 1
	jp z,tryMoveEnemyRightDown
	cp 2
	jp z,tryMoveEnemyLeftDown
1:

;otherrize continue moving
	ld a,(ix+7)
	cp DIR_LEFT
	jp z,tryMoveEnemyLeftDown
	cp DIR_RIGHT
	jp z,tryMoveEnemyRightDown


	;not other - stand
	jp setEnemyIdle

	ret

;an ghost enemy - moves left right with random stops without gravity
;sometime disapera and shows in new points from ghost points list :)
;32 points list :)
doEnemy4:
	;setup scripts
	ld hl,enemy4Right
	ld (enemyRightScript+1),hl
	ld hl,enemy4Left
	ld (enemyLeftScript+1),hl
	ld hl,enemy4Up
	ld (enemyUpScript+1),hl
	ld hl,enemy4Down
	ld (enemyDownScript+1),hl

	;check if we after flip
	ld a,(ix+15)
	or a
	jr z,1f
	call getRandom
	;
	ld hl,gpList
	add a,a;every gpoint is 4
	add a,a;every gpoint is 4
	ld c,a : ld b,0
	add hl,bc
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	;set tile coords
	ld (ix),e
	ld (ix+1),d
	;set real coords
	ld e,(hl)
	inc hl
	ld d,(hl)
	ld (ix+2),e
	ld (ix+3),d
	;reset flip flag
	ld (ix+15),0
	;set real x coord
	ld a,e
	add a,a
	add a,a
	add a,a
	add 4
	ld (ix+17),a
	;set random dir
;	call getRandom
;	cp 2
;	ld a,DIR_DOWN
;	jr nc,3f
;	inc a;dir right
;3:
;	ld (ix+7),a
	;restore dir
	ld a,(ix+19)
	ld (ix+7),a


	;restore pixels
	ld hl,(rEnemyLink+1)
	call restoreLeftMiddleHL
	;set flip mode
	ld hl,enemy4Flip
	;set can't beat hero flag
	ld (ix+18),1
	jp setScript
1:
	
	;ok flips logic
	call getRandom
	cp 3
	jr nz,1f
	call getRandom
	cp 1
	jr nz,1f
	call getRandom
	cp 1
	jr nz,1f
	;ok we decide to flip
	;set flip flag
	ld (ix+15),1
	;and set flip mode
	ld hl,enemy4Flip
	ld (enemyIdleScript+1),hl
	;set can't beat hero flag
	ld (ix+18),1
	;save cur dir
	ld a,(ix+7)
	ld (ix+19),a
	jp setEnemyIdle	
1:
	;set can't beat hero flag
	ld (ix+18),0

	ld hl,enemy4Idle
	ld (enemyIdleScript+1),hl

	;get coords
	ld e,(ix)
	ld d,(ix+1)
	;check wpoint
	call getWp
	;if no - skip
	cp 255
	jr z,1f
	;else get dir possible by wp value
	ld b,a;save wp
	;get random
	call getRandom
	;save it
	ld c,a
	ld a,b;restore wp
	ld h,high wpDirs
	add a,a
	add a,a
	;add rnd
	add c
	;4 values per wp
	ld l,a
	;now hl point to our dir
	ld a,(hl);get DIR
	ld (IX+7),a;save it
1:
	;ok continue moving with dir
	ld a,(IX+7)
	cp DIR_LEFT
	jp z,tryMoveEnemyLeft
	cp DIR_RIGHT
	jp z,tryMoveEnemyRight
	cp DIR_UP
	jp z,tryMoveEnemyUp
	cp DIR_DOWN
	jp z,tryMoveEnemyDown
	jp setEnemyIdle


;a very basic enemy that fly by sin without any restrictions
;so ix+7 is a position in sinus
;and me affect a real coords
enemy3Frames: dw eSprites+14*24*2,eSprites+14*24*2,eSprites+14*24*2,eSprites+14*24*2
              dw eSprites+13*24*2,eSprites+13*24*2,eSprites+13*24*2,eSprites+13*24*2


doEnemy3:
	;use tile coords for base Y and animationCount
	ld a,(ix);frame
	inc a
	and 7
	ld (ix),a
	;
	add a,a
	ld b,0
	ld c,a
	ld hl,enemy3Frames
	add hl,bc
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	;save frame sprite
	ld (ix+4),l
	ld (ix+5),h	
	;we don't need it
;e by sin
	ld hl,sin1
	ld l,(ix+7)
	ld a,(hl)
	inc l
	inc l
	ld (ix+7),l
;=;=;=;=;=;=;=;=;=;=;=;=;=;=;=;=;=;=;=;=;
	ld e,(ix+1);base Y
	add e
	sub 8+2
	ld (ix+3),a;save to draw
;restore
	ld hl,(rEnemyLink+1)
	call restoreLeftMiddleHL
		
	ret

tryMoveEnemyDown:
	;get tile coords
	ld e,(ix)
	ld d,(ix+1)
	inc d
	;ok move left
	ld (ix+7),DIR_DOWN
	;save new coords
	ld (ix+1),d
enemyDownScript:	ld hl,enemy1Left
	jp setScript

tryMoveEnemyUp:
	;get tile coords
	ld e,(ix)
	ld d,(ix+1)
	dec d
	;ok move left
	ld (ix+7),DIR_UP
	;save new coords
	ld (ix+1),d
enemyUpScript:	ld hl,enemy1Left
	jp setScript

;check if right down not null
tryMoveEnemyRightDown:
	ld e,(ix)
	ld d,(ix+1)
	inc e
	inc d
	call getTile
	cp TILE_LIFT
	jr c,tryMoveEnemyLeft
	;check if there is a solid left - seitch
;	ld bc,-12
;	add hl,bc
;	ld a,(hl)
;	cp TILE_SOLID
;	jr c,tryMoveEnemyLeft

;	jr c,setEnemyIdle

;ix pointer to enemy
tryMoveEnemyRight:
	;get tile coords
	ld e,(ix)
	ld d,(ix+1)
	inc e
	call getTile
	cp TILE_SOLID
;	jr nc,setEnemyIdle
	jr nc,tryMoveEnemyLeft
;	ret nc;is solid here

	ld a,1
;	ld (soundToPlay+1),a



	;ok move right
	ld (ix+7),DIR_RIGHT
	;save new coords
	ld (ix),e
enemyRightScript:	ld hl,enemy1Right
	jp setScript

tryMoveEnemyLeftDown:
	;get tile coords
	ld e,(ix)
	ld d,(ix+1)
	dec e
	inc d
	call getTile
	cp TILE_LIFT
	jr c,tryMoveEnemyRight
	;check if there is a solid left - seitch
;	ld bc,-12
;	add hl,bc
;	ld a,(hl)
;	cp TILE_SOLID
;	jr c,tryMoveEnemyRight
;	jr c,setEnemyIdle
tryMoveEnemyLeft:
	;get tile coords
	ld e,(ix)
	ld d,(ix+1)
	dec e
	call getTile
	cp TILE_SOLID
;	jr nc,setEnemyIdle
	jr nc,tryMoveEnemyRight
;	ret nc;is solid here
	ld a,1
;	ld (soundToPlay+1),a


	;ok move left
	ld (ix+7),DIR_LEFT
	;save new coords
	ld (ix),e
enemyLeftScript:	ld hl,enemy1Left
	jp setScript

tryFallEnemy:
	;get tile coords
	ld e,(ix)
	ld d,(ix+1)
	inc d
	call getTile
	ret
;	jp setScript

setEnemyIdle:
enemyIdleScript:	ld hl,enemy1Idle
	ld (ix+7),DIR_IDLE
;	halt:halt:halt:halt:halt:halt
;	jp setScript
setScript:
	ld (ix+9),l
	ld (ix+10),h
	;set start moving flag
	ld (ix+8),1
	;go script
	jp doEnemyScript
;	ret
;	ret

liftBusy:	db 0

;FLY ONE AND FIRE
doEnemy2:
	;set scripts for our type
	ld hl,enemy2Idle
	ld (enemyIdleScript+1),hl
	ld hl,enemy2Right
	ld (enemyRightScript+1),hl
	ld hl,enemy2Left
	ld (enemyLeftScript+1),hl
	ld hl,enemy2Down
	ld (enemyDownScript+1),hl
	ld hl,enemy2Up
	ld (enemyUpScript+1),hl

	;get coords
	ld e,(ix)
	ld d,(ix+1)
	;check wpoint
	call getWp
	;if no - skip
	cp 255
	jr z,1f
	;else get dir possible by wp value
	ld b,a;save wp
	;get random
	call getRandom
	;save it
	ld c,a
	ld a,b;restore wp
	ld h,high wpDirs
	add a,a
	add a,a
	;add rnd
	add c
	;4 values per wp
	ld l,a
	;now hl point to our dir
	ld a,(hl);get DIR
	ld (IX+7),a;save it
1:
	;ok continue moving with dir
	ld a,(IX+7)
	cp DIR_LEFT
	jp z,tryMoveEnemyLeft
	cp DIR_RIGHT
	jp z,tryMoveEnemyRight
	cp DIR_UP
	jp z,tryMoveEnemyUp
	cp DIR_DOWN
	jp z,tryMoveEnemyDown

	jp setEnemyIdle

	ret

;do enemy 1
;it's a random jumper:
;X DIR: - move left right and change dirs 1/4 times
;Y DIR - fall and if lift under or on then move by 1/4 times
;NOT USE WAYPOINTS AT ALL
;lift mover
doEnemy1:
	;set scripts for our type
	ld hl,enemy1Idle
	ld (enemyIdleScript+1),hl
	ld hl,enemy1Right
	ld (enemyRightScript+1),hl
	ld hl,enemy1Left
	ld (enemyLeftScript+1),hl
	;check lift down movw

	;check a lift up move
	ld a,(ix+7)
	cp DIR_DOWN
	jr z,2f

	;get tile coords
;	ld e,(ix)
;	ld d,(ix+1)
;	call getTile
;	;if lift may try move up
;	cp TILE_LIFT1
;	jr z,7f
;	cp TILE_LIFT
;	jr nz,2f

;if lift under hero
;if we on lift allread then check only current place
	ld e,(ix)
	ld d,(ix+1)
;get lift flag
	ld a,(ix+15)
	or a
	jr nz,9f
;======================
	dec d
	call getTile
;	inc d
	cp TILE_LIFT
	jr z,5f
	cp TILE_LIFT1
	jr z,5f
	inc d
9:
	;fast get tile
	call getTile
	cp TILE_LIFT1
	jr z,7f
	cp TILE_LIFT
	jr nz,2f
	jr 8f
5:
	;if we already move up then continue
	ld a,(ix+7)
	cp DIR_UP
	jr z,8f
	;otherize let's decide to move randomly move with lift
	call getRandom
;	or a
	cp 1
	;no wo don't want skip
	jr c,2f
	;check if another one is use lift
	ld a,(liftBusy)
	or a
	jr nz,2f
	;ok decide to move
	;set lift busy flag and activate lift we need	
	call activateLift2	
	inc d
	ld (ix+15),1;set on lift flag
	jr 8f
7:
	;if we already move up then continue
	ld a,(ix+7)
	cp DIR_UP
	jr z,8f
	;otherize let's decide to move randomly move with lift
	call getRandom
;	or a
	cp 1
	;no wo don't want skip
	jr c,2f
	;check if another one is use lift
	ld a,(liftBusy)
	or a
	jr nz,2f
	;ok decide to move
	;set lift busy flag and activate lift we need	
	call activateLift2	
	ld (ix+15),1;set on lift flag
8:
	;move on lift up
	ld a,3
;	ld (soundToPlay+1),a

	;move up
	ld (ix+7),DIR_UP
	dec d
	ld (ix+1),d
        ld hl,enemy1Up
	jp setScript
2:
	;check fall and lift down move
;======================================================
	;get tile coords
	ld e,(ix)
	ld d,(ix+1)
	inc d
	call getTile
	cp TILE_SOLID
	jr nc,1f
	cp TILE_LIFT
	jr z,3f
5:
;	;save new coords
	ld (ix+1),d
;	;ok fall
	ld (ix+7),DIR_DOWN
	ld a,3
;	ld (soundToPlay+1),a


	;ok fall
	ld hl,enemy1Down
	jp setScript		
;	;ok lift down, let's try to move by lift

3:
;move on lift down
	call getRandom
;	or a
	cp 1
	jr c,1f
	;check if another one is use lift
	ld a,(liftBusy)
	or a
	jr nz,1f
;ok decide to move
	call activateLift2
	ld (ix+15),1;set on lift flag
	jr 5b

1:
	;if we was on lift then disable
	ld a,(ix+15)
	or a
	jr z,1f
	;reset flag and disable lift
	ld (ix+15),0
	call deactivateLift2
1:

;======================================================
	;otherize
	call getRandom
	cp 1
	jp z,tryMoveEnemyLeft
	cp 2
	jp z,tryMoveEnemyRight
	;or stops randomly some times
	call getRandom
	or a
	jp z,setEnemyIdle

continueMoving:
	;get current dir and continue moving
	ld a,(ix+7)
	cp DIR_LEFT
	jp z,tryMoveEnemyLeft
	cp DIR_RIGHT
	jp z,tryMoveEnemyRight

	;not other - stand
	jp setEnemyIdle

;	jp setScript
	ret






;do enemies
doEnemies:
	;eSprites
N=0
	dup 4
	ld ix,enemiesList+eSize*N
	;do it based on type
	;and put a link to sprites in alt hl'
	ld hl,sprites+N*18
	ld (rEnemyLink+1),hl
	;check delay if delay then not move
	ld a,(ix+14)
	or a
	jr z,2f
	dec a
	ld (ix+14),a
	jr 3f
2:
	;if enemy is enabled then do it
	ld a,(ix+13)
	or a
	jr z,1f
	call doOneEnemy
3:
	;set coords and sprites to sprites
	;spite link
	ld l,(ix+4)
	ld h,(ix+5)
	ld (sprites+N*18),hl
	;coords
	ld l,(ix+2)
	ld h,(ix+3)
	ld (sprites+N*18+2),hl
	;type of draw
	ld l,(ix+11)
	ld h,(ix+12)
	ld (sprites+N*18+4),hl	
1:
N=N+1
	edup
	ret


tiles:
	incbin "res\tiles.tile"
eSprites:	incbin "res\enemies.tile";,0,32*48


;ok a copy proc between pages
;hl - where get
;de -where put
;bc - total size
;fixed pages from 7 to 4 :)
copyCopy:
	;copy by 1 byte %))))
1:	
	
	push bc
	ld a,(pgOutro) : call swapPage :  ld a,(hl) : inc hl : push af
	ld a,(pg0+1) : call swapPage :  pop af : ld (de),a : inc de
	pop bc
	dec bc                         ; This instruction does not modify the flags!
	ld a,b                         ; Verifying whether the counter reached zero
	or c                           ; The zero flag is set if both bytes of BC are zero
	jr nz,1b
	ret
pgOutro:	db 1; 4 for +2 +3

outroDelay:

	IFDEF PENTAGON
	ld bc,18700+224*16+48+64+64+32+24
;	inc bc
;	ld (outroDelay+1),bc
	call DELAY
	ld a,0
	out (254),a	
	ld bc,228
	call DELAY

	ELSE
	ld bc,18700+228*2+48
	call DELAY
	ENDIF

	ret

;one time without back to menu
;so we can kill all over 32768
outro:
	halt
	call StopPSG
  	ld hl, AYbuffer
        ld de, AYbuffer+1
        ld bc, 14
	ld (hl),0
        ldir

        ld b,100
1:
	halt
	djnz 1b



;	ld a,#cd : ld (mmm),a;replace callz with just call to enable 50hz music
;	ld a,(pgOutro) : ld (mPage+1),a
;	ld hl,0 : ld (TBKPSGPlayer.loopTick),hl: xor a: ld (TBKPSGPlayer.PSGLOOP),a
;	ld a,(pgOutro) : call swapPage
;	ld hl,outroMusic : ld (InitPSG+1),hl : call InitPSG

	di
	;unpack bg with collums for 4x4
;	halt
	ld a,(pgOutro) : call swapPage
	ld hl,bgOutro: ld de,16384: call DEC40
	;unpack attr
	;frame 0 to pixel render
	ld a,(pgOutro) : call swapPage
	ld hl,finMC2: ld de,32768-2048 : ld bc,2048 : ldir
	xor a: call swapPage
	ld hl,32768-2048 : ld de,49152 : call DEC40
	;frame 2
	ld a,(pgOutro) : call swapPage
	ld hl,finMC1: ld de,32768-2048 : ld bc,2048 : ldir
	ld a,(pg0+1) : call swapPage 
	ld hl,32768-2048 : ld de,49152 : call DEC40

	ei

	halt
	;swap to mcolor page
	ld a,(pg0+1):	call swapPage 	
	;unpack
	;set start
	ld hl,49152 : ld (mcStart+1),hl
	ld hl,outroDelay
	ld (topBorder+1),hl
	ld hl,doMusic
	ld (downBorder+1),hl
	halt

	;init music
	ld a,(pgOutro) : ld (mPage+1),a
	ld hl,0 : ld (TBKPSGPlayer.loopTick),hl: xor a: ld (TBKPSGPlayer.PSGLOOP),a
	ld hl,outroMusic : ld (InitPSG+1),hl : call InitPSG

	halt : ld hl,interrupt : call IMON
	
;	call setMoveDown

outroLoop:
	halt
	halt
;swapFrames
oSwp:	ld a,0
	inc a
	and 3
	ld (oSwp+1),a
	or a
	call z,swapSwap
	

;	halt
oPause:	ld a,178
	or a
	jr z,2f
	dec a
	ld (oPause+1),a
	jr 1f
2:
	ld hl,(mcStart+1)
oDlt:	ld bc,24
	add hl,bc
	ld (mcStart+1),hl
	ld a,h
	cp 255-38
	jr nz,3f
	ld a,l
	cp 24*4
	jr c,3f
	call setMoveUp
	jr 1f
3:
	cp #c0
	jr nz,1f
	ld a,l
	or a
	call z,setMoveDown
1:

;	ld a,r
;	out (254),a
	jp outroLoop


swapSwap:
	call swap2
	ret

swap1:
	ld a,(pg2+2) : ld (pg1+1),a
	ld hl,swap2
	ld (swapSwap+1),hl
	ret
swap2:
	ld a,16 : ld (pg1+1),a
	ld hl,swap1
	ld (swapSwap+1),hl
	ret


setMove:
	jp setMoveUp

setMoveDown:
	ld hl,setMoveUp
	ld (setMove+1),hl
	ld a,81 : ld (oPause+1),a
	ld bc,24
	ld (oDlt+1),bc	
	ret
setMoveUp:
	ld hl,setMoveDown
	ld (setMove+1),hl
	ld a,81 : ld (oPause+1),a
	ld bc,-24
	ld (oDlt+1),bc	
	ret

;base line
;51 bytes
baseLine:
	ld sp,22528+768+256 ;3b
	dup 12 : ld de,0+0*256 : push de : edup

;generate a screen
generateCodeScreen:
;repeat 320 times baseLine and add jp (hl) at end
	ld de,49152
	call gen160
	call gen160
	;jp (hl) to hl
	inc hl
	ld (hl),#E9
	ret
gen160:
	exx
	ld b,160
	exx
1:
	ld hl,baseLine
	ld bc,51
	ldir
	exx
	dec b
	exx
	jr nz,1b
	ret

	display /d,"pre 49152: ",49152-$

;pixels
;	page 0
;	org 49152
;	dup 320
;ld pushed pixels of level
;	;18 width
;	ld sp,22528+768+256 ;3b
;	dup 12 : ld de,0+0*256 : push de : edup
;	edup
;	jp (hl)
	;57344 limit
;	display /d,"page 0: ",$
p0end:

	page 1
	org 49152
finMC1:	
	incbin "outro\pict1.atr.mlz"
finMC2:	
	incbin "outro\pict.atr.mlz"

outroMusic: incbin "sound\outro.psg.tpp"
bgOutro: incbin "res\bgOutro.scr.mlz"


level01: incbin "levels\level01.bin.mlz"	
level02: incbin "levels\level02.bin.mlz"	
level03: incbin "levels\level03.bin.mlz"	
level04: incbin "levels\level04.bin.mlz"	
level05: incbin "levels\level05.bin.mlz"	
level06: incbin "levels\level06.bin.mlz"	
level07: incbin "levels\level07.bin.mlz"	
level08: incbin "levels\level08.bin.mlz"	
level09: incbin "levels\level09.bin.mlz"	
level10: incbin "levels\level10.bin.mlz"	
level11: incbin "levels\level11.bin.mlz"	
level12: incbin "levels\level12.bin.mlz"	
level13: incbin "levels\level13.bin.mlz"	
level14: incbin "levels\level14.bin.mlz"	
level15: incbin "levels\level15.bin.mlz"	
level16: incbin "levels\level16.bin.mlz"	
level17: incbin "levels\level17.bin.mlz"	
level18: incbin "levels\level18.bin.mlz"	
level19: incbin "levels\level19.bin.mlz"	
level20: incbin "levels\level20.bin.mlz"	

level21: incbin "levels\level21.bin.mlz"	
level22: incbin "levels\level22.bin.mlz"	
level23: incbin "levels\level23.bin.mlz"	
level24: incbin "levels\level24.bin.mlz"	
level25: incbin "levels\level25.bin.mlz"	


levels:	dw level01,level02,level11,level04,level06
	dw level09,level05,level08,level12,level03
	dw level14,level07,level10,level13,level15
	dw level18,level19,level17,level16,level22
	dw level21,level20,level23,level24,level25

;set world based on level
setWorld:
	ld a,(currentLevel)
	cp 8
	jp c,setWorld1
	cp 14
	jp c,setWorld2
	cp 20
	jp c,setWorld3
	jp setWorld4
	ret
setWorld1:
	;enable delay for slow enemies
	ld a,#c0;ret nz
	ld (enemyDelay),a
	;copy paint colors
	ld hl,paintColors1
	ld de,paintColors
	ld bc,3
	ldir
	;copy tiles
	ld hl,tiles1
	ld de,tiles
	ld bc,16*48
	ldir
	ret
setWorld2:
	;enable delay for slow enemies
	ld a,#c0;ret nz
	ld (enemyDelay),a
	;copy paint colors
	ld hl,paintColors2
	ld de,paintColors
	ld bc,3
	ldir
	;copy tiles
	ld hl,tiles2
	ld de,tiles
	ld bc,16*48
	ldir
	ret
setWorld3:
	;enable delay for slow enemies
	ld a,#c0;ret nz
	ld (enemyDelay),a

	;copy paint colors
	ld hl,paintColors3
	ld de,paintColors
	ld bc,3
	ldir
	;copy tiles
	ld hl,tiles3
	ld de,tiles
	ld bc,16*48
	ldir
	ret
setWorld4:
	;disable delay for slow enemies
	ld a,#00;nop
	ld (enemyDelay),a
	;copy paint colors
	ld hl,paintColors4
	ld de,paintColors
	ld bc,3
	ldir
	;copy tiles
	ld hl,tiles4
	ld de,tiles
	ld bc,16*48
	ldir

	ret

paintColors1: db 0+6+64,3*8+4+64,6+1*8
paintColors2: db 0+3+64,1*8+3+64,2+1*8
paintColors3: db 0+4+64,1*8+4+64,5+1*8
paintColors4: db 0+4+64,1*8+4+64,2+0*8

tiles1:		incbin "res\tiles1.tile",0,48*16
tiles2:		incbin "res\tiles2.tile",0,48*16
tiles3:		incbin "res\tiles3.tile",0,48*16
tiles4:		incbin "res\tiles4.tile",0,48*16


	display /d,"page 1: ",65535-$
p1end:

	page 7
	org 49152
;music:	incbin "sound/nullmusic.psg.tpp"
music:	incbin "sound/music.psg.tpp"
music2:	incbin "sound\music2.psg.tpp"
bgPacked:	incbin "res\bg.scr.mlz"

	display /d,"page 7: ",65535-$
p7end:

	page 0
        savebin "test.bin",24500,p0end-24500

	page 7
        savebin "p7.bin",49152,p7end-49152

	page 1
        savebin "p1.bin",49152,p1end-49152
