;AYREGS  equ TBKPSGPlayer.BufferPSG ; адрес 14 регистров PSG фрейма

TonA	EQU 0
TonB	EQU 2
TonC	EQU 4
Noise	EQU 6
Mixer	EQU 7
AmplA	EQU 8
AmplB	EQU 9
AmplC	EQU 10
Env	EQU 11
EnvTp	EQU 13

;--------------------------------------------------------------;
; Инициализация плеера эффектов.                               ;
; Выключает все каналы, устанавливает переменные.              ;
; Вход: HL = адрес банка с эффектами                           ;
;--------------------------------------------------------------;
AFXINIT:
	INC HL
	LD (BNK_ADR+1),HL	;сохраняем адрес таблицы смещений
	xor a
	LD (afxNoisePeriod), A
	LD HL, afxChData    ;помечаем все каналы как пустые
	LD BC, #03FF
.loop
	LD (HL),A
	INC HL
	LD (HL),A
	INC HL
	LD (HL),C
	INC HL
	LD (HL),C
	INC HL
	LD (HL),A
	INC HL
	LD (HL),C
	INC HL
	LD (HL),A
	INC HL
	LD (HL),A
	INC HL
	DJNZ .loop
	ret

;--------------------------------------------------------------
; Проигрывание текущего кадра                                 
AFXFRAME:
	ld ix,afxChData+8
;	ld de,#0008			;следующий канал
;	ld b,3
;afxFrameLoop:
	ld h,(ix+1)			;старший байт адреса эффекта
	cp h				;если 0, то канал не активен
	jr nc,afxFrameChSkip
	ld l,(ix+0)			;младший байт адреса эффекта
	ld c,(hl)			;читаем информационный байт
	inc hl
	ld (ix+5),c			;запоминаем биты микшера
	ld a,c
	and #0F
	ld (ix+4),a			;запоминаем громкость
	bit 5,c				;изменение периода тона
	jr z,afxFrameNoTone
	ld a,(hl)			;запоминаем период
	inc hl
	ld (ix+6),a
	ld a,(hl)
	inc hl
	ld (ix+7),a
afxFrameNoTone:
	bit 6,c				;изменение периода шума
	jr z,afxFrameNoNoise
	ld a,(hl)			;получаем период
	cp #20				;если он больше 31, эффект кончился
	jr c,afxFrameNoise
	xor a				;зануляем старший байт адреса и громкость
	ld (ix+1),a
	ld (ix+4),a
	jr afxFrameChSkip
afxFrameNoise:
	inc hl				;запоминаем период шума
	ld (afxNoisePeriod),a
afxFrameNoNoise:
	ld (ix+0),l			;запоминаем адрес
	ld (ix+1),h
	inc (ix+2)			;увеличиваем счётчик времени звучания
	jr nz,afxFrameChSkip
	inc (ix+3)
afxFrameChSkip:
;	add ix,de
;	djnz afxFrameLoop

;	ret

	ld a,(AYREGS+AmplA)
	ld c,a
	ld a,(afxChData+0*8+4)
	cp c
	jr c,afxSkipCh0
	ld (AYREGS+AmplA),a
	ld a,(afxChData+0*8+6)
	ld (AYREGS+TonA+0),a
	ld a,(afxChData+0*8+7)
	ld (AYREGS+TonA+1),a

	ld a,(AYREGS+Mixer)
	and %11110110
	ld c,a
	ld a,(afxChData+0*8+5)
	rra
	rra
	rra
	rra
	and %00001001
	or c
	ld (AYREGS+Mixer),a

afxSkipCh0:
	ld a,(AYREGS+AmplB)
	ld c,a
	ld a,(afxChData+1*8+4)
	cp c
	jr c,afxSkipCh1
	ld (AYREGS+AmplB),a
	ld a,(afxChData+1*8+6)
	ld (AYREGS+TonB+0),a
	ld a,(afxChData+1*8+7)
	ld (AYREGS+TonB+1),a

	ld a,(AYREGS+Mixer)
	and %11101101
	ld c,a
	ld a,(afxChData+1*8+5)
	rra
	rra
	rra
	and %00010010
	or c
	ld (AYREGS+Mixer),a
	
afxSkipCh1:
	ld a,(AYREGS+AmplC)
	ld c,a
	ld a,(afxChData+2*8+4)
	cp c
	jr c,afxSkipCh2
	ld (AYREGS+AmplC),a
	ld a,(afxChData+2*8+6)
	ld (AYREGS+TonC+0),a
	ld a,(afxChData+2*8+7)
	ld (AYREGS+TonC+1),a

	ld a,(AYREGS+Mixer)
	and %11011011
	ld c,a
	ld a,(afxChData+2*8+5)
	rra
	rra
	and %00100100
	or c
	ld (AYREGS+Mixer),a

afxSkipCh2:
	ld ix,afxChData
	ld a,(ix+0*8+5)
	and  (ix+1*8+5)
	and  (ix+2*8+5)
	rla
	jr c,ROUT
	ld a, 0
afxNoisePeriod equ $-1
	ld (AYREGS+Noise),a

ROUT	XOR A
	LD HL, AYREGS
	LD DE, #FFBF
	LD BC, #FFFD
	DUP 13
	OUT (C),A
	LD B,E
	OUTI
	LD B,D
	INC A
	EDUP
    
    ; wbcbz7 note: пробуем скрестить TBK PSG player и вот это вот все
	out     (c), a
    ld      a, d
    ld      (TBKPSGPlayer.BufferPSG+13), a  ; другого варианта сказать псгплееру, чтобы не дрюкал R13 я не знаю,
	ld      a, (hl)                         ; думаю что можно сделать лучше ;)
    ld      b, e
	inc     hl
	inc     a
	jr      z, .SkipReg13                   ; а, и кстати, по тактам не выровнено, так шта...
	outi

.SkipReg13:
    ret

afxChData:
	DS #18,#00 ; Буфер переменных эффектов AY
;--------------------------------------------------------------;
; Запуск эффекта на свободном канале. При отсутствии           ;
; свободных каналов выбирается наиболее давно звучащий.        ;
; Вход: A = номер эффекта 0..255                               ;
;--------------------------------------------------------------;
SFX:
	ld H,0;high afxChData
	LD L,A
	ADD HL,HL

BNK_ADR: LD BC,#0000 ;адрес таблицы смещений эффектов

	ld de,afxChData+3+8*1; 1-in abc
;	ld de,afxChData+3+2*8;2-center in acb

	ADD HL,BC
	LD C,(HL)
	INC HL
	LD B,(HL)
	ADD HL,BC ;адрес эффекта получен в hl
	EX DE,HL ;адрес канала +3
	LD (HL),B
	DEC L
	LD (HL),B
	DEC L
	LD (HL),D 
	DEC L
	LD (HL),E
	RET
	