#define VG75 ((uchar*)0xD800)
#define VT57 ((uchar*)0xDB00)

void main() {

  asm{
	MVI A,$80 ;mapper 8
	STA $DA00 ;set mapper
      
	MVI A,3 ;slot 3
	STA $DE00 ;select slot
	
	MVI A,006h ; proc6 - init mcpg
    CALL 0e00eh 

; ROM-like init	
;	LXI H,0D801h
;	MVI M,0h
;	DCX H
;	MVI M,04Dh
;	MVI M,064h
;	MVI M,077h
;	MVI M,058h
;	INX H
;	MVI M,027h
;	MVI M,0E0h
;	NOP
;	MVI M,027h
;	LXI H,0DB08h
;	MVI M,080h
;	MVI L,004h
;	MVI M,0D0h
;	MVI M,076h
;	INR L
;	MVI M,027h
;	MVI M,049h
;	
;	MVI A,0F3h
;	STA 07FF6h
;	LXI H,0D801h
;	MOV A,M
;Loop1:
;	LXI D,0CFFFh
;Loop2:
;	LDAX D
;	MOV A,E
;	ORA D
;	JZ Loop1
;	DCX D
;	MOV A,M
;	ANI 020h
;	JZ Loop2
;	MVI A,084h
;	STA 0DB08h
	
;fill screen
	LXI D, 77BDh
	LXI B, 0
fill_loop1:
	MVI A, 1
	STAX D
	INR A
	INX D
	STAX D
	INR A
	INX D
	STAX D
	INR A
	INX D
	STAX D
	INX D
	MOV A,B
	ADI 4
	MOV B,A
	MVI A, 64
	CMP B
	JNZ fill_loop1
	XRA A
	MOV B, A
	LXI H,14
	DAD D
	XCHG
	INR C
	MVI A, 25
	CMP C
	JNZ fill_loop1

;adding control code
	MVI A, 80h
	STA 77BDh
;adding control code
	MVI A, 8Ch
	STA 7F4Ch
	
	MVI A,$80 ;mapper 8
	STA $DA00 ;set mapper

colorcycle:
	
	;set red
	MVI A,0F6h ;red
	CALL set_color
	
	CALL wait_3frames

	;set green
	MVI A,0EDh ;green
	CALL set_color
	
	CALL wait_3frames

	;set blue
	MVI A,0DBh ;blue
	CALL set_color
	
	CALL wait_3frames
	
	;set RGBK stripes
	MVI A,0F6h ;red
	CALL set_color
	LXI H, 0C810h
	LXI D, 0D010h
stripes0:
	MVI A,0EDh ;green
	MOV M,A
	STAX D
	INR E
	INR L
	MVI A,24
	CMP L
	JNZ stripes0
	LXI H, 0C818h
	LXI D, 0D018h
stripes1:
	MVI A,0DBh ;blue
	MOV M,A
	STAX D
	INR E
	INR L
	MVI A,32
	CMP L
	JNZ stripes1
	LXI H, 0C822h
	LXI D, 0D022h
	MVI A,0EDh ;green
	MOV M,A
	STAX D
	INR E
	INR L
	MOV M,A
	STAX D
	INR E
	INR L
	MVI A,0DBh ;blue
	MOV M,A
	STAX D
	INR E
	INR L
	MOV M,A
	STAX D
	INR E
	INR L
	MVI A,0FFh ;black
	MOV M,A
	STAX D
	INR E
	INR L
	MOV M,A
	STAX D
	INR E
	INR L


	CALL wait_3frames

	
	JMP colorcycle

	
hang:
   JMP hang
   
;--------------------- setting color
Color:
	.DB 0
set_color:
	STA Color
	LXI H, 0C800h
	LXI D, 0D000h
color0:
	MVI A,0FFh
	MOV M,A
	STAX D
	INR E
	INR L
	MVI A,8
	CMP L
	JNZ color0
color1:
	LDA Color
	MOV M,A
	STAX D
	INR E
	INR L
	MVI A, 40
	CMP L
	JNZ color1
color2:
	MVI A, 0FFh
	MOV M,A
	STAX D
	INR E
	INR L
	MVI A, 255
	CMP L
	JNZ color2

;--------------------- wait for VG75
wait_vg75:
	LXI H, 0D801h
	MOV A,M
wait_vg75_loop:
	MOV A,M
	ANI 020h
	JZ wait_vg75_loop
	RET

;--------------------- wait for 3 frames
wait_3frames:
	CALL wait_vg75
	CALL wait_vg75
	CALL wait_vg75
	RET




   } 
  
}