;Input:
;HL - screen address

zx_screen:

	ld		(scr_addr),hl
	ld		de,#9000 + 256 * 8 + 32
	
	ld		b,3
zx_next_3:
	push	bc
	push	de
;++++++++++++++++++	
	ld		b,8
zx_next_line:
	push	bc
	push	de
;==================
	ld		b,8
zx_next_zm:
	push	bc
	push	de
;-------------------
	ld		b,32
zx_line:
	call	set_color
	ld		a,(hl)
	ex		de,hl
	ld		(hl),a
	ld		a,d
	ld		c,e
	ld		de,256
	add		hl,de
	ld		d,a
	ld		e,c
	ex		de,hl
	inc		hl
	dec 	b
	jp		nz,zx_line
;-------------------	
	ex		de,hl
	pop		hl
	ld		a,d
	ld		c,e
	ld		de,8
	add		hl,de
	ld		d,a
	ld		e,c
	ex		de,hl
	pop		bc
	dec		b
	jp		nz,zx_next_zm
;====================
	ex		de,hl
	pop		hl
	inc		hl
	ex		de,hl
	pop		bc
	dec		b
	jp		nz,zx_next_line
;++++++++++++++++++	
	ex		de,hl
	pop		hl
	ld		a,d
	ld		c,e
	ld		de,64
	add		hl,de
	ld		d,a
	ld		e,c
	ex		de,hl
	pop		bc
	dec		b
	jp		nz,zx_next_3

	ret

set_color:
	push	hl
	push	de

	ex		de,hl
	ld		hl,(scr_addr)
	ld		a,e
	sub		l
	ld		l,a
	ld		a,d
	sbc		h
	ld		h,a
	;В HL адрес картинки с нулевым смещением
	
	ld		e,l
	ld		a,h
	rra
	rra
	rra
	and		%11
	ld		d,a

	ld		hl,(scr_addr)
	add		hl,de
	
	ld		a,#18
	add		h
	ld		h,a

	ld		a,(hl)
	and		%111

	ld		hl,colors
	ld		d,0
	ld		e,a
	add		hl,de
	ld		a,(hl)
	ld		(#ff02),a

	pop		de
	pop		hl
	ret

scr_addr:
	dw		#0000
	
colors:
	db		#d0	;Black
	db		#c0	;Blue
	db		#50	;Red
	db		#40	;Magenta
	db		#90	;Green
	db		#80	;Cyan
	db		#10	;Yellow
	db		#00	;White
