///////////////////////////////////////////////////////////////////////////////
/////// A Z80 disassembler - works under Win32 for now
////// Author : Matthew Porth
///// Copyright : 2004 - Matthew Porth - however - if you email me I'll let
////              you use it commerically or non-comercially with no restrictions
///               accept you MUST contact me
// Version 0.08 - another compile option jr cc, -1 decompiles to RST cc, $38
//              - added compiler time option to switch between JP (HL) and JP HL
// Version 0.07 - added output of 16 bit load targets (often memory addresses)
// Version 0.06 - IXH/IXL and IYH/IYL swapped (H xlats2 I?H and L xlats2 I?L
// Version 0.05 - change in ED LD/CP/IN/OUT logic
// Version 0.04 - fixed ED LDI/CPI/INI/OUTI opcodes.
// Version 0.03 - added forward decl of dis() (duh!)
//              - swapped index byte read and opcode read in FD/DD+CB opcodes
//              - fixed double opcode bug in single op statements e.g. HALT HALT
//              - changed ixf/iyf to a single variable
//              - more opcodes stored in arrays (DAA/SCF and CB group rotates)
//              - fixed undoc DD/FD+CB opcodes (now prints "temp" reg properly)
// Version 0.02 - acceptable aligning of mneumnonics (6 chars)
//              - better calling conventions (still sucks though)
//              - negative indices in IX/IY index modes printed properly
//              - this header changed ;-)
// Version 0.01 - horribly unfinished.

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>

//#define PRINT_JUMP_TABLES
// convert jr cc, -1 to rst cc, 0x38
//#define _CONDITIONAL_RESET_
// converts jp (hl) to jp hl (same for ix/iy)
//#define _NO_INDIRECT_REG_JUMPS_

typedef unsigned __int8 byte;
typedef unsigned __int16 word;

// here - list of predefined entry points - probably includes
// 0,8,16,24,32,40,48,56 and 66 as minimum (reset and RST vectors, 

// absolute max.... err... reference count instead??? very lazy though... double arrays?
word jtargs[65536];
word dtargs[65536];
unsigned jt = 0;
unsigned dt = 0;
// memory image
byte memory[65536];
// inital instruction pointers
word ip = 0;
// used for printing out bytes of instructions in disassembly
word startip = 0;
// flags (this needs to be a little different)
#define idx_off       0
#define idx_ix        2
#define idx_iy        3
byte idxmode = idx_off;
// index byte
byte idxbyte = 0;
// hex LUT.
char hexes[] = "0123456789ABCDEF";

void dis();

void note(char *note, word data = 0);

void disasm(unsigned ipinit, unsigned ipmax) {
    ip = ipinit;

    while (ip < ipmax) {
        startip = ip;
        idxmode = idx_off;
        dis();
    }
#ifdef PRINT_JUMP_TABLES
    word x;

    printf("jtargs\n");
    for (x = 0; x < jt; x++) {
        printf("%04x\n", jtargs[x]);
    }
    printf("dtargs\n");
    for (x = 0; x < dt; x++) {
        printf("%04x\n", dtargs[x]);
    }
#endif
}

word addjtarg(word addr) {
    jtargs[jt++] = addr;
    note("target word ", jtargs[jt-1]);
    return addr;
}

void addjtarg(byte offs) {
    // sign extension bullshit
    jtargs[jt++] = (signed)(ip) + char(offs);
    note("target byte ", jtargs[jt-1]);
}

word adddtarg(word addr) {
    dtargs[dt++] = addr;
    note("target word ", dtargs[dt-1]);
    return addr;
}

void prsip() {
    printf("%04X ", startip);
    // now... up to 6 bytes (12 characters)
    for (word x = startip; x < ip; x++) {
        printf("%c%c", hexes[memory[x] >> 4], hexes[memory[x] & 0xf]);
    }
    // how many was that???
    if ((ip - startip) < 6) {
        for (word x = 0; x < (6 - (ip - startip)); x++) {
            printf("  ");
        }
    }
}

void prop(char *pszop) {
    printf("%s",pszop);
    for (word x = 0; x < 6 - strlen(pszop); x++) printf(" ");
}

void opcode(char *op) {
    prsip();
    prop(op);
    printf("\n");
}

void opcode(char *op, byte p1) {
    prsip();
    prop(op);
    printf("$%02X\n", unsigned(p1));
}

void opcode(char *op, word p1) {
    prsip();
    prop(op);
    printf("$%04X\n", unsigned(p1));
}

void opcode(char *op, char *p1, byte p2, bool ind = false) {
    prsip();
    prop(op);
    if (ind) printf("(%s), $%02X\n", p1, unsigned(p2));
    else printf("%s, $%02X\n", p1, unsigned(p2));
}

void opcode(char *op, char *p1, word p2, bool ind = false) {
    prsip();
    prop(op);
    if (ind) printf("%s, $(%04X)\n", p1, unsigned(p2));
    else printf("%s, $%04X\n", p1, unsigned(p2));
}

void opcode(char *op, word p1, char *p2, bool ind = false) {
    prsip();
    prop(op);
    if (ind) printf("$(%04X), %s\n", unsigned(p1),p2);
    else printf("$%04X, %s\n", unsigned(p1),p2);
}

void opcode(char *op, char *p1) {
    prsip();
    prop(op);
    printf("%s\n", p1);
}

void opcode(char *op, char *p1, char *p2) {
    prsip();
    prop(op);
    printf("%s, %s\n", p1, p2);
}

void opcode(char *op, byte p1, char *p2, bool ind = false) {
    prsip();
    prop(op);
    if (ind) printf("$(%02X), %s\n", unsigned(p1), p2);
    else printf("$%02X, %s\n", unsigned(p1), p2);
}

void opcode(char *op, byte p1, char *p2, char *p3) {
    prsip();
    prop(op);
    printf("$%02X, %s, %s\n", p1, p2, p3);
}

void note(char *note, word data) {
    printf(";;; %s %04x\n", note, data);
}

byte getbyte() {
    byte b = memory[ip];
    ip++;
    return b;
}

word getword() {
    word w = word(memory[ip]) | (word(memory[ip + 1]) << 8);
    ip += 2;
    return w;
}

byte getidxbyte() {
    return idxbyte = getbyte();
}

// fwd decls
void doCB();
void doED(); 

void doDD() {
    idxmode = idx_ix;
    dis();
}
void doFD() {
    idxmode = idx_iy;
    dis();
}

char pszix[] = "(IX+$xx)";
char psziy[] = "(IY+$xx)";

void put8bit(char *dst, byte b) {
    // sign
    dst[0] = (b & 0x80)?'-':'+';
    // doesn't really need to be here now but will in the future
    dst[1] = '$';
    // if neg then make it positive
    if (b & 0x80) b = ~b + 1;
    dst[2] = hexes[b >> 4];
    dst[3] = hexes[b & 0xf];
}


char *reg8(unsigned u) {
    if (u == 0) return "B";
    else if (u == 1) return "C";
    else if (u == 2) return "D";
    else if (u == 3) return "E";
    else if (u == 4 && idxmode == idx_ix) return "IXH";
    else if (u == 4 && idxmode == idx_iy) return "IYH";
    else if (u == 4) return "H";
    else if (u == 5 && idxmode == idx_ix) return "IXL";
    else if (u == 5 && idxmode == idx_iy) return "IYL";
    else if (u == 5) return "L";
    else if (u == 6 && idxmode == idx_ix) {
        put8bit(&(pszix[3]), idxbyte);
        return pszix;
    } else if (u == 6 && idxmode == idx_iy) {
        put8bit(&(psziy[3]), idxbyte);
        return psziy;
    }
    else if (u == 6) return "(HL)";
    else if (u == 7) return "A";
    else return 0;
}

// as above but DON'T add the idxmode to the subscript
char *reg8noidx(unsigned u) {
    if (u == 0) return "B";
    else if (u == 1) return "C";
    else if (u == 2) return "D";
    else if (u == 3) return "E";
    else if (u == 4) return "H";
    else if (u == 5) return "L";
    else if (u == 6) return "(HL)";
    else if (u == 7) return "A";
    else return 0;
}

char *reg16(unsigned u) {
    if (u == 0) return "BC";
    else if (u == 1) return "DE";
    else if (u == 2 && idxmode == idx_ix) return "IX";
    else if (u == 2 && idxmode == idx_iy) return "IY";
    else if (u == 2) return "HL";
    else if (u == 3) return "SP";
    else return 0;
}

char *gethl() { return reg16(2); }

// non stack versions
char *reg16st(unsigned u) {
    if (u == 0) return "BC";
    else if (u == 1) return "DE";
    else if (u == 2 && idxmode == idx_ix) return "IX";
    else if (u == 2 && idxmode == idx_iy) return "IY";
    else if (u == 2) return "HL";
    else if (u == 3) return "AF";
    else return 0;
}

char *ccs[8] = { "NZ", "Z", "NC", "C", "PO", "PE", "P", "M" };
char *cc(unsigned u) { return ccs[u]; }

char *aluops[8] = { "ADD", "ADC", "SUB", "SBC", "AND", "XOR", "OR", "CP" };
char *aluop(unsigned u) { return aluops[u]; }

char *g0gxg7ops[] = { "RLCA", "RRCA", "RLA", "RRA", "DAA", "CPL", "SCF", "CCF" };

void dis() {
    byte b = getbyte();
// split 7/6 5/4/3 2/1/0
// that is the _general_ organisation of the Z80
// some are organized vertically, some horizontally
    byte g0 = b >> 6;
    byte g1 = (b >> 3) & 7;
    byte g2 = b & 7;

    // primitive - ifdec(x) - tests for zero and decrements...
    // executes code if x is zero before decementing
    if (g0 == 0) {
        if (g2 == 0) {
            if (g1 == 0) opcode("NOP");
            if (g1 == 1) opcode("EX", "AF", "AF'");
            // jump target is ip (already updated to next instruction) + offset
            if (g1 == 2) {
                byte o = getbyte();
                addjtarg(o);
                // add condtional rst??? should be possbile DJNZ -1 will call RST $38
                // if B is not zero... bit weird though.
                opcode("DJNZ", o);
            }
            if (g1 == 3) {
                byte o = getbyte();
                addjtarg(o);
                opcode("JR", o);
            }
            if (g1 > 3) {
                byte o = getbyte();
#ifdef _CONDITIONAL_RESET_
                if (o == 0xff) opcode("RST", cc(g1 - 4), byte(0x38));
                else {
                    addjtarg(o);
                    opcode("JR", cc(g1 - 4), o);
                }
#else
                addjtarg(o);
                opcode("JR", cc(g1 - 4), o);
#endif
            }
        }
        if (g2 == 1) {
            if (g1 & 1) opcode("ADD", gethl(), reg16(g1 >> 1));
            else opcode("LD", reg16(g1 >> 1), adddtarg(getword()));
        }
        if (g2 == 2) {
            if (g1 == 0) opcode("LD", "(BC)", "A");
            else if (g1 == 1) opcode("LD", "A", "(BC)");
            else if (g1 == 2) opcode("LD", "(DE)", "A");
            else if (g1 == 3) opcode("LD", "A", "(DE)");
            else if (g1 == 4) {
                opcode("LD", adddtarg(getword()), gethl(), true);
            }
            else if (g1 == 5) opcode("LD", gethl(), adddtarg(getword()), true);
            else if (g1 == 6) opcode("LD", adddtarg(getword()), "A", true);
            else if (g1 == 7) opcode("LD", "A", adddtarg(getword()), true);
        }
        if (g2 == 3) {    // 16 bit inc/decs
            if (g1 & 1) opcode("DEC",reg16(g1 >> 1));
            else opcode("INC",reg16(g1 >> 1));
        }
        if (g2 == 4) {
            if (g1 == 6) getidxbyte();
            opcode("INC", reg8(g1));
        }
        if (g2 == 5) {
            if (g1 == 6) getidxbyte();
            opcode("DEC", reg8(g1));
        }
        if (g2 == 6) opcode("LD", reg8(g1), getbyte());
        if (g2 == 7) opcode(g0gxg7ops[g1]);
    }
    else if (g0 == 1) {
        if (g1 == 6 && g2 == 6) opcode("HALT");
        else {
            if (g2 == 6 && idxmode != idx_off) {
                getidxbyte();
                opcode("LD", reg8noidx(g1), reg8(g2));
            } else if (g1 == 6 && idxmode != idx_off) {
                getidxbyte();
                opcode("LD", reg8(g1), reg8noidx(g2));
            } else {
                opcode("LD", reg8(g1), reg8(g2));
            }
        }
    } else if (g0 == 2) {
        opcode(aluop(g1), reg8(g2));
    } else if (g0 == 3) {
        if (g2 == 0) {
            opcode("RET", cc(g1));
        } else if (g2 == 1) {
            if (g1 & 1) {
                if (g1 == 1) opcode("RET");
                else if (g1 == 3) opcode("EXX");
                else if (g1 == 5) {
#ifdef _NO_INDIRECT_REG_JUMPS_
                    opcode("JP", gethl());
#else
                    if (idxmode == idx_ix) opcode("JP","(IX)");
                    else if (idxmode == idx_iy) opcode("JP","(IY)");
                    else opcode("JP","(HL)");
#endif
                }
                else if (g1 == 7) opcode("LD", "SP", gethl());
            } else {
                opcode("POP", reg16st(g1 >> 1));
            }
        } else if (g2 == 2) {
            opcode("JP", cc(g1), addjtarg(getword()));
        } else if (g2 == 3) {
            if (g1 == 0) {
                opcode("JP", addjtarg(getword()));
            }
            else if (g1 == 1) doCB();
            else if (g1 == 2) opcode("OUT", getbyte(), "A", true);
            else if (g1 == 3) opcode("IN", "A", getbyte(), true);
            else if (g1 == 4) opcode("EX", "(SP)", gethl());
            else if (g1 == 5) opcode("EX", "DE", "HL");
            else if (g1 == 6) opcode("DI");
            else if (g1 == 7) opcode("EI");
        } else if (g2 == 4) {
            opcode("CALL", cc(g1), addjtarg(getword()));
        } else if (g2 == 5) {
            if (g1 & 1) {
                if (g1 == 1) {
                    opcode("CALL", addjtarg(getword()));
                } else if (g1 == 3) doDD();
                else if (g1 == 5) doED();
                else if (g1 == 7) doFD();
            } else {
                opcode("PUSH", reg16st(g1 >> 1));
            }
        } else if (g2 == 6) {
            opcode(aluop(g1), "A", getbyte());
        } else if (g2 == 7) {
            opcode("RST", byte(g1 * 8));
        }
    }
}

char *cbrops[8] = { "RLC", "RRC", "RL", "RR", "SLA", "SRA", "SLL", "SRL" };

void doCB(void) {
    if (idxmode != idx_off) getidxbyte();

    byte b = getbyte();
    byte g0 = b >> 6;
    byte g1 = (b >> 3) & 7;
    byte g2 = b & 7;

    if (g0 == 0) {
        if (idxmode != idx_off && (g2 != 6)) {
            opcode(cbrops[g1], reg8(6), reg8noidx(g2));
        } else {
            opcode(cbrops[g1], reg8(g2));
        }
    } else if (g0 == 1) {
        if (idxmode != idx_off) opcode("BIT", g1, reg8(6));
        else opcode("BIT", g1, reg8(g2));
    }
    else if (g0 == 2) {
        if (idxmode != idx_off && g2 != 6) opcode ("RES", g1, reg8(6), reg8noidx(g2));
        else opcode("RES", g1, reg8(g2));
    }
    else if (g0 == 3) {
        if (idxmode != idx_off && g2 != 6) opcode ("SET", g1, reg8(6), reg8noidx(g2));
        else opcode("SET", g1, reg8(g2));
    }
}

char *edautoops[16] = { "LDI", "LDD", "LDIR", "LDDR", "CPI", "CPD", "CPIR", "CPDR",
                        "INI", "IND", "INIR", "INDR", "OUTI", "OUTD", "OUTIR", "OUTDR" };

void doED() {
    idxmode = idx_off;

    byte b = getbyte();
    byte g0 = b >> 6;
    byte g1 = (b >> 3) & 7;
    byte g2 = b & 7;

    if (g0 == 0 || g0 == 3) opcode("NOP");

    if (g0 == 1) {
        if (g2 == 0) {
            if (g1 != 6) opcode("IN", reg8(g1), "(C)");
            else opcode("IN","(C)");
        } else if (g2 == 1) {
            if (g1 != 6) opcode("OUT", "(C)", reg8(g1));
            else opcode("OUT","(C)", byte(0));
        } else if (g2 == 2) {
            if (g1 & 1) opcode("ADC", "HL", reg16(g1 >> 1));
            else opcode("SBC", "HL", reg16(g1 >> 1));
        } else if (g2 == 3) {
            if (g1 & 1) opcode("LD", reg16(g1 >> 1), getword(), true);
            else opcode("LD", getword(), reg16(g1>> 1), true);
        } else if (g2 == 4) {
            opcode("NEG");
        } else if (g2 == 5) {
            if (g1 == 1) opcode("RETI");
            else opcode("RETN");
        } else if (g2 == 6) {
            g1 &= 3;
            if (g1 > 0) g1--;
            opcode("IM", g1);
        } else if (g2 == 7) {
            if (g1 == 0) opcode("LD","I","A");
            if (g1 == 1) opcode("LD","R","A");
            if (g1 == 2) opcode("LD","A","I");
            if (g1 == 3) opcode("LD","A","R");
            if (g1 == 4) opcode("RRD");
            if (g1 == 5) opcode("RLD");
            if (g1 == 6) opcode("NOP");
            if (g1 == 7) opcode("NOP");
        }
    } else if (g0 == 2) {
        if ((g1 & 4) & (~g2 & 4)) {
            opcode(edautoops[(g1 & 3) | (g2 << 2)]);
        }
        else { opcode("NOP"); }
    }
}
