--
-- : 1.2.2
-- 1.     177660-177665  .    
--		   .
-- 2. extended_reg   mode_reg
--	   pg_out   address_out[18..14]
--	       ,    
--		   _n
--	   bus_control_proc     2  
--	    sync_proc,      
-- : 1.2
--	:
--	1.  ,     _n,  /  
--		 .
--	2.       177130 177132   020, 
--		     .

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;
library altera;
use altera.altera_primitives_components.all;
library altera_mf;
use altera_mf.altera_mf_components.lcell;

entity smk64 is
	port
	(
		clk_in:     in std_logic;
		init_in_n:  in std_logic;           -- pin B19

		-- processor bus (QBUS)
		ad_inout_n: inout std_logic_vector(15 downto 0):=(others=>'Z');
		sync_in_n:  in std_logic;           -- pin B22
		din_in_n:   in std_logic;           -- pin A23
		dout_in_n:  in std_logic;           -- pin B21
		wtbt_in_n:  in std_logic;           -- pin B11
		rply_out_n: out std_logic;          -- pin B20

		-- main computer on-board ROM lock
		bas_out_n:  out std_logic;          -- Basic ROM lock on addresses 120000 - 140000,  pin A14
		bas2_out_n: out std_logic;          -- Basic ROM lock on addresses 160000,           pin A29
		p4o_out_n:  out std_logic;          -- ROM 4 exit,                                   pin A22
		mon10_out_n:out std_logic;          -- BK - 0010 monitor ROM lock,                   pin B1
		mon11_out_n:out std_logic;          -- BK - 0010 monitor ROM lock,                   pin B6

		-- RAM and ROM interface
		address_out:out std_logic_vector(18 downto 1); --  17..00  
		cs0_out_n:  out std_logic;          -- RAM CS
		rd_out_n:   out std_logic;          --   
		wr_out_n:   out std_logic;          --   
		bhe_out_n:  out std_logic;          -- RAM high byte enable
		ble_out_n:  out std_logic;          -- RAM low byte enable
		crf_out_n:  out std_logic;          -- ROM CE

		-- IDE interface
		cw0_out_n:  out std_logic;          -- pin 37 /IDE_CS0
		cw1_out_n:  out std_logic;          -- pin 38 /IDE_CS1
		shd_out_n:  out std_logic;          -- /EN IDE output buffer

		-- Floppy disk interface
		fdd_ds0:    out std_logic;          -- pin 10  0= Drive Select 0
		fdd_ds1:    out std_logic;          -- pin 12  0= Drive Select 1
		fdd_mon:    out std_logic;          -- pin 16  0= Motor Enable Drive 0
		fdd_dir:    out std_logic;          -- pin 18  0= Direction Select
		fdd_st:     out std_logic;          -- pin 20  0= Head Step
		fdd_wd:     out std_logic;          -- pin 22  Write Data
		fdd_wen:    out std_logic;          -- pin 24  Floppy Write Enable, 0=Write Gate
		fdd_sd:     out std_logic;          -- pin 32  0= Head Select
		fdd_idx:    in std_logic;           -- pin 8   1= Index
		fdd_tr0:    in std_logic;           -- pin 26  1= Track 00
		fdd_wp:     in std_logic;           -- pin 28  1=Write Protect
		fdd_rd:     in std_logic;           -- pin 30  Read Data
		fdd_rdy:    in std_logic;           -- pin 34  0=Disk Change/1=Ready

		fdd_test:   in std_logic;

		test1:      out std_logic;
		test2:      out std_logic;
		test3:      out std_logic
	);
end smk64;

architecture behaviour of smk64 is
	component RT5 is
	port
	(
		address: in std_logic_vector(8 downto 0);
		q:      out std_logic_vector(7 downto 0)
	);
	end component;

	component fdd is
	port
	(
		clk:        in std_logic;
		reset:      in std_logic;

		address:    in std_logic_vector(0 downto 0);
		writedata:  in std_logic_vector(15 downto 0);
		chipselect: in std_logic;
		read:       in std_logic;
		write:      in std_logic;
		readdata:   out std_logic_vector(15 downto 0);

		fdd_ds0:    out std_logic;
		fdd_ds1:    out std_logic;
		fdd_ds2:    out std_logic;
		fdd_ds3:    out std_logic;
		fdd_mon:    out std_logic;
		fdd_dir:    out std_logic;
		fdd_st:     out std_logic;
		fdd_wd:     out std_logic;
		fdd_wen:    out std_logic;
		fdd_sd:     out std_logic;
		fdd_idx:    in std_logic;
		fdd_tr0:    in std_logic;
		fdd_wp:     in std_logic;
		fdd_rd:     in std_logic;
		fdd_rdy:    in std_logic;
		fdd_rez:    out std_logic;
		test:       out std_logic
	);
	end component;

	signal reset: std_logic;
	signal sync: std_logic;
	signal sync_d: std_logic;       --     SYNC
	signal dout: std_logic;
	signal din: std_logic;
	signal din_blk: std_logic;      --   DIN
	signal blk128_n: std_logic;       --   177130 177132  
	signal a_n: std_logic_vector(15 downto 0); -- U10 & U11

	signal mode_reg: std_logic_vector(7 downto 1) := (others=>'0'); -- U1004
	signal start_tt: std_logic;
	signal ctm_n, ctm_del: std_logic;

	signal a4n: std_logic;
	signal a7t: std_logic;
	signal a74: std_logic;
	signal m10_n: std_logic;
	signal m11_n: std_logic;
	signal p4_n:  std_logic;
	signal rt5_address: std_logic_vector(8 downto 0);
	signal rt5_q_n: std_logic_vector(7 downto 0);
	signal rt5_ena_n:  std_logic;
	signal xrd:  std_logic;
	signal xwr:  std_logic;
	signal xcrf_n: std_logic;
	signal xcs0: std_logic;
	signal xcs1: std_logic;
	signal xcw0: std_logic;
	signal xcw1: std_logic;
	signal die:  std_logic;
	signal doe:  std_logic;
	signal wr_strobe: std_logic;    -- write impulse with duration of one clock period
	signal wr_del, rd_del: std_logic_vector(2 downto 0);
	signal xrd_del, xrd_del2, xrd_del3, xrd_del4, xrd_del5, xrd_del6: std_logic;
	signal xrd_d: std_logic;
	signal wr_repl: std_logic;
	signal xrpl_n: std_logic;
	signal fdd0_repl: std_logic;

	signal fdd0_reset: std_logic;
	signal fdd0_address: std_logic_vector(1 downto 1);
	signal fdd0_cs: std_logic;
	signal fdd0_rd: std_logic;
	signal fdd0_wr: std_logic;
	signal fdd0_readdata:  std_logic_vector(15 downto 0);
	signal fdd0_writedata: std_logic_vector(15 downto 0);
	signal fdd0_dir: std_logic;
	signal fdd0_mon: std_logic;
	signal fdd0_sd:  std_logic;
	signal fdd0_ds0: std_logic;
	signal fdd0_ds1: std_logic;
	signal fdd0_ds2: std_logic;
	signal fdd0_ds3: std_logic;
	signal fdd0_rez: std_logic;

--	signal glitch_t: std_logic;
	signal fdd0_test: std_logic;
	signal btn_reset: std_logic;
	signal res_demet, res_del1, res_del2: std_logic;
--	signal ac: std_logic_vector(15 downto 0);

begin

--	reset <= not init_in_n or btn_reset; --   
	reset <= not init_in_n;             --   "":      RESET
	sync  <= not sync_in_n;
	din   <= not din_in_n;
	dout  <= not dout_in_n;

	process (clk_in)
	begin
		if rising_edge(clk_in) then
--			res_del2 <= res_del1;       --  
--			res_del1 <= res_demet;
			res_demet <= fdd_test;      --     pin A1
		end if;
	end process;
--	btn_reset <= '1' when res_del1 = '0' and res_del2 = '1' else '0'; --        ,
--	btn_reset <= not res_del1; --'0';                                 -- -  ,    

	process (clk_in)
	begin
		if rising_edge(clk_in) then     --    
			if fdd0_cs = '1' then       --      17713
				btn_reset <= '0';       --  
			elsif res_demet = '0' then  --    
				btn_reset <= '1';       --  
			end if;
		end if;
	end process;

	sync_proc: process (reset, sync)
	begin
		if reset = '1' then
			sync_d <= '0';
		else
			sync_d <= sync;   --  sync.     .    
		end if;
	end process sync_proc;

	bus_control_proc: process (reset, clk_in)
	begin
		if reset = '1' then
			wr_del <= (others => '0');
			rd_del <= (others => '0');
		elsif rising_edge(clk_in) then  --   DIN/DOUT
			wr_del <= wr_del(1) & wr_del(0) & dout;
			rd_del <= rd_del(1) & rd_del(0) & din;
		end if;
	end process bus_control_proc;
	wr_strobe <= wr_del(1) and (not wr_del(2));

	fdd0: fdd port map
	(
		clk         => clk_in,
		reset       => fdd0_reset,
		address     => fdd0_address,
		writedata   => fdd0_writedata,
		chipselect  => fdd0_cs,
		read        => fdd0_rd,
		write       => fdd0_wr,
		readdata    => fdd0_readdata,
		fdd_ds0     => fdd0_ds0,
		fdd_ds1     => fdd0_ds1,
		fdd_ds2     => fdd0_ds2,
		fdd_ds3     => fdd0_ds3,
		fdd_mon     => fdd0_mon,
		fdd_dir     => fdd0_dir,
		fdd_st      => fdd_st,
		fdd_wd      => fdd_wd,
		fdd_wen     => fdd_wen,
		fdd_sd      => fdd0_sd,
		fdd_idx     => fdd_idx,
		fdd_tr0     => fdd_tr0,
		fdd_wp      => fdd_wp,
		fdd_rd      => fdd_rd,
		fdd_rdy     => fdd_rdy,
		fdd_rez     => fdd0_rez,
		test        => fdd0_test
	);

	fdd0_reset <= reset and blk128_n; --     ,    INIT  1-128
	din_blk    <= din   and blk128_n; --     ,    DIN  1-128
	fdd0_address(1) <= not a_n(1);      --   1-128 
	fdd0_writedata  <= not ad_inout_n;   --   1-128
	fdd0_rd <= din_blk;
	fdd0_wr <= wr_strobe;

	fdd_ds0 <= fdd0_ds0;
	fdd_ds1 <= fdd0_ds1;
	fdd_mon <= fdd0_mon;
	fdd_dir <= fdd0_dir;
	fdd_sd  <= fdd0_sd;

--      ,        .
--  bas_out_n  <= fdd0_ds3;
--  bas2_out_n <= fdd0_ds3;
	bas_out_n  <= '1';
	bas2_out_n <= '1';

	blk128_n <= fdd0_ds2; --  2   177130 177132  
						-- 0 - , 1 -  

	fdd0_cs <= '1' when sync_d = '1' and a_n(15 downto 2) = "00000001101001" else '0';

--	 RPLY,      
	fdd0_repl <= (fdd0_cs and 
				 ((din_blk and rd_del(1) and rd_del(2)) or
				  (dout    and wr_del(1) and wr_del(2))));

	ad_inout_n <= not fdd0_readdata when fdd0_cs = '1' and din_blk = '1' else (others => 'Z');
--	     -    
--	     
--	ac <= not fdd0_readdata when fdd0_cs = '1' and din_blk = '1' else (others => '1');
--	ad_outputs: for i in 0 to 15 generate
--	ad_out: opndrn
--	port map
--	(
--		a_in => ac(i),
--		a_out => ad_inout_n(i)
--	);
--	end generate ad_outputs;

	address_latch_proc: process (ad_inout_n, sync)
	begin
		if sync = '0' then
			a_n <= ad_inout_n;
		end if;
	end process address_latch_proc;	

	start_tt_proc: process (reset, clk_in)
	begin
		if reset = '1' then
			start_tt <= '0';
		elsif rising_edge(clk_in) then
			if fdd0_cs = '1' then
				start_tt <= '1';
			end if;
		end if;
	end process start_tt_proc;

--	    ,         4-
--	 ,          .
	ctm_n <= fdd0_ds1 or fdd0_ds2 or not fdd0_ds0 or not fdd0_ds3;

	extended_reg_proc: process (btn_reset, reset, clk_in)
	begin
		if reset = '1' then --   INIT    RESET
			ctm_del <= '1';
		elsif btn_reset = '1' then --    
			mode_reg <= (others => '0'); --  
		elsif rising_edge(clk_in) then
			if start_tt = '1' and ctm_del = '0' and ctm_n = '1' then
				mode_reg <= fdd0_ds0 & fdd0_ds3 & fdd0_sd & fdd0_rez & fdd0_ds2 & fdd0_mon & fdd0_dir;
			end if;
			ctm_del <= ctm_n;
		end if;
	end process extended_reg_proc;

	m10_n       <= mode_reg(5);
	m11_n       <= mode_reg(1);
	p4_n        <= mode_reg(2);
	-- page must be zero for ROM access, may be alternated in future extensions
	address_out(18 downto 12) <= mode_reg(7) & mode_reg(6) & mode_reg(3) & mode_reg(4) & xcs1 & a_n(13) & a_n(12) when xcrf_n = '1' else (others => '0'); --   ,   - 00
	address_out(11 downto 1)  <= a_n(11 downto 1);   --    

--      HDD
	a7t <= not (a_n(11) or a_n(9) or a_n(10));                  -- == 1   111(2)()
	a74 <= not (a_n(8)  or a_n(7) or a_n(6) or a_n(5) or a4n);  -- == 1   11110(2)()
	a4n <= not a_n(4);

	rt5_address <= p4_n & m10_n & m11_n & a_n(14) & a_n(13) & a_n(12) & a7t & a74 & a_n(0); --   RT5
	rt5_comp: rt5 port map
	(
		address => rt5_address,
		q       => rt5_q_n
	);

	rt5_ena_n   <= a_n(15) or not sync_d;    --     1(8)  sync_in_n ,  0,  1
	shd_out_n   <= rt5_ena_n or rt5_q_n(0); --   HDD
	xcw1        <= not (rt5_ena_n or rt5_q_n(1)); -- .  CW1
	xcw0        <= not (rt5_ena_n or rt5_q_n(2)); -- .  CW0 (CS0)
	xcrf_n      <= rt5_ena_n or rt5_q_n(3); --  
	xcs1        <= not (rt5_ena_n or rt5_q_n(4)); --   1 ,  -  
	xcs0        <= not (rt5_ena_n or rt5_q_n(5)); --   0 
	die         <= not (rt5_ena_n or rt5_q_n(6)); --  
	doe         <= not (rt5_ena_n or rt5_q_n(7)); --  

	xrd         <= din  and die;  --    
	xwr         <= dout and doe;  --    

	crf_out_n <= xcrf_n;
	cs0_out_n <= not xcs0;
	cw0_out_n <= not xcw0;
	cw1_out_n <= not xcw1;

	ble_out_n <= not (xcs0 and (wtbt_in_n or     a_n(0)));    --       == 1
	bhe_out_n <= not (xcs0 and (wtbt_in_n or not a_n(0)));    --       == 0

	-- delay line for rd_out_n front
	l1: lcell
	port map
	(
		a_in => xrd,
		a_out => xrd_del
	);
	l2: lcell
	port map
	(
		a_in => xrd_del,
		a_out => xrd_del2
	);
	l3: lcell
	port map
	(
		a_in => xrd_del2,
		a_out => xrd_del3
	);
	l4: lcell
	port map
	(
		a_in => xrd_del3,
		a_out => xrd_del4
	);
	l5: lcell
	port map
	(
		a_in => xrd_del4,
		a_out => xrd_del5
	);
	l6: lcell
	port map
	(
		a_in => xrd_del5,
		a_out => xrd_del6
	);

--	.     177660-177665
	xrd_d <= '0' when a_n(15 downto 3) = "0000000001001" and 
						(a_n(2) = '1' or (a_n(2) = '0' and a_n(1) = '1')) 
			else (xrd or xrd_del6);

	rd_out_n <= not xrd_d;
	wr_out_n <= not xwr;

--	 RPLY     HDD  
	wr_repl <= (xcw0 or xcw1 or xcs0) and xwr;

	xrpl_n <= not (xrd_d or wr_repl or fdd0_repl); --  RPLY  ,         FDD.
	rpl_out: opndrn --  xrpl_n = 0, rply_out_n = 0,  'Z'
	port map
	(
		a_in => xrpl_n,
		a_out => rply_out_n
	);

	mon10_out_n <= m10_n;
	mon11_out_n <= m11_n;
	p40_out: opndrn --  p4_n = 0, p4o_out_n = 0,  'Z'
	port map
	(
		a_in => p4_n,
		a_out => p4o_out_n
	);

/*
	er_cnt_proc: process(reset, clk_in)
	begin
		if rising_edge(clk_in) then
			er_cnt <= er_cnt - 1;
		end if; 
	end process er_cnt_proc;

	er_out: process (er_cnt, a_n, clk_in)
	begin
		case er_cnt(3 downto 0) is
			when "1111" =>  fdd_test <= clk_in;  -- start bit
			when "1110" =>  fdd_test <= rt5_address(8); 
			when "1101" =>  fdd_test <= rt5_address(7);
			when "1100" =>  fdd_test <= rt5_address(6);
			when "1011" =>  fdd_test <= rt5_address(5);
			when "1010" =>  fdd_test <= rt5_address(4);
			when "1001" =>  fdd_test <= rt5_address(3);
			when "1000" =>  fdd_test <= rt5_address(2);
			when "0111" =>  fdd_test <= rt5_address(1);
			when "0110" =>  fdd_test <= rt5_address(0);
			when "0101" =>  fdd_test <= not clk_in;
			when "0100" =>  fdd_test <= '0';
			when "0011" =>  fdd_test <= '0';
			when "0010" =>  fdd_test <= '0';
			when others =>  fdd_test <= '0';
		end case; 
	end process;
*/

/*
	er_out: process (er_cnt, a_n, clk_in)
	begin
		case er_cnt(3 downto 0) is
			when "1111" =>  fdd_test <= clk_in;  -- start bit
			when "1110" =>  fdd_test <= mode_reg(7); 
			when "1101" =>  fdd_test <= mode_reg(6);
			when "1100" =>  fdd_test <= mode_reg(5);
			when "1011" =>  fdd_test <= mode_reg(4);
			when "1010" =>  fdd_test <= mode_reg(3);
			when "1001" =>  fdd_test <= mode_reg(2);
			when "1000" =>  fdd_test <= mode_reg(1);
			when "0111" =>  fdd_test <= not clk_in;
			when "0110" =>  fdd_test <= '0';
			when "0101" =>  fdd_test <= '0';
			when "0100" =>  fdd_test <= '0';
			when "0011" =>  fdd_test <= '0';
			when "0010" =>  fdd_test <= '0';
			when others =>  fdd_test <= '0';
		end case; 
	end process;
*/
/*
	test_out: process(reset, clk_in)
		variable v_break: std_logic;
	begin
		if reset = '1' then
			v_break := '0';
		elsif rising_edge(clk_in) then
			if sync_in_n = '0' then
				if (not a_n) = o"166140" then
					v_break := '1';
--				elsif (not a_n) = o"162532" then
--					v_break := '0';
				end if;
			end if;
		end if;
		fdd_test <= v_break;
	end process test_out;
*/
/*
	test_out: process(reset, clk_in)
		variable v_break: std_logic;
	begin
		if reset = '1' then
			v_break := '0';
		elsif rising_edge(clk_in) then
			if mode_reg = "1101001" then
				v_break := '1';
			end if;
		end if;
		fdd_test <= v_break;
	end process test_out;
*/

--  fdd_test <= fdd0_test;
--  fdd_test <= glitch_t;
--  fdd_test <= not mode_reg(3);

--  test1 <= fdd0_test;
--  test2 <= fdd0_rd;
--  test3 <= fdd0_address(1);
end behaviour;
