-- Copyright (C) 1991-2013 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions
-- and other software and tools, and its AMPP partner logic
-- functions, and any output files from any of the foregoing
-- (including device programming or simulation files), and any
-- associated documentation or information are expressly subject
-- to the terms and conditions of the Altera Program License
-- Subscription Agreement, Altera MegaCore Function License
-- Agreement, or other applicable license agreement, including,
-- without limitation, that your use is for the sole purpose of
-- programming logic devices manufactured by Altera and sold by
-- Altera or its authorized distributors.  Please refer to the
-- applicable agreement for further details.

-- ***************************************************************************
-- This file contains a Vhdl test bench template that is freely editable to
-- suit user's needs .Comments are provided in each section to help the user
-- fill out necessary details.
-- ***************************************************************************
-- Generated on "03/11/2019 20:46:02"

-- Vhdl Test Bench template for design  :  smk64
--
-- Simulation tool : ModelSim-Altera (VHDL)
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;
library altera;
use altera.altera_primitives_components.all;
library altera_mf;
use altera_mf.altera_mf_components.lcell;

ENTITY smk64_tb IS
END smk64_tb;

ARCHITECTURE smk64_arch OF smk64_tb IS
	-- constants
	constant CLKPERIOD : time := 250 ns; -- 4 
	-- signals
	signal tb_wtbt:		std_logic := '0';
	signal tb_bsy_n:	std_logic := '1';
	signal tb_addr_s:   std_logic_vector(15 downto 0) := "0000000000000000"; --    /
	signal tb_data_s:   std_logic_vector(15 downto 0) := "0000000000000000"; --    /

	signal clk_in:     	std_logic;
	signal init_in_n:  	std_logic;           -- pin B19

	-- processor bus (QBUS)
	signal ad_inout_n: 	std_logic_vector(15 downto 0);
	signal sync_in_n:  	std_logic;          -- pin B22
	signal din_in_n:   	std_logic;          -- pin A23
	signal dout_in_n:  	std_logic;          -- pin B21
	signal wtbt_in_n:  	std_logic;          -- pin B11
	signal rply_out_n: 	std_logic;          -- pin B20

	-- main computer on-board ROM lock
	signal bas_out_n:  	std_logic;          -- Basic ROM lock on addresses 120000 - 140000,  pin A14
	signal bas2_out_n: 	std_logic;          -- Basic ROM lock on addresses 160000,           pin A29
	signal p4o_out_n:  	std_logic;          -- ROM 4 exit,                                   pin A22
	signal mon10_out_n:	std_logic;          -- BK - 0010 monitor ROM lock,                   pin B1
	signal mon11_out_n:	std_logic;          -- BK - 0010 monitor ROM lock,                   pin B6

	-- RAM and ROM interface
	signal address_out: std_logic_vector(18 downto 1);
	signal cs0_out_n:  	std_logic;          -- RAM CS
	signal rd_out_n:   	std_logic;
	signal wr_out_n:   	std_logic;
	signal bhe_out_n:  	std_logic;          -- RAM high byte enable
	signal ble_out_n:  	std_logic;          -- RAM low byte enable
	signal crf_out_n:  	std_logic;          -- ROM CE

	-- IDE interface
	signal cw0_out_n:   std_logic;          -- pin 37 /IDE_CS0
	signal cw1_out_n:   std_logic;          -- pin 38 /IDE_CS1
	signal shd_out_n:   std_logic;          -- /EN IDE output buffer

	-- Floppy disk interface
	signal fdd_ds0:     std_logic;          -- pin 10  0= Drive Select 0
	signal fdd_ds1:     std_logic;          -- pin 12  0= Drive Select 1
	signal fdd_mon:     std_logic;          -- pin 16  0= Motor Enable Drive 0
	signal fdd_dir:     std_logic;          -- pin 18  0= Direction Select
	signal fdd_st:      std_logic;          -- pin 20  0= Head Step
	signal fdd_wd:      std_logic;          -- pin 22  Write Data
	signal fdd_wen:     std_logic;          -- pin 24  Floppy Write Enable, 0=Write Gate
	signal fdd_sd:      std_logic;          -- pin 32  0= Head Select
	signal fdd_idx:    	std_logic;           -- pin 8   1= Index
	signal fdd_tr0:    	std_logic;           -- pin 26  1= Track 00
	signal fdd_wp:     	std_logic;           -- pin 28  1=Write Protect
	signal fdd_rd:     	std_logic;           -- pin 30  Read Data
	signal fdd_rdy:    	std_logic;           -- pin 34  0=Disk Change/1=Ready

	signal fdd_test:   	std_logic;

	signal test1:      	std_logic;
	signal test2:      	std_logic;
	signal test3:      	std_logic;

	-- Cyprys
	signal cy_CE_b: std_logic;
	signal cy_WE_b: std_logic;
	signal cy_OE_b: std_logic;
	signal cy_BHE_b: std_logic;
	signal cy_BLE_b: std_logic;
	signal cy_A:    Std_Logic_Vector(17 downto 0);
	signal cy_DQ:   Std_Logic_Vector(15 downto 0);
	signal cy_out:  Std_Logic_Vector(15 downto 0);

	COMPONENT smk64
		PORT (
			clk_in:     in std_logic;
			init_in_n:  in std_logic;           -- pin B19

			-- processor bus (QBUS)
			ad_inout_n: inout std_logic_vector(15 downto 0);
			sync_in_n:  in std_logic;           -- pin B22
			din_in_n:   in std_logic;           -- pin A23
			dout_in_n:  in std_logic;           -- pin B21
			wtbt_in_n:  in std_logic;           -- pin B11
			rply_out_n: out std_logic;          -- pin B20

			-- main computer on-board ROM lock
			bas_out_n:  out std_logic;          -- Basic ROM lock on addresses 120000 - 140000,  pin A14
			bas2_out_n: out std_logic;          -- Basic ROM lock on addresses 160000,           pin A29
			p4o_out_n:  out std_logic;          -- ROM 4 exit,                                   pin A22
			mon10_out_n:out std_logic;          -- BK - 0010 monitor ROM lock,                   pin B1
			mon11_out_n:out std_logic;          -- BK - 0010 monitor ROM lock,                   pin B6

			-- RAM and ROM interface
			address_out:out std_logic_vector(18 downto 1);
			cs0_out_n:  out std_logic;          -- RAM CS
			rd_out_n:   out std_logic;
			wr_out_n:   out std_logic;
			bhe_out_n:  out std_logic;          -- RAM high byte enable
			ble_out_n:  out std_logic;          -- RAM low byte enable
			crf_out_n:  out std_logic;          -- ROM CE

			-- IDE interface
			cw0_out_n:  out std_logic;          -- pin 37 /IDE_CS0
			cw1_out_n:  out std_logic;          -- pin 38 /IDE_CS1
			shd_out_n:  out std_logic;          -- /EN IDE output buffer

			-- Floppy disk interface
			fdd_ds0:    out std_logic;          -- pin 10  0= Drive Select 0
			fdd_ds1:    out std_logic;          -- pin 12  0= Drive Select 1
			fdd_mon:    out std_logic;          -- pin 16  0= Motor Enable Drive 0
			fdd_dir:    out std_logic;          -- pin 18  0= Direction Select
			fdd_st:     out std_logic;          -- pin 20  0= Head Step
			fdd_wd:     out std_logic;          -- pin 22  Write Data
			fdd_wen:    out std_logic;          -- pin 24  Floppy Write Enable, 0=Write Gate
			fdd_sd:     out std_logic;          -- pin 32  0= Head Select
			fdd_idx:    in std_logic;           -- pin 8   1= Index
			fdd_tr0:    in std_logic;           -- pin 26  1= Track 00
			fdd_wp:     in std_logic;           -- pin 28  1=Write Protect
			fdd_rd:     in std_logic;           -- pin 30  Read Data
			fdd_rdy:    in std_logic;           -- pin 34  0=Disk Change/1=Ready

			fdd_test:   in std_logic;

			test1:      out std_logic;
			test2:      out std_logic;
			test3:      out std_logic
		);
	END COMPONENT;

	COMPONENT async_256Kx16
	Port (
		CE_b    : IN Std_Logic;	                                                -- Chip Enable CE#
		WE_b  	: IN Std_Logic;	                                                -- Write Enable WE#
		OE_b  	: IN Std_Logic;                                                 -- Output Enable OE#
		BHE_b	: IN std_logic;                                                 -- Byte Enable High BHE#
		BLE_b   : IN std_logic;                                                 -- Byte Enable Low BLE#
		A 		: IN Std_Logic_Vector(17 downto 0);                    -- Address Inputs A
		DQ		: INOUT Std_Logic_Vector(15 downto 0):=(others=>'Z')   -- Read/Write Data IO
		); 
	End COMPONENT;

BEGIN
	i1 : smk64
	PORT MAP (
-- list connections between master ports and signals
		ad_inout_n      => ad_inout_n,
		address_out     => address_out,
		bas2_out_n      => bas2_out_n,
		bas_out_n       => bas_out_n,
		bhe_out_n       => bhe_out_n,
		ble_out_n       => ble_out_n,
		clk_in          => clk_in,
		crf_out_n       => crf_out_n,
		cs0_out_n       => cs0_out_n,
		cw0_out_n       => cw0_out_n,
		cw1_out_n       => cw1_out_n,
		din_in_n        => din_in_n,
		dout_in_n       => dout_in_n,
		fdd_dir         => fdd_dir,
		fdd_ds0         => fdd_ds0,
		fdd_ds1         => fdd_ds1,
		fdd_idx         => fdd_idx,
		fdd_mon         => fdd_mon,
		fdd_rd          => fdd_rd,
		fdd_rdy         => fdd_rdy,
		fdd_sd          => fdd_sd,
		fdd_st          => fdd_st,
		fdd_test        => fdd_test,
		fdd_tr0         => fdd_tr0,
		fdd_wd          => fdd_wd,
		fdd_wen         => fdd_wen,
		fdd_wp          => fdd_wp,
		init_in_n       => init_in_n,
		mon10_out_n     => mon10_out_n,
		mon11_out_n     => mon11_out_n,
		p4o_out_n       => p4o_out_n,
		rd_out_n        => rd_out_n,
		rply_out_n      => rply_out_n,
		shd_out_n       => shd_out_n,
		sync_in_n       => sync_in_n,
		test1           => test1,
		test2           => test2,
		test3           => test3,
		wr_out_n        => wr_out_n,
		wtbt_in_n       => wtbt_in_n
	);

	cypr: async_256Kx16
	port map (
		CE_b    => cy_CE_b,
		WE_b  	=> cy_WE_b,
		OE_b  	=> cy_OE_b,
		BHE_b	=> cy_BHE_b,
		BLE_b   => cy_BLE_b,
		A 		=> cy_A,
		DQ		=> cy_DQ
	);

	cy_CE_b <= cs0_out_n;
	cy_WE_b <= wr_out_n;
	cy_OE_b <= rd_out_n;
	cy_BHE_b <= bhe_out_n;
	cy_BLE_b <= ble_out_n;
	cy_A     <= address_out;

	cy_DQ <= ad_inout_n;
	ad_inout_n <= cy_DQ when cy_CE_b = '0' and cy_OE_b = '0' else (others =>'Z');

--	cy_out <= cy_DQ when cy_CE_b = '0' and cy_OE_b = '0' else (others =>'1');
--	cyoe0:  opndrn port map( a_in => cy_out(0),  a_out => ad_inout_n(0));
--	cyoe1:  opndrn port map( a_in => cy_out(1),  a_out => ad_inout_n(1));
--	cyoe2:  opndrn port map( a_in => cy_out(2),  a_out => ad_inout_n(2));
--	cyoe3:  opndrn port map( a_in => cy_out(3),  a_out => ad_inout_n(3));
--	cyoe4:  opndrn port map( a_in => cy_out(4),  a_out => ad_inout_n(4));
--	cyoe5:  opndrn port map( a_in => cy_out(5),  a_out => ad_inout_n(5));
--	cyoe6:  opndrn port map( a_in => cy_out(6),  a_out => ad_inout_n(6));
--	cyoe7:  opndrn port map( a_in => cy_out(7),  a_out => ad_inout_n(7));
--	cyoe8:  opndrn port map( a_in => cy_out(8),  a_out => ad_inout_n(8));
--	cyoe9:  opndrn port map( a_in => cy_out(9),  a_out => ad_inout_n(9));
--	cyoe10: opndrn port map( a_in => cy_out(10), a_out => ad_inout_n(10));
--	cyoe11: opndrn port map( a_in => cy_out(11), a_out => ad_inout_n(11));
--	cyoe12: opndrn port map( a_in => cy_out(12), a_out => ad_inout_n(12));
--	cyoe13: opndrn port map( a_in => cy_out(13), a_out => ad_inout_n(13));
--	cyoe14: opndrn port map( a_in => cy_out(14), a_out => ad_inout_n(14));
--	cyoe15: opndrn port map( a_in => cy_out(15), a_out => ad_inout_n(15));

	init : PROCESS
	-- variable declarations
	BEGIN
		-- code that executes only once
		init_in_n  <= 'Z';
		tb_wtbt <= '0';
		wait until rising_edge(clk_in);
		init_in_n <= '0';	--   
		wait for 2000 ns;
		init_in_n <= '1';	-- 
	WAIT;
	END PROCESS init;

	always : PROCESS
	-- optional sensitivity list
	-- (        )
	-- variable declarations
		variable tb_addr:   bit_vector(15 downto 0) := "0000000000000000"; --    /
		variable tb_data:   bit_vector(15 downto 0) := "0000000000000000"; --    /

		procedure qbus_write (
			addr : in bit_vector(15 downto 0);
			data : in bit_vector(15 downto 0);
			signal wtbt : in std_logic
		) is
		begin
			wait until rising_edge(clk_in); -- 0
			sync_in_n <= '1';
			wtbt_in_n <= '1';
			wait until falling_edge(clk_in); --1
			tb_bsy_n <= '0';
			din_in_n  <= '1';
			dout_in_n <= '1';
			wtbt_in_n <= '0';
			ad_inout_n <= not to_stdlogicvector(addr);
			wait until falling_edge(clk_in); --2
			sync_in_n <= '0';
			wait until rising_edge(clk_in); --2
			wtbt_in_n <= '1';
			ad_inout_n <= (others => 'Z');
			wait until falling_edge(clk_in); --3
			wait until rising_edge(clk_in); --3
			ad_inout_n <= not to_stdlogicvector(data);
			wait until falling_edge(clk_in); --4
			wtbt_in_n <= not wtbt;
			dout_in_n <= '0';
			wait on rply_out_n until rply_out_n = '0';
			wait until falling_edge(clk_in); --6
			wait until falling_edge(clk_in); --7
			wait until rising_edge(clk_in); --7
			dout_in_n <= '1';
			wait until falling_edge(clk_in); --8
			ad_inout_n <= (others => 'Z');
			wtbt_in_n <= '1';
			if (rply_out_n = '0') then
				wait on rply_out_n until rply_out_n /= '0';
			end if;
			wait until falling_edge(clk_in); --9
			sync_in_n <= '1';
			tb_bsy_n <= '1';
			wait until rising_edge(clk_in);
		end procedure qbus_write;

		procedure qbus_read (
			addr : in bit_vector(15 downto 0);
			data : inout bit_vector(15 downto 0)
		) is
		begin
			wait until rising_edge(clk_in); -- 0
			sync_in_n <= '1';
			wait until falling_edge(clk_in); --1
			tb_bsy_n <= '0';
			din_in_n <= '1';
			dout_in_n <= '1';
			wtbt_in_n <= '1';
			ad_inout_n <= not to_stdlogicvector(addr);
			wait until falling_edge(clk_in); --2
			sync_in_n <= '0';
			wait until rising_edge(clk_in); --2
			din_in_n <= '0';
			ad_inout_n <= (others => 'Z');
			wait on rply_out_n until rply_out_n = '0';
			wait until falling_edge(clk_in); --5
			wait until falling_edge(clk_in); --6
			wait until rising_edge(clk_in); --7
			data := not to_bitvector(ad_inout_n);
			din_in_n <= '1';
			if (rply_out_n = '0') then
				wait on rply_out_n until rply_out_n /= '0';
			end if;
			wait until falling_edge(clk_in); --9
			sync_in_n <= '1';
			tb_bsy_n <= '1';
			wait until rising_edge(clk_in);
		end qbus_read;


	BEGIN
		ad_inout_n (15 downto 0) <= (others => 'Z');
		tb_bsy_n <= '1';
		sync_in_n <= '1';
		din_in_n  <= '1';
		dout_in_n <= '1';
		wtbt_in_n <= '1';
		wait for 3000 ns;
		-- code executes for every event on sensitivity list
		--   120
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000110"; --6
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000001010000"; --0120
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000000"; --0
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		--    137130,  
		tb_addr (15 downto 0) := "1011111001011000"; --177130
		tb_data (15 downto 0) := "0101010101010101"; --52525
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		wait for 1000 ns;
		--   20
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000110"; --6
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000010000"; --020
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000000"; --0
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		wait for 1000 ns;
		--    177130,   (     )
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "1010101010101010"; --125252
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		wait for 1000 ns;
		--    177130,  (       )
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_addr_s <= to_stdlogicvector(tb_addr);
		qbus_read(tb_addr, tb_data);
		tb_data_s <= to_stdlogicvector(tb_data);
		wait for 1000 ns;
		--    
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000100"; --4
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		wait for 1000 ns;
		--    177130,  (    )
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_addr_s <= to_stdlogicvector(tb_addr);
		qbus_read(tb_addr, tb_data);
		tb_data_s <= to_stdlogicvector(tb_data);
		wait for 1000 ns;
		--    177660, ,  , ..   
--		tb_addr (15 downto 0) := "1111111110110000"; --177660
--        tb_data (15 downto 0) := "0000000001000000"; --100
--		tb_addr_s <= to_stdlogicvector(tb_addr);
--		tb_data_s <= to_stdlogicvector(tb_data);
--		qbus_write(tb_addr, tb_data, tb_wtbt);
        --    177660, 
--		tb_addr (15 downto 0) := "1111111110110000"; --177660
--		tb_addr_s <= to_stdlogicvector(tb_addr);
--		qbus_read(tb_addr, tb_data);
--		tb_data_s <= to_stdlogicvector(tb_data);
--		wait for 1000 ns;
		--   160
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000110"; --6
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000001100000"; --0140
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000000"; --0
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		wait for 1000 ns;
		--    177130, 
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000010001"; --21
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		--    177132, 
		tb_addr (15 downto 0) := "1111111001011010"; --177132
		tb_data (15 downto 0) := "0101010101010110";
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);

		--    177130, 
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_addr_s <= to_stdlogicvector(tb_addr);
		qbus_read(tb_addr, tb_data);
		tb_data_s <= to_stdlogicvector(tb_data);
		--    177132, 
		tb_addr (15 downto 0) := "1111111001011010"; --177132
		tb_addr_s <= to_stdlogicvector(tb_addr);
		qbus_read(tb_addr, tb_data);
		tb_data_s <= to_stdlogicvector(tb_data);

	WAIT;
	END PROCESS always;

	p_clk  : process
	begin
		clk_in <= '0';
		wait for CLKPERIOD / 2;
		clk_in <= '1';
		wait for CLKPERIOD / 2;
	end process p_clk;


END smk64_arch;
