-- Copyright (C) 1991-2011 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions
-- and other software and tools, and its AMPP partner logic
-- functions, and any output files from any of the foregoing
-- (including device programming or simulation files), and any
-- associated documentation or information are expressly subject
-- to the terms and conditions of the Altera Program License
-- Subscription Agreement, Altera MegaCore Function License
-- Agreement, or other applicable license agreement, including,
-- without limitation, that your use is for the sole purpose of
-- programming logic devices manufactured by Altera and sold by
-- Altera or its authorized distributors.  Please refer to the
-- applicable agreement for further details.

-- ***************************************************************************
-- This file contains a Vhdl test bench template that is freely editable to
-- suit user's needs .Comments are provided in each section to help the user
-- fill out necessary details.
-- ***************************************************************************
-- Generated on "04/21/2019 12:38:19"

-- Vhdl Test Bench template for design  :  smk64
--
-- Simulation tool : ModelSim-Altera (VHDL)
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY smk64_vhd_tst IS
END smk64_vhd_tst;
ARCHITECTURE smk64_arch OF smk64_vhd_tst IS
	-- constants
	constant CLKPERIOD : time := 250 ns; -- 4 МГц
	-- signals
	signal tb_wtbt:		std_logic := '0';
	signal tb_bsy_n:	std_logic := '1';
	signal tb_addr_s:   std_logic_vector(15 downto 0) := "0000000000000000"; -- адрес для циклов чтения/записи
	signal tb_data_s:   std_logic_vector(15 downto 0) := "0000000000000000"; -- данные для циклов чтения/записи

SIGNAL ad : STD_LOGIC_VECTOR(15 DOWNTO 0);
SIGNAL address : STD_LOGIC_VECTOR(13 DOWNTO 1);
SIGNAL bas : STD_LOGIC;
SIGNAL bas2 : STD_LOGIC;
SIGNAL bhe : STD_LOGIC;
SIGNAL ble : STD_LOGIC;
SIGNAL clk : STD_LOGIC;
SIGNAL crf : STD_LOGIC;
SIGNAL cs0 : STD_LOGIC;
SIGNAL cw0 : STD_LOGIC;
SIGNAL cw1 : STD_LOGIC;
SIGNAL din : STD_LOGIC;
SIGNAL dout : STD_LOGIC;
SIGNAL epg : STD_LOGIC_VECTOR(2 DOWNTO 0);
SIGNAL fdd_dir : STD_LOGIC;
SIGNAL fdd_ds0 : STD_LOGIC;
SIGNAL fdd_ds1 : STD_LOGIC;
SIGNAL fdd_idx : STD_LOGIC;
SIGNAL fdd_mon : STD_LOGIC;
SIGNAL fdd_rd : STD_LOGIC;
SIGNAL fdd_rdy : STD_LOGIC;
SIGNAL fdd_sd : STD_LOGIC;
SIGNAL fdd_st : STD_LOGIC;
SIGNAL fdd_test : STD_LOGIC;
SIGNAL fdd_tr0 : STD_LOGIC;
SIGNAL fdd_wd : STD_LOGIC;
SIGNAL fdd_wen : STD_LOGIC;
SIGNAL fdd_wp : STD_LOGIC;
SIGNAL mon10 : STD_LOGIC;
SIGNAL mon11 : STD_LOGIC;
SIGNAL p4o : STD_LOGIC;
SIGNAL pg : STD_LOGIC_VECTOR(1 DOWNTO 0);
SIGNAL rd : STD_LOGIC;
SIGNAL rpl : STD_LOGIC;
SIGNAL rst_n : STD_LOGIC;
SIGNAL shd : STD_LOGIC;
SIGNAL syn : STD_LOGIC;
SIGNAL test1 : STD_LOGIC;
SIGNAL test2 : STD_LOGIC;
SIGNAL test3 : STD_LOGIC;
SIGNAL wbt : STD_LOGIC;
SIGNAL wr : STD_LOGIC;
COMPONENT smk64
	PORT (
	ad : INOUT STD_LOGIC_VECTOR(15 DOWNTO 0);
	address : OUT STD_LOGIC_VECTOR(13 DOWNTO 1);
	bas : OUT STD_LOGIC;
	bas2 : OUT STD_LOGIC;
	bhe : OUT STD_LOGIC;
	ble : OUT STD_LOGIC;
	clk : IN STD_LOGIC;
	crf : OUT STD_LOGIC;
	cs0 : OUT STD_LOGIC;
	cw0 : OUT STD_LOGIC;
	cw1 : OUT STD_LOGIC;
	din : IN STD_LOGIC;
	dout : IN STD_LOGIC;
	epg : OUT STD_LOGIC_VECTOR(2 DOWNTO 0);
	fdd_dir : OUT STD_LOGIC;
	fdd_ds0 : OUT STD_LOGIC;
	fdd_ds1 : OUT STD_LOGIC;
	fdd_idx : IN STD_LOGIC;
	fdd_mon : OUT STD_LOGIC;
	fdd_rd : IN STD_LOGIC;
	fdd_rdy : IN STD_LOGIC;
	fdd_sd : OUT STD_LOGIC;
	fdd_st : OUT STD_LOGIC;
	fdd_test : IN STD_LOGIC;
	fdd_tr0 : IN STD_LOGIC;
	fdd_wd : OUT STD_LOGIC;
	fdd_wen : OUT STD_LOGIC;
	fdd_wp : IN STD_LOGIC;
	mon10 : OUT STD_LOGIC;
	mon11 : OUT STD_LOGIC;
	p4o : OUT STD_LOGIC;
	pg : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
	rd : OUT STD_LOGIC;
	rpl : OUT STD_LOGIC;
	rst_n : IN STD_LOGIC;
	shd : OUT STD_LOGIC;
	syn : IN STD_LOGIC;
	test1 : OUT STD_LOGIC;
	test2 : OUT STD_LOGIC;
	test3 : OUT STD_LOGIC;
	wbt : IN STD_LOGIC;
	wr : OUT STD_LOGIC
	);
END COMPONENT;
BEGIN
	i1 : smk64
	PORT MAP (
-- list connections between master ports and signals
	ad => ad,
	address => address,
	bas => bas,
	bas2 => bas2,
	bhe => bhe,
	ble => ble,
	clk => clk,
	crf => crf,
	cs0 => cs0,
	cw0 => cw0,
	cw1 => cw1,
	din => din,
	dout => dout,
	epg => epg,
	fdd_dir => fdd_dir,
	fdd_ds0 => fdd_ds0,
	fdd_ds1 => fdd_ds1,
	fdd_idx => fdd_idx,
	fdd_mon => fdd_mon,
	fdd_rd => fdd_rd,
	fdd_rdy => fdd_rdy,
	fdd_sd => fdd_sd,
	fdd_st => fdd_st,
	fdd_test => fdd_test,
	fdd_tr0 => fdd_tr0,
	fdd_wd => fdd_wd,
	fdd_wen => fdd_wen,
	fdd_wp => fdd_wp,
	mon10 => mon10,
	mon11 => mon11,
	p4o => p4o,
	pg => pg,
	rd => rd,
	rpl => rpl,
	rst_n => rst_n,
	shd => shd,
	syn => syn,
	test1 => test1,
	test2 => test2,
	test3 => test3,
	wbt => wbt,
	wr => wr
	);
init : PROCESS
-- variable declarations
BEGIN
        -- code that executes only once
    rst_n  <= 'Z';
    tb_wtbt <= '0';
    wait until rising_edge(clk);
    rst_n <= '0';	-- подаём сигнал инициализации
    wait for 2000 ns;
    rst_n <= '1';	-- снимаем
WAIT;
END PROCESS init;
always : PROCESS
-- optional sensitivity list
-- (        )
-- variable declarations
		variable tb_addr:   bit_vector(15 downto 0) := "0000000000000000"; -- адрес для циклов чтения/записи
		variable tb_data:   bit_vector(15 downto 0) := "0000000000000000"; -- данные для циклов чтения/записи

		procedure qbus_write (
			addr : in bit_vector(15 downto 0);
			data : in bit_vector(15 downto 0);
			signal wtbt : in std_logic
		) is
		begin
			wait until rising_edge(clk); -- Т0
			syn <= '1';
			wbt <= '1';
			wait until falling_edge(clk); --Т1
			tb_bsy_n <= '0';
			din  <= '1';
			dout <= '1';
			wbt <= '0';
			ad <= not to_stdlogicvector(addr);
			wait until falling_edge(clk); --Т2
			syn <= '0';
			wait until rising_edge(clk); --Т2
			wbt <= '1';
			ad <= (others => 'Z');
			wait until falling_edge(clk); --Т3
			wait until rising_edge(clk); --Т3
			ad <= not to_stdlogicvector(data);
			wait until falling_edge(clk); --Т4
			wbt <= not wtbt;
			dout <= '0';
			wait on rpl until rpl = '0';
			wait until falling_edge(clk); --Т6
			wait until falling_edge(clk); --Т7
			wait until rising_edge(clk); --Т7
			dout <= '1';
			wait until falling_edge(clk); --Т8
			ad <= (others => 'Z');
			wbt <= '1';
			if (rpl = '0') then
				wait on rpl until rpl /= '0';
			end if;
			wait until falling_edge(clk); --Т9
			syn <= '1';
			tb_bsy_n <= '1';
			wait until rising_edge(clk);
		end procedure qbus_write;

		procedure qbus_read (
			addr : in bit_vector(15 downto 0);
			data : inout bit_vector(15 downto 0)
		) is
		begin
			wait until rising_edge(clk); -- Т0
			syn <= '1';
			wait until falling_edge(clk); --Т1
			tb_bsy_n <= '0';
			din <= '1';
			dout <= '1';
			wbt <= '1';
			ad <= not to_stdlogicvector(addr);
			wait until falling_edge(clk); --Т2
			syn <= '0';
			wait until rising_edge(clk); --Т2
			din <= '0';
			ad <= (others => 'Z');
			wait on rpl until rpl = '0';
			wait until falling_edge(clk); --Т5
			wait until falling_edge(clk); --Т6
			wait until rising_edge(clk); --Т7
			data := not to_bitvector(ad);
			din <= '1';
			if (rpl = '0') then
				wait on rpl until rpl /= '0';
			end if;
			wait until falling_edge(clk); --Т9
			syn <= '1';
			tb_bsy_n <= '1';
			wait until rising_edge(clk);
		end qbus_read;


BEGIN
        -- code executes for every event on sensitivity list
		ad (15 downto 0) <= (others => 'Z');
		tb_bsy_n <= '1';
		syn <= '1';
		din  <= '1';
		dout <= '1';
		wbt <= '1';
		wait for 3000 ns;
		-- code executes for every event on sensitivity list
		-- установим режим 120
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000110"; --6
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000001010000"; --0120
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000000"; --0
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		-- запишем по адресу 137130, контрольное число
		tb_addr (15 downto 0) := "1011111001011000"; --177130
		tb_data (15 downto 0) := "0101010101010101"; --52525
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		wait for 1000 ns;
		-- установим режим 20
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000110"; --6
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000010000"; --020
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000000"; --0
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		wait for 1000 ns;
		-- запишем по адресу 177130, контрольное число (запись в память не должна происходить)
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "1010101010101010"; --125252
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		wait for 1000 ns;
		-- прочитаем по адресу 177130, значение (должно читаться и из памяти и из регистра)
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_addr_s <= to_stdlogicvector(tb_addr);
		qbus_read(tb_addr, tb_data);
		tb_data_s <= to_stdlogicvector(tb_data);
		wait for 1000 ns;
		-- запретим чтение из регистров
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000100"; --4
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		wait for 1000 ns;
		-- прочитаем по адресу 177130, значение (должно читаться только из памяти)
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_addr_s <= to_stdlogicvector(tb_addr);
		qbus_read(tb_addr, tb_data);
		tb_data_s <= to_stdlogicvector(tb_data);
		wait for 1000 ns;
		-- запишем по адресу 177660, значение, записи нет, т.к. не сэмулирована БК
--		tb_addr (15 downto 0) := "1111111110110000"; --177660
--        tb_data (15 downto 0) := "0000000001000000"; --100
--		tb_addr_s <= to_stdlogicvector(tb_addr);
--		tb_data_s <= to_stdlogicvector(tb_data);
--		qbus_write(tb_addr, tb_data, tb_wtbt);
        -- прочитаем по адресу 177660, значение
--		tb_addr (15 downto 0) := "1111111110110000"; --177660
--		tb_addr_s <= to_stdlogicvector(tb_addr);
--		qbus_read(tb_addr, tb_data);
--		tb_data_s <= to_stdlogicvector(tb_data);
--		wait for 1000 ns;
		-- установим режим 160
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000110"; --6
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000001100000"; --0140
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000000000"; --0
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		wait for 1000 ns;
		-- запишем по адресу 177130, значение
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_data (15 downto 0) := "0000000000010001"; --21
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);
		-- запишем по адресу 177132, значение
		tb_addr (15 downto 0) := "1111111001011010"; --177132
		tb_data (15 downto 0) := "0101010101010110";
		tb_addr_s <= to_stdlogicvector(tb_addr);
		tb_data_s <= to_stdlogicvector(tb_data);
		qbus_write(tb_addr, tb_data, tb_wtbt);

		-- прочитаем по адресу 177130, значение
		tb_addr (15 downto 0) := "1111111001011000"; --177130
		tb_addr_s <= to_stdlogicvector(tb_addr);
		qbus_read(tb_addr, tb_data);
		tb_data_s <= to_stdlogicvector(tb_data);
		-- прочитаем по адресу 177132, значение
		tb_addr (15 downto 0) := "1111111001011010"; --177132
		tb_addr_s <= to_stdlogicvector(tb_addr);
		qbus_read(tb_addr, tb_data);
		tb_data_s <= to_stdlogicvector(tb_data);

	WAIT;
	END PROCESS always;

	p_clk  : process
	begin
		clk <= '0';
		wait for CLKPERIOD / 2;
		clk <= '1';
		wait for CLKPERIOD / 2;
	end process p_clk;

END smk64_arch;
