--
-- Версия: 1.3
--  1. добавлена дыра в адресах 177660-177665 по чтению, чтобы не было конфликтов
--		при чтении регистров БК.
--	2. Исправлен баг с не блокировкой регистров 177130 177132 в режиме 020, при
--		включённой блокировке этих регистров по чтению.
--  Чтобы прошивку было можно скомпилировать были проделаны следующие оптимизации:
--      1. Добавлен процесс sync_proc - ретранслятор сигнала sync. Без него ни в
--      какую не компилируется, не хватает соединений между ячейками.
--      2. переделан start_tt_proc и упрощен extended_reg_proc
--      3. Видоизменено формирование сигналов pg и epg


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;
library altera;
use altera.altera_primitives_components.all;
library altera_mf;
use altera_mf.altera_mf_components.lcell;

entity smk64 is
	port
	(
		clk: in std_logic;
		rst_n: in std_logic;				 -- pin B19

		-- processor bus (QBUS)
		ad: inout std_logic_vector(15 downto 0);
		syn: in std_logic;					-- pin B22
		din: in std_logic;					-- pin A23
		dout: in std_logic;					-- pin B21
		wbt: in std_logic;					-- pin B11
		rpl: out std_logic;					-- pin B20

		-- main compter on-board ROM lock
		bas: out std_logic;				 -- Basic ROM lock on addresses 120000 - 140000,	pin A14
		bas2: out std_logic;			 -- Basic ROM lock on addresses 160000,				pin A29
		p4o: out std_logic;				 -- ROM 4 exit,										pin A22
		mon10: out std_logic;			 -- BK - 0010 monitor ROM lock,						pin B1
		mon11: out std_logic;			 -- BK - 0010 monitor ROM lock,						pin B6

		-- RAM and ROM interface
		address: out std_logic_vector(13 downto 1);
		pg:	 out std_logic_vector(1 downto 0);
		epg: out std_logic_vector(2 downto 0);
		cs0: out std_logic;		-- RAM CS
		rd:	 out std_logic;
		wr:	 out std_logic;
		bhe: out std_logic;		-- RAM high byte enable
		ble: out std_logic;		-- RAM low byte enable
		crf: out std_logic;		-- ROM CE

		-- IDE interface
		cw0: out std_logic;		-- pin 37 /IDE_CS0
		cw1: out std_logic;		-- pin 38	/IDE_CS1
		shd: out std_logic;		-- /EN IDE output buffer

		-- Floppy disk interface
		fdd_ds0: out std_logic;	 -- pin 10	0= Drive Select 0
		fdd_ds1: out std_logic;	 -- pin 12	0= Drive Select 1
		fdd_mon: out std_logic;	 -- pin 16	0= Motor Enable Drive 0
		fdd_dir: out std_logic;	 -- pin 18	0= Direction Select
		fdd_st:	 out std_logic;	 -- pin 20	0= Head Step
		fdd_wd:	 out std_logic;	 -- pin 22	Write Data
		fdd_wen: out std_logic;	 -- pin 24	Floppy Write Enable, 0=Write Gate
		fdd_sd:	 out std_logic;	 -- pin 32	0= Head Select
		fdd_idx: in std_logic;	 -- pin 8		1= Index
		fdd_tr0: in std_logic;	 -- pin 26	1= Track 00
		fdd_wp:	 in std_logic;	 -- pin 28	1=Write Protect
		fdd_rd:	 in std_logic;	 -- pin 30	Read Data
		fdd_rdy: in std_logic;	 -- pin 34	0=Disk Change/1=Ready

		fdd_test: in std_logic;

	test1: out std_logic;
	test2: out std_logic;
	test3: out std_logic
	);
end smk64;

architecture behaviour of smk64 is
	component RT5 is
	port
	(
		address: in std_logic_vector(8 downto 0);
		q: out std_logic_vector(7 downto 0)
	);
	end component;

	component fdd is
	port
	(
		clk: in std_logic;
		reset: in std_logic;

		address: in std_logic_vector(0 downto 0);
		writedata: in std_logic_vector(15 downto 0);
		chipselect: in std_logic;
		read: in std_logic;
		write: in std_logic;
		readdata: out std_logic_vector(15 downto 0);

		fdd_ds0: out std_logic;
		fdd_ds1: out std_logic;
		fdd_ds2: out std_logic;
		fdd_ds3: out std_logic;
		fdd_mon: out std_logic;
		fdd_dir: out std_logic;
		fdd_st:	 out std_logic;
		fdd_wd:	 out std_logic;
		fdd_wen: out std_logic;
		fdd_sd:	 out std_logic;
		fdd_idx: in std_logic;
		fdd_tr0: in std_logic;
		fdd_wp:	 in std_logic;
		fdd_rd:	 in std_logic;
		fdd_rdy: in std_logic;
		fdd_rez: out std_logic;
		test: out std_logic
	);
	end component;

	signal reset: std_logic;
	signal din_blk, sync_d, rt5_ena: std_logic;
	signal a: std_logic_vector(15 downto 0); -- U10 & U11
	signal extended_reg: std_logic_vector(7 downto 1) := "0000000";		-- U1004

	signal ac: std_logic_vector(15 downto 0);

	signal start_tt: std_logic;
	signal er_cnt: std_logic_vector(10 downto 0);

	signal a1n: std_logic;
	signal a4n: std_logic;
	signal a7t: std_logic;
	signal a74: std_logic;
	signal m10: std_logic;
	signal m11: std_logic;
	signal p4: std_logic;
	signal ctm, ctm_del: std_logic;
	signal blk128: std_logic;
	signal rt5_address: std_logic_vector(8 downto 0);
	signal rt5_q: std_logic_vector(7 downto 0);
	signal xrd, xrd_d: std_logic;
	signal xwr: std_logic;
	signal xcrf: std_logic;
	signal xcs0: std_logic;
	signal xcs1: std_logic;
	signal xcw0: std_logic;
	signal xcw1: std_logic;
	signal die: std_logic;
	signal doe: std_logic;
	signal xrpl: std_logic;
	signal wr_demet, wr_del, wr_del2: std_logic;
	signal wr_strobe: std_logic;	-- write impulse with duration of one clock period
	signal rd_demet, rd_del, rd_del2: std_logic;
	signal fdd0_repl: std_logic;
	signal wr_repl: std_logic;
	signal reg_cs0: std_logic;
	signal xrd_del, xrd_del2, xrd_del3, xrd_del4, xrd_del5, xrd_del6: std_logic;

	signal fdd0_reset: std_logic;
	signal fdd0_address: std_logic_vector(1 downto 1);
	signal fdd0_cs: std_logic;
	signal fdd0_rd: std_logic;
	signal fdd0_wr: std_logic;
	signal fdd0_readdata: std_logic_vector(15 downto 0);
	signal fdd0_writedata: std_logic_vector(15 downto 0);
	signal fdd0_dir: std_logic;
	signal fdd0_mon: std_logic;
	signal fdd0_sd: std_logic;
	signal fdd0_ds0: std_logic;
	signal fdd0_ds1: std_logic;
	signal fdd0_ds2: std_logic;
	signal fdd0_ds3: std_logic;
	signal fdd0_rez: std_logic;

	signal glitch_t: std_logic;
	signal fdd0_test: std_logic;
	signal btn_reset: std_logic;
	signal res_demet, res_del1, res_del2: std_logic;
begin
	process (clk)
	begin
		if rising_edge(clk) then
			res_del2 <= res_del1;
			res_del1 <= res_demet;
			res_demet <= fdd_test;
		end if;
	end process;
--	btn_reset <= '1' when res_del1 = '0' and res_del2 = '1' else '0';
--	btn_reset <= not res_del1; --'0';
	process (clk)
	begin
		if rising_edge(clk) then
		if fdd0_cs = '1' then
			btn_reset <= '0';
		elsif res_demet = '0' then
			btn_reset <= '1';
		end if;
	end if;
	end process;

--	reset <= not rst_n or btn_reset;
	reset <= not rst_n;

	rt5_comp: rt5
	port map
	(
		address => rt5_address,
		q => rt5_q
	);

	fdd0: fdd
	port map
	(
		clk => clk,
		reset => fdd0_reset,
		address => fdd0_address,
		writedata => fdd0_writedata,
		chipselect => fdd0_cs,
		read => fdd0_rd,
		write => fdd0_wr,
		readdata => fdd0_readdata,
		fdd_ds0 => fdd0_ds0,
		fdd_ds1 => fdd0_ds1,
		fdd_ds2 => fdd0_ds2,
		fdd_ds3 => fdd0_ds3,
		fdd_mon => fdd0_mon,
		fdd_dir => fdd0_dir,
		fdd_st => fdd_st,
		fdd_wd => fdd_wd,
		fdd_wen => fdd_wen,
		fdd_sd => fdd0_sd,
		fdd_idx => fdd_idx,
		fdd_tr0 => fdd_tr0,
		fdd_wp => fdd_wp,
		fdd_rd => fdd_rd,
		fdd_rdy => fdd_rdy,
		fdd_rez => fdd0_rez,
		test => fdd0_test
	);

	fdd0_reset <= reset and blk128;
	fdd0_address(1) <= not a(1);
	fdd0_writedata <= not ad;
	din_blk <= not din and blk128;
	fdd0_rd <= din_blk;
	fdd0_wr <= wr_strobe;
	fdd0_cs <= '1' when sync_d = '0' and a(15 downto 2) = "00000001101001" else '0';
	fdd0_repl <= '0' when (fdd0_cs = '1') and ((din_blk = '1' and rd_del = '1' and rd_del2 = '1') or
		(dout = '0' and wr_del = '1' and wr_del2 = '1'))
		else '1';

	sync_proc: process (reset, syn)
	begin
		if reset = '1' then
			sync_d <= '1';
		else
			sync_d <= syn;
		end if;
	end process sync_proc;

	address_latch_proc: process (ad, syn)
	begin
		if syn = '1' and din = '1' and dout = '1' then
			a <= ad;
		end if;
	end process address_latch_proc;

	start_tt_proc: process (reset, btn_reset, clk)
	begin
		if reset = '1' then
			ctm_del <= '1';
		elsif rising_edge(clk) then
			ctm_del <= ctm;
		end if;
	end process start_tt_proc;

	extended_reg_proc: process (btn_reset, reset, clk)
	begin
		if btn_reset = '1' then
			extended_reg <= "0000000";
		elsif rising_edge(clk) then
			if fdd0_cs = '1' and ctm_del = '0' and ctm = '1' then
				extended_reg <= fdd0_ds0 & fdd0_ds3 & fdd0_sd & fdd0_rez & fdd0_ds2 & fdd0_mon & fdd0_dir;
			end if;
		end if;
	end process extended_reg_proc;

	bus_control_proc: process (reset, clk)
	begin
		if reset = '1' then
			wr_demet <= '0';
			wr_del	 <= '0';
			wr_del2	 <= '0';
			rd_demet <= '0';
			rd_del	 <= '0';
			rd_del2	 <= '0';
		elsif rising_edge(clk) then
			wr_del2	 <= wr_del;
			wr_del	 <= wr_demet;
			wr_demet <= not dout;
			rd_del2	 <= rd_del;
			rd_del	 <= rd_demet;
			rd_demet <= not din;
		end if;
	end process bus_control_proc;
	wr_strobe <= wr_del and not wr_del2;

	m10 <= extended_reg(5);
	m11 <= extended_reg(1);
	p4	<= extended_reg(2);
	-- page must be zero for ROM access, may be alternated in future extensions
	pg <= xcs1 & extended_reg(4) when xcrf = '1' else "00";
--	pg(0) <= extended_reg(4) and rt5_q(3); --xcrf;
--	pg(1) <= rt5_q(4) and rt5_q(3);  -- xcs1 and xcrf
--  epg(0) <= extended_reg(3) and rt5_q(3); -- xcrf
--	pg(0) <= '0';
--	pg(1) <= '0'; -- rt5_q(4);
--  epg(0) <= '0';
	epg <= extended_reg(7) & extended_reg(6) & extended_reg(3) when xcrf = '1' else "000";

	a7t <= not (a(11) or a(9) or a(10));
	a74 <= not (a(8) or a(7) or a(6) or a(5) or a4n);
	a4n <= not a(4);
	ctm <= fdd0_ds1 or fdd0_ds2 or not fdd0_ds0 or not fdd0_ds3;
	blk128 <= fdd0_ds2;

	rt5_address <= p4 & m10 & m11 & a(14) & a(13) & a(12) & a7t & a74 & a(0);
	rt5_ena <= a(15) or sync_d;
	shd	 <= rt5_ena or rt5_q(0);
	xcw1 <= rt5_ena or rt5_q(1);
	xcw0 <= rt5_ena or rt5_q(2);
	xcrf <= rt5_ena or rt5_q(3);
	xcs1 <= rt5_ena or rt5_q(4);
	xcs0 <= rt5_ena or rt5_q(5);
	die	 <= rt5_ena or rt5_q(6);
	doe	 <= rt5_ena or rt5_q(7);

--	ad <= not fdd0_readdata when fdd0_cs = '1' and fdd0_rd = '1' else (others => 'Z');
	ad <= not fdd0_readdata when fdd0_cs = '1' and din_blk = '1' else (others => 'Z');

--	ac <= not fdd0_readdata when fdd0_cs = '1' and fdd0_rd = '1' else (others => '1');
--	ad_outputs: for i in 0 to 15 generate
--	ad_out: opndrn
--	port map
--	(
--		a_in => ac(i),
--		a_out => ad(i)
--	);
--	end generate ad_outputs;

	address(11 downto 1)	<= a(11 downto 1);
--  address(13 downto 12) <= a(13 downto 12) when xcrf = '1' else "00";	
	address(13 downto 12) <= a(13 downto 12) when rt5_q(3) = '1' else "00";
	crf <= xcrf;
	cs0 <= xcs0;
	cw0 <= xcw0;
	cw1 <= xcw1;

	ble <= '1' when (wbt = '0' and a(0) = '0') else '0';
	bhe <= '1' when (wbt = '0' and a(0) = '1') else '0';
	xrd <= din or die;
--  xwr <= '0' when wr_strobe = '1' and (xcw0 = '0' or xcw1 = '0' or xcs0 = '0') and (doe = '0') else '1';
--  xwr <= '0' when doe = '0' and wr_strobe = '1' else '1';
	xwr <= dout or doe;

	-- delay line for rd front
	l1: lcell
	port map
	(
	a_in => xrd,
		a_out => xrd_del
	);
	l2: lcell
	port map
	(
	a_in => xrd_del,
		a_out => xrd_del2
	);
	l3: lcell
	port map
	(
	a_in => xrd_del2,
		a_out => xrd_del3
	);
	l4: lcell
	port map
	(
	a_in => xrd_del3,
		a_out => xrd_del4
	);
	l5: lcell
	port map
	(
	a_in => xrd_del4,
		a_out => xrd_del5
	);
	l6: lcell
	port map
	(
	a_in => xrd_del5,
		a_out => xrd_del6
	);

--	костыль. добавляем дыру в адресах 177660-177665
	xrd_d <= '1' when a(15 downto 3) = "0000000001001" and 
						(a(2) = '1' or (a(2) = '0' and a(1) = '1')) 
			else (xrd and xrd_del6);

	rd <= xrd_d;
	wr <= xwr;

--  wr_repl <= '0' when (xcw0 = '0' or xcw1 = '0' or xcs0 = '0') and (dout = '0' and wr_del = '1' and wr_del2 = '1') and (doe = '0') else '1';
	wr_repl <= '0' when (xcw0 = '0' or xcw1 = '0' or xcs0 = '0') and (doe = '0') and (dout = '0') else '1';
	xrpl <= xrd_d and wr_repl and fdd0_repl;

	rpl_out: opndrn
	port map
	(
		a_in => xrpl,
		a_out => rpl
	);

	mon10 <= m10;
	mon11 <= m11;
	p40_out: opndrn
	port map
	(
		a_in => p4,
		a_out => p4o
	);

--	bas <= fdd0_ds3;
	bas <= '1'; 
--	bas2 <= fdd0_ds3;
	bas2 <= '1';

	/*
	er_cnt_proc: process(reset, clk)
	begin
	if rising_edge(clk) then
			er_cnt <= er_cnt - 1;
		end if;
	end process er_cnt_proc;

	er_out: process (er_cnt, a, clk)
	begin
		case er_cnt(3 downto 0) is
			when "1111" =>	fdd_test <= clk;	-- start bit
			when "1110" =>	fdd_test <= rt5_address(8);
			when "1101" =>	fdd_test <= rt5_address(7);
			when "1100" =>	fdd_test <= rt5_address(6);
			when "1011" =>	fdd_test <= rt5_address(5);
			when "1010" =>	fdd_test <= rt5_address(4);
			when "1001" =>	fdd_test <= rt5_address(3);
			when "1000" =>	fdd_test <= rt5_address(2);
			when "0111" =>	fdd_test <= rt5_address(1);
			when "0110" =>	fdd_test <= rt5_address(0);
			when "0101" =>	fdd_test <= not clk;
			when "0100" =>	fdd_test <= '0';
			when "0011" =>	fdd_test <= '0';
			when "0010" =>	fdd_test <= '0';
		when others =>	fdd_test <= '0';
		end case;
	end process;
*/

/*
	er_out: process (er_cnt, a, clk)
	begin
		case er_cnt(3 downto 0) is
			when "1111" =>	fdd_test <= clk;	-- start bit
			when "1110" =>	fdd_test <= extended_reg(7);
			when "1101" =>	fdd_test <= extended_reg(6);
			when "1100" =>	fdd_test <= extended_reg(5);
			when "1011" =>	fdd_test <= extended_reg(4);
			when "1010" =>	fdd_test <= extended_reg(3);
			when "1001" =>	fdd_test <= extended_reg(2);
			when "1000" =>	fdd_test <= extended_reg(1);
			when "0111" =>	fdd_test <= not clk;
			when "0110" =>	fdd_test <= '0';
			when "0101" =>	fdd_test <= '0';
			when "0100" =>	fdd_test <= '0';
			when "0011" =>	fdd_test <= '0';
			when "0010" =>	fdd_test <= '0';
		when others =>	fdd_test <= '0';
		end case;
	end process;
*/
/*
	test_out: process(reset, clk)
		variable v_break: std_logic;
	begin
		if reset = '1' then
			v_break := '0';
		elsif rising_edge(clk) then
			if syn = '0' then
				if (not a) = o"166140" then
					v_break := '1';
--				elsif (not a) = o"162532" then
--					v_break := '0';
				end if;
			end if;
		end if;
		fdd_test <= v_break;
	end process test_out;
*/
/*
	test_out: process(reset, clk)
		variable v_break: std_logic;
	begin
		if reset = '1' then
			v_break := '0';
		elsif rising_edge(clk) then
			if extended_reg = "1101001" then
				v_break := '1';
			end if;
		end if;
		fdd_test <= v_break;
	end process test_out;
*/

	fdd_ds0 <= fdd0_ds0;
	fdd_ds1 <= fdd0_ds1;
	fdd_mon <= fdd0_mon;
	fdd_dir <= fdd0_dir;
	fdd_sd <= fdd0_sd;

--	fdd_test <= fdd0_test;
--	fdd_test <= glitch_t;
--	fdd_test <= not extended_reg(3);

--	test1 <= fdd0_test;
--	test2 <= fdd0_rd;
--	test3 <= fdd0_address(1);
end behaviour;
