library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

entity smk_dummy is
	port
	(
	  clk: in std_logic;
		rst_n: in std_logic;				 -- pin B19
    clk_out: out std_logic;
		
		-- processor bus (QBUS)
		ad: inout std_logic_vector(15 downto 0); 
		syn: in std_logic;					-- pin B22
		din: in std_logic;				  -- pin A23
		dout: in std_logic;				  -- pin B21
		wbt: in std_logic;				  -- pin B11
		rpl: out std_logic;				  -- pin B20
		
		-- main compter on-board ROM lock
		bas: out std_logic;				 -- Basic ROM lock on addresses 120000 - 140000,  pin A14
		bas2: out std_logic;			 -- Basic ROM lock on addresses 160000,           pin A29
		p4o: out std_logic;				 -- ROM 4 exit,                                   pin A22
		mon10: out std_logic;			 -- BK - 0010 monitor ROM lock,                   pin B1 
		mon11: out std_logic;			 -- BK - 0010 monitor ROM lock,                   pin B6  
		
		-- RAM and ROM interface
		address: out std_logic_vector(13 downto 1);
		pg:  out std_logic_vector(1 downto 0);
		epg: out std_logic_vector(2 downto 0);
		cs0: out std_logic;   -- RAM CS
		rd:  out std_logic;
		wr:  out std_logic;
		bhe: out std_logic;		-- RAM high byte enable
		ble: out std_logic;	  -- RAM low byte enable
		crf: out std_logic;   -- ROM CE	 
		
		-- IDE interface
		cw0: out std_logic;   -- pin 37 /IDE_CS0
		cw1: out std_logic;		-- pin 38	/IDE_CS1 
		shd: out std_logic;   -- /EN IDE output buffer
		
		-- Floppy disk interface
		fdd_ds0: out std_logic;  -- pin 10	0= Drive Select 0	
		fdd_ds1: out std_logic;	 -- pin 12	0= Drive Select 1 
		fdd_mon: out std_logic;	 -- pin 16  0= Motor Enable Drive 0 
		fdd_dir: out std_logic;	 -- pin 18	0= Direction Select
		fdd_st:  out std_logic;	 -- pin 20	0= Head Step 
		fdd_wd:  out std_logic;	 -- pin 22	Write Data 
		fdd_wen: out std_logic;	 -- pin 24	Floppy Write Enable, 0=Write Gate
		fdd_sd:  out std_logic;	 -- pin 32	0= Head Select
		fdd_idx: in std_logic;	 -- pin 8		0= Index
		fdd_tr0: in std_logic;	 -- pin 26	0= Track 00 
		fdd_wp:  in std_logic;	 -- pin 28	0=Write Protect 
		fdd_rd:  in std_logic; 	 -- pin 30	Read Data
		fdd_rdy: in std_logic		 -- pin 34	1=Disk Change/0=Ready		
	);	
end smk_dummy;

architecture behaviour of smk_dummy is
  signal cnt: std_logic_vector(15 downto 0);
begin
	process (clk)
	begin
		if rising_edge(clk) then
			cnt <= cnt + 1;
		end if;	
	end process;

  clk_out <= not clk;
	
	ad(7 downto 0) <= cnt(7 downto 0);
	ad(15 downto 8) <= cnt(7 downto 0);
  address <= cnt(12 downto 0);
	pg <= cnt(1 downto 0);
	epg <= cnt(2 downto 0);
	rd <= '1';
	wr <= '0';
	bhe <= cnt(4);
	ble <= cnt(5);
	crf <= cnt(6);
  rpl <= cnt(7);	
	
	bas <= cnt(3);
	bas2 <= cnt(4);
	p4o <= cnt(5);
	mon10 <= cnt(6);
	mon11 <= cnt(7); 
	
	cw0 <= '1'; -- cnt(4);
	cw1 <= '1'; -- cnt(5);
	shd <= '0';
  cs0 <= '1';
	
	fdd_ds0 <= cnt(2);	
	fdd_ds1 <= cnt(3); 
	fdd_mon <= cnt(4); 
	fdd_dir <= cnt(5);
	fdd_st  <= cnt(6);
	fdd_wd <= cnt(7);
	fdd_wen <= cnt(8);
	fdd_sd <= cnt(9);	
end behaviour;
