;====================================================================
; Main.asm file generated by New Project wizard
;
; Created:     23 2019
; Processor: PIC16F628A
; Compiler:  MPASM (Proteus)
;====================================================================
    __CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _LVP_OFF
;    __CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _XT_OSC & _MCLRE_OFF & _LVP_OFF 

;====================================================================
; DEFINITIONS
;====================================================================

#include p16f628.inc                ; Include register definition file

;====================================================================
; Main.asm file generated by New Project wizard
;
; Created:     1 2019
; Processor: PIC16F84A
; Compiler:  MPASM (Proteus)
;====================================================================
;***** COMPILATION MESSAGES & WARNINGS *****

  ERRORLEVEL -207   ; Found label after column 1.
  ERRORLEVEL -302   ; Register in operand not in bank 0.

;***** MEMORY STRUCTURE *****

  ;ORG     0x00 processor reset vector, declared below
  ;ORG     0x04 interrupt service routine, declared below

;***** PORT DECLARATION *****

  #define TXport  PORTA,0x00  ; RS232 output port, could be
  #define TXtris  TRISA,0x00  ; any active push/pull port
  #define KBDdatapin PORTA,0x04 ; keyboard data input port
  #define KBDdatatris TRISA,0x04  ; (open-collector pin)
  #define KBDclkpin PORTB,0x00  ; keyboard clock input port (IntB)
  #define KBDclktris  TRISB,0x00  ; @ INTF interrupt source (RB0)
  #define ShiftLed  PORTA,2
  #define ShiftLedTris  TRISA,2

;***** CONSTANT DECLARATION *****

  CONSTANT BASE = 0x20  ; Base address of user file registers 

;***** REGISTER DECLARATION *****

  TEMP1 set BASE+d'0' ; Universal temporary register
  TEMP2 set BASE+d'1' ; ATTENTION !!!
  TEMP3 set BASE+d'2' ; They are used by various modules.
  TEMP4 set BASE+d'3' ; If you use them, make sure not to use
          ; them concurrently !
  FLAGreg equ BASE+d'4' ; register containing keyboard and other flags

  TXD equ BASE+d'5' ; RS232 TX-Data register
  RXD equ BASE+d'6' ; RS232 RX-Data register (not used here, but m_rs232
          ; requires its declaration)
  KBDcnt  equ BASE+d'7' ; IRQ based keyboard scan pattern counter
  KBD equ BASE+d'8' ; keyboard scan code & ascii data register
  KBDcopy equ BASE+d'9' ; keyboard scan code register
  #define RELflag FLAGreg,0x00  ; release flag (0xF0)
  #define SHIflag FLAGreg,0x01  ; shift flag (0x12 / 0x59)
  #define SPEflag FLAGreg,0x02  ; special code flag (0xE0)
  #define CAPflag FLAGreg,0x03  ; caps lock flag (0x0D)
  #define ALTflag FLAGreg,0x04  ; ALT flag (0x11)
  #define CTRLflag FLAGreg,0x05 ; CTRL flag (0x14)
  #define KBDflag FLAGreg,0x06  ; keyboard data reception flag

  ; interrupt context save/restore
  W_TEMP  equ BASE+d'10'  ; context register (ISR)
  STATUS_TEMP equ BASE+d'11'  ; context register (ISR)
  PCLATH_TEMP equ BASE+d'12'  ; context register (ISR)
  FSR_TEMP equ  BASE+d'13'  ; context register (ISR)

  ORG 0x190
;  #include "m_bank.asm"
#DEFINE M_BANK_ID dummy

  IFDEF TWO_BANKS
    MESSG "Bank macros customized for two-bank devices"
  ELSE
    MESSG "Bank macros customized for four-bank devices"
  ENDIF

BANK0 macro     ; select register bank 0
  IFDEF TWO_BANKS
    bcf STATUS,RP0  ; for two-bank devices
  ELSE
    bcf STATUS,RP0  ; for four-bank devices
    bcf STATUS,RP1
  ENDIF
  endm
  
BANK1 macro     ; select register bank 1
  IFDEF TWO_BANKS
    bsf STATUS,RP0  ; for two-bank devices
  ELSE
    bsf STATUS,RP0  ; for four-bank devices
    bcf STATUS,RP1
  ENDIF
  endm

BANK2 macro     ; select register bank 2
  IFDEF TWO_BANKS
    ERROR "Unsupported configuration"
  ELSE
    bcf STATUS,RP0  ; for four-bank devices
    bsf STATUS,RP1
  ENDIF
  endm

BANK3 macro     ; select register bank 3
  IFDEF TWO_BANKS
    ERROR "Unsupported configuration"
  ELSE
    bsf STATUS,RP0  ; for four-bank devices
    bsf STATUS,RP1
  ENDIF
  endm


;*** Conditional branching ***
; Macros to simplify 'IF THEN ELSE' queries
; Pre:  valid w
; Post: compare w vs. m_val, branch to m_target or not

;branch on equal w and m_val
BEQ macro m_val, m_target
  sublw m_val
  bz  m_target  ; zero bit set, branch
  endm

;branch on 0 value in register m_file, jump to m_target
BZF macro m_file, m_target
  tstf  m_file    ; check register (Z)
  bz  m_target  ; zero bit set, branch
  endm  

;branch on not equal w and m_val
BNEQ  macro m_val, m_target
  sublw m_val
  bnz m_target  ; zero bit not set, branch
  endm

;branch on not 0 value in register m_file, jump to m_target
BNZF  macro m_file, m_target
  tstf  m_file    ; check register (Z)
  bnz m_target  ; zero bit set, branch
  endm  

;branch on greater w than m_val
BRG macro m_val, m_target
  sublw m_val   ; result = m_val - w
  bnc m_target  ; no carry if result negative, branch
  endm

;branch on equal or greater w than m_val
BREG  macro m_val, m_target
  sublw m_val-0x1 ; result = (m_val-1) - w
  bnc m_target  ; no carry if result negative, branch
  endm

;branch on smaller w than m_val
BRS macro m_val, m_target
  sublw m_val-0x1 ; result = (m_val-1) - w
  bc  m_target  ; carry if result zero or positive, branch
  endm

;branch on equal or smaller w than m_val
BRES  macro m_val, m_target
  sublw m_val   ; result = m_val - w
  bc  m_target  ; carry if result zero or positive, branch
  endm


;*** Microchip Tips'n Tricks ***
; swaps the contents of W and REG without using a second register
; from 'Microchip Tips'n Tricks'
SWAPWF macro REG
  XORWF REG,F
  XORWF REG,W
  XORWF REG,F
  endm

;  #include "m_wait.asm"
#DEFINE M_WAIT_ID dummy

;***** INCLUDE FILES *****

  IFNDEF  M_BANK_ID
    ERROR "Missing include file: m_bank.asm"
  ENDIF

;***** CONSTANT DECLARATION *****
      
  CONSTANT PRESCstd = b'00000001' ; standard prescaler for TMR0
      
;***** REGISTER DECLARATION *****
      
  IFNDEF  BASE
    ERROR "Declare BASE (Base address of user file registers) in MAIN PROGRAM"
  ENDIF

  WCYCLE  set BASE+d'0' ; wait cycle counter
  
;***** MACROS *****

WAIT  macro timeconst_1
  IF (timeconst_1 != 0)
    movlw timeconst_1
    call  WAITstd
  ENDIF
  endm

WAITX macro timeconst_2, prescaler
  IF (timeconst_2 != 0)
    movlw timeconst_2 
    call  _Xsetup
    movlw prescaler   ; assign prescaler for TMR0
    call  _Xwait
  ENDIF
  endm

;***** SUBROUTINES *****

_Xsetup movwf WCYCLE    ; assign wait cycle duration
  clrf  TMR0
  BANK1
  movlw b'11000000'   ; set up mask
  andwf OPTION_REG,f  ; clear corresponding bits
  RETURN

WAITstd movwf WCYCLE    ; assign wait cycle duration
  clrf  TMR0
  BANK1
  movlw b'11000000'   ; set up mask
  andwf OPTION_REG,f  ; clear corresponding bits
  movlw PRESCstd    ; load standard prescaler
_Xwait  iorwf OPTION_REG,f  ; assign prescaler to TMR0
  BANK0

_WAITa  bcf INTCON,T0IF   ; clears TMR0 overflow flag
_WAITb  btfss INTCON,T0IF ; checks TMR0 overflow flag, skip if set
  goto  _WAITb      ; this is the wait-loop
  decfsz  WCYCLE,f    ; repeats the loop according to the
  goto  _WAITa      ; assigned wait cycles
  RETURN

;  #include "m_rs096.asm"  ; 9600 baud @ 4 MHz
;***** INCLUDE FILES *****

  IFNDEF  M_BANK_ID
    ERROR "Missing include file: m_bank.asm"
  ENDIF

;***** HARDWARE DECLARATION *****

  IFNDEF  TXport
    ERROR "Define TXport in MAIN PROGRAM."
  ENDIF
  IFNDEF  TXtris
    ERROR "Define TXtris in MAIN PROGRAM."
  ENDIF
  
  MESSG "Default RS232 RXport is PORTB,0x00."

  #define RXport  PORTB,0x00  ; needs to be an interrupt supervised port
  #define RXtris  TRISB,0x00  ; if modified, set adequate flags in INTCON register
  
;***** CONSTANT DECLARATION *****

  CONSTANT NUM_BITS = d'8'    ; number of data bits to transmit/receive
  CONSTANT WAIT_GENERAL = 0x1D  ; delay for transmission and reception
  CONSTANT WAIT_RX_SB = 0x08    ; delay for reception of start bit

  CONSTANT LF = d'10'   ; line feed
  CONSTANT CR = d'13'   ; carriage return
  CONSTANT TAB =  d'9'    ; tabulator
  CONSTANT BS = d'8'    ; backspace

;***** REGISTER DECLARATION *****

  IFNDEF  BASE
    ERROR "Declare BASE (Base address of user file registers) in MAIN PROGRAM"
  ENDIF

  TEMP1 set BASE+d'0' ; universal temporary register
  TEMP2 set BASE+d'1'

  IFNDEF  TXD
    ERROR "Declare TXD register in MAIN PROGRAM"
  ENDIF
  IFNDEF  RXD
    ERROR "Declare RXD register in MAIN PROGRAM"
  ENDIF 

;***** MACROS *****

RS232init macro
  BANK1
  bcf TXtris    ; set output
  bsf RXtris    ; set input with weak pull-up
  bcf OPTION_REG,INTEDG ; RS232 interrupt on falling edge
  BANK0
  bsf TXport    ; set default state: logical 1
  bcf INTCON,INTF ; ensure interrupt flag is cleared
  bsf INTCON,INTE ; enable RB0/INT interrupt
  bsf INTCON,GIE  ; enable global interrupt
  endm

SEND  macro S_string  ; "SEND 'X'" sends character to RS232
  movlw S_string
  call  SENDsub
  endm

SENDw macro
  call  SENDsub
  endm

RECEIVE macro
  call  SB_Wait   ; first wait subroutine
  btfsc RXport
  goto  _RSerror  ; no valid start bit
  movlw NUM_BITS  ; ### number of data bits to receive, usually 8
  movwf TEMP1
_RECa call  T_Wait    ; inter-baud wait subroutine
  btfsc RXport
  bsf   RXD,0x07
  btfss RXport
  bcf   RXD,0x07
  decfsz  TEMP1,w   ; skip if TEMP1 == 1
  rrf   RXD,f   ; do this only NUM_BITS-1 times
  decfsz  TEMP1,f
  goto  _RECa
  call  T_Wait    ; inter-baud wait subroutine
  btfss RXport    ; check if stop bit is valid
  goto  _RSerror  ; no valid stop bit
  endm

;***** SUBROUTINES *****

SENDsub movwf TXD   ; store in data register
  bcf   TXport    ; start bit
  movlw NUM_BITS  ; ### number of data bits to send, usually 8
  movwf TEMP1
  call  T_Wait
_SENDa  btfsc TXD,0x00  ; send LSB first
  bsf   TXport
  btfss TXD,0x00
  bcf   TXport
  rrf   TXD,f
  call  T_Wait
  decfsz  TEMP1,f
  goto  _SENDa
  bsf   TXport    ; stop bit
  call  T_Wait
  call  T_Wait    ; allow some time for re-synchronization
  RETURN

T_Wait movlw WAIT_GENERAL ; ### for transmission & reception
  movwf TEMP2   ; total delay until next
  goto  X_Wait    ; bit: 104 us @ 9600 baud

;*** When entering this subroutine, ISR context restore has already consumed some cycles ***
SB_Wait movlw WAIT_RX_SB  ; ### for reception of start bit
  movwf TEMP2   ; total delay: 52 us @ 9600 baud
  ;goto X_Wait    ; (=> sampling in the center of each bit)
  
X_Wait  decfsz  TEMP2,f   ; wait loop
  goto  X_Wait
  RETURN

_RSerror clrf RXD   ; invalid data
  goto _ISR_RS232error  ; goto RS232 error handling in ISR


  ;***** MACROS *****

KEYBOARDinit macro
  BANK1
  bsf KBDclktris  ; set keyboard clock line to input explicitely
  bsf KBDdatatris ; set keyboard data line to input explicitely
  bcf OPTION_REG,INTEDG ; keyboard interrupt on falling edge
  BANK0
  bsf INTCON,INTE ; enable RB0/INT interrupts
  endm
  
;====================================================================
; RESET and INTERRUPT VECTORS
;====================================================================
;***** INTERRUPT SERVICE ROUTINE *****

  ORG 0x04    ; interrupt vector location

ISR ;************************
  ;*** ISR CONTEXT SAVE ***
  ;************************

  bcf INTCON,GIE  ; disable all interrupts
  btfsc INTCON,GIE  ; assure interrupts are disabled
  goto  ISR
  movwf W_TEMP    ; context save: W
  swapf STATUS,W  ; context save: STATUS
  movwf STATUS_TEMP ; context save
  clrf  STATUS    ; bank 0, regardless of current bank
  movfw PCLATH    ; context save: PCLATH
  movwf PCLATH_TEMP ; context save
  clrf  PCLATH    ; page zero, regardless of current page
  bcf STATUS,IRP  ; return to bank 0
  movfw FSR   ; context save: FSR
  movwf FSR_TEMP  ; context save
  ;*** context save done ***

  ;**************************
  ;*** ISR MAIN EXECUTION ***
  ;**************************

  ;*****************************************
  ;*** KEYBOARD SCAN PATTERN ACQUISITION ***
  ;*****************************************

  ;*** check start bit ***
  tstf  KBDcnt    ; check
  bnz _KBDdat   ; branch on no zero
  btfsc KBDdatapin  ; test start bit of keyboard data input
  goto  _KBDabort ; no valid start bit, abort
  goto  _INCF   ; exit

  ;*** keyboard scan pattern acquisition ***
_KBDdat movfw KBDcnt    ; get kbd scan pattern acquisition counter
  sublw d'8'    ; w = d'8' - KBDcnt (*)
  bnc _KBDpari  ; branch if negative (carry == 0)
  btfss KBDdatapin  ; get keyboard data input
  bcf KBD,0x07  ; (bit operations do not alter zero flag)
  btfsc KBDdatapin
  bsf KBD,0x07  
  bz  _INCF   ; exit on zero (zero flag still valid from (*))
  rrf KBD,F   ; do this only 7 times
  goto  _INCF   ; exit

  ;*** ignore parity bit ***
_KBDpari movfw  KBDcnt    ; get kbd scan pattern acquisition counter
  sublw d'9'    ; w = d'9' - KBDcnt
  bnc _KBDstp   ; branch if negative (carry == 0)
  goto  _INCF   ; exit

  ;*** check stop bit ***
_KBDstp btfss KBDdatapin  ; check if stop bit is valid
  goto  _KBDabort ; if not set, abort
  bsf KBDflag   ; else set reception flag to decode KBD
  ;*** stall keyboard ***
  ; to prevent the arrival of more data before having finished decoding
  BANK1     ; hold keyboard (with kbd clk low):
  bcf KBDclktris  ; set clk line to output
  BANK0
  bcf KBDclkpin ; set keyboard clk line low (stall)
  ;*** disable RB0/INT interrupt line ***
  bcf INTCON,INTE ; disable RB0/INT interrupt
  goto  _KBDterm  ; terminate successfully

_KBDabort clrf  KBD   ; abort / invalid data
_KBDterm clrf KBDcnt    ; reset kbd scan pattern acquisition counter
  goto  _KBDend   ; terminate execution of keyboard ISR

  ;***********************************
  ;*** CLEARING OF INTERRUPT FLAGS ***
  ;***********************************
  ; NOTE: Below, I only clear the interrupt flags! This does not
  ; necessarily mean, that the interrupts are already re-enabled.
  ; Basically, interrupt re-enabling is carried out at the end of
  ; the corresponding service routine in normal operation mode.
  ; The flag responsible for the current ISR call has to be cleared
  ; to prevent recursive ISR calls. Other interrupt flags, activated
  ; during execution of this ISR, will immediately be served upon
  ; termination of the current ISR run.

_INCF incf  KBDcnt,F  ; increment acquisition counter
_ISR_RS232error
_KBDend bcf INTCON,INTF ; clear RB0/INT interrupt flag
  ;goto ISRend    ; terminate execution of ISR

  ;*****************************************
  ;*** ISR TERMINATION (CONTEXT RESTORE) ***
  ;*****************************************

ISRend  movfw FSR_TEMP  ; context restore
  movwf FSR   ; context restore
  movfw PCLATH_TEMP ; context restore
  movwf PCLATH    ; context restore
  swapf STATUS_TEMP,W ; context restore
  movwf STATUS    ; context restore
  swapf W_TEMP,F  ; context restore
  swapf W_TEMP,W  ; context restore
  RETFIE      ; enable global interrupt (INTCON,GIE)

;***** END OF INTERRUPT SERVICE ROUTINE *****


;***** KEYBOARD SCAN PATTERN DECODING SUBROUTINE *****

KBDdecode
  ;**********************************************************
  ;*** KEYBOARD SCAN CODE PRE-DECODING, SET / CLEAR FLAGS ***
  ;**********************************************************

  ;*** check key release scan code (F0) ***
;  movfw KBD   ; get scan code
;  movwf KBDcopy   ; make backup of scan code for later use
;  goto _OUTP ; <<<
  clrf PORTB
  btfsc   RELflag
  goto RelFlOut
  btfsc KBD,0
  bsf PORTB,1
  btfsc KBD,1
  bsf PORTB,2
  btfsc KBD,2
  bsf PORTB,3
  btfsc KBD,3
  bsf PORTB,4
  btfsc KBD,4
  bsf PORTB,5
  btfsc KBD,5
  bsf PORTB,6
  btfsc KBD,6
  bsf PORTB,7

 RelFlOut
  sublw 0xF0    ; check if FO has been sent:
  bnz _KBD_1    ; branch if no 'release' scan code occured
  bsf RELflag   ; set key release flag if 'release' occured
  bcf SPEflag   ; clear special code flag always on release
  goto  _ClrStall ; abort with nothing to display
_KBD_1  btfss RELflag   ; check release flag, exit if cleared:
  goto  _KBD_2    ; release flag has not been set, branch
  ;*** release flag has been set / key release is in progress: ***
;<<<<  
;  movlw '0'
;  SENDw     ; send actual pressed keyboard character
;  movlw 'F'
;  SENDw     ; send actual pressed keyboard character
  
  bcf RELflag   ; clear key release flag
 
 ;*** if release of SHIFT key, clear shift flag: ***
  movfw KBD   ; check left shift button (0x12):
  sublw 0x12    ; subtract, check if zero
  bz  _clrSHI   ; if zero, branch
  movfw KBD   ; check right shift button (0x59):
  sublw 0x59    ; subtract, check if zero
  skpnz     ; skip on non zero
_clrSHI 
  bcf ShiftLed
  bcf SHIflag   ; clear shift flag
  ;*** check for CAPS LOCK activity: ***
  movfw KBD   ; check caps lock key release:
  sublw 0x58    ; subtract, check if zero
  bnz _clrALT   ; if not zero, branch
  btfss CAPflag   ; check flag, clear flag if set:
  goto  _setCAP   ; flag has not been set, branch
  bcf CAPflag   ; clear flag
  goto  _ClrStall ; abort with nothing to display
_setCAP bsf CAPflag   ; set flag if cleared
  goto  _ClrStall ; abort with nothing to display
  ;*** check for ALT activity: ***
_clrALT movfw KBD   ; check ALT key release:
  sublw 0x11    ; subtract, check if zero
  bnz _clrCTRL  ; if not zero, branch (to next check)
  bcf ALTflag   ; clear flag
  goto  _ALTdec   ; goto ALT-DEC-Entry conversion/display routine
  ; /not implemented, enhancement/
  ;*** check for CTRL activity: ***
_clrCTRL movfw  KBD   ; check CTRL key release:
  sublw 0x14    ; subtract, check if zero
  bnz _ClrStall ; if not zero, branch / exit
  bcf CTRLflag  ; clear flag
  goto  _CTRLhex  ; goto CTRL-HEX-Entry conversion/display routine
  ; /not implemented, enhancement/

  ;****************************************************
  ;* The following table has to be located within one *
  ;* page to allow for correct lookup functionality.  *
  ;* Therefore, additional ISR code has been moved    *
  ;* further down.                                    *
  ;****************************************************

  ;*********************************************************************
  ;* LOOKUP TABLE FOR KEYBOARD-SCAN-CODE TO ASCII-CHARACTER CONVERSION *
  ;*********************************************************************

  ;ORG  0x??      ; if necessary, move table

;  #include "eng_main.asm"   ; English 'codepage'
KBDtable ; (not used for characters typed with shift button active)
  addwf PCL,F
  retlw 0 ; invalid entry
  retlw A'9'  ; F9 -> 9 0x01
  retlw 0 ; 
  retlw A'5'  ; F5 -> 5
  retlw A'3'  ; F3 -> 3
  retlw A'1'  ; F1 -> 1
  retlw A'2'  ; F2 -> 2
  retlw A'2'  ; F12 -> 2
  retlw 0 ;
  retlw A'0'  ; F10 -> 0
  retlw A'8'  ; F8 -> 8 0x0A
  retlw A'6'  ; F6 -> 6
  retlw A'4'  ; F4 -> 4
  retlw 0x09  ; TAB
  retlw A'~'  ; 
  retlw 0 ;
  retlw 0 ;   0x10
  goto  _ALT  ; ALT (set/clear ALT flag)
  goto  _SHIFT  ; SHIFT (set/clear SHIFT flag)
  retlw 0 ;
  goto  _CTRL ; CTRL  (set/clear CTRL flag)
  DT  "q1"  ; DT: MPASM directive to create a table (retlw x)
  retlw 0 ; 
  retlw 0 ; 
  retlw 0 ;     0x19
  DT  "zsaw2" ;
  retlw 0 ; 
  retlw 0 ;     0x20
  DT  "cxde43";
  retlw 0 ; 
  retlw 0 ; 
  retlw A' '  ; SPACE
  DT  "vftr5" ;
  retlw 0 ; 
  retlw 0 ;     0x30
  DT  "nbhgy6";
  retlw 0 ; 
  retlw 0 ; 
  retlw 0 ; 
  DT  "mju78" ;
  retlw 0 ; 
  retlw 0 ;     0x40
  DT  ",kio09";
  retlw 0 ; 
  retlw 0 ; 
  DT  ".?l;p" ;
  retlw A'-'  ; 
  retlw 0 ; 
  retlw 0 ;   0x50 
  retlw 0 ; 
  DT  "'" ; 
  retlw 0 ; 
  retlw A'['  ; 
  retlw A'+'  ; 
  retlw 0 ; 
  retlw 0 ; 
  retlw 0 ; CAPS LOCK, check and alter CAPflag on key release
  goto  _SHIFT  ; SHIFT
  goto  _CRLF ; CR,LF   0x5A
  retlw A']'  ; 
  retlw 0 ; 
  retlw A'|'  ; 
  retlw 0 ; 
  retlw 0 ; 
  retlw 0 ; 
  retlw A'<'  ;     0x61
;*** begin compression (scan code - d'14') ***
  DT  "0.2568"
  retlw 0 ; ESCAPE  0x76
  retlw 0 ; NUM LOCK
  DT  "1+3-*9"
  retlw 0 ; SCROLL LOCK 0x7E
;*** begin compression (scan code - d'14' + d'35') ***
  retlw 0x08  ; BACKSPACE
  retlw 0 ; 
  retlw 0 ; 
  retlw A'1'  ;     0x82
;*** begin compression (scan code - d'14') ***
  retlw A'7'  ; 
;*** begin compression (scan code - d'14' + d'35') ***
  retlw A'4'
KBDtableEND retlw A'7'


;  IF (high (KBDtable) != high (KBDtableEND))
;    ERROR "Keyboard lookup table hits page boundary!"
;  ENDIF

  
  ;****************************************************
  ;* The following code belongs also to the interrupt *
  ;* service routine and has been moved down to this  *
  ;* place to allow the main keyboard decode lookup   *
  ;* table to be located within one page.             *
  ;* The code below may be arranged on another page,  *
  ;* but that doesn't matter.                         *
  ;****************************************************

  ;********************************
  ;*** SCAN CODE RANGE CHECKING ***
  ;********************************

_KBD_2  ;*** check if special code (0xE0) has been submitted previously ***
  btfss SPEflag
  goto  _KBD_3
  ;*** decoding of scan code with preceding special code (0xE0) ***
  ; (decoding currently only necessary for 'E0 4A' = '/')
  movfw KBD
  sublw 0x4A    ; 0x4A - w
  bnz _NOSUP    ; branch on non-zero
  movlw '/'   ; store '/' in KBD
  movwf KBD
  goto  _OUTP
_NOSUP  ;*** check if scan code 0x5A or smaller has occurred ***
  movfw KBD
  sublw 0x5A    ; 0x5A - w
  bc  _KBD_3    ; carry if result positive or zero, branch
  ;*** range exceeded (above 0x5A) ***
  ; it's one of the following keys: arrow button, 'Home', 'Del',
  ; 'PageUp', 'PageDown', 'Insert', 'End'
  ; these keys are currently not used, so
  goto  _ClrStall
_KBD_3  ;*** check if scan code 0x61 or smaller has occurred ***
  movfw KBD
  sublw 0x61    ; 0x61 - w
  bc  KBD_dec   ; carry if result positive or zero, goto table
  movlw d'14'
  subwf KBD,F   ; KBD = KBD - d'14'
  ;*** check if scan code 0x61 (0x6F-d'14') or smaller has occurred ***
  movfw KBD
  sublw 0x61    ; 0x61 - w
  bnc _KBD_4    ; no carry if result negative, goto _KBD_4
  movlw d'25'
  addwf KBD,F   ; KBD = KBD + d'25'
  goto  KBD_dec
_KBD_4  ;*** check if scan code 0x78 (0x86 - d'14') or higher has occurred ***
  movfw KBD
  sublw 0x77    ; 0x77 - w
  bc  KBD_dec   ; carry if result zero or positive, branch
  ;*** no character to display: ***
  ;*** check for special code (0xE0): 0xD2 = 0xE0 - d'14' ***
  movfw KBD
  sublw 0xD2    ; 0xD2 - w
  skpnz     ; skip if not zero
  bsf SPEflag   ; special code occurred, set flag
  clrf PORTB
  goto _ClrStall    ; abort with nothing to display

  ;*******************************************************
  ;*** SCAN CODE DECODING & ASCII CHARACTER CONVERSION ***
  ;*******************************************************

  ;*** DECODE SCAN CODE ***
KBD_dec movlw HIGH KBDtable ; get correct page for PCLATH
  movwf PCLATH    ; prepare right page bits for table read
  movfw KBD
  call  KBDtable  ; GET CORRESPONDING KEYBOARD CHAR IN LOOKUP TABLE
  movwf KBD   ; save result to KBD
  tstf  KBD   ; test KBD to get the zero flag
  bz  _ClrStall ; abort if KBD is zero / invalid entry, nothing to display

  ;*** check for ALT-DEC-Entry ***
  ; /not implemented, enhancement/
  ;btfsc  ALTflag   ; check flag
  ;goto _ALTstr   ; jump if set

  ;*** check for CTRL-HEX-Entry ***
  ; /not implemented, enhancement/
  ;btfsc  CTRLflag  ; check flag
  ;goto _CTRLstr  ; jump if set

  ;*** convert only LETTERS to capital letters: ***
  ; a letter in KBD value has to be in range from 0x61 to 0x7A
  movfw KBD
  sublw 0x60    ; 0x60 - w
  bc  _SHICHR   ; carry if result greater or equal zero = no letter, exit
  movfw KBD
  sublw 0x7A    ; 0x7A - w
  bnc _SHICHR   ; no carry if result negative = no letter, exit
  ;*** there is now a letter in KBD, check conversion to capital letter: ***
  movfw KBD
  btfsc CAPflag   ; check caps lock flag
  goto  _SHIset   ; flag has been set
  btfss SHIflag   ; check shift flag
  goto  _OUTP   ; no flag, exit
  goto  _cnvCAP   ; flag has been set, convert to capital letter

_SHIset btfsc SHIflag   ; check shift flag
  goto  _OUTP   ; flag has been set, exit
_cnvCAP addlw d'224'    ; convert to capital letter (+ d'224')
  movwf KBD
  ;goto _OUTP   ; (uncomment in case _OUTP will be moved)

  ;*************************************
  ;*** KEYBOARD DATA OUTPUT TO RS232 ***
  ;*************************************

_OUTP ;*** RS232 ***
;  movlw high HEXtable
;  movwf PCLATH
;  swapf KBD,W
;  call HEXtable
;  SENDw     ; send actual pressed keyboard character
;  movfw KBD
;  call HEXtable
;  SENDw     ; send actual pressed keyboard character
;  movlw ' '
  movfw KBD ;<<<<
  SENDw     ; send actual pressed keyboard character
  goto _ClrStall    ; (uncomment in case _ClrStall will be moved)

  ;************************************************
  ;*** SPECIAL COMMANDS I (with special output) ***
  ;************************************************

_CRLF SEND  CR    ; on 'Enter', send CR and LF to RS232
  movlw LF    ; put LF to w, return
  RETURN

  ;**********************************************************
  ;*** STALL RELEASE & CLEAR KEYBOARD DATA RECEPTION FLAG ***
  ;**********************************************************
_ClrStall 
  BANK1
  bsf KBDclktris  ; set clk line back to input (and goes high)
  BANK0     ; (release stall)
  bcf KBDflag   ; clear keyboard data reception flag
  bsf INTCON,INTE ; re-enable interrupt RB0/INT
  RETURN

  ;****************************************************
  ;*** SPECIAL COMMANDS II (without special output) ***
  ;****************************************************

_SHIFT  
  bsf ShiftLed
  bsf SHIflag   ; set shift flag
  RETLW 0   ; clear w to obtain invalid entry

_ALT  bsf ALTflag   ; set ALT flag
  RETLW 0   ; clear w to obtain invalid entry

_CTRL bsf CTRLflag  ; set CTRL flag
  RETLW 0   ; clear w to obtain invalid entry

  ;***********************************************
  ;*** ALT-DEC & CTRL-HEX STORING & CONVERSION ***
  ;***********************************************
  ; store typed numbers in CTRLreg1 - CTRLreg3
_CTRLstr ; /not implemented, enhancement/
_ALTstr ; /not implemented, enhancement/

_ALTdec ; PRE: ALT + [1..3] numbers (e.g. ALT + 6 + 4 = @) in CTRLreg1 - 3
  ; POST: convert ALT-DEC-Entry after release of ALT key, return
  ;       ascii value converted from numbers
  ; /not implemented, enhancement/

_CTRLhex ; PRE: CTRL + [1..2] letters/numbers (e.g. CTRL + 3 + F = ?)
  ;       in CTRLreg1 - 2
  ; POST: convert ALT-DEC-Entry after release of ALT key, return
  ;       ascii value as concatenated hex value from numbers
  ; /not implemented, enhancement/

  ; catch all handler for non-implemented features:
  goto  _ClrStall ; abort & exit (nothing to display/send)

  ;*****************************************************************
  ;*** SCAN CODE DECODING & ASCII CONVERSION FOR 'SHIFT' ENTRIES ***
  ;*****************************************************************

_SHICHR ;*** special character decoding typed with shift button active ***
  ; check for active shift button, if not active, branch
  btfss SHIflag
  goto  _OUTP   ; branch
  ; check for 'backspace', 'tab', 'linefeed' and 'carriage return' :
  ; (here, KBD has already been converted to ASCII character values)
  movfw KBD
  sublw d'13'   ; d'13' - w
  bc  _OUTP   ; carry if result zero or positive, branch

  ;*** range check: abort if KBDcopy greater than 0x61 ***
  ; (KBDcopy has the value of the original keyboard scan code)
  movfw KBDcopy
  sublw 0x61    ; 0x61 - w
  bnc _OUTP   ; no carry if result negative, branch
  ;*** check if KBDcopy greater than 0x3C ***
  movfw KBDcopy
  sublw 0x3C    ; 0x3C - w
  bc  _SHICH1   ; carry if result zero or positive, branch
  movlw d'61'
  subwf KBDcopy,F ; KBDcopy = KBDcopy - d'61'
  goto  _SHICH3
  ;*** check if KBDcopy greater than 0x24 ***
_SHICH1 movfw KBDcopy
  sublw 0x24    ; 0x24 - w
  bc  _SHICH2   ; carry if result zero or positive, branch
  movlw d'35'
  subwf KBDcopy,F ; KBDcopy = KBDcopy - d'35'
  goto  _SHICH3
  ;*** else ***
_SHICH2 movlw d'4'
  addwf KBDcopy,F ; KBDcopy = KBDcopy + d'4'

_SHICH3 movlw HIGH KBDSHIFTtable ; get correct page for PCLATH
  movwf PCLATH    ; prepare right page bits for table read
  movfw KBDcopy
  call  KBDSHIFTtable ; GET CORRESPONDING KEYBOARD CHAR IN LOOKUP TABLE
  movwf KBD   ; save result to KBD
  goto  _OUTP

  ;*******************************************************
  ;* The following table has also to be located within   *
  ;* one page to allow for correct lookup functionality. *
  ;*******************************************************

  ;**********************************************************************
  ;* LOOKUP TABLE FOR SPECIAL CHARACTERS TYPED WITH SHIFT BUTTON ACTIVE *
  ;**********************************************************************

  ;ORG  0x??      ; if necessary, move table

;  #include "eng_shif.asm"   ; English 'codepage'
KBDSHIFTtable ; some of the items are located here with 'compressed' offset
  addwf PCL,F
  DT  "&*$#<" ; 0x3D - 0x41
  retlw 0 ; invalid entry
  retlw 0 ; 
  retlw 0 ; 
  DT  ")("  ; 0x45 - 0x46
  retlw 0 ; 
  DT  "%>/" ; 0x48 - 0x4A
  retlw 0 ; 
  retlw A':'  ; "\" 0x4C
  retlw 0 ; 
  DT  "_`^" ; 0x4E - 0x50
  retlw 0 ; 
  retlw A'"'  ; 0x52
  retlw 0 ; 
  DT  "{="  ; 0x54 - 0x55
  retlw 0 ; 
  retlw A'!'  ; 0x57
  retlw 0 ; 
  retlw 0 ; 
  retlw 0 ; 
  retlw A'}'  ; 0x5B
  retlw 0 ; 
  retlw 0x5C  ; 0x5D
  retlw 0 ; 
  retlw A'@'  ; 0x5F
  retlw 0 ; 
KBDSHIFTtableEND retlw  A'>'  ; 0x61 (not used in english but left for completion)


;  IF (high (KBDSHIFTtable) != high (KBDSHIFTtableEND))
;    ERROR "Keyboard lookup SHIFTtable hits page boundary!"
;  ENDIF
  
  ;#include "..\tables\ger_shif.asm"    ; modified Swiss-German 'codepage'

;***** END OF SCAN PATTERN DECODING SUBROUTINE *****

      ; Reset Vector
;RST   code  0x0 
MAIN  ORG 0x00

  BANK1
  clrf  OPTION_REG  ; PORTB pull-ups enabled
  goto  _MAIN

;PGM   code
  ORG 0x1E0

_MAIN ;*** RS232 INITIALIZATION ***
  ; Do not call RS232init, since we have no RS232 reception and
  ; PORTB,0 is already used by the keyboard.
  ; (Note: KEYBOARDinit and RS232init are almost equal)
  ; Initialize only RS232 transmission (TXport):
  bcf TXtris    ; set RS232 output
  bcf ShiftLedTris
  clrf TRISB
  BANK0
  bsf TXport    ; set default state: logical 1
  bcf ShiftLed
  movlw 0x07
  movwf CMCON
  clrf PORTB
  ;*** AT KEYBOARD INITIALIZATION ***
  KEYBOARDinit    ; keyboard initialization
  clrf  KBDcnt    ; clear IRQ based scan pattern counter
  clrf  FLAGreg   ; clear all flags (keyboard & other)

  ;*** ENABLE ALL INTERRUPTS ***
  movlw b'11111000'
  andwf INTCON,F  ; clear all interrupt flags
  bsf INTCON,GIE  ; enable global interrupt

  ;*** define amount of table items for startup message ***
  #define tab_items d'42'
  movlw tab_items ; store amount of table items in counter
  movwf TEMP3

  ;*** transmit startup message ***
_ILOOP  movlw HIGH WelcomeTable ; get correct page for PCLATH
  movwf PCLATH    ; prepare right page bits for table read
  movfw TEMP3   ; get actual count-down value
  sublw tab_items ; table offset: w = tab_items - TEMP3
  call  WelcomeTable  ; call lookup table
  SENDw
  decfsz  TEMP3,F   ; decrement counter
  goto  _ILOOP

  ;******************************
_MLOOP  btfss KBDflag   ; check scan pattern reception flag
  goto  _MLOOP
   movfw KBD   ; get scan code
  movwf KBDcopy   ; make backup of scan code for later use
  call  KBDdecode ; if set, call decoding routine
  goto  _MLOOP
  ;******************************

  ORG 0x210   ; align table within page

WelcomeTable
  addwf PCL,F   ; add offset to table base pointer
  retlw LF    ; Line Feed
  retlw CR    ; Carriage Return
  DT  "PIC16F628 AT Keyboard Decoder connected" ; create table
  retlw CR    ; Carriage Return
  retlw LF    ; Line Feed
WTableEND retlw LF    ; Line Feed

HEXtable
  andlw 0x0f
  addwf PCL,F
  retlw '0' ;
  retlw '1' ;
  retlw '2' ;
  retlw '3' ;
  retlw '4' ;
  retlw '5' ;
  retlw '6' ;
  retlw '7' ;
  retlw '8' ;
  retlw '9' ;
  retlw 'A' ;
  retlw 'B' ;
  retlw 'C' ;
  retlw 'D' ;
  retlw 'E' ;
  retlw 'F' ;
  

;  IF (high (WelcomeTable) != high (WTableEND))
;    ERROR "Welcome table hits page boundary!"
;  ENDIF

  END
