#include <stdio.h>
#include <stdlib.h>
#include <string.h>

unsigned char ao[4096];
unsigned char ac[4096];

int main()
{
int i,j,o;
FILE *f1;
unsigned char b2,h6,h5,h4,b3,v4,v3,v2,v5,v8,vv,rg0;
unsigned char vs,bl,hs,he,z1,z2;
unsigned char VS,BL,HS,HE,Z1,Z2;

f1 = fopen("xl8rom4k.bin","rb");
if(f1==NULL) return -1;

vs = bl = hs = he = z1 = z2 = 255;

for(i=0;i<4096;i++)
{

b2  = (i&1)?255:0;
h6  = (i&2)?255:0;
h5  = (i&4)?255:0;
h4  = (i&8)?255:0;
b3  = (i&16)?255:0;
v4  = (i&32)?255:0;
v3  = (i&64)?255:0;
v2  = (i&128)?255:0;
v5  = (i&256)?255:0;
v8  = (i&512)?255:0;
vv  = (i&1024)?255:0;
rg0 = (i&2048)?255:0;


for(j=0;j<5;j++)
{

#if 1
/* CP7.SRC */
VS  = v3 & v4 & v5 & ~vv & v8 & rg0;
VS |= v2 & v3 & ~vv & v4 & v5 & v8 & ~rg0;
VS |= ~v2 & ~v3 & ~vv & ~v4 & ~v5 & ~v8;
#else
/* CP7SEC.SRC or CP7SEC1.SRC */
VS  = v3 & v4 & v5 & ~vv & v8;
#if 1
/* CP7SEC.SRC */
VS |= ~v3 & ~v4 & ~v5 & ~vv & ~v8;
#else
/* CP7SEC1.SRC */
VS |= ~v2 & ~v3 & ~v4 & ~v5 & ~vv & ~v8;
#endif
#endif

BL  = ~h4 & ~h5 & h6 & rg0;
BL |= ~b3 & ~b2 & h4 & ~h5 & h6 & rg0;
BL |= b3 & ~h4 & ~h5 & h6 & ~rg0;
BL |= ~b3 & h4 & ~h5 & h6 & ~rg0;
BL |= b3 & ~b2 & h4 & ~h5 & h6 & ~rg0;
BL |= ~vv & v4 & v5 & v8;
BL |= ~vv & ~v4 & ~v5 & ~v8;

HS  = ~h6;
HS |= ~b3 & ~h4 & ~h5 & h6 & ~rg0;
HS |= b3 & ~h4 & ~h5 & h6 & rg0;
HS |= h4 & ~h5 & h6;
HS |= h5 & h6;

HE  = h4 & h5 & ~h6 & rg0 & ~z1;
HE |= ~h5 & h6;
HE |= ~vv & v8;
HE |= rg0 & ~vv;
HE |= ~rg0 & ~vv & ~v5 & ~v8;
HE |= ~rg0 & ~vv & ~v4 & v5 & ~v8;
HE |= ~rg0 & ~v3 & ~vv & v4 & v5 & ~v8;

Z1  = ~v8 & ~z1;
Z1 |= ~v8 & ~vv & ~v5 & ~v4 & v3 & ~v2 & hs & h6 & ~h5 & ~h4 & b3 & rg0;
Z1 |= ~v8 &  vv &  v5 & ~v4 & v3 & ~v2 & hs & h6 & ~h5 & ~h4 & b3 & rg0;

Z2  = ~z1 & ~rg0 & v2 & ~v3 & v4 & ~v8 & h5 & h4 & ~hs;
Z2 |= ~z1 & ~rg0 & ~v2 & v3 & ~v4 & ~v8 & h4 & ~b3;
Z2 |= ~z1 & ~rg0 & ~v2 & ~v3 & v4 & ~v8 & h5 & ~hs & bl;
Z2 |= ~z1 & ~rg0 & v2 & v3 & v4 & v5 & ~v8 & ~h6 & h4 & ~b3;
Z2 |= ~z1 & ~rg0 & ~v2 & ~v3 & ~v4 & ~v8 & vv & h6 & ~h5 & b3 & he;
Z2 |= z1 & ~v2 & ~vv & ~v4 & v5 & ~h4 & b3;
Z2 |= z1 & v2 & ~vv & ~v4 & v5 & ~bl & b3 & ~h4;

vs = ~VS;
bl = ~BL;
hs = ~HS;
he = ~HE;
z1 = ~Z1;
z2 = ~Z2;

//printf("|%2.2X|%2.2X|%2.2X|%2.2X|%2.2X|%2.2X|\n",z2,z1,he,hs,bl,vs);

}

j = (vs?1:0)|(bl?2:0)|(hs?4:0)|(he?8:0)|(z1?16:0)|(z2?32:0);
o = fgetc(f1);
if(o!=j) printf("[0x%4.4X] = 0x%2.2X != 0x%2.2X\n",i,j,o);
ao[i] = o;
ac[i] = j;
}

fclose(f1);

for(rg0=0;rg0<2;rg0++)
{
printf("\nSCREEN %i\n\n",rg0);
for(j=0;j<512;j+=4){
printf("%03d ",j);
for(i=0;i<128;i+=4){
 b2 = (i&4)?1:0;
 b3 = (i&8)?1:0;
 h4 = (i&16)?1:0;
 h5 = (i&32)?1:0;
 h6 = (i&64)?1:0;
 v2 = (j&4)?1:0;
 v3 = (j&8)?1:0;
 v4 = (j&16)?1:0;
 v5 = (j&32)?1:0;
 vv = ((j&64)?1:0)|((j&128)?1:0); /* v6|v7 */
 v8 = (j&256)?1:0;

 o = b2|(h6<<1)|(h5<<2)|(h4<<3)|(b3<<4)|(v4<<5)|(v3<<6)|(v2<<7)|(v5<<8)|(v8<<9)|(vv<<10)|(rg0<<11);
 switch(ac[o])
 {
    case 0x34: // 10
         printf(" 4");
         break;
    case 0x11: // 16
         printf("!1");
         break;
    case 0x15: // 16
         printf("!5");
         break;
    case 0x13: // 48
         printf("!3");
         break;
    case 0x30: // 150
         printf(" 0");
         break;
    case 0x35: // 230
         printf(" 5");
         break;
    case 0x31: // 650
         printf(" 1");
         break;
    case 0x33: // 1392
         printf(" 3");
         break;
    case 0x3B: // 1584
         printf("<>");
         break;
    default:
         printf("??");
 }
}
printf("\n");
}
}

return 0;
}
