//`timescale 1 ps / 1 ps
//`include "sdram_8b.v"
//`include "vgu.v"

module VGA_and_SDRAM
(
	input		wire			clk_140MHz,		// Вход тактовой 140МГц
// VGA 2:2:2 output
	output	wire				VGA_Red,		// 
	output	wire				VGA_Green,	// 
	output	wire				VGA_Blue,	// 
	output	wire				VGA_I,
	output	wire				VGA_h_sync,	// Horizontal syncronization 
	output	wire				VGA_v_sync,	// Vertical syncronization
// 
	input		wire				vRAM_Pages,	// 4 for examole
// Интерфейс памяти	Memory port
	input		wire	[24:0]	A,					// Шина адреса, вход
	input		wire	[7:0]		DI,				// Шина данных, вход
	output	wire	[7:0]		DO,				// Шина данных, выход
	input		wire				WR,				// Запрос записи, вход
	input		wire				RD,				// Запрос чтения, вход
	output	wire				IDLE,				// Свободен-/занят, выход
// SD_RAM Interface (H57V2562GTR) 39pin
	output	wire				SDR_CLK,		// 
	output	wire				SDR_CKE,		// 
	output	wire				SDR_nCS,		// 
	output	wire				SDR_nWE,		// 
	output	wire				SDR_nCAS,	// 
	output	wire				SDR_nRAS,	// 
	output	wire	[1:0]		SDR_BA, 		// 
	output	wire	[1:0]		SDR_DQM,		// 
	output	wire	[12:0]	SDR_Addr,	// 
	inout		wire	[15:0]	SDR_Data		// 

);
//=============================================
wire rd_str; wire [13:0] vram_addr; wire [7:0] vram_data;
//=============================================
vgu VGA(
	.picselclock	(clk_140MHz),		// Вход тактовой
	
	.state			(),

	.Den				(),						// Data Enable (for TFT display)
//	.Ren				(),						// RAM Access Enable (Разрешение памяти)
	.h_sync			(VGA_h_sync),				// Horizontal syncronization
	.v_sync			(VGA_v_sync),				// Vertical syncronization
	.video			({VGA_Blue, VGA_Red, VGA_Green, VGA_I}),	// B R G I
// Видеопамять
	.vram_addr		(vram_addr),
	.vram_data		(vram_data),			// 128 бит
	.port_fe			(3'b010),
	.get				(rd_str)
);
//=============================================
// Видеопамять
assign SDR_CKE = 1'b1;		// W6
assign SDR_nCS = 1'b0;		// AA3
//---------------------------------------------
sdram_1b sdrAM (
	.CLK					(clk_140MHz),		// Вход тактовой
//	Video port
	.v_RD					(rd_str),			// Запрос чтения видео, вход
	.v_A					({vRAM_Pages, vram_addr}),		// Адрес для чтения видео
	.v_D					(vram_data),		// Данные для чтения
//	Memory port
	.A						(A),					// Шина адреса, вход
	.DI					(DI),					// Шина данных, вход
	.DO					(DO),					// Шина данных, выход
	.WR					(WR),					// Запрос записи, вход
	.RD					(RD),					// Запрос чтения, вход
	.IDLE					(IDLE),				// Свободен-/занят, выход
//	SDRAM Pin
	.CK					(SDR_CLK),			// Тактирование микросхем(ы) SDRAM, выход (CKE должен быть активен всегда)
	.RAS_n				(SDR_nRAS),			// Строб выбора рядов, выход
	.CAS_n				(SDR_nCAS),			// Строб выбора столбцов, выход
	.WE_n					(SDR_nWE),			// Строб записи, выход
	.DQM					(SDR_DQM),			// Маска чтения/записи
	.BA					(SDR_BA),			// Выбор активного банка, выход
	.MA					(SDR_Addr),			// Шина адреса, выход
	.DQ					(SDR_Data)			// Шина данных, двунаправленная
);

//=============================================
endmodule
//*********************************************
