/*	SDRAM контроллер для проекта ZX-ULAX на 256 Мбит микросхем SDRAM
	Чтение/запись выполняется пакетами по 8 слов шириной по 16 бит
	Регенерации не нужна, так как идёт сканирование экрана. (кто б подумал?)
	Принцип построения конечного автомата основан на коде Влада (MVV)
	GNU GPL v3.0 licensing */

//	V 0.1   11.05.2019		Пробная версия, отработка алгоритма и таймингов
// V 0.2   23.05.2019		Добавлена синхронизация циклов чтения/записи/рефреша
// V 1.0   23.05.2019		Сделана "в лоб" запись бурста 8 слов, сделал для CL=3, для CL=2 надо пересчирывать формулы
// V 1.01  15.06.2019		Добавлен порт чтения видеоданных, теперь двухпортовка)))

/*	CAS Latency = 3
	RAS to CAS delay 	- 3T
	CAS to RD/WR delay	- 3T
*/

// CLK		= 112++ MHz
// WR/RD		= 16T
// RFSH		= 8T (не нужен)
/*
-- todo
-- АРБИТРАЖ
*/

//module sdram #(parameter CL = 3)
module sdram_1b
(
	input		wire				CLK,			// Вход тактовой
// Video port
	input		wire				v_RD,			// Запрос чтения видео, вход
	input		wire	[13:0]	v_A,			// Видео адрес, вход (2 страницы)
	output	reg	[7:0]		v_D = 8'd0,	// Видео данные, выход
//	Memory port
	input		wire	[24:0]	A,				// Шина адреса, вход
	input		wire	[7:0]		DI,			// Шина данных, вход
	output	reg	[7:0]		DO = 8'd0,	// Шина данных, выход
	input		wire				WR,			// Запрос записи, вход
	input		wire				RD,			// Запрос чтения, вход
	output	wire				IDLE,			// Свободен-/занят, выход
//	SDRAM Pin
	output	wire				CK,			// Тактирование микросхем(ы) SDRAM, выход (CKE должен быть активен всегда)
	output	wire				RAS_n,		// Строб выбора рядов, выход
	output	wire				CAS_n,		// Строб выбора столбцов, выход
	output	wire				WE_n,			// Строб записи, выход
	output	wire				DQM,			// Активация старшего/младшего байта слова, выход
	output	wire	[1:0]		BA,			// Выбор активного банка, выход
	output	wire	[12:0]	MA,			// Шина адреса, выход
	inout		wire	[15:0]	DQ				// Шина данных, двунаправленная
);
// Init-------------------------------------------------------		Idle		Read--------rr-rr		Write------     Refresh-------
// 00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 10 11 12	13		14			15 16 17 18 19 14    1A 1B 12 13     0F 10 11 12 13
// pr xx re xx xx xx xx xx re xx xx xx xx xx ms xx xx xx xx	xx    xx/ac/re	xx rd xx xx xx xx		xx wr xx	xx     xx xx xx xx xx
//                               10 11 12 13 14 15 16 17 18 19    20       21 22 23 24 25 20    26 27 18 19     15 16 17 18 19 

// Init----------------------------------------------------------------------------
// 00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 10 11 12	13 14 15 16 17 18 19 1A
// pr xx xx re xx xx xx xx xx xx xx re xx xx xx xx xx xx xx ms xx xx xx xx xx xx xx
//                               10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26

// Idle		  Read-----------------rr-rr-rr-rr-rr-rr-rr-rr      Write-ww-ww-ww-ww-ww-ww-ww-ww---------		Refresh-------------
// 1B         1C 1D 1E 1F 20 21 22 23 24 25 26 27 28 29 1B      2A 2B 2C 2D 2E 2F 30 31 32 33 18 19 1A      14 15 16 17 18 19 1A
// xx/ac/re	  xx xx rd xx xx xx xx xx xx xx xx xx xx xx xx      xx xx wr wr wr wr wr wr wr wr xx xx xx      xx xx xx xx xx xx xx
// 27         28 29 30 31 32 33 34 35 36 37 38 39 40 41 27      42 43 44 45 46 47 48 49 50 51 24 25 26      20 21 22 23 24 25 26
//=============================================
parameter CL = 3;
parameter st_precharge     = 0;
parameter st_refresh_1     = st_precharge + CL;                //  2 /  3
parameter st_refresh_2     = st_refresh_1 + 2 + CL * 2;        //  8 / 11
parameter st_modeset       = st_refresh_2 + 2 + CL * 2;			// 14 / 19
parameter st_idle          = st_modeset   + 2 + CL * 2;        // 20 / 27 nop / Activate / Refresh + чтение в цикле чтения
parameter st_read          = st_idle      + 1;                 // 21 / 28 ожидание Cas Latency
parameter st_read_c        = st_idle      + CL;           		// 22 / 30 Команда Read + AutoPrecharge

parameter st_write         = st_read_c		+ 1;           // 23 / 31 ожидание Cas Latency
parameter st_write_c       = st_write     - 1 + CL;      // 24 / 33 Команда Write + AutoPrecharge
parameter st_write_end     = st_idle      - CL;       	// 18 / 24 ожидание Cas Latency
parameter st_read_end      = st_idle      + 2 - CL * 2;  // 18 / 23 ожидание Cas Latency
parameter st_refresh       = st_modeset   + 1;           // 15 / 20
//=============================================
//							RAS_CAS_WE
parameter 	SdrCmd_xx		=	3'b111; 		// no operation
parameter 	SdrCmd_ac		=	3'b011; 		// activate
parameter 	SdrCmd_rd		=	3'b101; 		// read
parameter 	SdrCmd_wr		=	3'b100; 		// write		
parameter 	SdrCmd_pr		=	3'b010; 		// precharge all
parameter 	SdrCmd_re		=	3'b001; 		// refresh
parameter 	SdrCmd_ms		=	3'b000; 		// mode regiser set

parameter 	A12_A10			=	3'b000;		// Reserved
parameter 	WriteMode		=	1'b1;			// A[9]=0 Burst read And Burst write  A[9]=1 Burst read And single write
parameter 	A8_A7				=	2'b00;		// Reserved & Test Mode

parameter 	[2:0] CAS_Latency		=	CL;//3'b010;			// A[6:4]=2
parameter 	AdressingMode	=	1'b0;			// A[3]=0 Sequential  A[3]=1 Interleave
parameter	BurstLength		=	3'b000;			// A[2:0]=0 1word
parameter 	WorkMode = {A12_A10, WriteMode, A8_A7, CAS_Latency, AdressingMode, BurstLength};	
//=============================================
//assign v_D		= data_reg;
//assign	DO 		= data_reg /* synthesis keep */;

assign	IDLE		= idle1;
assign	CK 		= CLK;
assign	RAS_n 	= sdr_cmd[2];
assign	CAS_n 	= sdr_cmd[1];
assign	WE_n 		= sdr_cmd[0];
assign	DQM 		= sdr_dqm;
assign	BA	 		= sdr_ba;
assign	MA 		= sdr_a;
assign	DQ 		= sdr_dq;
//=============================================
reg	[5:0]		state		= 0;
reg	[8:0]		address	= 0;
reg			 	H_addr	= 1'b0;
reg	[9:0]		rfsh_cnt	= 0;
//reg				rfsh_req	= 0;
reg	[7:0]		data		= 0;
reg				idle1		= 0;
reg	[2:0]		temp		= 0;
//=============================================
	// SD-RAM control signals
reg	[2:0]		sdr_cmd	= SdrCmd_xx;
reg	[1:0]		sdr_ba	= 2'b00;
reg	[1:0]		sdr_dqm	= 2'b11;
reg	[12:0]	sdr_a		= 0;
reg	[15:0]	sdr_dq	= 16'hZZZZ;
//=============================================
reg [13:0]	V_RD_addr	= 14'd0;
reg [24:0]	M_RD_addr	= 25'd0;
reg [24:0]	M_WR_addr	= 25'd0;
reg [7:0]	M_WR_data	= 8'd0;

reg V_RD_flag = 1'b0;
reg M_RD_flag = 1'b0;
reg M_WR_flag = 1'b0;

reg V_RD_ena = 1'b0;
reg M_RD_ena = 1'b0;
reg M_WR_ena = 1'b0;

reg video = 1'b0;

always @ (posedge CLK) begin
temp <= {v_RD, RD, WR};
//
	if (~temp[2] && v_RD) begin					// Пришел запрос чтения видеопамяти
		V_RD_addr		<= v_A;						// Сохранение адреса для чтения
		V_RD_flag		<= 1'b1;						// Включаем Флаг запроса чтения памяти
		//if (M_WR_flag) M_WR_wait <= 1'b1;		// Если в очереди уже есть циел записи, пропускаем его вперёд
	end else if (V_RD_ena) begin					// Если чтение памяти активировано
		V_RD_flag		<= 1'b0;						// Сброс Флага запроса чтения памяти
	end
//
	if (~temp[1] && RD) begin						// Пришел запрос чтения памяти
		M_RD_addr		<= A;			// Сохранение адреса для чтения
//		M_RD_addr		<= {8'd0, v_A, 3'b000};	// Сохранение адреса для чтения
		M_RD_flag		<= 1'b1;						// Включаем Флаг запроса чтения памяти
		//if (M_WR_flag) M_WR_wait <= 1'b1;		// Если в очереди уже есть циел записи, пропускаем его вперёд
	end else if (M_RD_ena) begin					// Если чтение памяти активировано
		M_RD_flag		<= 1'b0;						// Сброс Флага запроса чтения памяти
	end
//
	if (~temp[0] && WR) begin						// Пришел запрос записи памяти
		M_WR_addr		<= A;			// Сохранение адреса для записи
		M_WR_data		<= DI;						// Сохранение данных для записи
		M_WR_flag		<= 1'b1;						// Включаем Флаг запроса записи памяти
	end else if (M_WR_ena) begin					// Если запись памяти активирована
		M_WR_flag		<= 1'b0;						// Сброс Флага запроса записи памяти
		//M_WR_wait		<= 1'b0;						// Сброс Флага долгого ожидания записи памяти
	end
end //always
//=============================================
always @ (negedge CLK) begin
	case (state)
		// Init
		st_precharge: begin
						sdr_cmd	<= SdrCmd_pr;			// PRECHARGE
						sdr_a		<= 'b1_1111_1111_1111;
						sdr_ba	<= 2'b00;
						sdr_dqm	<= 2'b11;
						state		<= state + 1;
					end
		st_refresh_1, st_refresh_2: begin				// s03, s09
						sdr_cmd	<= SdrCmd_re;			// REFRESH
						state		<= state + 1;
					end
		st_modeset: begin									// s0F
						sdr_cmd	<= SdrCmd_ms;			// LOAD MODE REGISTER
						sdr_a		<= WorkMode;				
						state		<= state + 1;
					end
		// Idle
		st_idle:		begin								// s14
						sdr_dq <= 16'hZZZZ;
						if (V_RD_flag) begin			// Доступ к видеоданным
						//if RD = '1' then
							idle1		<= 1'b0;
							address	<= V_RD_addr[8:0];	// video address [7:0]
							sdr_cmd	<= SdrCmd_ac;		// ACTIVE
							sdr_ba	<= V_RD_addr[10:9];	// video address [9:8]
							sdr_a		<= {8'd0, V_RD_addr[13:11]};	// video address [21:10] 12
							H_addr	<= 1'b0;								// video address [22] 12
							V_RD_ena	<= 1'b1;
							state		<= st_read;				// s15 Read
							video		<= 1'b1;
						end

						else if (M_RD_flag) begin	// Цикл чтения памяти
						//if RD = '1' then
							idle1		<= 1'b0;
							address	<= M_RD_addr[8:0];	// Memory Read address [7:0]
							sdr_cmd	<= SdrCmd_ac;		// ACTIVE
							sdr_ba	<= M_RD_addr[10:9];	// Memory Read address [9:8]
							sdr_a		<= M_RD_addr[23:11];	// Memory Read address [21:10]
							H_addr	<= M_RD_addr[24];		// Memory Read address [22]
							M_RD_ena	<= 1'b1;
							state		<= st_read;				// s15 Read
							video		<= 1'b0;
						end
//
						else if (M_WR_flag) begin	// Цикл записи памяти
						//elsif WR = '1' then
							idle1		<= 1'b0;
							address	<= M_WR_addr[8:0];	// Memory Write address [7:0]
							data		<= M_WR_data;
							sdr_cmd	<= SdrCmd_ac;		// ACTIVE
							sdr_ba	<= M_WR_addr[10:9];	// Memory Write address [9:8]
							sdr_a		<= M_WR_addr[23:11];	// Memory Write address [21:11]
							H_addr	<= M_WR_addr[24];
							M_WR_ena	<= 1'b1;
							state		<= st_write;			// s17 Write
						end
					end
				// A22 A21 A20 A19 A18 A17 A16 A15 A14 A13 A12 A11 A10 A9 A8 A7 A6 A5 A4 A3 A2 A1 A0
				// H/L----------------------ROW---------------------- BA1 BA0-------COLUMN----------
				// Single read - with auto precharge
		st_read_c:	begin								// s16
						sdr_cmd	<= SdrCmd_rd;			// READ (A10 = 1 enable auto precharge; A8..0 = column)
						sdr_a		<= {4'b0100, address};
						sdr_dqm	<= 2'b00;
						state		<= st_read_end;				// s12
					end
				// Single write - with auto precharge
		st_write_c:	begin								// s18
						sdr_cmd	<= SdrCmd_wr;			// WRITE word_7
						sdr_a		<= {4'b0100, address};
						sdr_dq	<= {data, data};
						sdr_dqm	<= {~H_addr, H_addr};
						state		<= st_write_end;			// s12

					end
		default:	begin
						sdr_dq		<= 16'hZZZZ;
						sdr_cmd		<= SdrCmd_xx;			// NOP
						V_RD_ena		<= 1'b0;
						M_RD_ena		<= 1'b0;
						M_WR_ena		<= 1'b0;
						state			<= state + 1;
					end
	endcase
end //always
//=============================================
reg rd_g = 1'b0;
always @ (negedge CLK) begin
	if (state == st_read_c)		rd_g <= 1'b1;			// 
	else if (state == st_idle)	rd_g <= 1'b0;
end //always
//=============================================
always @ (posedge CLK) begin
	if (~idle1 & rd_g & (state == st_idle)) begin
//		case (state)
//			st_idle	:	begin
////								v_D <= {data_reg , DQ};		// READ video word_0
								if (video) v_D <= (H_addr) ? DQ[15:8] : DQ[7:0];		// READ video word_0
								else			DO <= (H_addr) ? DQ[15:8] : DQ[7:0];		// READ data word_0
//							end
//		endcase
	end
end //always
//=============================================
endmodule
//*********************************************
