/*
ZX_ULAX
Модуль синхрогенератора для монитора 640х480 & 60 Гц (800х525) 31,5кГц (25.2MHz)
Пиксельклок 125МГц делится до 25MHz посредством state
Вывод изображения Спектрум-совместимого компьютера
с двойным дублированием изображения.
Для SDRAM burst-8
Синхронизирует MMU, выделяя для памяти 4 окна 56МГц
Окно изображения 512х384, бордюр по Х 64+64, по Y 48+48 точек.
448 точек по Х 1,25 358 активная часть х и 
*/
//`define		f50hz
module vgu
(
	input		wire				picselclock,		//Вход тактовой 125
	
	output	reg [3:0] 		state = 4'b0000,
	
	output	wire				Den,// = 1'b0,			// Data Enable (for TFT display)
	output	wire				h_sync,// = 1'b1,		// Horizontal syncronization
	output	wire				v_sync,// = 1'b1,		// Vertical syncronization
	output	wire	[3:0]		video,					// B R G I
	
	output	wire				window,				// Окно изображения
	output	wire				border,				// Бордюрная часть видимой области экрана
	
	output	wire				flash,

	output	wire	[12:0]	vram_addr,
	input		wire	[7:0]		vram_data,
	input		wire	[2:0]		port_fe,
	
	output	wire				get
);
//=============================================
assign get = dotclock & (hcnt[2:0] == 3'b001);
//reg [15:0] rd_buf = 0;
/*		такт		0			1			2			3
				LoPort
							HiPort1				HiPort1
							захват	чтение
													dotclock
*/ 
// blank		= (state == 3'b000);								// 3'b000 (0)
// HiPort1		= (state == 3'b001) | (state == 3'b011);	// 3'b0x0 (1 & 3)
// HiPort2		= (state == 3'b010) | (state == 3'b100);	// 3'bx01 (2 & 4)
wire dotclock	= (state == 4'b1001); 							// 3'b101 (3)
//=============================================
always @(posedge picselclock) begin
	if (dotclock) begin
		state <= 4'b0000; 
	end else begin
		state <= state + 4'b0001;
	end
end		//always
//********************************************* 640 16 96 48 = 800 (596 16 90 44=746) 140/6=23,33 МГц / 746 = 31,278кГц
localparam [8:0] Display_X		= 320;	// 640 dot
localparam [8:0] FroPorch_X	= 8;		// 16 dot
localparam [8:0] Lenght_SSI	= 48;		// 96 dot
localparam [8:0] BacPorch_X	= 24;		// 48 dot
localparam [8:0] ScreenX		= 256;	// 512 dot
localparam [8:0] BorderX		= (Display_X - ScreenX) / 2;	// 42 dot
parameter RasterX	= Display_X + FroPorch_X + Lenght_SSI + BacPorch_X;	// 400- 800 dot
localparam [8:0] MovWin			= -7; // Сдвиг окна 256х192
localparam [8:0] DelayX			= 8; // Задержка на вывод пикселей

localparam [8:0] Display_Y		= 240;	// 480 lines
localparam [8:0] FroPorch_Y	= 5;		// 10 lines
localparam [8:0] Lenght_KSI	= 1;		// 2 lines
localparam [8:0] BacPorch_Y	= 16;		// 33 lines
localparam [8:0] ScreenY		= 192;	// 384 lines
localparam [8:0] BorderY		= (Display_Y - ScreenY) / 2;	// 24 lines
parameter RasterY	= Display_Y + FroPorch_Y + Lenght_KSI + BacPorch_Y;	// 262- 525 lines

// Вычисляемые
//localparam [8:0] Lenght_SGI	= FroPorch_X + Lenght_SSI + BacPorch_X;	// 31.25kHz (31.25kHz)
//localparam [8:0] Lenght_KGI	= FroPorch_Y + Lenght_KSI + BacPorch_Y;	// 59.64 Hz (60.00 Hz)
localparam [8:0] Start_B_X	= ScreenX - 1;								// 256-1            = 255
localparam [8:0] Start_SGI	= Start_B_X + BorderX - MovWin;		// 255+32           = 287
localparam [8:0] Start_SSI	= Start_SGI + FroPorch_X;				// 287+8            = 295
localparam [8:0] Stop_SSI	= Start_SSI + Lenght_SSI;				// 295+48           = 343
localparam [8:0] Stop_SGI	= Stop_SSI + BacPorch_X;				// 343+24           = 367
localparam [8:0] Stop_B_X	= Stop_SGI + BorderX + MovWin;		// 367+32           = 399

localparam [8:0] Start_WIN	= DelayX - 1;						// 8-1 = 7
localparam [8:0] Stop_WIN	= Start_WIN + ScreenX;			// 255+8 = 263


localparam [8:0] Start_B_Y	= ScreenY - 1;										// 192-1      = 191
localparam [8:0] Start_KGI	= Start_B_Y + BorderY;							// 191+24     = 215
localparam [8:0] Start_KSI	= Start_KGI + FroPorch_Y;						// 215+5      = 220
localparam [8:0] Stop_KSI	= Start_KSI + Lenght_KSI;						// 220+1      = 221
localparam [8:0] Stop_KGI	= Stop_KSI + BacPorch_Y;						// 221+16     = 237
localparam [8:0] Stop_B_Y	= Stop_KGI + BorderY;							// 245+24     = 261

localparam [8:0] Start_Int		= 1;
localparam [8:0] Lenght_Int	= 32;
localparam [8:0] Stop_Int		= Start_Int + Lenght_Int;
//*********************************************
assign border = Den ^ window;	// Не окно и не гашение
assign h_sync = SSI;	// По стандарту синхроимпульс отрицательный
assign v_sync = KSI;	// По стандарту синхроимпульс отрицательный
assign Den = Den_X & Den_Y;				// Весь растр
assign window = window_X & window_Y;	// Окно 256х192
//*********************************************
wire [12:0] addr_Pics = {vcnt[7:6], vcnt[2:0], vcnt[5:3], hcnt[7:3]};	// 2+3+3+5=13
wire [12:0] addr_Attr = {3'b110, vcnt[7:3], hcnt[7:3]};						// 3+5+5=13
//---------------------------------------------
assign vram_addr = (hcnt[1]) ? addr_Attr : addr_Pics;	// Стандартный экран
//=============================================

//=============================================
wire [5:0] v_ink = {attr_reg[5], attr_reg[4], attr_reg[3], attr_reg[6]};	// B R G I
wire [5:0] v_pap = {attr_reg[2], attr_reg[1], attr_reg[0], attr_reg[6]};	// B R G I
wire infv = ~(flash & attr_reg[7]) ^ vid_dot;
//---------------------------------------------
wire [2:0] vsel = {Den, window, infv};
//---------------------------------------------
assign video = (vsel == 3'b110) ? v_pap :						// Paper
					(vsel == 3'b111) ? v_ink :						// Ink
					(vsel == 3'b100) ? {port_fe[2:0], 1'b0} :	// Border
					(vsel == 3'b101) ? {port_fe[2:0], 1'b0} :	// Border
					4'b0000;
//=============================================
// Чтение видеоданных
reg [7:0] attr_reg; reg [8:0] inf_reg; wire vid_dot = inf_reg[7];
reg [7:0] tmp_inf; reg [7:0] tmp_attr;
//---------------------------------------------
always @ (posedge picselclock) begin
	if (dotclock) begin
		if (hcnt[2:0] == 3'b101) tmp_inf <= vram_data;	// Чтение пиксельной области
		if (hcnt[2:0] == 3'b110) tmp_attr <= vram_data;						// Чтение атрибутов
	end
end //always
always @ (posedge picselclock) begin
	if (dotclock) begin
		if (hcnt[2:0] == 3'b111) begin
			inf_reg <= tmp_inf;
			attr_reg <= tmp_attr;
		end else inf_reg <= {inf_reg[7:0], 1'b0};	
	end
end //always
//=============================================
// Развёртки
/*---------------------------------------------
Вспомогательный делитель на 2 для скандаблера + строчной и кадровый счётчики
---------------------------------------------*/
//reg 			htmp = 1'b0; 
reg 			vtmp = 1'b0;	// Для скандаблера
reg [8:0] hcnt = Stop_SSI;	reg [8:0] vcnt = Stop_KSI;	// Счетчики развётрки
reg			SSI = 1'b1;		reg			KSI = 1'b1;		// Синхроимпульсы
reg window_X = 1'b0;  reg window_Y = 1'b0;	// Регистры окно (256х192) / не экран (бордюр/гашение)
reg Den_X = 1'b0; reg Den_Y = 1'b0;
/*============================================
    Определяем размеры строки и кадра
============================================*/
always @(posedge picselclock) begin
	if (dotclock) begin								// Скандаблер
		case (hcnt)
			Stop_B_X	:	begin						// 399
									hcnt <= 0;
									if	(vtmp) begin				// Скандаблер
										case (vcnt)
											Stop_B_Y	:	vcnt	<= 0;	// 261
											default	:	vcnt <= vcnt + 1;
										endcase
									end
									vtmp <= ~vtmp;					// Инкремент счётчика скандаблера Y
								end
			default	:	hcnt <= hcnt + 1;
		endcase
	end
end		//always
/*============================================
    Строчные синхросигналы отдельно, так как сдвиг на чтение
============================================*/
always @(posedge picselclock) begin
	if (dotclock) begin								// Скандаблер
		case (hcnt)
			Start_WIN	:	window_X	<= 1'b1;		// -1 + 8
			Stop_WIN		:	window_X	<= 1'b0;		// 255 + 8
		endcase
	end
end		//always
/*============================================
    Управление окном и кадровые синхроимпульсы
============================================*/
always @(posedge picselclock) begin
	if (dotclock) begin								// Скандаблер
		case (hcnt)
			//Start_B_X	:	window_X	<= 1'b0;		// 255
			Start_SGI	:	Den_X		<= 1'b0;		// 287
			Start_SSI	:	SSI <= 1'b0;			// 295
			Stop_SSI		:	begin
									SSI <= 1'b1;			// 343
									Den_X		<= 1'b1;		// 367
									if	(vtmp) begin				// Скандаблер
										case (vcnt)
											Start_B_Y	:	window_Y	<= 1'b0;	// 191
											Start_KGI	:	Den_Y		<= 1'b0;	// 215
											Start_KSI	:	KSI		<= 1'b0;	// 220
											Stop_KSI		:	KSI		<= 1'b1;	// 221
											Stop_KGI		:	Den_Y		<= 1'b1;	// 237
											Stop_B_Y		:	window_Y	<= 1'b1;	// 261
										endcase
									end
								end
			//Stop_B_X		:	window_X	<= 1'b1;		// 399
		endcase
	end
end		//always
//=============================================
assign flash = flash_cnt[5];
reg [5:0] flash_cnt = 0;
always @(posedge KSI) begin
		flash_cnt <= flash_cnt + 1;
end		//always
//=============================================
endmodule
//*********************************************
