//
// *************************************************
// *********   0- -LPT  ***********
// *************  60 **************
// *************************************************
//

#include <LPC214X.H>                        /* LPC214x definitions */

#include "integer.h"

//    LPT

#define lpt_read  ((FIO0PIN & 1<<10)==0)
#define lpt_busy  ((FIO0PIN & 1<<10)>0)

//  
#define PORTOUTCLR	(FIO1CLR = 0x00FF0000)
//    
#define PORTOUT(b)	(FIO1SET = (b<<16)|(1<<21))

BYTE KS;  //  

extern BYTE Buff[8192]; //   
extern WORD Adr_b; //      
extern BYTE Rom_Bl_Start;  //    ROM

// =====================
void Init_Port_LPT(void){
	PORTOUTCLR;	//  
  FIO1DIR |= (0xFF<<16);  //    
}

// =====================
void OFF_Port_LPT(void){
  PORTOUT(0xFF);	//    
  FIO1DIR &= ~(0xFF<<16);  //   
}

//  
void Send_Byte_LPT(BYTE b){
	PORTOUT(b & 0x0F);	//   /  
	while(lpt_busy && Key_Stop);	//    
  PORTOUTCLR;
	while(lpt_read && Key_Stop);	//    
	PORTOUT(b >> 4);	//   /  
	while(lpt_busy && Key_Stop);	//    
  PORTOUTCLR;
}


//========================================================
//  
// nom_blok -    
// kol_blok -     (1  = 256 )
// Bblok - (  )
BYTE To_LPT(BYTE nom_blok, WORD kol_blok, WORD Bblok){
BYTE err;

  err=0;
  if(Key_Stop){
    if(nom_blok==0){
      Init_Port_LPT();  //     
	    KS=0;		//    

//  
  	  Send_Byte_LPT(0x55);
	    Send_Byte_LPT(0xAA);
      Send_Byte_LPT(Rom_Bl_Start);
      Send_Byte_LPT(kol_blok);
//
    }
 	  Adr_b = 0;	//     
  	while(Bblok--){
	  	Send_Byte_LPT(Buff[Adr_b]);
      KS = KS ^ Buff[Adr_b++];
	  }
    nom_blok++;
	  if (nom_blok==kol_blok){
      Send_Byte_LPT(KS);
      OFF_Port_LPT();	//  
    }
  }
  else{
    OFF_Port_LPT();	//  
    err=1;
  }
  return err;
}

//========================================================
