#include <PS2KeyRaw.h>
#define AX0 4
#define AX1 5
#define AX2 6
#define AX3 7
#define AY0 8
#define AY1 9
#define AY2 10
#define RSTMT 14
#define CSMT  15
#define DATMT 16
#define STBMT 17
#define DATAPIN 2
#define IRQPIN  3

volatile boolean d = HIGH;
uint8_t table[128] = {127,127,127,44,42,40,41,127,127,127,127,127,43,102,127,127,127,127,112,127,117,33,65,127,127,127,50,35,1,39,66,127,
127,3,48,4,5,68,67,127,127,103,38,6,36,34,69,127,127,22,2,16,7,49,70,127,127,127,21,18,37,71,80,127,127,127,19,17,23,64,81,127,127,127,127,20,127,32,
127,127,127,127,127,127,127,127,127,127,127,119,96,127,127,127,127,127,127,127,127,127,127,127,101,127,127,9,127,12,15,127,127,127,8,22,10,13,14,24,
115,127,127,127,11,127,127,25,127,127};

PS2KeyRaw keyboard;

void setup() {
  //Инициализация портов
  pinMode(19, OUTPUT);
  pinMode(AX0, OUTPUT);   //AX0
  pinMode(AX1, OUTPUT);   //AX1
  pinMode(AX2, OUTPUT);   //AX2
  pinMode(AX3, OUTPUT);   //AX3
  pinMode(AY0, OUTPUT);   //AY0
  pinMode(AY1, OUTPUT);   //AY1
  pinMode(AY2, OUTPUT);   //AY2
  pinMode(RSTMT, OUTPUT); //RES
  pinMode(CSMT, OUTPUT);  //CS
  pinMode(DATMT, OUTPUT); //DAT
  pinMode(STBMT, OUTPUT); //STB
  //Инициализация MT8816
  SetAddr(0);
  digitalWrite(RSTMT, LOW);
  digitalWrite(CSMT, LOW);
  digitalWrite(DATMT, LOW);
  digitalWrite(STBMT, LOW); //инициализация
  digitalWrite(CSMT, HIGH); //выбор чипа
  digitalWrite(RSTMT, HIGH);
  digitalWrite(RSTMT, LOW);  //сброс
  digitalWrite(CSMT, LOW);
  delay(1000);
  //Инициализация клавиатуры
  keyboard.begin( DATAPIN, IRQPIN );
}

void SetAddr(uint8_t addr) {
  digitalWrite(AX0,bitRead(addr,0));
  digitalWrite(AX1,bitRead(addr,1));
  digitalWrite(AX2,bitRead(addr,2));
  digitalWrite(AX3,bitRead(addr,3));
  digitalWrite(AY0,bitRead(addr,4));
  digitalWrite(AY1,bitRead(addr,5));
  digitalWrite(AY2,bitRead(addr,6));
}

void SetKey(boolean data){
   digitalWrite(CSMT, HIGH); //выбор чипа
   digitalWrite(STBMT, HIGH); //строб on
   digitalWrite(DATMT, data); //данные 1
   digitalWrite(STBMT, LOW); //строб off    
   digitalWrite(CSMT, LOW);   
}

void loop()
{
  if( keyboard.available() ){
    digitalWrite(19, HIGH);  //индикация нажатия клавиши ON
    int c = keyboard.read(); //чтение кода
    switch (c) {
      case 0xE0:              //если считался префикс 0xE0
        break;
      case 0xF0:              //если считался префикс 0xF0 (отпускание клавиши)
        d = LOW;
        break;
      default:
        SetAddr(table[c]);
        SetKey(d);
        d = HIGH;
   }
   digitalWrite(19, LOW);  //индикация нажатия клавиши OFF
  }
}

