



procedure idniundm;
begin
	asm
;		include "zxlikepascal_lib.asm"

	end;
	
	{$ifndef demo_z}
	asm
; ===== ____mul_proc =====

; функция беззнакового умножения 16-разрядных чисел
; (C) Kirill Frolov
;     idea by Vasil Ivanov
; dehl=de*bc   ~730t.

___mul:	ld	a,d
	and	a
	jp	nz,___mul_00
	ld	ix,___mul_00
	ld	h,b
	ld	l,c
	ld	a,e
	jp	___mul_02

___mul_00:	ld	a,b
	and	a
	jp	nz,___mul_01
	ld	ix,___mul_01
	ld	h,d
	ld	l,e
	ld	a,c
	jp	___mul_02

___mul_01:
        ld hl, 0
        ld a, c 
        ld c, l    ; 18

        add a, a 
        jr nc, $+4
        add hl, de 
        adc a, c   ; 29
     ; REPEAT 7
          add hl, hl 
          rla 
          jr nc, $+4
          add hl, de 
          adc a, c   ; 40*7  309
              add hl, hl 
              rla 
              jr nc, $+4
              add hl, de 
              adc a, c 
            add hl, hl 
            rla 
            jr nc, $+4
            add hl, de 
            adc a, c 
              add hl, hl 
              rla 
              jr nc, $+4
              add hl, de 
              adc a, c 
            add hl, hl 
            rla 
            jr nc, $+4
            add hl, de 
            adc a, c 
              add hl, hl 
              rla 
              jr nc, $+4
              add hl, de 
              adc a, c 
            add hl, hl 
            rla 
            jr nc, $+4
            add hl, de 
            adc a, c 
     ; ENDR 

        ld c, a 
        push hl   ; 0chl
        ld hl, 0
        ld a, b 
        ld b, l   ; 33

        add a, a 
        jr nc, $+4
        add hl, de
        add a, b   ; 29
     ; REPEAT 7
          add hl, hl 
          rla 
          jr nc, $+4
          add hl, de 
          add a, b   ; 40*7  309
              add hl, hl 
              rla 
              jr nc, $+4
              add hl, de 
              add a, b 
            add hl, hl 
            rla 
            jr nc, $+4
            add hl, de 
            add a, b 
              add hl, hl 
              rla 
              jr nc, $+4
              add hl, de 
              add a, b 
            add hl, hl 
            rla 
            jr nc, $+4
            add hl, de 
            add a, b 
              add hl, hl 
              rla 
              jr nc, $+4
              add hl, de 
              add a, b 
            add hl, hl 
            rla 
            jr nc, $+4
            add hl, de 
            add a, b 
     ; ENDR 

   ; ahl0 + 0cde = hlde
        pop de
        ld b, l
        ld l, h
        ld h, a
        ld a, d
        add a, b
        ld d, a 
        ld b, 0
        adc hl, bc
        ex de, hl   ; 60

        ret         ; 729t.


___mul_02:		and	a
		jp	z,___mul_n0
		cp	1
		jp	z,___mul_n1
		cp	2
		jp	z,___mul_n2
		cp	3
		jp	z,___mul_n3
		cp	4
		jp	z,___mul_n4
		cp	5
		jp	z,___mul_n5
		cp	8
		jp	z,___mul_n8
		cp	10
		jp	z,___mul_n10
		cp	15
		jp	z,___mul_n15
		cp	16
		jp	z,___mul_n16
		cp	20
		jp	z,___mul_n20
		cp	32
		jp	z,___mul_n32
		cp	50
		jp	z,___mul_n50
		cp	64
		jp	z,___mul_n64
		cp	100
		jp	z,___mul_n100
		cp	128
		jp	z,___mul_n128
		jp	(ix)

___mul_n0:		ld	hl,0
		ret

___mul_n1:		ret

___mul_n2:		add	hl,hl
		ret

___mul_n3:		ld	d,h
		ld	e,l
		add	hl,hl
		add	hl,de
		ret

___mul_n4:		add	hl,hl
		add	hl,hl
		ret

___mul_n5:		ld	d,h
		ld	e,l
		add	hl,hl
		add	hl,hl
		add	hl,de
		ret

___mul_n8:		add	hl,hl
		add	hl,hl
		add	hl,hl
		ret

___mul_n10:		add	hl,hl
		ld	d,h
		ld	e,l
		add	hl,hl
		add	hl,hl
		add	hl,de
		ret

___mul_n15:		ld	d,h
		ld	e,l
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		and	a
		sbc	hl,de
		ret

___mul_n16:		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		ret

___mul_n20:		add	hl,hl
		add	hl,hl
		ld	d,h
		ld	e,l
		add	hl,hl
		add	hl,hl
		add	hl,de
		ret

___mul_n32:		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		ret

___mul_n50:		add	hl,hl
		ld	d,h
		ld	e,l
		add	hl,hl
		add	hl,hl
		add	hl,hl
		ld	b,h
		ld	c,l
		add	hl,hl
		add	hl,bc
		add	hl,de
		ret

___mul_n64:		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		ret

___mul_n100:	add	hl,hl
		add	hl,hl
		ld	d,h
		ld	e,l
		add	hl,hl
		add	hl,hl
		add	hl,hl
		ld	b,h
		ld	c,l
		add	hl,hl
		add	hl,bc
		add	hl,de
		ret

___mul_n128:	add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		add	hl,hl
		ret
	end;
	{$endif}
	asm

; ===== _map =====

map_addr_array:		defw	0
map_xmax_array:		defb	0
map_ymax_array:		defb	0
map_addr_sprites:	defw	0
map_xscr:		defb	0
map_yscr:		defb	0
map_width_scr:		defb	0
map_height_scr:		defb	0

map_x:			defb	0
map_y:			defb	0
map_xmin:		defb	0
map_ymin:		defb	0
map_xmax:		defb	0
map_ymax:		defb	0
map_xlen:		defb	0
map_ylen:		defb	0
map_addr_curr:		defw	0
map_xscr_curr:		defb	0
map_yscr_curr:		defb	0

map_id_elem:		defb	0
map_distance_elem:	defb	0
map_condition:		defw	0
map_x_elem:		defb	0
map_y_elem:		defb	0
map_value_elem:		defb	0
map_distance_curr:	defb	0
map_addr_source:		defw	0

table_condition:		defb	0cdh,0cch,0c4h,0dch,0d4h



; ===== _mirror =====

mirror_max_x:		defb	0

; ===== _all =====

; константы

;virt_screen_high:	equ	160				; старший байт смещения вирт.экрана
;addr_virt_screen:	equ	57344				; адрес вирт.экрана
;table_mirror_high:	equ	251				; старший байт адреса таблицы зеркальных байтов
virt_screen_high:	equ	95-64				; старший байт смещения вирт.экрана
addr_virt_screen:	equ	05f00h ; 06000h				; адрес вирт.экрана


; ===== _put_text_variable =====

col_screen:			defb	0					; столбец экрана
row_screen:			defb	0					; строка экрана
half_tile_screen:		defb	0					; полузнакоместо (0=первое/1=второе)
attr_screen:			defb	56					; атрибуты экрана

col_screen_temp:			defw	0					; временные координаты на экране
half_tile_screen_temp:		defb	0					; временное полузнакоместо


	end;
end;


////////////////////////////////////////////////////////////////////////////////

procedure textbackgroundeee(n:byte);
begin
end;

////////////////////////////////////////////////////////////////////////////////

procedure textcoloreee(n:byte);
begin
end;

////////////////////////////////////////////////////////////////////////////////

procedure gotoxyfff(x,y:byte);
begin
end;


////////////////////////////////////////////////////////////////////////////////

procedure randomize1;
begin
end;

////////////////////////////////////////////////////////////////////////////////

function randomww(n:word):word;
begin
end;

////////////////////////////////////////////////////////////////////////////////



procedure MapSet(p1,p2:pointer; a3,a4,a5,a6:byte);
begin
//	MapSet(@map,map_sprites,0,0,32,22);
	asm
		ld    e,(&&p1+0)
		ld    d,(&&p1+1)
		ld    (map_addr_array),de

		ld    e,(&&p2+0)
		ld    d,(&&p2+1)
		ld    (map_addr_sprites),de

		ld    a,(&&a3)
		ld    (map_xscr),a

		ld    a,(&&a4)
		ld    (map_yscr),a

		ld    a,(&&a5)
		ld    (map_width_scr),a

		ld    a,(&&a6)
		ld    (map_height_scr),a

		ld    a,64
		ld    (map_xmax_array),a
		ld    a,64
		ld    (map_ymax_array),a
	end;
end;

procedure MapSet__(a3,a4:byte); // "Y,X" ?!
begin
	asm
		ld    a,(&&a3)
		ld    (map_ymax_array),a

		ld    a,(&&a4)
		ld    (map_xmax_array),a
	end;
end;


////////////////////////////////////////////////////////////////////////////////

procedure MapPut1x1(x,y:byte);
begin
	asm
		ld a,(&&x) ; X
		ld (map_x),a
		ld a,(&&y) ; Y
		ld (map_y),a
		push ix
		call map_put_1x1
		pop ix
		jp __ret4


; ===== _map_1x1 =====

; вывод участка карты на экран клетками 1x1 знакомест
; вход: параметры карты
; выход: нет

map_put_1x1: 
	ld	a,(map_ymax_array)
			ld	c,a
			ld	b,0
			ld	a,(map_x)
			dec	a
			ld	e,a
			ld	d,0
			call	___mul

			ld	a,(map_y)
			dec	a
			ld	e,a
			ld	d,0
			add	hl,de

			ld	de,(map_addr_array)
			add	hl,de

			ld	(map_addr_curr),hl

			ld	hl,(map_xscr)
			ld	(map_xscr_curr),hl

			ld	a,(map_height_scr)
			ld	b,a

map_put_1x1_01:
			push	bc

			ld	a,(map_width_scr)
			ld	b,a

map_put_1x1_02:
			push	bc

			ld	hl,(map_addr_curr)

			ld	a,(hl)
			and	a
			ld	hl,(map_addr_sprites)
			jp	z,map_put_1x1_04
			ld	b,a

			ld	de,8
; +++++ _flag_attr_map +++++
			ld	de,9
; ----- _flag_attr_map -----


map_put_1x1_03:
			add	hl,de
			djnz	map_put_1x1_03

map_put_1x1_04:		
			call	map_put_1x1_10

			ld	hl,(map_addr_curr)
			inc	hl
			ld	(map_addr_curr),hl

			ld	hl,map_xscr_curr
			inc	(hl)
			;inc	(hl)

			pop	bc
			djnz	map_put_1x1_02

			ld	hl,(map_addr_curr)
			ld	a,(map_ymax_array)
			ld	e,a
			ld	d,0
			add	hl,de

			ld	a,(map_width_scr)
			ld	e,a
			and	a
			sbc	hl,de

			ld	(map_addr_curr),hl

			ld	hl,map_yscr_curr
			inc	(hl)
			;inc	(hl)

			ld	a,(map_xscr)
			ld	(map_xscr_curr),a

			pop	bc
			djnz	map_put_1x1_01

			ret


map_put_1x1_10:
			ex	de,hl

; +++++ _flag_attr_map +++++

			ld	bc,(map_xscr_curr)

			LD	A,B
			RRCA
			RRCA
			RRCA
			LD	L,A
			AND	31
			OR	88
			LD	H,A
			LD	A,L
			AND	252
			OR	C
			LD	L,A

; +++++ _flag_virt_scr_map +++++

			ld	bc,addr_virt_screen-16384
			add	hl,bc

; ----- _flag_virt_scr_map -----

			ld	a,(de)
			ld	(hl),a
			inc	de

; ----- _flag_attr_map -----

			ld	bc,(map_xscr_curr)

			LD      A,B
			LD      H,A
			RRCA
			RRCA
			RRCA
			AND	224
			ADD	A,C
			LD	L,A
			LD	A,H
			AND	24
			OR	64
			LD	H,A

; +++++ _flag_virt_scr_map +++++

			ld	bc,addr_virt_screen-16384
			add	hl,bc

; ----- _flag_virt_scr_map -----

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a

			ret

__ret4:
	end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure map4x4_put(_X_MAP_SCR,_Y_MAP_SCR:byte);
begin
	asm

		ld a,(&&_X_MAP_SCR)
;		ld	a,(_X_MAP_SCR)
		ld	(map_x),a

		ld a,(&&_Y_MAP_SCR)
;		ld	a,(_Y_MAP_SCR)
		ld	(map_y),a

		call MAP4X4_PUT
		jp _ret13

; вывод участка карты на экран спрайтами 4х4 знакоместа без атрибутов
; вход: параметры карты
; выход: нет

MAP4X4_PUT:

			ld	a,(map_y)
			dec	a
			ld	l,a
			ld	h,0
			add	hl,hl
			add	hl,hl
			add	hl,hl
			add	hl,hl
			add	hl,hl
			add	hl,hl

			ld	a,(map_x)
			dec	a
			ld	e,a
			ld	d,0
			add	hl,de

			ld	de,(map_addr_array)
			add	hl,de

			ld	(map_addr_curr),hl

			ld	hl,(map_xscr)
			ld	(map_xscr_curr),hl

			ld	a,(map_height_scr)
			ld	b,a

map4x4_put_01:		push	bc

			ld	a,(map_width_scr)
			ld	b,a

map4x4_put_02:		push	bc

			ld	hl,(map_addr_curr)

			ld	a,(hl)
			cp	255
			jp	z,map4x4_put_05
			and	a
			ld	hl,(map_addr_sprites)
			jp	z,map4x4_put_04
			ld	b,a

			ld	de,128

map4x4_put_03:		add	hl,de
			djnz	map4x4_put_03

map4x4_put_04:		call	map4x4_put_10

map4x4_put_05:		ld	hl,(map_addr_curr)
			inc	hl
			ld	(map_addr_curr),hl

			ld	hl,map_xscr_curr
			inc	(hl)
			inc	(hl)
			inc	(hl)
			inc	(hl)

			pop	bc
			djnz	map4x4_put_02

			ld	hl,(map_addr_curr)
			ld	a,(map_xmax_array)
			ld	e,a
			ld	d,0
			add	hl,de

			ld	a,(map_width_scr)
			ld	e,a
			and	a
			sbc	hl,de

			ld	(map_addr_curr),hl

			ld	hl,map_yscr_curr
			inc	(hl)
			inc	(hl)
			inc	(hl)
			inc	(hl)

			ld	a,(map_xscr)
			ld	(map_xscr_curr),a

			pop	bc
			djnz	map4x4_put_01

			ret


map4x4_put_10:		ex	de,hl

			ld	bc,(map_xscr_curr)

			LD      A,B
			LD      H,A
			RRCA
			RRCA
			RRCA
			AND	224
			ADD	A,C
			LD	L,A
			LD	A,H
			AND	24
			OR	64
			LD	H,A

			ld	bc,addr_virt_screen-16384
			add	hl,bc


			; 1

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 2

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 3

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 4

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 5

			ld	bc,06e3h
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 6

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 7

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 8

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 9

			ld	bc,06e3h
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 10

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 11

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 12

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 13

			ld	bc,06e3h
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 14

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 15

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a
			inc	de

			; 16

			ld	bc,06ffh
			and	a
			sbc	hl,bc

			dup	7
			ld	a,(de)
			ld	(hl),a
			inc	de
			inc	h
			edup

			ld	a,(de)
			ld	(hl),a

dhbffgjnbb:

			ret
			
_ret13:

	end;
end;


////////////////////////////////////////////////////////////////////////////////

procedure SpritePutClear(param1:pointer; x,y:word);
begin
	asm
		ld    e,(&&param1+0) ; param1
		ld    d,(&&param1+1) ; param1
		ex de,hl
		ld    e,(&&x) ; X
		ld    d,(&&y) ; Y
		call  put_spr_put
		jp __ret1

; ===== _put_sprite_put =====

; вывод произвольного спрайта с атрибутами с затиранием изображения на экране
; вход: HL=адрес спрайта, DE=координаты вывода на экране
; выход: нет

put_spr_put:	LD	B,(HL)

put_spr_put_01:	PUSH	BC				; B = количество знакомест в спрайте

		INC	HL
		LD	A,(HL)
		ADD	A,D

; +++++ _flag_edge_screen_sprite +++++

		CP	24
		JP	NC,put_spr_put_03

; ----- _flag_edge_screen_sprite -----

		LD	B,A

		INC	HL
		LD	A,(HL)
		ADD	A,E

; +++++ _flag_edge_screen_sprite +++++

		CP	32
		JP	NC,put_spr_put_04

; ----- _flag_edge_screen_sprite -----

		LD	C,A

		INC	HL
		PUSH	DE				; DE = координаты спрайта на экране
							; HL = адрес нахождения в спрайте, DE = свободно

	end;
	{$ifdef _flag_attr_sprite}
	asm
; +++++ _flag_attr_sprite +++++

		PUSH	BC				; BC = реальные координаты спрайта на экране

              LD	A,B				; расчет адреса атрибутов знакоместа в DE
                RRCA
                RRCA
                RRCA
                LD	E,A
                AND	31
                OR	88
                LD	D,A
                LD	A,E
                AND	252
                OR	C
                LD	E,A

; +++++ _flag_virt_scr_sprite +++++

		ld	a,virt_screen_high
		add	a,d
		ld	d,a

; ----- _flag_virt_scr_sprite -----

               POP     BC                              ; BC = реальные координаты спрайта на экране
		LD      A,(HL)                          ; читаем байт атрибутов знакоместа в спрайте
        LD      (DE),A                          ; заносим атрибуты знакоместа на экран
		INC	HL

; ----- _flag_attr_sprite -----
	end;
{$endif}
	asm
                LD      A,B				; расчет адреса первого байта знакоместа в DE
                LD      D,A
                RRCA
                RRCA
                RRCA
                AND	224
		ADD	A,C
                LD	E,A
                LD	A,D
                AND	24
                OR	64
                LD	D,A				; DE = адрес вывода знакоместа на экране, HL = адрес изображения в спрайте

; +++++ _flag_virt_scr_sprite +++++

		ld	a,virt_screen_high
		add	a,d
		ld	d,a

; ----- _flag_virt_scr_sprite -----

		; вывод знакоместа (8 строк)

		dup	7
		LD	A,(HL)
		LD	(DE),A				; вывели байт спрайта
		INC     HL
                INC     D
		edup

		LD	A,(HL)
		LD	(DE),A				; вывели байт спрайта

		POP	DE				; HL = адрес нахождения в спрайте, DE = координаты спрайта на экране
put_spr_put_02:	POP	BC				; B = цикл по количеству знакомест в спрайте
		DJNZ	put_spr_put_01
		RET

; +++++ _flag_edge_screen_sprite +++++

put_spr_put_03:	ld	bc,9
		add	hl,bc
	end;
{$ifdef _flag_attr_sprite}
	asm
; +++++ _flag_attr_sprite +++++

		inc	hl

; ----- _flag_attr_sprite -----
	end;
{$endif}
	asm

		jp	put_spr_put_02

put_spr_put_04:	ld	bc,8
		add	hl,bc
	end;
{$ifdef _flag_attr_sprite}
	asm

; +++++ _flag_attr_sprite +++++

		inc	hl

; ----- _flag_attr_sprite -----
	end;
{$endif}
	asm

		jp	put_spr_put_02

; ----- _flag_edge_screen_sprite -----

__ret1:
	end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure SpritePutAnd(param1:pointer; x,y:word);
begin
	asm
	
		ld    e,(ix+12)
		ld    d,(ix+13)
		ex de,hl
		ld    e,(ix+8) ; X
		ld    d,(ix+4) ; Y
		call  put_spr_and
		jp __ret11

; ===== _put_sprite_and =====

; вывод произвольного спрайта с атрибутами по методу AND
; вход: HL=адрес спрайта, DE=координаты вывода на экране
; выход: нет

put_spr_and:	LD	B,(HL)

put_spr_and_01:	PUSH	BC				; B = количество знакомест в спрайте

		INC	HL
		LD	A,(HL)
		ADD	A,D

; +++++ _flag_edge_screen_sprite +++++

		CP	24
		JP	NC,put_spr_and_03

; ----- _flag_edge_screen_sprite -----

		LD	B,A

		INC	HL
		LD	A,(HL)
		ADD	A,E

; +++++ _flag_edge_screen_sprite +++++

		CP	32
		JP	NC,put_spr_and_04

; ----- _flag_edge_screen_sprite -----

		LD	C,A

		INC	HL
		PUSH	DE				; DE = координаты спрайта на экране
							; HL = адрес нахождения в спрайте, DE = свободно

; +++++ _flag_attr_sprite +++++

;		PUSH	BC				; BC = реальные координаты спрайта на экране
;
;               LD	A,B				; расчет адреса атрибутов знакоместа в DE
;                RRCA
;                RRCA
;                RRCA
;                LD	E,A
;                AND	31
;                OR	88
;                LD	D,A
;                LD	A,E
;                AND	252
;                OR	C
;                LD	E,A

; +++++ _flag_virt_scr_sprite +++++

;		ld	a,virt_screen_high
;		add	a,d
;		ld	d,a

; ----- _flag_virt_scr_sprite -----

 ;               POP     BC                              ; BC = реальные координаты спрайта на экране
;		LD      A,(HL)                          ; читаем байт атрибутов знакоместа в спрайте
;                LD      (DE),A                          ; заносим атрибуты знакоместа на экран

;		INC	HL

; ----- _flag_attr_sprite -----

                LD      A,B				; расчет адреса первого байта знакоместа в DE
                LD      D,A
                RRCA
                RRCA
                RRCA
                AND	224
		ADD	A,C
                LD	E,A
                LD	A,D
                AND	24
                OR	64
                LD	D,A				; DE = адрес вывода знакоместа на экране, HL = адрес изображения в спрайте

; +++++ _flag_virt_scr_sprite +++++

		ld	a,virt_screen_high
		add	a,d
		ld	d,a

; ----- _flag_virt_scr_sprite -----

		; вывод знакоместа (8 строк)

		dup	7
		LD	A,(DE)
		AND	(HL)
		LD	(DE),A				; вывели байт спрайта
		INC     HL
                INC     D
		edup

		LD	A,(DE)
		AND	(HL)
		LD	(DE),A				; вывели байт спрайта

		POP	DE				; HL = адрес нахождения в спрайте, DE = координаты спрайта на экране
put_spr_and_02:	POP	BC				; B = цикл по количеству знакомест в спрайте
		DJNZ	put_spr_and_01
		RET

; +++++ _flag_edge_screen_sprite +++++

put_spr_and_03:	ld	bc,9
		add	hl,bc

; +++++ _flag_attr_sprite +++++

;		inc	hl

; ----- _flag_attr_sprite -----

		jp	put_spr_and_02

put_spr_and_04:	ld	bc,8
		add	hl,bc

; +++++ _flag_attr_sprite +++++

;		inc	hl

; ----- _flag_attr_sprite -----

		jp	put_spr_and_02

; ----- _flag_edge_screen_sprite -----
__ret11:
	end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure SpritePutOr(param1:pointer; x,y:word);
begin
	asm
	
		ld    e,(ix+12)
		ld    d,(ix+13)
		ex de,hl
		ld    e,(ix+8) ; X
		ld    d,(ix+4) ; Y
		call  put_spr_or
		jp __ret12

; ===== _put_sprite_or =====

; вывод произвольного спрайта с атрибутами по методу OR
; вход: HL=адрес спрайта, DE=координаты вывода на экране
; выход: нет

put_spr_or:	LD	B,(HL)

put_spr_or_01:	PUSH	BC				; B = количество знакомест в спрайте

		INC	HL
		LD	A,(HL)
		ADD	A,D

; +++++ _flag_edge_screen_sprite +++++

		CP	24
		JP	NC,put_spr_or_03

; ----- _flag_edge_screen_sprite -----

		LD	B,A

		INC	HL
		LD	A,(HL)
		ADD	A,E

; +++++ _flag_edge_screen_sprite +++++

		CP	32
		JP	NC,put_spr_or_04

; ----- _flag_edge_screen_sprite -----

		LD	C,A

		INC	HL
		PUSH	DE				; DE = координаты спрайта на экране
							; HL = адрес нахождения в спрайте, DE = свободно

; +++++ _flag_attr_sprite +++++

;		PUSH	BC				; BC = реальные координаты спрайта на экране
;
;                LD	A,B				; расчет адреса атрибутов знакоместа в DE
;                RRCA
;                RRCA
;                RRCA
;                LD	E,A
;                AND	31
;                OR	88
;                LD	D,A
;                LD	A,E
;                AND	252
;                OR	C
;                LD	E,A

; +++++ _flag_virt_scr_sprite +++++

;		ld	a,virt_screen_high
;		add	a,d
;		ld	d,a

; ----- _flag_virt_scr_sprite -----

 ;               POP     BC                              ; BC = реальные координаты спрайта на экране
;		LD      A,(HL)                          ; читаем байт атрибутов знакоместа в спрайте
;                LD      (DE),A                          ; заносим атрибуты знакоместа на экран

;		INC	HL

; ----- _flag_attr_sprite -----

                LD      A,B				; расчет адреса первого байта знакоместа в DE
                LD      D,A
                RRCA
                RRCA
                RRCA
                AND	224
		ADD	A,C
                LD	E,A
                LD	A,D
                AND	24
                OR	64
                LD	D,A				; DE = адрес вывода знакоместа на экране, HL = адрес изображения в спрайте

; +++++ _flag_virt_scr_sprite +++++

		ld	a,virt_screen_high
		add	a,d
		ld	d,a

; ----- _flag_virt_scr_sprite -----

		; вывод знакоместа (8 строк)

		dup	7
		LD	A,(DE)
		OR	(HL)
		LD	(DE),A				; вывели байт спрайта
		INC     HL
                INC     D
		edup

		LD	A,(DE)
		OR	(HL)
		LD	(DE),A				; вывели байт спрайта

		POP	DE				; HL = адрес нахождения в спрайте, DE = координаты спрайта на экране
put_spr_or_02:	POP	BC				; B = цикл по количеству знакомест в спрайте
		DJNZ	put_spr_or_01
		RET

; +++++ _flag_edge_screen_sprite +++++

put_spr_or_03:	ld	bc,9
		add	hl,bc

; +++++ _flag_attr_sprite +++++

;		inc	hl

; ----- _flag_attr_sprite -----

		jp	put_spr_or_02

put_spr_or_04:	ld	bc,8
		add	hl,bc

; +++++ _flag_attr_sprite +++++

;		inc	hl

; ----- _flag_attr_sprite -----

		jp	put_spr_or_02

; ----- _flag_edge_screen_sprite -----
__ret12:
	end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure border(b:byte);
begin
	asm
		ld a,(&&b)
		out (0feh),a
	end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure color(b:byte);
begin
end;

////////////////////////////////////////////////////////////////////////////////

procedure VirtScreenClear;
begin
	asm
		ld hl,addr_virt_screen

; ===== _clrscr =====

; очистка экрана или виртуального экрана
; вход: hl = адрес экрана
; выход: нет

clrscr:			
			ld	d,h
			ld	e,l
			inc	de
			ld	(hl),0

			ld	a,192
clrscr_01:		
			dup	32
			ldi
			edup
			dec	a
			jp	nz,clrscr_01

			ld	a,(attr_screen)
			ld	(hl),a
			ld	bc,767
			ldir

			ld	bc,0
			ld	(col_screen),bc
			xor	a
			ld	(half_tile_screen),a


	end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure VirtScreenPut;
begin
	asm
; ===== _virt_screen =====

; копирование вирт.экрана на реальный
; вход: нет
; выход: нет

put_virt:
		ld	a,216
		LD      HL,addr_virt_screen
		LD	DE,16384
put_virt_01:
		dup	32
		LDI
		edup
		dec	a
		jp	nz,put_virt_01
	end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure ReadKey(var key1,key2:byte);
begin
	asm
		call readkey

		ld e,(&&key2+0)
		ld d,(&&key2+1)
		ld a,(code_key_2)
		ld (de),a

		ld e,(&&key1+0)
		ld d,(&&key1+1)
		ld a,(code_key_1)
		ld (de),a

		jp __ret5

; ===== _readkey =====

; чтение до двух одновременно нажатых клавиш
; вход: нет
; выход: (code_key_1),(code_key_2) = коды нажатых клавиш (если не нажата, то 0)

readkey:
		ld	de,0
		ld	(code_key_1),de


		ld	bc,32766
		call	readkey_10
		ld	bc,49150
		call	readkey_10
		ld	bc,57342
		call	readkey_10
		ld	bc,61438
		call	readkey_10
		ld	bc,63486
		call	readkey_10
		ld	bc,64510
		call	readkey_10
		ld	bc,65022
		call	readkey_10
		ld	bc,65278
		call	readkey_10
		ret

readkey_10:	in	a,(c)

		rrca
		call	nc,readkey_20
		inc	e

		rrca
		call	nc,readkey_20
		inc	e

		rrca
		call	nc,readkey_20
		inc	e

		rrca
		call	nc,readkey_20
		inc	e

		rrca
		call	nc,readkey_20
		inc	e

		ret

readkey_20:	push	af

		ld	bc,code_key_1
		ld	a,(bc)
		and	a
		jp	z,readkey_21
		inc	bc

readkey_21:	ld	hl,table_code_key
		add	hl,de
		ld	a,(hl)
		ld	(bc),a

		pop	af

		ret


; ===== _readkey =====

code_key_1:			defb	0					; код нажатой клавиши 1
code_key_2:			defb	0					; код нажатой клавиши 2

table_code_key:
	defb	32,16,77,78,66				; таблица кодов нажатых клавиш для полурядов
	defb	13,76,75,74,72
	defb	80,79,73,85,89
	defb	48,57,56,55,54
	defb	49,50,51,52,53
	defb	81,87,69,82,84
	defb	65,83,68,70,71
	defb	17,90,88,67,86

__ret5:

	end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure ScreenThaw;
begin
	asm
; ===== _screen_thaw ====

; процедура растворения экрана
; вход: нет
; выход: нет

scr_thaw:   LD    B,8         ;экран очищается за 8 циклов
       LD    DE,0        ;адрес начала кодов ПЗУ
THAW1:  LD    HL,0x4000    ;адрес начала экранной области
       PUSH  DE
THAW2:  LD    A,(DE)      ;берем «случайный» байт из ПЗУ
       AND   (HL)        ;объединяем с байтом из видеобуфера
       LD    (HL),A      ;помещаем обратно в видеобуфер
       INC   HL          ;переходим к следующим адресам
       INC   DE
       LD    A,H         ;проверяем, нужно ли повторять цикл
       CP    0x58         ;если прошли еще не весь видеобуфер
                         ; (#5800 - адрес начала области атрибутов)
       JR    NZ,THAW2    ; то повторяем
       halt
       halt
       halt
       POP   DE
       LD    HL,100
       ADD   HL,DE       ;увеличиваем адрес в ПЗУ на 100
       EX    DE,HL       ;меняем HL на DE
       DJNZ  THAW1       ;повторяем цикл

	; окончательно очищаем экран

	ld	hl,16384
	ld	(hl),0
	ld	de,16385
	ld	bc,6143
	ldir

       RET
	end;
end;

////////////////////////////////////////////////////////////////////////////////

procedure SoundEffect(sound_loop,sound_freq,a3:byte);
begin
	asm
;		ld a,(ix+4)
;		ld (sound_freq),a
		ld a,(ix+8)
		ld (sound_time),a
;		ld a,(ix+12)
;		ld (sound_loop),a
		
;		call sound_effect

; ===== _sound =====

; звуковой эффект
; вход: (sound_loop),(sound_freq),(sound_time)
; выход: нет

sound_effect:

	ld	a,(&&sound_loop)
	ld	b,a
	ld	e,(&&sound_freq+0)
	ld	d,(&&sound_freq+1)

       LD    A,(23624)
       AND   0x38
       RRA
       RRA
       RRA
       LD    L,A
       DI
EXPL1:  PUSH  BC
       PUSH  DE
EXPL2:  PUSH  DE
EXPL3:  LD    B,E
       DJNZ  $           ;задержка
       LD    A,(BC)      ;в паре BC один из первых 256 адресов ПЗУ
       AND   16
       OR    L
       OUT   (254),A
       INC   C
       DEC   D
       JR    NZ,EXPL3
       POP   DE
; Изменение высоты шума (понижение среднего тона;
;  если заменить на DEC E, тон будет наоборот повышаться)
       INC   E
       DEC   D
       JR    NZ,EXPL2
       POP   DE
       POP   BC
       DJNZ  EXPL1       ;повторение всего эффекта
       EI
;       RET
; ===== _sound =====

	jp __ret3
;sound_loop		defb	0		; количество повторений
;sound_freq		defb	0		; частота
sound_time:		defb	0		; длительность звучания
__ret3:

	end;
end;



