#include <SPI.h>
#include <SdFat.h>

#include "sav_button.h"
#include "sound_dataUP.h"
#include "sound_dataDOWN.h"

int fileCnt = 0;
int dirCnt = -1;
int curdir = 0;
int old_curdir = -1;
int sel = 0;
int abc = 2; // 0 - ACB, 1 - BAC, 2 - ABC
char lineToSent[16];

void resetAY() {
  digitalWrite(8, LOW);
  digitalWrite(9, LOW);

  digitalWrite(10, HIGH);

  digitalWrite(2, LOW);
  delay(100);
  digitalWrite(2, HIGH);
  delay(100);

  for (int i = 0; i < 16; i++) ay_out(i, 0);

}

void setupAYclock() {
  pinMode(3, OUTPUT);
  TCCR2A = 0x23;
  TCCR2B = 0x09;
  OCR2A = 8;
  OCR2B = 3;
}

void setup() {
  pinMode(A0, OUTPUT); // D0
  pinMode(A1, OUTPUT);
  pinMode(A2, OUTPUT);
  pinMode(A3, OUTPUT); // D3

  pinMode(2, OUTPUT);

  pinMode(4, OUTPUT); // D4
  pinMode(5, OUTPUT);
  pinMode(6, OUTPUT);
  pinMode(7, OUTPUT); // D7

  pinMode(8, OUTPUT);  // BC1
  pinMode(9, OUTPUT);  // BDIR

  pinMode(10, OUTPUT);

  Serial.begin(9600);
  randomSeed(analogRead(4) + analogRead(5));
  
  initFile();

  setupAYclock();
  resetAY();
  setupTimer();
}

void setupTimer() {
  cli();

  TCCR1A = 0;
  TCCR1B = 0;
  TCNT1  = 0;
  OCR1A = 1250;

  TCCR1B |= (1 << WGM12);
  TCCR1B |= (1 << CS12);
  TIMSK1 |= (1 << OCIE1A);

  sei();
}

void ay_out(unsigned char port, unsigned char data) {
  PORTB = PORTB & B11111100;

  PORTC = port & B00001111;
  PORTD = PORTD & B00001111;

  PORTB = PORTB | B00000011;
  delayMicroseconds(1);
  PORTB = PORTB & B11111100;

  PORTC = data & B00001111;
  PORTD = (PORTD & B00001111) | (data & B11110000);

  PORTB = PORTB | B00000010;
  delayMicroseconds(1);
  PORTB = PORTB & B11111100;
}

unsigned int playPos = 0;
unsigned int fillPos = 0;
const byte bufSize = 200;
byte playBuf[bufSize]; // 31 bytes per frame max, 50*31 = 1550 per sec, 155 per 0.1 sec

const char *supportedFileExt = ".psg";
const byte fileExtLen = strlen(supportedFileExt);

SdFat sd;
SdFile fp;
SdFile root;

boolean play_Finished = false;
boolean play_Pause = false;
boolean random_Dir = true;

SButton button_right(100, 50, 2000, 4000, 500);
SButton button_play (101, 50, 2000, 4000, 500);
SButton button_menu (102, 50, 2000, 4000, 500);
SButton button_left (103, 50, 2000, 4000, 500);

void loop() {

  if (!play_Pause) {
    fillBuffer();
  }

  switch ( button_right.Loop() ) {
    case SB_CLICK:
      playPause();
      play_Right();
      break;
    case SB_LONG_CLICK:
      playPause();
      play_dir_Right();
      break;
    case SB_AUTO_CLICK:
      break;
  }
  switch ( button_play.Loop() ) {
    case SB_CLICK:
      play_Pause = !play_Pause;
      if (play_Pause) {
        for (int i = 8; i < 11; i++) ay_out(i, 0);
      }
      break;
    case SB_LONG_CLICK:
      playPause();
      if (abc != 2) {
        abc++;
      } else {
        abc = 0;
      }
      play_Pause = false;
      break;
    case SB_AUTO_CLICK:
      break;
  }
  switch ( button_menu.Loop() ) {
    case SB_CLICK:
      playPause();
      openRandomFile();
      break;
    case SB_LONG_CLICK:
      random_Dir = !random_Dir;
      if (random_Dir) {
        play_Sound(sound_dataUP);
      } else {
        play_Sound(sound_dataDOWN);
      }
      break;
    case SB_AUTO_CLICK:
      break;
  }
  switch ( button_left.Loop() ) {
    case SB_CLICK:
      playPause();
      play_Left();
      break;
    case SB_LONG_CLICK:
      playPause();
      play_dir_Left();
      break;
    case SB_AUTO_CLICK:
      break;
  }

  if (play_Finished) {
    play_Right();
  }

}

void playPause() {
  play_Pause = true;
  for (int i = 8; i < 11; i++) ay_out(i, 0);
}

void play_Sound(byte sound_data) {
  int k;
  byte myChar_0, myChar_1;

  playPause();
  resetAY();

  int len = pgm_read_byte_near(sound_data);
  for (k = 1; k < len; k++) {
    myChar_0 =  pgm_read_byte_near(sound_data + k);
    myChar_1 =  pgm_read_byte_near(sound_data + k + 1);
    if (myChar_0 == 0xFF) {
      delay(20);
      continue;
    }
    if (myChar_0 < 16) ay_out(myChar_0, myChar_1);
  }

  resetAY();
  play_Pause = false;
}

void play_Right() {
  old_curdir = curdir;

  if (sel < fileCnt - 1) {
    sel++;
  } else {
    if (curdir < dirCnt - 1) {
      curdir++;
      sel = 0;
    } else {
      curdir = 0;
      sel = 0;
    }
  }

  open_File();

  play_Finished = false;
  play_Pause = false;
}

void play_dir_Right() {
  old_curdir = curdir;

  if (curdir < dirCnt - 1) {
    curdir++;
    sel = 0;
  } else {
    curdir = 0;
    sel = 0;
  }

  open_File();

  play_Finished = false;
  play_Pause = false;
}


void play_Left() {
  old_curdir = curdir;

  if (sel > 0) {
    sel--;
  } else {
    if (curdir > 0) {
      curdir--;
      sel = 0;
    } else {
      curdir = 0;
      sel = 0;
    }
  }

  open_File();

  play_Finished = false;
  play_Pause = false;
}

void play_dir_Left() {
  old_curdir = curdir;

  if (curdir > 0) {
    curdir--;
    sel = 0;
  } else {
    curdir = 0;
    sel = 0;
  }

  open_File();

  play_Finished = false;
  play_Pause = false;
}

void fillBuffer() {
  short int fillSz = 0;
  short int freeSz = bufSize;
  if (fillPos > playPos) {
    fillSz = fillPos - playPos;
    freeSz = bufSize - fillSz;
  }
  if (playPos > fillPos) {
    freeSz = playPos - fillPos;
    fillSz = bufSize - freeSz;
  }

  freeSz--; // do not reach playPos
  while (freeSz > 0) {
    byte b = 0xFD;
    if (fp.available()) {
      b = fp.read();
    }
    playBuf[fillPos] = b;
    fillPos++;
    if (fillPos == bufSize) fillPos = 0;
    freeSz--;
  }
}

void prepareFile(SdFile entry) {

  entry.getName(lineToSent, 16);

  fp.close();
  fp = entry;

  delay(200);
  
  while (fp.available()) {
    byte b = fp.read();
    if (b == 0xFF) break;
  }

  fillPos = 0;
  playPos = 0;
  cli();
  fillBuffer();
  resetAY();
  sei();
}

void open_File() {
  SdFile file;

  openStart:  
  
  root.close();
  if (!root.open(string2char("/" + String(curdir)), O_READ)) {
    if (!root.open("/", O_READ)) {
      Serial.println("Error open root!");
      return;
    }
  }

  delay(200);

  if (old_curdir != curdir) {
    fileCnt = countDirectory(root);
  }


  int n = sel;

  while (file.openNext(&root, O_READ)) {
    if (checkFile(file)) {
      if (n <= 0) {
        prepareFile(file);
        return;
      }
      n--;
    }
    file.close();
  }
  goto openStart;
}

void openRandomFile() {
  SdFile file;
  
  randStart:
  
  old_curdir = curdir;
  if (random_Dir) curdir = random(0, dirCnt - 1);

  root.close();
  if (!root.open(string2char("/" + String(curdir)), O_READ)) {
    if (!root.open("/", O_READ)) {
      Serial.println("Error open root!");
      return;
    }
  }

  delay(200);
  
  if (old_curdir != curdir) {
    fileCnt = countDirectory(root);
  }
  int sel = random(0, fileCnt - 1);

  int n = sel;
  
  while (file.openNext(&root, O_READ)) {
    if (checkFile(file)) {
      if (n <= 0) {
        prepareFile(file);
        play_Finished = false;
        play_Pause = false;
        return;
      }
      n--;
    }
    file.close();
  }
  file.close();
  goto randStart;
}

bool checkFile(SdFile entry) {
  char name[256];
  entry.getName(name, 255);
  return !entry.isHidden() && !entry.isDir() && (strlen(name) > fileExtLen &&
         !strcasecmp(name + strlen(name) - fileExtLen, supportedFileExt));
}

void initFile() {
  SdFile file;
  Serial.print("Initializing SD card...");

  if (!sd.begin(10, SD_SCK_MHZ(50))) {
    Serial.println("-");
    sd.initErrorHalt();
    return;
  }

  Serial.println("initialization done.");

  if (!root.open("/", O_READ)) {
    Serial.println("Error open root!");
    return;
  }

  while (file.openNext(&root, O_READ)) {

    if (file.isDir()) {
      dirCnt++;
    }
    file.close();
  }
  root.close();

  open_File();

}

char* string2char(String command) {
  if (command.length() != 0) {
    char *p = const_cast<char*>(command.c_str());
    return p;
  }
}

int countDirectory(SdFile dir) {
  SdFile file;
  int res = 0;
  
  while (file.openNext(&dir, O_READ)) {
    if (checkFile(file)) {
      res++;
    }
    file.close();
  }
  
  return res;
}

int skipCnt = 0;

ISR(TIMER1_COMPA_vect) {
  if (play_Pause) {
    return;
  }
  if (skipCnt > 0) {
    skipCnt--;
  } else {
    int fillSz = 0;
    int freeSz = bufSize;
    if (fillPos > playPos) {
      fillSz = fillPos - playPos;
      freeSz = bufSize - fillSz;
    }
    if (playPos > fillPos) {
      freeSz = playPos - fillPos;
      fillSz = bufSize - freeSz;
    }

    boolean ok = false;
    int p = playPos;
    while (fillSz > 0) {
      byte b = playBuf[p];
      p++; if (p == bufSize) p = 0;
      fillSz--;

      if (b == 0xFF) {
        ok = true;
        break;
      }
      if (b == 0xFD) {
        ok = true;
        play_Finished = true;
        for (int i = 0; i < 16; i++) ay_out(i, 0);
        break;
      }
      if (b == 0xFE) {
        if (fillSz > 0) {
          skipCnt = playBuf[p];
          p++; if (p == bufSize) p = 0;
          fillSz--;

          skipCnt = 4 * skipCnt;
          ok = true;
          break;
        }
      }
      if (b <= 252) {
        if (fillSz > 0) {
          byte v = playBuf[p];
          p++; if (p == bufSize) p = 0;
          fillSz--;

          if (abc == 1) {
            if (b == 0x00) {
              b = 0x04;   // A
            } else if (b == 0x01) {
              b = 0x05;
            } else if (b == 0x08) {
              b = 0x0A;
            } else if (b == 0x02) {
              b = 0x00;   // B
            } else if (b == 0x03) {
              b = 0x01;
            } else if (b == 0x09) {
              b = 0x08;
            } else if (b == 0x04) {
              b = 0x02;   // C
            } else if (b == 0x05) {
              b = 0x03;
            } else if (b == 0x0A) {
              b = 0x09;
            } else if (b == 0x07) {
              byte mask = v;
              v = v >> 1;
              if (bit_is_set(mask, 3)) {
                v |= (1 << 5);
              } else {
                v &= ~((1 << 5));
              }
              if (bit_is_set(mask, 0)) {
                v |= (1 << 2);
              } else {
                v &= ~((1 << 2));
              }
            }
          } else if (abc == 2) {
            if (b == 0x02) {
              b = 0x04;   // B
            } else if (b == 0x03) {
              b = 0x05;
            } else if (b == 0x09) {
              b = 0x0A;
            } else if (b == 0x04) {
              b = 0x02;   // C
            } else if (b == 0x05) {
              b = 0x03;
            } else if (b == 0x0A) {
              b = 0x09;
            } else if (b == 0x07) {
              byte mask = v;
              v = v >> 1;
              if (bit_is_set(mask, 4)) {
                v |= (1 << 5);
              } else {
                v &= ~((1 << 5));
              }
              if (bit_is_set(mask, 1)) {
                v |= (1 << 2);
              } else {
                v &= ~((1 << 2));
              }
              if (bit_is_set(mask, 3)) {
                v |= (1 << 3);
              } else {
                v &= ~((1 << 3));
              }
              if (bit_is_set(mask, 0)) {
                v |= (1 << 0);
              } else {
                v &= ~((1 << 0));
              }
            }
          }

          if (b < 16) ay_out(b, v);
        }
      }
    } // while (fillSz>0)

    if (ok) {
      playPos = p;
    }
  } // else skipCnt
}
