
NAM	EQU	0
EXT	EQU	8
ATR	EQU	11

CLU3	EQU	20
CLU4	EQU	21

TIM1	EQU	22
TIM2	EQU	23
DAT1	EQU	24
DAT2	EQU	25
CLU1	EQU	26
CLU2	EQU	27
LEN1	EQU	28
LEN2	EQU	29
LEN3	EQU	30
LEN4	EQU	31
POS1	EQU	32
POS2	EQU	33
POS3	EQU	34
POS4	EQU	35
DIRCLU1	EQU	36
DIRCLU2	EQU	37
HND1	EQU	38
HND2	EQU	39
FDRV	EQU	40
AMODE	EQU	41
FTASK	EQU	42

DIR	EQU	#C000

DIRPAGE	EQU	0

;ACCESS	MODE:
;	00 - READ/WRITE
;	01 - READ
;	02 - WRITE

;File Manipulator (FM)
FM_BUF	DEFB	".	 "	;+00 NAME
	DEFB	"   "		;+08 EXT
	DEFB	#10		;+11 ATTRIBUT
	DEFB	0,0,0,0,0,0,0,0,0,0 ;+12 RESERVED
	DEFW	#0000		;+22 TIME
	DEFW	#0000		;+24 DATE
	DEFW	#0000		;+26 START CLUSTER
	DEFW	#0000,#0000	;+28 SIZE FILE
	DEFW	#0000,#0000	;+32 FILE POSITION (FP)
	DEFW	#0000		;+36 DIRECTORY CLUSTER
	DEFW	#0000		;+38 HANDLE NUMBER
	DEFB	#00		;+40 DRIVE OR CURRENT
	DEFB	#00		;+41 ACCESS MODE
	DEFB	#00		;+42 TASK
	DEFB	#00		;+43 EMPTY
END_FM
;End of	FM
	DEFS	44*1,0

FM_SIZE	EQU	END_FM-FM_BUF

SET_FM	PUSH	DE
	INC	A
	LD	IY,FM_BUF-FM_SIZE
	LD	DE,FM_SIZE
SET_FM1	ADD	IY,DE
	DEC	A
	JR	NZ,SET_FM1
	POP	DE
	LD	A,(IY+0)
	OR	A
	LD	A,0
	RET	NZ
	LD	A,5
	SCF 
	RET 

; HL:IX	- OFFSET POINTER
;     A	- FILE MANIPULATOR

MOVE_FP	CALL	SET_FM
	RET	C
	INC	B
	DEC	B
	JP	Z,MOVE_FA
	DEC	B
	JP	Z,MOVE_FB
	DEC	B
	JP	Z,MOVE_FC
	LD	A,1
	SCF 
	RET 

;from Start File
MOVE_FA	LD	BC,0
	LD	DE,0
	JR	MOVE_F1

;from End File
MOVE_FC	LD	C,(IY+28)
	LD	B,(IY+29)
	LD	E,(IY+30)
	LD	D,(IY+31)
	JR	MOVE_F1

;from Current Position
MOVE_FB	LD	C,(IY+32)
	LD	B,(IY+33)
	LD	E,(IY+34)
	LD	D,(IY+35)
MOVE_F1	ADD	IX,BC
	ADC	HL,DE
	LD	D,HX
	LD	E,LX
	LD	(IY+32),E
	LD	(IY+33),D
	LD	(IY+34),L
	LD	(IY+35),H
	XOR	A
	RET 

;FP COMPARE
; CY - FILE POINTER > SIZE
; NC - FILE POINTER < SIZE

MOVE_CP	LD	L,(IY+28)
	LD	H,(IY+29)
	LD	E,(IY+32)
	LD	D,(IY+33)
	AND	A
	SBC	HL,DE
	LD	L,(IY+30)
	LD	H,(IY+31)
	LD	E,(IY+34)
	LD	D,(IY+35)
	SBC	HL,DE
	RET 

INITDISK
	LD	B,4
CD_I_LP	PUSH	BC
	LD	DE,DIR
	LD	HL,#0000
	LD	IX,#0010
	LD	BC,#0105
;	LD	A,(DRIVE)
	CALL	CDCMD
;	RST	#18
	POP	BC
	JR	NC,CD_I_OK
	DJNZ	CD_I_LP
UNKCD	SCF
	RET

CD_I_OK	LD	HL,DIR
	LD	A,(HL)
	INC	HL
	CP	#01
	JR	NZ,UNKCD
	LD	A,(HL)
	INC	HL
	CP	"C"
	JR	NZ,UNKCD
	LD	A,(HL)
	INC	HL
	CP	"D"
	JR	NZ,UNKCD
	LD	HL,DIR+#009E
	LD	DE,ROOTDIR
	LDI 
	LDI 
	LDI 
	LDI 
	LD	HL,DIR+#00A6
	LD	DE,ROOTLEN
	LDI 
	LDI 
	LDI 
	LDI 
;	POP	AF
;	OUT	(PAGE3),A
;	LD	HL,0
;	LD	(FATCASH),HL
	XOR	A
	RET 





LOADDIR	XOR	A
	LD	A,DIRPAGE
	CALL	BANK
	PUSH	AF
	LD	B,3
LOADFFF	PUSH	BC
	LD	HL,#C000
	LD	DE,#C001
	LD	BC,#3FFF
	LD	(HL),L
	LDIR 
;	LD	A,(DRIVE)
;	LD	(IY+FDRV),A
;;	LD	C,(IY+LEN1)
	LD	C,(IY+LEN2)
	LD	B,(IY+LEN3)
	LD	E,(IY+LEN4)
	LD	D,0
	SRL	D
	RR	E
	RR	B
	RR	C
	SRL	D
	RR	E
	RR	B
	RR	C
	SRL	D
	RR	E
	RR	B
	RR	C
	LD	E,(IY+CLU1)
	LD	D,(IY+CLU2)
	LD	L,(IY+CLU3)
	LD	H,(IY+CLU4)
	LD	HX,D
	LD	LX,E
	LD	B,C
	LD	A,B
	OR	A
	JR	Z,ERRLEND
	CP	#08
	JR	C,NORLEND
	LD	B,8
NORLEND	LD	A,(DRIVE)
	LD	C,5
	LD	DE,DIR
	CALL	CDCMD
;	RST	#18
	POP	BC
	JR	NC,LOADMMM
	DEC	B
	JP	NZ,LOADFFF
	POP	AF
	OUT	(PAGE3),A
	SCF 
	LD	A,20
	RET 

ERRLEND	POP	BC
	POP	AF
	OUT	(PAGE3),A
	SCF 
	LD	A,20
	RET 

LOADMMM	POP	AF
	OUT	(PAGE3),A
	CALL	CORRDIR
	AND	A
	RET 

CORRDIR	LD	A,DIRPAGE
	CALL	BANK
	PUSH	AF
	LD	HL,DIR
	LD	DE,DIR
CORRL1	PUSH	DE
	LD	C,(HL)
	LD	B,0
	LD	DE,ENTRYBF
	LDIR 
	POP	DE
	PUSH	HL
	LD	HL,FCDFLEN
	LD	C,(HL)
	LD	B,0
	ADD	HL,BC
	INC	HL
	LD	(HL),0
	SBC	HL,BC
	PUSH	DE
	CALL	MASK
	POP	HL
	LD	BC,11
	ADD	HL,BC
	LD	A,(FCDFLAG)
	AND	2
	LD	A,#00	;ATTRIBUT FILE
	JR	Z,CORRL0
	LD	A,#10	;ATTRIBUT DIRECTORY
CORRL0	LD	(HL),A
	INC	HL
	XOR	A
	LD	B,8
FILLCDN	LD	(HL),A
	INC	HL
	DJNZ	FILLCDN
	LD	A,(FCDSEC+2)
	LD	(HL),A
	INC	HL
	LD	A,(FCDSEC+3)
	LD	(HL),A
	INC	HL
	LD	DE,#0000	;TIME
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	LD	DE,#0000	;DATE
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	LD	DE,(FCDSEC)
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	EX	DE,HL
	LD	HL,FCDLEN
	LDI 
	LDI 
	LDI 
	LDI 
	POP	HL
	BIT	7,H
	JR	Z,CORRL2
	LD	A,(HL)
	OR	A
	JP	NZ,CORRL1
	LD	L,0
	INC	H
	JR	Z,CORRL2
	LD	A,(HL)
	OR	A
	JP	NZ,CORRL1
CORRL2	XOR	A
	LD	(DE),A
	LD	DE,(ROOTDIR+0)
	LD	L,(IY+CLU1)
	LD	H,(IY+CLU2)
	AND	A
	SBC	HL,DE
	JR	NZ,CORRL6
	LD	DE,(ROOTDIR+2)
	LD	L,(IY+CLU3)
	LD	H,(IY+CLU4)
	AND	A
	SBC	HL,DE
	JR	NZ,CORRL6
	LD	HL,DIR
	LD	A,(HL)
	CP	" "
	JR	NZ,CORRL4
	LD	(HL),#E5
	LD	BC,#0020
	ADD	HL,BC
	LD	A,(HL)
	CP	" "
	JR	NZ,CORRL4
	LD	(HL),#E5
	JR	CORRL4
CORRL6	LD	HL,DIR
	LD	A,(HL)
	CP	" "
	JR	NZ,CORRL4
	LD	(HL),"."
	LD	BC,#0020
	ADD	HL,BC
	LD	A,(HL)
	CP	" "
	JR	NZ,CORRL4
	LD	(HL),"."
	INC	HL
	LD	(HL),"."
CORRL4	POP	AF
	OUT	(PAGE3),A
	AND	A
	RET 

ENTRYBF
	DEFB	#00	;Entry lenght
	DEFB	#00	;XAR in	LBN
FCDSEC	DEFW	#00,#00	;Start sector (Intel)
	DEFW	#00,#00	;Start sector (Motorola)
FCDLEN	DEFW	#00,#00	;Lenght	file (Intel)
	DEFW	#00,#00	;Lenght	file (Motorola)
FCDYEAR	DEFB	#00	;Year
FCDMOUN	DEFB	#00	;Mount
FCDDAY	DEFB	#00	;Day
FCDHOUR	DEFB	#00	;Hour
FCDMIN	DEFB	#00	;Minute
FCDSECN	DEFB	#00	;Second
	DEFB	#00	;Reserve
FCDFLAG	DEFB	#00	;Flag
	DEFB	#00	;Interlive size
	DEFB	#00	;Interlive skip	factor
	DEFW	#0000	;Volume	Set Sequence (Intel)
	DEFW	#0000	;Volume	Set Sequence (Motorola)
FCDFLEN	DEFB	#00
DEFSA	EQU	$-ENTRYBF
FCDNAME	DEFS	#100-DEFSA

ROOTDIR	DEFW	0,0
ROOTLEN	DEFW	0,0

DIRSIZE	DEFW	0

BANK	LD	C,A
	LD	B,0
	LD	HL,BANKTBL
	ADD	HL,BC
	IN	A,(PAGE3)
	LD	C,PAGE3
	OUTI 
	RET 

BANKTBL	DEFB	#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
	DEFB	#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF

HANDTA	DEFB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DEFB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

MASKARE
	DEFB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DEFB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

; HL - MASK "file*.t??"
; DE - 11 bytes	filename
; RET: C=2 FILE	WITHOUT	EXTENTION
;      C=1 FILE	WITH EXTENTION

MASK	PUSH	HL
	PUSH	DE
	LD	H,D
	LD	L,E
	INC	DE
	LD	(HL),#20
	LD	BC,10
	LDIR 
	POP	DE
	POP	HL
	LD	A,(HL)
	CP	#21
	RET	C
	LD	BC,#0902
MASK1	LD	A,(HL)
	CP	#21
	CCF 
	RET	NC
	CP	#22
	JR	Z,MASK7
	CP	"*"
	JR	Z,MASK3
	CP	"+"
	JR	Z,MASK7
	CP	","
	JR	Z,MASK7
	CP	"."
	JR	Z,MASK5
	CP	"/"
	JR	Z,MASK7
	CP	":"
	JR	Z,MASK7
	CP	";"
	JR	Z,MASK7
	CP	"<"
	JR	Z,MASK7
	CP	"="
	JR	Z,MASK7
	CP	">"
	JR	Z,MASK7
	CP	"["
	JR	Z,MASK7
	CP	"\"
	JR	Z,MASK7
	CP	"]"
	JR	Z,MASK7
	CP	"|"
	JR	Z,MASK7
	CP	"a"
	JR	C,MASK2
	CP	"{"
	JR	NC,MASK2
	SUB	#20
MASK2	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	MASK1
MASK7	LD	A,16
	SCF 
	RET 

MASK3	LD	A,"?"
	INC	HL
	DJNZ	MASK6
	LD	A,16
	SCF 
	RET 

MASK6	LD	(DE),A
	INC	DE
	DJNZ	MASK6
	LD	B,1
	JR	MASK1

MASK5	LD	A," "
	INC	HL
	DJNZ	MASK4
	LD	B,4
	DEC	C
	JP	NZ,MASK1
	LD	A,16
	SCF 
	RET 

MASK4	LD	(DE),A
	INC	DE
	DJNZ	MASK4
	LD	B,4
	DEC	C
	JP	NZ,MASK1
	LD	A,16
	SCF 
	RET 
