;[BEGIN]
;
; CDX.EXE [command] [-switches] [directory]
;
;commands:
;	OPEN
;	EJECT
;	CLOSE
;	COPY
;	LIST
;	DUMP
;	COMMAND
; -h,?	Help page


CR	EQU	13
LF	EQU	10

	ORG	#8100-512
	INCLUDE	"dss.inc"
	DB	"EXE"	;EXE ID
	DB	#00	;EXE VERSION
	DW	#0200	;CODE OFFSET LOW
	DW	#0000	;CODE OFFSET HIGH
	DW	#0000	;END-BEG ;PRIMARY LOADER
	DW	#0000	;
	DW	#0000	;RESERVED
	DW	#0000	;
	DW	#8100	;LOAD ADDRESS
	DW	#8100	;START ADDRESS
	DW	#BFFF	;STACK ADDRESS
	DS	490

START	PUSH	IX
	LD	A,MSG_HELLO
	CALL	MESSAGE
	CALL	INIT
	LD	C,DSS_VERSION
	RST	#10		;GET DSS VERSION
	EX	DE,HL
	AND	A
	LD	DE,#0136	;1.54
	SBC	HL,DE		;CHECK DSS VERSION
	POP	HL
	JP	C,OLD_DSS
	LD	IX,BUF_PTRS
	CALL	EX_COMMAND_LINE

	CALL	MALLOC
	JR	C,QUIT

	CALL	FIND_CDROM
	LD	A,(STOPMODE)
	OR	A
	CALL	Z,COMMAND

	CALL	MDEALLOC
QUIT
	CALL	CRLF
	LD	BC,DSS_EXIT
	RST	#10
	RET

OLD_DSS
	LD	A,MSG_OLD_DSS
	CALL	MESSAGE
	JR	QUIT

HNDMEM	DB	#FF

MALLOC
	LD	BC,#0200+DSS_GETMEM
	RST	#10
	JR	NC,M_ALLOK
	LD	A,MSG_MEMERROR
	CALL	MESSAGE
	SCF
	RET
M_ALLOK
	LD	(HNDMEM),A
	LD	BC,#0100+DSS_SETWIN3
	RST	#10
	LD	HL,BANKTBL
	LD	C,#C5
	LD	A,(HNDMEM)
	RST	#08
	RET

MDEALLOC
	LD	A,(HNDMEM)
	LD	C,DSS_FREEMEM
	RST	#10
	RET

FIND_CDROM
	LD	IX,DEV_CFG
	LD	C,#5F
	RST	#08
	LD	A,(IX+3)	;CDROM
	OR	A
	JR	Z,W_O_CD
	LD	A,(CDDRIVE)
	INC	A
	RET	NZ
	LD	A,SLAVE		;DEFAULT
	LD	(CDDRIVE),A
	RET
W_O_CD	LD	A,MSG_NO_CDROM
	CALL	MESSAGE
	LD	A,1
	LD	(STOPMODE),A
	SCF
	RET

;BUF_PRINT
;	LD	HL,BUF_PTRS
;BUF_PL	LD	E,(HL)
;	INC	HL
;	LD	D,(HL)
;	INC	HL
;	LD	A,D
;	OR	E
;	RET	Z
;	PUSH	HL
;	EX	DE,HL
;	LD	C,DSS_PCHARS
;	RST	#10
;	CALL	CRLF
;	POP	HL
;	JR	BUF_PL

;OPEN_FILE
;	LD	HL,FILENAME
;	XOR	A
;	LD	C,DSS_OPEN
;	RST	#10
;	LD	(FILEHND),A
;	RET	NC
;	LD	HL,FILENAME
;	CALL	PUTVAR
;	LD	A,MSG_CANT_OPEN
;	CALL	MESSAGE
;	SCF
;	RET

;CLOSE_FILE
;	LD	A,(FILEHND)
;	LD	C,DSS_CLOSE
;	RST	#10
;	RET

INIT
	XOR	A
	LD	(STOPMODE),A
	DEC	A
	LD	(CDDRIVE),A
;
	LD	C,1
	CALL	CDCMD
	RET

;VARIABLES

FILENAME	DS	256

FILEHND		DB	#FF
STOPMODE	DB	#00

	INCLUDE	"cmdparse.asm"
	INCLUDE	"command.asm"
	INCLUDE	"cd_bios.asm"
	INCLUDE	"cd_dos.asm"

CRLF	LD	A,#0D
	LD      C,DSS_PUTCHAR
	RST     #10
	LD      A,#0A
	LD      C,DSS_PUTCHAR
	RST     #10
	RET

ERROR	CP	MAX_DSS_ERR
	LD	E,A
	LD	D,0
	JP	C,ERR_MSG
	LD	E,D
	JP	ERR_MSG

ERR_MSG	PUSH	DE
	LD	HL,ERRCDX
	CALL	PRINTZ
	POP	DE
	CALL	FMESAGE
	CALL	PRINTZ
	CALL	CRLF
	CALL	CRLF
	RET

FMESAGE	INC	DE
	LD	HL,ERR0
	LD	BC,ERR1-ERR0
LCPIR	XOR	A
	CPIR
	RET	PO
	RET	NZ
	DEC	DE
	LD	A,D
	OR	E
	JP	NZ,LCPIR
	RET

MAX_DSS_ERR	EQU	33

ERRCDX	DB	"CDX: ",0

ERR0	DB	#00
	DB	"Unknown error",0
	DB	"Invalid function",0
	DB	"Invalid drive number",0
	DB	"File not found",0
	DB	"Path not found",0
	DB	"Invalid handle",0
	DB	"Extended error 6",0
	DB	"File exist",0
	DB	"File read only",0
	DB	"Root overflow",0
	DB	"No free space",0
	DB	"Directory not empty",0
	DB	"Can't delete current directory",0
	DB	"Invalid media",0
	DB	"Unknown operation",0	;R02
	DB	"Directory exist",0
	DB	"Invalid filename",0
	DB	"Invalid EXE-file",0
	DB	"Not supported EXE-file",0
	DB	"Access denied",0
	DB	"Not ready",0
	DB	"Seek error",0
	DB	"Sector not found",0
	DB	"CRC error",0
	DB	"Write protect",0
	DB	"Read error",0
	DB	"Write error",0
	DB	"Drive failure",0
	DB	"Extended error 28",0
	DB	"Extended error 29",0
	DB	"No free memory",0
	DB	"Invalid memory block",0
	DB	"Extended error 32",0
	DB	"Extended error 33",0
	DB	"Extended error 34",0
	DB	"35",0
	DB	"36",0
	DB	"37",0
	DB	"38",0
	DB	"39",0
	DB	"40",0
	DB	"41",0
	DB	"42",0
	DB	"43",0
	DB	"44",0
	DB	"45",0
	DB	"46",0
	DB	"47",0
	DB	"48",0
	DB	"49",0
	DB	"50"
	DB	0
ERR1

FIND_MESSAGE
	LD	E,A
	LD	D,0
	CALL	MESAGE
	RET

MESSAGE	LD	E,A
	LD	D,0
	CALL	MESAGE
	CALL	PRINTZ
	RET

MESAGE	INC	DE
	LD	HL,MSG0
	LD	BC,MSG1-MSG0
LCPIR2	XOR	A
	CPIR
	RET	PO
	RET	NZ
	DEC	DE
	LD	A,D
	OR	E
	JP	NZ,LCPIR2
	RET

PRINTZ	LD	A,(HL)
	INC	HL
	OR	A
	RET	Z
	CP	"%"
	JR	NZ,PRINTZ2
	LD	A,(HL)
	INC	HL
	SUB	"1"
	PUSH	HL
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	BC,PRM1
	ADD	HL,BC
	LD	C,DSS_PCHARS
	RST	#10
	POP	HL
	JR	PRINTZ
PRINTZ2	LD	C,DSS_PUTCHAR
	RST	#10
	JP	PRINTZ

PRINT_	LD	BC,#0182
	RST	#08
	RET

PUTVAR	LD	DE,PRM1
PUTPRM	LD	BC,15
PUTPRMA	LD	A,(HL)
	LDI
	RET	PO
	OR	A
	JR	NZ,PUTPRMA
	RET

PRM1    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM2    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM3    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM4    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM5    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM6    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM7    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM8    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM9    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0


MSG_HELLO	EQU	0
MSG_TRAY_OPEN	EQU	1
MSG_TRAY_CLOSE	EQU	2
MSG_USAGE	EQU	3
MSG_UNK_PARAMETER	EQU	4
MSG_UNK_COMMAND	EQU	5
;MSG_DISABLED	EQU	6
;MSG_ENABLED	EQU	7
MSG_DONE	EQU	8
MSG_NO_CDROM	EQU	9
MSG_IO_ERROR	EQU	10
MSG_OLD_DSS	EQU	11
MSG_COPYFILE	EQU	12
MSG_DIRHEAD	EQU	13
MSG_DIRENTRY	EQU	14
MSG_MEMERROR	EQU	15
MSG_COPYTO	EQU	16
MSG_CD_READ_ERR	EQU	17
MSG_F_WRITE_ERR	EQU	18
MSG_FAILURE	EQU	19
MSG_ERR_DEST	EQU	20
MSG_COPYABORTED	EQU	21

MSG0	DB	0
;0
	DB	"CDROM eXtension utility v1.00, 2003 (c) PETERS PLUS LTD",CR,LF
	DB	"Type CDX.EXE -? for help.",CR,LF,CR,LF,0
;1
	DB	"Opening tray...",0
;2
	DB	"Closing tray...",0
;3
;               01234567890123456789012345678901234567890123456789012345678901234567890123456789
	DB	"  Usage: CDX.EXE [-switches] [command] [param1] [param2]",CR,LF,CR,LF
	DB	"Commands:",CR,LF
	DB     " CDX.EXE OPEN			      - Open tray",CR,LF
	DB     " CDX.EXE CLOSE			      - Close tray",CR,LF
	DB     " CDX.EXE LIST [\\cd_path\\][pattern]    - Show CDROM filelist",CR,LF
	DB     " CDX.EXE COPY \\source d:\\destination\\ - Copy file(s) from CDROM to another disk",CR,LF
	DB     " CDX.EXE DUMP sector [offset]	      - Show sector dump from CDROM",CR,LF
	DB	CR,LF
	DB	"Switches:",CR,LF
	DB	" -h,?	Help page",CR,LF
	DB	" -m	CDROM installed as IDE Master device",CR,LF
	DB	" -s	CDROM installed as IDE Slave device",CR,LF
	DB	0
;4
	DB	"  Error: Unknown switch: %1",CR,LF,0
;5
	DB	"  Error: Unknown command: %1",CR,LF,0
;6
	DB	"Disabled",0
;7
	DB	"Enabled",0
;8
	DB	"Done!",CR,LF,0
;9
	DB	"  Error: Can't find CDROM device",CR,LF,0
;10
	DB	"  Error: I/O Error",CR,LF,0
;11
	DB	"  Error: Need DSS version 1.54 or higher",CR,LF,0
;12
	DB	"Copying ",0
;13
	DB	"Directory of CDROM:",0
;14		 FILENAME EXT SIZE DATE	TIME
	DB	"%1 %2  %3  %4  %5",CR,LF,0
;15
	DB	"  Error: Memory allocation error",CR,LF,0
;16
	DB	" to ",0
;17
	DB	"  Error: Reading failure",CR,LF,0
;18
	DB	"  Error: Writing failure",CR,LF,0
;19
	DB	"Failure!",CR,LF,0
;20
	DB	"  Error: Can't open destination file",CR,LF,0
;21
	DB	"Copying aborted",CR,LF,0
;22
	DB	0
MSG1

BUF_PTRS
	DW	BUF1,BUF2,BUF3,BUF4,0

BUF1	DS	256
BUF2	DS	256
BUF3	DS	256
BUF4	DS	256
DEV_CFG
;[END]
